/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	memory.h:		RAM allocation routines

************************************************************************************/

#ifndef _MEMORY_H_
#define _MEMORY_H_

#if (GOLCD==YES) || (RELEASE==YES)
#define MEMORY_DEBUGMODE	0
#else
#define MEMORY_DEBUGMODE	1
#endif

#ifdef MEMORY_DEBUGMODE
	#define MALLOC(A, B) memoryDebugAllocate((A),(B),__FILE__,__LINE__)
	#define TEMPMALLOC(A, B) memoryTempDebugAllocate((A),(B),__FILE__,__LINE__)
#else
	#define MALLOC(A, B) memoryAllocate(A)
	#define TEMPMALLOC(A, B) memoryTempAllocate((A))
#endif
#define FREE(A)	memoryFree(A)
#define FREENULL(A) { memoryFree(A); (A) = NULL; }

#define NEW(T)		MALLOC(sizeof(T),#T)

#define DELETE(P)	FREENULL(P)

#define DWORD ULONG


/**************************************************************************
	FUNCTION:	memoryInitialise()
	PURPOSE:	Initialise memory for allocation
	PARAMETERS:	Base address, size of area
	RETURNS:	0/1
**************************************************************************/

int memoryInitialise(DWORD base, DWORD size);


/**************************************************************************
	FUNCTION:	memoryDestroy()
	PURPOSE:	Destroy memory allocation data
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void memoryDestroy();


/**************************************************************************
	FUNCTION:	memoryReset()
	PURPOSE:	Reset memory allocation
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void memoryReset();


/**************************************************************************
	FUNCTION:	memoryAllocate()
	PURPOSE:	Allocate block of memory from pool
	PARAMETERS:	Size of area, ID string
	RETURNS:	Base address of block or NULL
**************************************************************************/

void *memoryAllocate(DWORD size);


/**************************************************************************
	FUNCTION:	memoryDebugAllocate()
	PURPOSE:	Allocate block of memory from pool (with debug info)
	PARAMETERS:	Size of area, ID string, filename, line number
	RETURNS:	Base address of block or NULL
**************************************************************************/

void *memoryDebugAllocate(DWORD size, char *desc, char *file, int line);


/**************************************************************************
	FUNCTION:	memoryFree()
	PURPOSE:	Free block of memory allocated from global pool
	PARAMETERS:	Base ptr
	RETURNS:	
**************************************************************************/

void memoryFree(void *blk);


/**************************************************************************
	FUNCTION:	memoryShow()
	PURPOSE:	Send list of allocated blocks to debug output
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void memoryShow();
void memoryPrintGarbageGap();


/**************************************************************************
	FUNCTION:	memoryShowStats()
	PURPOSE:	Show memory usage statistics
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void memoryShowStats();

void memoryDump(void *pMem);


// Temp blocks are allocated from the bottom of the heap, to avoid
// fragmentation of the top.
// Note that there is no freespace concatenation, etc, in temp blocks
void *memoryTempAllocate(DWORD size);
void *memoryTempDebugAllocate(DWORD size, char *desc, char *file, int line);
void memoryTempFree(void *blk);





void memoryStartJoinMalloc(void);
void memoryJoinMalloc(void **pp, size_t size);
void memoryEndJoinMalloc(char *s);

#endif
