/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	object.h:		General object draw routines

************************************************************************************/

#ifndef _OBJECT_H_
#define _OBJECT_H_



extern int object_atlantis_waterflag;

typedef struct _objectSegDataType {
   	SHORT	segStart;
   	SHORT	segEnd;
	SHORT 	numSegs;
   	UBYTE	segFlags;
   	UBYTE	segFPS;
 	UBYTE 	segName[32];
}objectSegDataType;

typedef struct _AnimType {
	int					num;
	int					frame;
	int					frameFixed;
	int					length;
	int					inc;
	int					speed;
	objectSegDataType	*segInfo;
}AnimType;

enum {
	FIGHT_NONE,				//doing nothing - walking
	FIGHT_ATTACK,			//in process of attacking
	FIGHT_ATTACKHIT,		//attack hits
	FIGHT_BLOCK,			//blocking
	FIGHT_RECOIL,			//recoiling
	FIGHT_OUT,				//knocked out
	FIGHT_GETTING_UP,		//get up from floor
	FIGHT_ON_THE_FLOOR,		//laying on the floor
};

#if PALMODE==1
	#define GLOBALSPEED	7372
#else
	#define GLOBALSPEED	6144
#endif


#define ANIM_START(a,s)				a.num = (s); \
									a.frame = a.frameFixed = 0; \
									a.length = a.segInfo[(s)].segEnd-a.segInfo[(s)].segStart; \
									a.inc = 1; \
									a.speed = GLOBALSPEED;

#define ANIM_STARTSPEED(a,s,sp)		a.num = (s); \
									a.frame = a.frameFixed = 0; \
									a.length = a.segInfo[(s)].segEnd-a.segInfo[(s)].segStart; \
									a.inc = 1; \
									a.speed = (sp);

#define ANIM_STARTBACKWARD(a,s)		a.num = (s); \
									a.length = a.segInfo[(s)].segEnd-a.segInfo[(s)].segStart; \
									a.frame = a.length; \
									a.frameFixed = a.length*4096; \
									a.inc = -1; \
									a.speed = GLOBALSPEED;

#define ANIM_ADVANCEFRAME(a)		a.frameFixed += a.inc*a.speed; \
									a.frame = (a.frameFixed/4096)% a.length;


#define ANIM_CALCFRAMENUM(f,s)		(((f)-((f)-(((((f)/(s)))*(s)))))/4096)
#define ANIM_FRAMENUM(f)			(ANIM_CALCFRAMENUM(((f)*4096),GLOBALSPEED))
#define ANIM_FRAMENUMSPEED(f,s)		(ANIM_CALCFRAMENUM(((f)*4096),(s)))



typedef struct {
	short   nx, ny, nz;
	u_char  tu, tv;
}NORM;





//typedef struct {
//	short   nx, ny, nz;
//	u_char  tu, tv;
//}NORM;

typedef struct{
	VERT *vertop;         /* vertex top address of TMD format */
	u_long  vern;           /* the number of vertex of TMD format */	//this could be a ushort, but doesnt work!?
	NORM *nortop;         /* normal top address of TMD format */
	u_long  norn;           /* the number of normal of TMD format */   //this could be a ushort, but doesnt work!?
	u_long *primtop;        /* primitive top address of TMD format */
	u_long  primn;          /* the number of primitives of TMD format */  //this could be a ushort, but doesnt work!?
	USHORT	frames;			/*num of frames in animation*/
	USHORT  scale;          /* the scale factor of TMD format SQRT of width*height*length (from boundbox)*/
	UBYTE 	name[10];
	SHORT	boundminx,boundmaxx;			// X bounds
	SHORT	boundminy,boundmaxy;			// Y bounds
	SHORT	boundminz,boundmaxz;			// Z bounds
	SHORT	pad;	
	VERT	center;							//	center point of segment
	SHORT	sorttablesize[4];
  	int		*sorttable[4];
	ULONG   packetbuildsize;
}NEWTMD;

/*
typedef struct _myCOORDINATE2{	//this maps over a SONY structure, so DO NOT alter!
	unsigned long flg;	
	MATRIX  coord;
	MATRIX  workm;		
	GsCOORD2PARAM *param;		
	struct _myCOORDINATE2 *super;
	struct _MODEL *child; 
	SVECTOR rotate;			//angle of object vx,vy,vz
	SVECTOR scale;
}myCOORDINATE2;
 */
/*typedef struct _OBJECT {
	unsigned long flags;	
	MATRIX  matrixscale;		//not needed
	MATRIX  matrix;
//	GsCOORD2PARAM *param;		
	struct _OBJECT *parent;
	struct _OBJECT *child; 
	struct _OBJECT *sister; 
 	SVECTOR rotate;			//angle of object vx,vy,vz
   	VECTOR scale;
	NEWTMD *meshdata;
}OBJECT;

*/


/*
typedef struct _MODEL
{
				OBJECT world;
				UBYTE	framenum;
				SHORT   depthoffset;
   				VECTOR globalscale;
				VECTOR inverseglobalscale;
}MODEL;	 

  */


typedef struct{
	LONG x,y,z,w;
}QVECTOR;

typedef struct{
	QVECTOR vect;
	LONG time;
}KEYFRAME;


typedef struct _NEWOBJECT{
	unsigned long flags;	
	MATRIX  	matrixscale;		//not needed
	MATRIX  	matrix;
	USHORT		Animstart;
	USHORT		Animend;
	USHORT		numScaleKeys;
	USHORT		numMoveKeys;
	USHORT		numRotateKeys;
	USHORT		pad;
	KEYFRAME	*scalekeys;
	KEYFRAME	*movekeys;
	KEYFRAME	*rotatekeys;
	struct		_NEWOBJECT *parent;
	struct		_NEWOBJECT *child; 
	struct		_NEWOBJECT *next; 
	IQUATERNION	qRot;
	IQUATERNION	qRotVel;
	IQUATERNION	qRotLight;
	IQUATERNION	qRotLightVel;
 	SVECTOR		rotate;			//angle of object vx,vy,vz
   	VECTOR		scale;
	NEWTMD		*meshdata;		//sort list size and pointers included in TMD
} NEWOBJECT;


typedef struct	_NEWMODEL{
				NEWOBJECT	world;
				UBYTE		framenum;
				SHORT		depthoffset;
   				VECTOR		globalscale;
				VECTOR		inverseglobalscale;
				VECTOR		position;
//				QUATERNION	qRot;
//				QUATERNION	qRotVel;
				struct _NEWOBJECT	**segmenttable;
//				struct _NEWOBJECT	**segmentorder;
				ULONG		numberofsegments;
			}NEWMODEL;	 


typedef struct _MODELCTRL
{
	USHORT 	depthoveride; //0=sort normally, otherwise model will be at this depth;
	UBYTE  	specialmode;	//OFF WIREFRAME GHOST STEALTH
	UBYTE	onmap;		//YES or NO;
	RGB		col;		//override RGB of model
	UBYTE   sprites;	//ON or OFF attached sprites on model
	UBYTE	lighting;	//OFF ON
	UBYTE	semitrans;  //0 or 2 for ON!
	USHORT  PrimLeft;
	int*	SortPtr;
	LONG	polyclipsize; //0=calculate from camera,1->254 is the size, 255 dont clip any polys 
	ULONG*	PrimTop;
	VERT*	VertTop;
	VERT*	NormTop;
	UBYTE	scaling;
	UBYTE showquad;
	LONG clipflag;
	LONG polysdrawn;
	LONG polysclipped;
	LONG preclipped;
	LONG numPolysDrawn;
	LONG sortdepth;
	LONG sorttable;
	USHORT lastdepth;
	USHORT nearclip; //default 100
	UBYTE shownormals;	 //only works in wire frame mode
	UBYTE reducefaces;	 //only works on loading
	GsRVIEW2* whichcamera;			
	SHORT addoffset;
	RGB ghostcol;		// added by Ian 25/3/98

	int		originX, originY, originZ;
	ULONG	indDepth;
	VECTOR *pWaterBox;
	int		waterClipFlags;
	UBYTE	specialFX;
	UBYTE	fadeout;// street spirit
	UBYTE	subdivide;
	UBYTE	split;	// Tom used for cracking control
	NEWMODEL *currentmodel;	// Fred, 5 mar 99, for sprite scales
	UBYTE halfgouraud;
	UBYTE subdivflag;
	UBYTE brown;
}MODELCTRL;


//#endif

/*
typedef struct _objectSegDataType {
   	SHORT	segStart;
   	SHORT	segEnd;
	SHORT 	numSegs;
   	UBYTE	segFlags;
   	UBYTE	segFPS;
// 	UBYTE 	segName[32];
} objectSegDataType;
*/


extern MODELCTRL modelctrl;


/**************************************************************************
	FUNCTION:	objectDraw()
	PURPOSE:	Draw a generic hierarchical object
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void objectDraw(NEWMODEL *actor);

// Position is taken from the NEWMODEL structure. Radii are "small" (not *4096)
// This rou calls "getheightat". If the height of the shadow is known & fixed, call the shadow rou directly
// If the object is within "objradius" of the floor, the shadow will be inserted at the same OT position
// as the object, otherwise it will be independantly sorted
// (flags (will be) for things like height-dependant shadow radii)
void objectDrawWithShadow(NEWMODEL *actor,LONG objradius,LONG shadradius,int flags);

void 	objectDrawCheckWaterShadow(NEWMODEL *model, int frame,LONG objradius,LONG shadradius, int flags);


/**************************************************************************
	FUNCTION:	objectSetupSegmentSort()
	PURPOSE:	Set up object inter-segment sorting
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void objectSetupSegmentSort(NEWMODEL *model);


/**************************************************************************
	FUNCTION:	objectSegmentSort()
	PURPOSE:	Sort object segments
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void objectSegmentSort(NEWMODEL *model);


/**************************************************************************
	FUNCTION:	objectSetAnimation()
	PURPOSE:	Set keyframe information for current object frame
	PARAMETERS:	Model structure, frame number
	RETURNS:	
**************************************************************************/

void objectSetAnimation(NEWMODEL *actor, ULONG frame);


/**************************************************************************
	FUNCTION:	objectLoadSeg()
	PURPOSE:	Load animation segments for object
	PARAMETERS:	Seg info
	RETURNS:	
**************************************************************************/

objectSegDataType *objectLoadSeg(char *name);


/**************************************************************************
	FUNCTION:	objectFree()
	PURPOSE:	for freeing an actor
	PARAMETERS:	model pointer and object pointer
	RETURNS:	
**************************************************************************/

void objectFree(NEWMODEL *mPtr, NEWOBJECT *oPtr);


/**************************************************************************
	FUNCTION:	objectInstanceFree()
	PURPOSE:	for freeing an instance
	PARAMETERS:	model pointer and object pointer
	RETURNS:	
**************************************************************************/

void objectInstanceFree(NEWMODEL *mPtr, NEWOBJECT *oPtr);


/**************************************************************************
	FUNCTION:	
	PURPOSE:	
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void objectLookAtPoint(NEWMODEL *actor, VERT *point);


/**************************************************************************
	FUNCTION:	
	PURPOSE:	
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void objectSetHeadAngle(NEWMODEL *actor, long angle);


/**************************************************************************
	FUNCTION:	objectShowGun
	PURPOSE:	Show GUN object in hierarchy
	PARAMETERS:	Model
	RETURNS:	
**************************************************************************/

void objectShowGun(NEWMODEL *actor);


/**************************************************************************
	FUNCTION:	objectHideGun
	PURPOSE:	Hide GUN object in hierarchy
	PARAMETERS:	Model
	RETURNS:	
**************************************************************************/

void objectHideGun(NEWMODEL *actor);

void objectCalcNorms(NEWOBJECT *world);


void Set_Model_CoordsNew(NEWMODEL *model,LONG x,LONG y,LONG z,LONG vx,LONG vy,LONG vz);

/**************************************************************************
	FUNCTION:	polyDrawLineClipped()
	PURPOSE:	Clip line + add line to packet draw list
	PARAMETERS:	x0,y0,x1,y1, r,g,b, Depth value
	RETURNS:	
**************************************************************************/

void polyDrawLineClipped(int x0, int y0, int x1, int y1, char r, char g, char b, int depth);


void objectSetSegments(NEWMODEL *model,NEWOBJECT *object);
void objectCalcWorldMatrix(NEWMODEL *actor, NEWOBJECT *world);






/*********************WAS MODEL .H *****************/
 



#endif

