/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	overlay.h:		General overlay handling

************************************************************************************/

#ifndef _OVERLAY_H_
#define _OVERLAY_H_

#define MAX_OVERLAY_FRAMES 32

/***********************************************************************************************/
//typedef struct
//{
//	UBYTE r;
//	UBYTE g;
//	UBYTE b;
//}RGB;

typedef struct
{
	UBYTE r,g,b,code;
}RGBCD;


#define COLOURMASK (15)
#define SPTRCAST (UBYTE*)

#define COL2			(0)
#define COL4			(1)
#define COL8			(2)
#define COL16			(3)
#define COL32			(4)
#define COL64			(5)
#define COL128		(6)
#define COL256		(7)
#define COL16BIT		(8)
#define COL24BIT		(9)

#define ALLFLAGS		(-1)
#define FIRSTSPR 		(0)
#define FLIP 			(1<<4)
#define BITSTREAM 		(1<<5)
#define RUNLENGTH 		(1<<6)
#define RESPAGE 		(1<<7)
#define LASTSPR 		(1<<8)
#define NOIMAGE		(1<<9)
#define TEMPVRAM		(1<<10)
#define DONTXORVRAM     (1<<11) 	
//#define OLDSPR	     (1<<12)
#define INVRAM	     (1<<13)
#define SPLIT		     (1<<14)
#define TEMPVRAMCNT	(1<<15)

typedef struct {
			 UBYTE *image; /*0*/     /*whoops should be a *UBYTE */
			 USHORT *pal;	/*4*/	 /*whoops should be a *USHORT */
			 UBYTE x;      /*8*/  
			 UBYTE y;	     /*9*/	
			 UBYTE w;      /*10*/
			 UBYTE h;      /*11*/ 
			 SHORT u;      /*12*/
			 SHORT v;      /*14*/
			 USHORT tpage; /*16*/ 
			 USHORT clut;  /*18*/
			 USHORT flags; /*20*/
			 }SPRITE;       /*22*/  /*24 bytes*/

typedef struct {
			 UBYTE *image; /*0*/     /*whoops should be a *UBYTE */
			 USHORT *pal;	/*4*/	 /*whoops should be a *USHORT */
			 UBYTE x;      /*8*/  
			 UBYTE y;		/*9*/	
			 UBYTE w;      /*10*/
			 UBYTE h;      /*11*/ 
			 SHORT u;      /*12*/
			 SHORT v;      /*14*/
			 USHORT tpage; /*16*/ 
			 USHORT clut;  /*18*/
			 USHORT flags; /*20*/
			 USHORT pad0;
			u_char	u0, v0;	u_short	clut1; //this must start on a long boundary
			u_char	u1, v1;	u_short	tpage1;
			u_char	u2, v2;	u_short	pad1;
			u_char	u3, v3;	u_short	pad2;
			int	handle;
}SPRITEX;       /*22*/  /*24 bytes*/

#define FLIPX 		1
#define FLIPY 		2
#define USESPRITEX  4


#define GOURAUDSPR 1 
#define GOURAUDSCR 2
typedef struct{
			UBYTE		r,g,b,semitrans;
			UBYTE		r1,g1,b1,shaded;
			SHORT	scalex;
			SHORT	scaley;
			BYTE		center;
			BYTE		flipx;
			BYTE		flipy;
			BYTE		true_alpha;
			SHORT		forceZ;
			USHORT	tempvram;
			ULONG	attribute;
			USHORT	overrideclut;
			USHORT farclip;
			GsSPRITE  *zbufspr;
			BYTE		noclip;
			UBYTE	nofade;
			UBYTE	usespritex; //fills a bigger sprite structure
			UBYTE	basecenter; //sets origin, to base of sprite
			LONG	rotate;
			RGBCD gouraudrgb[4];
			UBYTE gouraud; //OFF/ON
			UBYTE greyscale;
		   	int stretch;
}SPRCTRL;

extern UBYTE num256cluts;

#define MAX16CLUTS (512+1024+12*16)
#define MAX256CLUTS 4
extern	USHORT copy16cluts[MAX16CLUTS][16];
extern	USHORT pal16check;

extern ULONG 		vram_slot_table[32][64];
extern UBYTE	vram_slot_count[32][64];
extern UBYTE 		cluts16[MAX16CLUTS];
extern UBYTE 		cluts256[MAX256CLUTS];
extern SPRCTRL		sprctrl;
extern SHORT		fade;
extern SHORT		fadespd;
extern USHORT last256cols[256];
extern UBYTE 		colours2bits[];
extern USHORT last256slot;
//extern RGB 	FogCol;
//extern UBYTE fogpalnumber;



typedef struct {
	unsigned long length;
	GsOT_TAG *org;
	unsigned long offset;
	unsigned long point;
	GsOT_TAG *tag;
	unsigned long shift;
	ULONG *end;
	ULONG truncate;
}GsOTA;


#define TRUESCALE 2

#define SPX			(16)
#define SCIT			(8)
#define FROMVRAM		(1)
#define FROMMEM		(2)
#define FROMPOINTER	(4)
#define TOVRAM		(1)
#define TOMEM			(2)

typedef struct{
				ULONG id;
			 	ULONG flag;
			 	ULONG clutlen;
				USHORT cx,cy;
				USHORT cw,ch;
				USHORT col[16];
				ULONG pixlen;
				USHORT px,py;
				USHORT pw,ph;
				UBYTE data;
			}TIM;


SPRITE* Tim2Spr(TIM* tim);

typedef struct{
	ULONG 	forcelocation;
	UBYTE 	vramtopback; //=0;
	UBYTE   alignTextures; //=NO;
	UBYTE   flipable; //=NO
	UBYTE	tilewidth;
	UBYTE	tileheight;
	UBYTE	returnfirsttexture;	//YES
	UBYTE	*name;
}VRAMCTRL;
extern VRAMCTRL Vramctrl;

#define NLASTSPR	1 
#define NEIGHTBIT	2
#define NSPLIT		4
#define NBITSTREAM	8

#define NCOLOURKEY	32

typedef struct tagNSPRITE{
	UBYTE *image; 	//UBYTE *image; 
	USHORT *pal;    //UWORD *pal;	
	UBYTE w; 
	UBYTE h;   
	SHORT u;    
	SHORT v;
	USHORT flags;
	ULONG crc;     
}NSPRITE; 



void spritePrint(SPRITEX *spr,SHORT x,SHORT y,USHORT zbuf);
void spriteReset(void);


#define MAX_OVERLAYS 180

typedef struct tagFRAMELIST
{
	SPRITEX *texture[MAX_OVERLAY_FRAMES];
	short numFrames;
	short currentFrame;
}FRAMELIST;

typedef struct tagOVERLAY
{
	struct tagOVERLAY *next,*prev;
	SPRITEX *texture;
	short	xPos,yPos;
	short	zPos,currentFrame;	
	SHORT scaleX,scaleY;
	UBYTE r,g,b,a;
//	Sprite sprite;
	BOOL behindText;
	int	active;
	FRAMELIST *frameList;
}OVERLAY;

typedef struct
{
	OVERLAY head;
	int		numEntries;
	void	*dl;
}OVERLAYLIST;


void overlayClearAll(void);

void overlaySetup(OVERLAY *overlay, SPRITEX *texture, int xPos, int yPos, int zPos, int attrib);
void overlaySetupAndAdd(OVERLAY *overlay, SPRITEX *texture, int xPos, int yPos, int zPos, int attrib);
void overlayInitialise(OVERLAY *overlay);
void overlayInitialiseList(void);
void overlaySub(OVERLAY *overlay);
void overlayAdd(OVERLAY *overlay);
void overlayPrintAll(void);
void overlayPrint(OVERLAY *overlay);


void overlayFindFrames(OVERLAY *pOverlay, char *sStr);









extern USHORT overlayAlphaClut;






#endif
