#include "glover.h"


void	doRampsWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;
	

//	COPYVECTOR(&vreboundBounce[reboundBouncecount], pD->pVel);
	//COPYVECTOR(&tempVec, pD->pVel);
	COPYVECTOR(&tempVec, reboundBounce);
	UpdateRampCollision(pD , pHitData , collPos , reboundBounce);
/*
	COPYVECTOR(&tempVel, reboundBounce);
	SUBVECTOR(&tempVec1,&tempVec,&tempVel);
	tempVec1.vx=(tempVec1.vx* (4096-Physics->bounce) )/4096;
	tempVec1.vy=(tempVec1.vy* (4096-Physics->bounce) )/4096;
	tempVec1.vz=(tempVec1.vz* (4096-Physics->bounce) )/4096;
	tempVec1.vx/=2;
	tempVec1.vy/=2;
	tempVec1.vz/=2;

	ADDVECTOR(reboundBounce,reboundBounce,&tempVec1);
*/
} 

////////////////////////////////////////////////////////////////


void	doPlanesWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;

	UpdatePlaneCollision(pD , pHitData , collPos , reboundBounce);
	switch(pHitData->plane)
 	{
 		case D_XZPLANE:
 		case U_XZPLANE:
//		reboundBounce->vy=(reboundBounce->vy*Physics->bounce)/4096;
		break;

 		case D_YZPLANE:
 		case U_YZPLANE:
//		reboundBounce->vx=(reboundBounce->vx*Physics->bounce)/4096;
		break;

		case D_XYPLANE:
 		case U_XYPLANE:
//		reboundBounce->vz=(reboundBounce->vz*Physics->bounce)/4096;
		break;
	}
}

////////////////////////////////////////////////////////////////

void	doEdgesWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;

	//COPYVECTOR(&tempVec, pD->pVel);
	COPYVECTOR(&tempVec, reboundBounce);
	UpdateEdgeCollision(pD , pHitData , collPos , reboundBounce);

/*	COPYVECTOR(&tempVel, reboundBounce);
	SUBVECTOR(&tempVec1,&tempVec,&tempVel);
	tempVec1.vx=(tempVec1.vx* (4096-Physics->bounce) )/4096;
	tempVec1.vy=(tempVec1.vy* (4096-Physics->bounce) )/4096;
	tempVec1.vz=(tempVec1.vz* (4096-Physics->bounce) )/4096;
	tempVec1.vx/=2;
	tempVec1.vy/=2;
	tempVec1.vz/=2;

	ADDVECTOR(reboundBounce,reboundBounce,&tempVec1);
*/
}


////////////////////////////////////////////////////////////////

void	doCornersWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)				
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;


	//COPYVECTOR(&tempVec, pD->pVel);
	COPYVECTOR(&tempVec, reboundBounce);
	UpdateCornerCollision(pD , pHitData , collPos , reboundBounce);
/*
	COPYVECTOR(&tempVel, reboundBounce);
	SUBVECTOR(&tempVec1,&tempVec,&tempVel);
	tempVec1.vx=(tempVec1.vx* (4096-Physics->bounce) )/4096;
	tempVec1.vy=(tempVec1.vy* (4096-Physics->bounce) )/4096;
	tempVec1.vz=(tempVec1.vz* (4096-Physics->bounce) )/4096;
	tempVec1.vx/=2;
	tempVec1.vy/=2;
	tempVec1.vz/=2;

	ADDVECTOR(reboundBounce,reboundBounce,&tempVec1);
*/
}

////////////////////////////////////////////////////////////////

void	doCylindersWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)				
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;


	//COPYVECTOR(&tempVec, pD->pVel);
	COPYVECTOR(&tempVec, reboundBounce);
	UpdateCylinderCollision(pD , pHitData , collPos , reboundBounce);
/*
	COPYVECTOR(&tempVel, reboundBounce);
	SUBVECTOR(&tempVec1,&tempVec,&tempVel);
	tempVec1.vx=(tempVec1.vx* (4096-Physics->bounce) )/4096;
	tempVec1.vy=(tempVec1.vy* (4096-Physics->bounce) )/4096;
	tempVec1.vz=(tempVec1.vz* (4096-Physics->bounce) )/4096;
	tempVec1.vx/=2;
	tempVec1.vy/=2;
	tempVec1.vz/=2;

	ADDVECTOR(reboundBounce,reboundBounce,&tempVec1);
*/
}





////////////////////////////////////////////////////////////////

void	doSpheresWithBounce(COLLDATA *pD , HITDATA *pHitData , VECTOR *collPos , VECTOR *reboundBounce)				
{
VECTOR	tempVec,tempVec1,tempVel;
BEHAVIOUR_PHYSICS	*Physics;

	if (pD->physics==NULL)
	{
		printf ("ERROR no physics model exists\n");
		CRASH;
	}
	Physics=&pD->physics[pD->physicsModel];
	pD->radius=Physics->radius;


	//COPYVECTOR(&tempVec, pD->pVel);
	COPYVECTOR(&tempVec, reboundBounce);
	UpdateSphereCollision(pD , pHitData , collPos , reboundBounce);
/*
	COPYVECTOR(&tempVel, reboundBounce);
	SUBVECTOR(&tempVec1,&tempVec,&tempVel);
	tempVec1.vx=(tempVec1.vx* (4096-Physics->bounce) )/4096;
	tempVec1.vy=(tempVec1.vy* (4096-Physics->bounce) )/4096;
	tempVec1.vz=(tempVec1.vz* (4096-Physics->bounce) )/4096;
	tempVec1.vx/=2;
	tempVec1.vy/=2;
	tempVec1.vz/=2;
	ADDVECTOR(reboundBounce,reboundBounce,&tempVec1);
*/
}

////////////////////////////////////////////////////////////////

