


#ifndef __PUZZLES_H__
#define __PUZZLES_H__


// ============== Variables for other rous to pick up on ============

typedef struct TAGPUZZLEVARS
{
	char any_camera_overrides;

	char camera_parallel_flag;

	int camera_additional_distance;
	int camera_additional_height;
}PUZZLEVARS;
extern PUZZLEVARS PuzzleVars;

// =================== Enums =========================

#define CONDITION_AND	0
#define CONDITION_OR	1

enum
{
	ACTION_START_MOVE,
	ACTION_START_SPIN,
	ACTION_START_ORBIT,
	ACTION_SET_NEXT_POINT,
	ACTION_SET_NEXT_SPIN,
	ACTION_SET_SPIN_WAIT,
	ACTION_SET_SPIN_AXIS,
	ACTION_SET_STATE,
	ACTION_SET_CONVEYOR,
	ACTION_SET_EXISTANCE,
	ACTION_SET_GRAVITY,
	ACTION_SET_VAR,
	ACTION_ADDTO_VAR,
	ACTION_SUBFROM_VAR,
	ACTION_DROP_PICKUP,
	ACTION_ADD_NME,
	ACTION_MOVE_PLAT,
	ACTION_LOOK_AT_PLAT,
	ACTION_LOOK_AT_POINT,
	ACTION_SET_CAMERA_POS,
	ACTION_SET_CAM_DIST,
	ACTION_SET_CAM_HEIGHT,
	ACTION_NME_GOTO_ACTION,
	ACTION_SET_WIND,
	ACTION_DROP_GARIBS,
	ACTION_CAM_HEIGHT,
	ACTION_CAM_DISTANCE,
	ACTION_CAM_PARALLEL,
	ACTION_CAM_FIXEDPOS,
	ACTION_CAM_FIXEDROT,
	ACTION_CAM_CORNER,
	ACTION_CAM_IGNORE_SLOPES,
	ACTION_CAM_CIRCLE,
	ACTION_SET_WATERLEVEL,
	ACTION_EARTHQUAKE,
	ACTION_SET_LEVEL_GRAVITY,
	ACTION_START_CAMEO,
	ACTION_SET_PLAT_DIR,
	ACTION_UNFREEZE_BALL,
	ACTION_START_SOUND,
	ACTION_SET_BACKDROP,
	ACTION_SET_FOG,
	ACTION_ADD_TO_SCORE,
	NUM_ACTION_TYPES
};

enum
{
	CONDITION_AT_POINT,
	CONDITION_AT_SPIN,
	CONDITION_AT_ORBIT,
	CONDITION_JUST_AT_POINT,
	CONDITION_JUST_AT_SPIN,
	CONDITION_JUST_AT_ORBIT,
	CONDITION_HAND_ON,
	CONDITION_HAND_JUST_ON,
	CONDITION_BALL_ON,
	CONDITION_BALL_JUST_ON,
	CONDITION_NME_ON,
	CONDITION_NME_JUST_ON,
	CONDITION_HAND_TOUCHING,
	CONDITION_HAND_JUST_TOUCHED,
	CONDITION_BALL_TOUCHING,
	CONDITION_BALL_JUST_TOUCHED,
	CONDITION_NME_TOUCHING,
	CONDITION_NME_JUST_TOUCHED,
	CONDITION_VAR_EQUAL,
	CONDITION_VAR_NOT_EQUAL,
	CONDITION_VAR_GREATER_THAN,
	CONDITION_VAR_LESS_THAN,
	CONDITION_CONFINED,
	CONDITION_JUST_CONFINED,
	CONDITION_NME_DEAD,
	CONDITION_HAND_CROSSES_LINE,
	CONDITION_HAND_IN_BOX,
	CONDITION_HAND_IN_RANGE,
	CONDITION_BALL_IN_BOX,
	CONDITION_BALL_IN_RANGE,
	CONDITION_CAM_IN_BOX,
	CONDITION_CAM_IN_RANGE,
	CONDITION_HAND_IN_CYLINDER,
	CONDITION_DESTROYED,
	CONDITION_COLLECTED,
	CONDITION_PICKUP_ON,
	NUM_CONDITION_TYPES
};



#define ACTION_GO_ONE_CYCLE		(1<<0)
#define ACTION_GO_ONE_STEP		(1<<1)
#define ACTION_GO_NOW			(1<<2)
#define	ACTION_SET_FAN			(1<<3)
#define ACTION_SET_TELEPORT		(1<<4)
#define ACTION_SET_CATAPULT		(1<<5)
#define ACTION_SET_ELECTRIC		(1<<6)
#define ACTION_USE_VAR			(1<<7)
#define ACTION_SET_VENT			(1<<8)
#define ACTION_SPECIAL			(1<<9)
#define ACTION_SET_BUZZER		(1<<10)
#define ACTION_STOPPED			(1<<11)


// =================== Actions =======================
/*
typedef struct TAGACTION_DROP_GARIBS
{
	char times;	// number of times to do the drop (!?)
	char group;
	SHORT yval;	// if not zero, place at this yvalue
}STRACTION_DROP_GARIBS;
*/
typedef struct TAGACTION_AMOUNT
{
	int value;	// on occasion, this can fill an int (action_set_backdrop)
}STRACTION_AMOUNT;

/*
typedef struct TAGACTION_START_MOVE
{
	unsigned char flags;
	unsigned char platform_tag;
	SHORT max_speed;
}STRACTION_START_MOVE;
*/

typedef struct TAGACTION_VECTOR_TV
{
	SVECTOR vec;
	SHORT value;
	SHORT tag;
//	SHORT flags;
}STRACTION_VECTOR_TV;

typedef struct TAGACTION_QUAKE
{
	SHORT info[4];
	SHORT value;
	SHORT tag;
//	SHORT flags;
}STRACTION_QUAKE;

typedef struct TAGACTION_SOUND
{
	SHORT info[6];
	SVECTOR vec;
	SHORT value;
	SHORT tag;
}STRACTION_SOUND;

typedef struct TAGACTION_VECTOR
{
	SVECTOR vec;
}STRACTION_VECTOR;

typedef struct TAGACTION_FOG
{
	SHORT info[5];
}STRACTION_FOG;

typedef struct TAGACTION_FIXEDROT
{
	SHORT value;
	SHORT speed;
}STRACTION_FIXEDROT;

typedef struct TAGACTION_VAL_TAG_FLAGS
{
	SHORT value;
	SHORT tag;
//	SHORT flags;
}STRACTION_VAL_TAG_FLAGS;

// examples from LND files
//  ACTION DROP_GARIBS  3 0.000000 0 0 
//  ACTION START_MOVE  35 1.000000 6 10 
//  ACTION START_MOVE  50 1.000000 6 10 
//  ACTION SET_CAMERA_POS  0 0.000000 218.000000 297.000000 -2216.000000 0 0 
//  ACTION LOOK_AT_POINT  0 70.000000 91.000000 242.000000 -2632.000000 0 0 


typedef struct TAGACTION
{
	short	timer;
	short	delay;
	short	type;
	short	flags;	// these go up to "1<<11"
	union
	{
// twelves
		STRACTION_VECTOR_TV			vector_tv;
		STRACTION_VAL_TAG_FLAGS		val_tag_flags;
		STRACTION_QUAKE				quake;
// twos
		STRACTION_VECTOR			vector;
		STRACTION_AMOUNT			amount;
		STRACTION_SOUND				sound;
		STRACTION_FOG				fog;
		STRACTION_FIXEDROT			fixedrot;


//		STRACTION_DROP_GARIBS		drop_garibs;
//		STRACTION_DISTANCE			distance;
//		STRACTION_START_MOVE		start_move;
//		STRACTION_SET_CAMERA_POS	set_camera_pos;
//		STRACTION_LOOK_AT_POINT		look_at_point;
	}data;
}ACTION;


// =================== Conditions =======================

// The n64 source for this one always returns false...
typedef struct TAGCONDITION_TAG
{
	short tag;
}STRCONDITION_TAG;

// check = 0,1: garibs, 2:any uncollected from a given group, 3:all collected from a given group
// (most of the conditions are just a garib/platform tag, and a detailed "check type" value (usually 0/1 for "not" condition)
// (at point/just at point use "check" as a path-point number
typedef struct TAGCONDITION_TAGCHECK
{
	short tag;
	short check;
}STRCONDITION_TAGCHECK;

// hand in box, ball in box, camera in box
typedef struct TAGCONDITION_IN_BOX
{
	SVECTOR pos;
	SVECTOR size;
}STRCONDITION_IN_BOX;
typedef struct TAGCONDITION_IN_RANGE
{
	SVECTOR pos;
	SHORT range;
}STRCONDITION_IN_RANGE;
typedef struct TAGCONDITION_IN_CYLINDER
{
	SVECTOR pos;
	SHORT radius;
	SHORT height;
}STRCONDITION_IN_CYLINDER;
typedef struct TAGCONDITION_CROSSES_LINE
{
	SVECTOR p1;
	SVECTOR p2;
	SHORT swing;
}STRCONDITION_CROSSES_LINE;

// used for "at point" and "just at point"
/*
typedef struct TAGCONDITION_AT_POINT
{
	unsigned char platform_tag;
	short path_point;
}STRCONDITION_AT_POINT;
*/

typedef struct TAGCONDITION
{
	UBYTE	type;
	union
	{
		STRCONDITION_TAG			tag;
		STRCONDITION_TAGCHECK		tagcheck;
		STRCONDITION_IN_BOX			in_box;
		STRCONDITION_IN_CYLINDER	in_cylinder;
		STRCONDITION_IN_RANGE		in_range;
		STRCONDITION_CROSSES_LINE	crosses_line;
//		STRCONDITION_AT_POINT		at_point;
	}data;
}CONDITION;

//  CONDITION DESTROYED  76 0 
//  CONDITION HAND_IN_BOX  -307.000000 28.000000 -416.932190 608.419189 142.795013 423.932190 
//  CONDITION JUST_AT_POINT  153 1 


// =================== Top-Level stuff =======================

// we don't want a linked list, we want a structure that's loaded as part of a LEV
typedef struct TAGPUZZLE
{
	struct TAGPUZZLE	*next;

	unsigned char		numconditions;
	unsigned char		andor;
	short				numtimes;
	CONDITION			*conditions;

	short				numactions;
	short				checkactions;

	ACTION				*actions;
}PUZZLE;

// =================== prototypes =======================

// beginning & end of the file-parse
void puzzleBeginFile();
void puzzleEndFile();

// after the end of playing the level
void puzzleFreePuzzles();

// during the file parse
int puzzleParseTokenPuzzle(short token,UBYTE **data);

// sometime during the update
// (note that it puts (ummm, will put) in requests to change the camera pos/dist, so
// within the rendering code wouldn't be a good idea)
void puzzleCheckPuzzles();


#endif

