// SFX.H
// by Chris Wilson
// Started on 19/4/99

#ifndef __SFX_H
#define __SFX_H

#define	SFXPlayDist(vab, sfx, vol, pos, pitch, time)\
	SFXPlay3D(vab, sfx, 64, pos, pitch, time)


void sfxInitialise(UBYTE vabnum);


void PlaySFX(int vab,int sfx,UBYTE volume,UBYTE pitch);

typedef struct tagSFX3DQUEUE
{
	UBYTE priority;//0
	UBYTE volume;
	UBYTE pitch;
	UBYTE vab;
	UBYTE sfx;//4
	UBYTE pad[3];
	long timer;//8
	long endTimer;
	VECTOR *pPos;
	ENEMYPOS *pEnemy;
}SFX3DQUEUE;


#define AMBIENT_STEREO (0)
#define AMBIENT_PROLOGIC (1)

extern	int	volume;

typedef int SFXHANDLE;

//SFXHANDLE SFXPlay3D(int vab, int sfx, UBYTE vol, VECTOR *pObj, UBYTE pitch, int time);
//short SFXPlay(int channel,int vab,int sfx,int rVol, int lVol, UBYTE pitch);
//void SFXPlayStereo(int vab, int sfx, int rVol, int lVol, int pitch, int timer);
//void SFXPlayAmbient(int vab, int sfx, int flags, int vol, int pitch, int timer);
//void SFXUpdate3D(void);
//void SFXShutUp(SFXHANDLE);
//
//SFXHANDLE SFXPlayNME3D(int vab, int sfx, UBYTE vol, ENEMYPOS *pEnemy, UBYTE pitch, int time);
//void SFXStopSounds(void);

//BOOLEAN VABchecker();
void	LoadMusic();




extern UBYTE spellssfxvab;
extern UBYTE glovesfxvab;
extern UBYTE glvoiceAfxvab;


extern	UBYTE globalfxvab;
extern	UBYTE atlantisfxvab;
extern	UBYTE hubfxvab;
extern	UBYTE carnivalfxvab;
extern	UBYTE fortressfxvab;
extern	UBYTE prehistfxvab;
extern	UBYTE piratesfxvab;
extern	UBYTE spacefxvab;
extern	UBYTE levelfxvab;	// = one of the above
extern int music_bank_loaded;

extern int levelFX, globalFX;

#define DEFAULTPITCH 52
#define DEFAULTVOLUME 128


//#define SFX_MAX_VABS 16

extern UBYTE	sfxvolume;
/*
typedef struct SFXCtrlStructType
{
	UBYTE	bSFXOn;					// Are we having SFX in the game at all?
	UBYTE	nStatus;

	UBYTE	fxVolume;				// 0...255
	UBYTE	voiceVolume;
	UBYTE	nError;					// Used To Store Success Or Failure Of Various Functions
									// See defines above for codes

	UBYTE	nTotalVabsLoaded;
	UBYTE	*VabHeadAddr[SFX_MAX_VABS];			// Address to which the file header was loaded
	UBYTE	*VabBodyAddr[SFX_MAX_VABS];			// Address to which the file body was loaded

	SHORT	VabID;
	ULONG	nVabSize;
	
	UBYTE	nLastLoadedVabID;		// Counter for loading file - (0 ... 15)
	UBYTE pitch;
}SFXCTRL;
*/
/**************************************** MACROS **************************************/

//#define SFXShutDown(); sfxDestroy(1);

/********************************* FUNCTION DECLARATIONS ******************************/
#define SIX_MHZ 64
#define VOICE  128
LONG SFXLoad(char *szFilenameStem,UBYTE vabnum );


/**************************************************************************************/

// bank base is used for asserts in sfx.c to ensure you
// only use valid sfx numbers
#if (GOLDCD == NO) && (RELEASE == NO)
#define SFX_HUB_BASE		((HUB+1)<<8)			//	1 * 256
#define SFX_AT_BASE			((ATLANTIS+1)<<8)		// 512
#define SFX_CA_BASE			((CARNIVAL+1)<<8)		// 768	
#define SFX_PI_BASE			((PIRATES+1)<<8)		// 1024
#define SFX_PR_BASE			((PREHISTORIC+1)<<8)	// 1280
#define SFX_FF_BASE			((FORTRESS+1)<<8)		// 1536
#define SFX_SP_BASE			((SPACE+1)<<8)			// 1792
#define SFX_GENERIC_BASE	((GENERIC+1)<<8)		// 2048
#else
#define SFX_HUB_BASE		0
#define SFX_AT_BASE			0
#define SFX_CA_BASE			0
#define SFX_PI_BASE			0
#define SFX_PR_BASE			0
#define SFX_FF_BASE			0
#define SFX_SP_BASE			0
#define SFX_GENERIC_BASE	0
#endif

enum {// Global.vab
SFX_BALLBOUNCE_RUBBER = SFX_GENERIC_BASE,   // = 0,
SFX_BALLBOUNCE_BOWLING,
SFX_BALLBOUNCE_POWER,
SFX_BALLBOUNCE_BEARING,
SFX_BALLBOUNCE_BEACH,
SFX_BALLBOUNCE_CRYSTAL,
SFX_BALLBOUNCE_CRYSTAL_SMASH,
SFX_BALL_BURST,
SFX_HAND_FOOTSTEP_LEFT,
SFX_HAND_FOOTSTEP_RIGHT,
SFX_HAND_SKID,

SFX_HAND_SKID_LOOP,
SFX_HAND_JUMP_SMALL,
SFX_HAND_JUMP_BIG,
SFX_HAND_LAND,		// 6k
SFX_HAND_HURT_1,
SFX_HAND_HURT_2,
SFX_HAND_HURT_3,
SFX_HAND_PUSH_1,
SFX_HAND_PUSH_2,
SFX_HAND_DIE_1,

SFX_HAND_DIE_2,
SFX_HAND_FINGERTAP_1,
SFX_HAND_FINGERTAP_2,
SFX_HAND_FINGERCLICK,
SFX_HAND_FISTSLAM,	// 6k
SFX_HAND_THROW_1,
SFX_HAND_THROW_2,
SFX_HAND_THROW_3,
SFX_HAND_THROW_4_LOOP,
SFX_HAND_WHACKBALL,

SFX_HAND_BOUNCETAP_1,	// 6k
SFX_HAND_BOUNCETAP_2,
SFX_HAND2_JUMP1,
SFX_HAND2_JUMP2,
SFX_HAND2_JUMP3,
SFX_HAND2_JUMP4,
SFX_HAND2_RUNJUMP1,
SFX_HAND2_RUNJUMP2,
SFX_HAND2_RUNJUMP3,
SFX_HAND2_RUNJUMP4,

SFX_HAND2_PUSH1,
SFX_HAND2_PUSH2,
SFX_HAND2_PUSH3,
SFX_HAND2_PUSH4,
SFX_HAND2_HURT1,
SFX_HAND2_HURT2,
SFX_HAND2_HURT3,
SFX_HAND2_HURT4,
SFX_HAND2_SPELL1,
SFX_HAND2_SPELL2,

SFX_HAND2_SPELL3,
SFX_HAND2_SPELL4,
SFX_HAND2_VICTORY1,
SFX_HAND2_VICTORY2,
SFX_HAND2_VICTORY3,
SFX_HAND2_VICTORY4,
SFX_HAND2_DIE1,
SFX_HAND2_DIE2,
SFX_HAND2_DIE3,
SFX_HAND2_WOW,

SFX_IMPACT_STONE_MEDIUM,	// note 40 
SFX_IMPACT_WOOD_MEDIUM,		// 6k note 30
SFX_IMPACT_METAL_MEDIUM,	// 6k note 30
SFX_IMPACT_SAND_MEDIUM,		// note 40
SFX_IMPACT_SNOW_MEDIUM,		// note 40
SFX_IMPACT_MUD_MEDIUM,		// 6K note 30
SFX_IMPACT_WATER_MEDIUM,	// note 40
SFX_STONE_SCRAPE_LARGE,		// 6K note 30 
SFX_METAL_SCRAPE_LARGE,		// note 40
SFX_WOOD_SCRAPE_LARGE,		// 6k note 30

SFX_ICE_SCRAPE_LARGE, 		// note 40
SFX_SWITCH_1,			// note 40
SFX_SWITCH_2,			// note 40
SFX_SWITCH_5,			// note 40
//SFX_SWITCH_6,			// note 30 - use SFX_SWITCH_5 lower pitch
SFX_SWITCH_7,			// note 40
SFX_SWITCH_8,			// 6k note 30

//SFX_BUBBLES_1,		// 6k note 35 - use SFX_BUBBLES_2 higher pitch
SFX_BUBBLES_2,			// 6k note 30 
//SFX_BUBBLES_3,		// 6k note 25 - use SFX_BUBBLES_2 lower pitch

SFX_CAST_SPELL_1,		
SFX_CAST_SPELL_2,		// 6k
SFX_CAST_SPELL_3,
SFX_COLLECT_BONUS_1,
SFX_COLLECT_BONUS_1_ECHO,
SFX_COLLECT_BONUS_2,
SFX_COLLECT_POWERUP_1,		// xtra life collect
SFX_COLLECT_POWERUP_2,		// (frog enemy - unused on n64)
SFX_COLLECT_POWERUP_3,		// garib collection with xtal
SFX_COLLECT_POWERUP_4,		// spell impacting glove
SFX_COLLECT_POWERUP_5,		// spell being collected
SFX_COLLECT_BONUS_3,
SFX_COLLECT_BONUS_4,
SFX_COLLECT_BONUS_5,
SFX_CAST_SPELL_4,
SFX_CAST_SPELL_5,

SFX_FROG_CALL,			// 6k
SFX_TELEPORT_1,
SFX_TELEPORT_2,
SFX_POINT_DIRECTION_1,
SFX_POINT_DIRECTION_2,
SFX_GENERIC_BLEEP_1,		// 6k note 30
//SFX_GENERIC_BLEEP_2,		// 6k note 35 - use SFX_GENERIC_BLEEP_1 higher pitch
SFX_GENERIC_BLEEP_3,		// 6k note 30
//SFX_GENERIC_BLEEP_4,		// 6k note 35 - use SFX_GENERIC_BLEEP_3 higher pitch
SFX_HEAVY_SWITCH,
SFX_HAND_FALL,
SFX_HAND2_FALL,

// new additions
SFX_GE_REGGIE_DEATH,
SFX_GE_BADGLOVE_LAUGH,
SFX_GE_ETHEL_ATTACK,
SFX_GE_SUCKER_SPIT,
SFX_GE_SUCKER_ATTACK_LOOP,
SFX_GE_DENNIS_LAUNCH,
SFX_GE_SAMTEX_WALK,
SFX_GE_FUMBLE_PANTING_LOOP,
SFX_GE_CRUMPET_ATTACK,
SFX_GE_SAMTEX_EXPLODE,
SFX_GE_KEG_CALL,
SFX_GE_CHICKEN_BELCH,
SFX_GE_CHICKEN_FART,
SFX_GE_CHICKEN_CLUCKMAD,
SFX_GE_ROTORBLADE,
};



enum {// hub.vab
SFX_FLANNEL_WINGFLAP = SFX_HUB_BASE, // = 0,
SFX_FLANNEL_CALL,

SFX_CHICKEN_CLUCKNORMAL,
SFX_CHICKEN_CLUCKHARFMAD,

SFX_BIRD_TWEET_1,
SFX_BIRD_TWEET_2,
SFX_BIRD_TWEET_3,		// 6k
SFX_BIRD_TWEET_4,
SFX_BIRD_TWEET_5,
SFX_BIRD_TWEET_6,

SFX_WATERFALL,
SFX_DRIPPING_WATER,
SFX_FOUNTAIN_1,
//SFX_FOUNTAIN_2,		// note 45 - use SFX_FOUNTAIN_1
SFX_HU_SPLASH_SMALL1,
SFX_HU_SPLASH_SMALL2,
SFX_HU_SPLASH_SMALL3,
SFX_HU_SPLASH_SMALL4,

SFX_BAT_WINGFLAP,
SFX_BAT_CALL,
SFX_BAT_CALL_ECHO,

SFX_EERIE_WIND_HUB,			// 6k

// new additions
SFX_HU_FRANKIE_ATTACK_LOOP,
SFX_HU_SUCKER_CRYSTAL,
SFX_HU_BOVVA_GENERAL,
NUM_HUB_FX
};


enum {// atlantis.vab
SFX_SHIRLEY_SWIM_FINS = SFX_AT_BASE, // = 0,
SFX_SHIRLEY_LAND,
SFX_SHIRLEY_LAUNCH,

SFX_MALLET_WALK_LEFT,
SFX_MALLET_WALK_RIGHT,
SFX_MALLET_STAMPEDE,
SFX_MALLET_WAIT,		// 6k

SFX_WATERFALL_AT,
SFX_SEA_WAVES_1,
SFX_SEA_WAVES_2,
SFX_SEA_OFF_EDGE,
SFX_AT_SPLASH_SMALL1,
SFX_AT_SPLASH_SMALL2,
SFX_AT_SPLASH_SMALL3,
SFX_AT_SPLASH_SMALL4,

SFX_SELWYNJOFF_ATTACK,
SFX_SELWYNJOFF_LAND,
SFX_SELWYNJOFF_FLAP_L,
SFX_SELWYNJOFF_FLAP_R,
SFX_SELWYNCANCER_ATTACK,
SFX_SELWYNKIRK_FLY,

// new additions
SFX_AT_FRANKIE_ATTACK_LOOPED,
SFX_AT_SPANK_OOF,

SFX_GENERALWU_DIVESNAP,
SFX_GENERALWU_HITGROUND,
SFX_GENERALWU_PULLUP,
SFX_GENERALWU_WALK_LEFT,
SFX_GENERALWU_WALK_RIGHT,

NUM_ATLANTIS_FX
};

enum {// carnival.vab
SFX_CA_DENNIS_WALK = SFX_CA_BASE, // = 0,			// 6k
SFX_CA_DENNIS_LAND,			// 6k

SFX_CA_CHUCK_CALL,				
SFX_CA_CHUCK_ATTACK,
SFX_CA_CHUCK_JUGGLE,
SFX_CA_CHUCK_WALK,
SFX_CA_CHUCK_JUGGLE_ENDING,	

SFX_CA_BUGLE_CALL,
SFX_CA_BUGLE_ATTACK,
SFX_CA_BUGLE_DEATH,

SFX_KLOSET_CALL,
SFX_KLOSET_WALK_LEFT,
SFX_KLOSET_WALK_RIGHT,
SFX_KLOSET_ATTACK,
SFX_KLOSET_SPINFLOOR,
SFX_KLOSET_BOXINGGLOVE,
SFX_KLOSET_BOMB,
SFX_KLOSET_PIANOFALL,

SFX_TROUSERS_FALLDOWN,

SFX_CA_SPLASH_SMALL1,
SFX_CA_SPLASH_SMALL2,
SFX_CA_SPLASH_SMALL3,
SFX_CA_SPLASH_SMALL4,

SFX_CA_BOVVA_GENERAL,
SFX_CA_BOVVA_ATTACK,


NUM_CARNIVAL_FX
};


enum {// fortress.vab
SFX_THRICE_ATTACK = SFX_FF_BASE, // = 0,
SFX_THRICE_IDLE,

SFX_MIKE_WALK_LEFT,
SFX_MIKE_WALK_RIGHT,
SFX_MIKE_ATTACK,		// 6k

SFX_FUMBLE_CALL,		// 6k
SFX_FUMBLE_WALK,
SFX_FUMBLE_SPOTBALL,		// 6k
SFX_FUMBLE_KEEPBALANCE,		// 6k

SFX_ETHEL_CALL,			// 6k
//SFX_ETHEL_WIND,		// 6k removed to save space - use SFX_EERIE_WIND

SFX_FRANKIE_ATTACK_LOOPED,
SFX_FRANKIE_ATTACK,
SFX_FRANKIE_ATTACK2,
SFX_FRANKIE_GENERALHUM,		// 6k
SFX_FRANKIE_WALK_LEFT,		// 6k
// SFX_FRANKIE_WALK_RIGHT, 	// 6k removed to save space - use SFX_FRANKIE_WALK_LEFT
SFX_FRANKIE_CALL,		// 6k
SFX_FRANKIE_DEATH,		

SFX_SAMTEX_FUSE,
SFX_FF_EERIE_WIND,			// 6k
//SFX_RAIN,			// lower volume of SFX_RAIN_HEAVY
SFX_RAIN_HEAVY,
SFX_THUNDER, 			// 6k
SFX_PORTCULLIS1,		// 6k
SFX_PORTCULLIS2,

// new additions
SFX_FF_CANNONBALL_WALK,
NUM_FORTRESS_FX
};

enum {// pirates.vab
SFX_SHIRLEYSWIM_FINS_P = SFX_PI_BASE, // = 0,
SFX_SHIRLEY_LAND_P,
SFX_SHIRLEY_LAUNCH_P,
SFX_REGGIE_WALK,
SFX_SWISH_WALK_LEFT,
SFX_SWISH_WALK_RIGHT,
SFX_SWISH_ATTACK,
SFX_CHESTER_ATTACK,
SFX_CHESTER_WALK,
SFX_CHESTER_CALL,
SFX_PI_CANNONBALL_WALK,		// 6k
SFX_CHESTER_GROWL, 
SFX_EERIE_WIND_PI,			// 6k

SFX_BIRD_TWEET_1_PI,
SFX_BIRD_TWEET_2_PI,
SFX_BIRD_TWEET_3_PI,		// 6k
SFX_BIRD_TWEET_4_PI,
//SFX_BIRD_TWEET_5,		// removed to save space
//SFX_BIRD_TWEET_6,		// removed to save space

SFX_SEA_WAVES_1_PI,		// 6K note 30
//SFX_SEA_WAVES_2,		// 6k note 26 use SFX_SEA_WAVES_1 lower pitched
SFX_SEA_OFF_EDGE_PI,		// 6k note 30
SFX_WATER_LAPPING_1,		// 6k note 30 
//SFX_WATER_LAPPING_2,		// 6k note 25 use SFX_WATER_LAPPING_1 lower pitched

SFX_PI_SPLASH_SMALL1,
SFX_PI_SPLASH_SMALL2,
SFX_PI_SPLASH_SMALL3,
//SFX_SPLASH_SMALL4,		// removed to save space

SFX_SPANK_CALL_1,		// 6k
SFX_SPANK_CALL_2, 		// 6k
SFX_SPANK_SWING,
SFX_SPANK_ATTACK,
SFX_SPANK_DROP,			// 6k
SFX_SPANK_CALL_3,
SFX_SPANK_CALL_4,
SFX_PI_SPANK_OOF,

// new additions 
SFX_BUGLE_DEATH_PI,
NUM_PIRATES_FX
};


enum {// prehstoric.vab
SFX_CRUMPET_FLY = SFX_PR_BASE, // = 0,
SFX_CRUMPET_CALL,

SFX_TRACY_DANCING,
SFX_TRACY_CALL,
SFX_TRACY_WALK_LEFT,
SFX_TRACY_WALK_RIGHT,
SFX_TRACY_LAND,
SFX_TRACY_CHARGE,
SFX_TRACY_JUMP,

SFX_TREX_CALL,
SFX_TREX_ATTACK,
SFX_TREX_FOOTSTEP_LEFT,
SFX_TREX_FOOTSTEP_RIGHT,
//SFX_TREX_PANTING_LOOP,	// gone

SFX_PR_BOVVA_GENERAL,
SFX_PR_BOVVA_ATTACK,

SFX_ROLLING_SNOWBALL,
SFX_BALLBOUNCE_SNOW,
SFX_WATERFALL_PR,
SFX_EERIE_WIND_PR,			// 6k
SFX_LAVA_1,			// 6k
SFX_LAVA_2,			// 6k
SFX_ROCK_SMASH_1,		// note 45
SFX_ROCK_SMASH_2,		// note 40
//SFX_ROCK_SMASH_3,		// note 35

// new additions
SFX_PR_SPANK_OOF,
SFX_PR_CANNONBALL_WALK,
SFX_PR_FUMBLE_CALL,		// 6k
SFX_PR_SPLASH,		// 6k
NUM_PREHISTORIC_FX
};


enum {// space.vab
SFX_SUCKER_ATTACK = SFX_SP_BASE, // = 0,,
SFX_SUCKER_CALL_1,
SFX_SUCKER_CALL_2,
SFX_SUCKER_CALL_3,		// 6k
SFX_SUCKER_CRYSTAL,
SFX_SUCKER,

//SFX_ROBOT_WALK,
//SFX_ROBOT_ATTACK,
//SFX_ROBOT_GENERAL,		// 6k
//SFX_ROBOT_GENERAL_2,
//SFX_ROBOT_GENERAL_3,
//SFX_ROBOT_GENERAL_4,
//SFX_ROBOT_GENERAL_5,

SFX_YOOFOO_FLY,			// 6k
//SFX_YOOFOO_ATTACK,
SFX_OPEC_IDLE,			// 6k
SFX_OPEC_ATTACK_SINGLE,	
SFX_CYMON_GENERAL,
SFX_CYMON_WALK_LEFT,
SFX_CYMON_WALK_RIGHT,
SFX_ENGINE_FAIL,
SFX_ENGINE_START,
SFX_ENGINE_RUNNING,		// 6k
SFX_ENGINE_FAIL2,
SFX_JETPACK,

// new additions
SFX_SP_BUGLE_DEATH,
SFX_SP_FRANKIE_ATTACK2,
SFX_SP_TRACY_CHARGE,
SFX_SP_CRUMPET_ATTACK,
NUM_SPACE_FX
};

/************************************************************************************/
/**************************************************************************
	FUNCTION:	sfxInitialise()
	PURPOSE:	Initialise sound chip & routines
	PARAMETERS:	none
	RETURNS:	none
**************************************************************************/


//void sfxInitialise();

/**************************************************************************
	FUNCTION:	sfxLoadBank()
	PURPOSE:	loads the requested sample bank
	PARAMETERS:	filename of sample bank
	RETURNS:	none
**************************************************************************/

//void sfxLoadBank(char *filename);


/**************************************************************************
	FUNCTION:	sfxStartSound()
	PURPOSE:	Start sound DMA processing
	PARAMETERS:	none
	RETURNS:	none
**************************************************************************/


//void sfxStartSound();

/**************************************************************************
	FUNCTION:	sfxStopSound()
	PURPOSE:	Stop sound DMA processing
	PARAMETERS:	none
	RETURNS:	none
**************************************************************************/


//void sfxStopSound();

/**************************************************************************
	FUNCTION:	sfxPlaySound()
	PURPOSE:	plays sample
	PARAMETERS:	sample number
	RETURNS:	none
**************************************************************************/

#define sfxPlayVoice sfxPlay
unsigned long sfxPlay(int vab,int sfxNum);
void sfxStopVoice(int sfxNum);

//unsigned long sfxPlaySound(int sfxNum,int vol);
void sfxSetVolume(int sampleNum, int vol);







/**************************************************************************
	FUNCTION:	sfxPlaySound3D()
	PURPOSE:	Plays the requested sound in 3D space
	PARAMETERS:	sample number, position in space
	RETURNS:	none
**************************************************************************/



ULONG sfxPlaySound3D(int vab,int sampleNum, VECTOR *position); //should go!
ULONG sfxPlay3D(int vab,int sampleNum, VECTOR *position);


void sfxDestroy(UBYTE vabnum);

void sfxDisplayDebug();

void sfxSetPitch(int sampleNum, int pitch);

// Play a sound at the NME's position, with zero-volume being the enemy's visibility distance
ULONG sfxPlayNME3D(int vab,int sampleNum, ENEMYPOS *nme);
// vol = 0...256
ULONG sfxPlayVol3D(int vab,int sampleNum, VECTOR *position, int vol);

// full volume, regardless of distance
ULONG sfxPlayFull3D(int vab,int sampleNum, VECTOR *pos);
ULONG sfxPlayFullVol3D(int vab,int sampleNum, VECTOR *pos, int vol);


typedef struct LNDAMBIENTSOUNDDEFTAG
{
	short num;
	short volume;
	short pitch;
	short delay;
	short rnddelay;
	short looptime;
	short plat_tag;
	short tag;

	short x;
	short dummy1;
	short y;
	short dummy2;
	short z;
	short dummy3;
	short radius;
	short dummy4;
}LNDAMBIENTSOUNDDEFSTR;

typedef struct AMBIENTSOUNDTAG
{
	struct AMBIENTSOUNDTAG *next;
	short time;
	short enabled;

	LNDAMBIENTSOUNDDEFSTR def;
}AMBIENTSOUNDSTR;



void sfxPlayParsed(VECTOR *pos,short sfx,short pitch,short vol);
void sfxPlayAmbient(AMBIENTSOUNDSTR *snd);


// ======================================================================

typedef struct _sfxSampleType
{
	unsigned long	size;
	unsigned long	spuOffset;
	unsigned long	pitch;
	long			leftVol;
	long			rightVol;
} sfxSampleType;


typedef struct _sfxBankType
{
	unsigned long	numSamples;
	sfxSampleType	*samples;
	unsigned long	startAddr;
	unsigned long	length;
//	unsigned char	*vh;
} sfxBankType;

#define DEFAULT_PITCH 0x400
#define DEFAULT_VOLUME 0x3fff

extern sfxBankType	sampleBank[2];




#if (GOLDCD == NO) || (RELEASE == NO)
  #define SFX_CHECKBANK(bank,sample) { \
    if(sample > 0xff) \
	{ \
		if(bank == globalFX) \
		{   \
			if(((sample) >> 8) != (GENERIC+1) ) \
			{ \
				DB("Effect bank %d, &%8x failed. should be generic\n",bank,sample); \
				CRASH; \
			} \
			(sample) = (sample) & 0xff; \
		} \
		else if(bank == levelFX) \
		{ \
			if(((sample) >> 8) != (world+1) ) \
			{ \
				DB("Effect bank %d &%8x failed. should be world %d\n",bank,sample,world); \
				CRASH; \
			} \
			(sample) = (sample) & 0xff; \
		} \
		else \
		{ \
			DB("What the hell - bank %d,sample %d?\n",sample); \
			CRASH; \
		} \
	} \
 }
  #define SFX_CHECKBANK2(bank,sample) { \
    if(sample > 0xff) \
	{ \
		if(bank == globalFX) \
		{   \
			if(((sample) >> 8) != (GENERIC+1) ) \
			{ \
				DB("Effect bank %d, &%8x failed. should be generic\n",bank,sample); \
				CRASH; \
			} \
		} \
		else if(bank == levelFX) \
		{ \
			if(((sample) >> 8) != (world+1) ) \
			{ \
				DB("Effect bank %d &%8x failed. should be world %d\n",bank,sample,world); \
				CRASH; \
			} \
		} \
		else \
		{ \
			DB("What the hell - bank %d,sample %d?\n",sample); \
			CRASH; \
		} \
	} \
 }
#else
  #define SFX_CHECKBANK(bank,sample)
  #define SFX_CHECKBANK2(bank,sample)
#endif


// default DEFAULT_PITCH
#define sfxSetSamplePitch(vab,sample,pit) \
{ \
	SFX_CHECKBANK2((vab),(sample)); \
	sampleBank[(vab)].samples[(sample) & 0xff].pitch = (pit); \
}

#define sfxSetSampleVolume(vab,sample,volume) \
{ \
	SFX_CHECKBANK2((vab),(sample)); \
	sampleBank[(vab)].samples[(sample) & 0xff].leftVol = (volume); \
	sampleBank[(vab)].samples[(sample) & 0xff].rightVol = (volume); \
}


#endif


