
#ifndef __SOUND_H
#define __SOUND_H

/*****************************************************************************
  Sound.h
  ==========

  CD and SFX library

  For Example Useage See Comments At End OF c File
*****************************************************************************/
extern ULONG firstmusictrack;

void	Pause_Music();
void	UnPause_Music();
void	Stop_Music(void);
extern	LONG fxvol;
typedef struct {UBYTE soundnum; UBYTE pitch; UBYTE vol;} SOUNDFX;
extern SOUNDFX sound[];
void	Start_Sfx(SHORT sfx,UBYTE lvol,UBYTE rvol,SHORT pitch);

#define BUTTONSOUND1 31

/************************** SINGLE GLOBAL STRUCTURE *************************/
// All CD Functions use this structure. There is no need for ANY other 
// global variables. Each function written stores any results in this 
// structure.

#define MAX_MUSIC_TRACKS	100

#define CD_SUCCESS			0
#define CD_GETTOC_FAILED	1
#define CD_PLAYTRACK_FAILED 2

//void Set_CD2AudioMode();

void Check_CD_Still_Playing();


typedef struct CDPlayerCtrlStructType
{
	UBYTE	nStatus;					// Last Command Issued To The CD SubSystem
	UBYTE	bMusicOn;					// Are we having CD Music in the game at all?
	UBYTE	Volume;					// 0 ... 255
	CdlLOC  loc;
  //	UBYTE	CurrentTrack;				// 0 ... MAX_MUSIC_TRACKS
  //	UBYTE   min;
  //	UBYTE	sec;
  //	UBYTE	milli;
	UBYTE	trackrequested;
	UBYTE	nooftracks;					// Actual Total Number Of Tracks On Disk 0 ... MAX_MUSIC_TRACKS
										
	UBYTE	nError;						// Used To Store Success Or Failure Of Various Functions
 										// See defines above for codes
	UBYTE 	firsttrack;

	CdlATV	sAttenuationVol;							// Stereo Mixing Volume etc

	unsigned char	caCtrlParams[4];			// Parameters Passed To CDControl
	unsigned char	caCtrlResult[8];			// Results Obtained From CDControl
	CdlLOC	toc[MAX_MUSIC_TRACKS];		// Essentially a Table Of Track Start Positions
	UBYTE opendoor;
	UBYTE tryagain;
	UBYTE wait;
}CDCTRL;
extern CDCTRL CDctrl;



typedef struct {
	USHORT  cnt;
	UBYTE	vab;					// Last Command Issued To The CD SubSystem
	UBYTE	sfx;					// Last Command Issued To The CD SubSystem
	UBYTE   pitch;
	UBYTE   volume;
	UBYTE	playside;		//0=normal stereo 1=left(player 1) 2=right(player2) 
}SFXQUEUE;
#define MAXSFXQUEUE 20

extern SFXQUEUE sfxqueue[MAXSFXQUEUE];
				
void 	ResetSFXQueue();
void 	UpdateSFXQueue();
void	PlaySFXQueue(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch,USHORT delay);


void Cd_Pause();
void Cd_UnPause();

/************************************ MACROS **********************************/

// These are re implementations of the standard CD library macros except 
// that they update a flag in the Global CDPlayerControl Function as well

#define CDSETVOLUME(vol, v) (vol)->val0=(vol)->val2=v,(vol)->val1=(vol)->val3=0,CdMix(vol)

#define CDSTANDBY(ctrl)	CdControl((ctrl)->nStatus = CdlStandby,  0, 0)
#define CDPAUSE(ctrl)	CdControl((ctrl)->nStatus = CdlPause,    0, 0)
#define CDSTOP(ctrl)	CdControl((ctrl)->nStatus = CdlStop,     0, 0)
#define CDMUTE(ctrl)	CdControl((ctrl)->nStatus = CdlMute,     0, 0)
#define CDDEMUTE(ctrl)	CdControl((ctrl)->nStatus = CdlDemute,   0, 0)
#define CDFORWARD(ctrl)	CdControl((ctrl)->nStatus = CdlForward,  0, 0)
#define CDBACKWARD(ctrl)	CdControl((ctrl)->nStatus = CdlBackward, 0, 0)

/***************************** FUNCTION DECLARATIONS *************************/

BOOLEAN CDInitialise();
BOOLEAN CDPlayTrack(UBYTE nTrackToPlay);
void CDReportToScreen();		// Really Only For Debugging
/******************************************************************************/
/************************** SINGLE GLOBAL STRUCTURE *************************/

//#define MAX_SFX 16

#define SFX_MAX_VABS 16

#define SFX_SUCCESS						(0)
#define SFX_SSVABOPENHEAD_FAILED		(1<<0)
#define SFX_SSVABTRANSBODY_FAILED		(1<<1)

#define SFX_SFXLOAD_LOADHEADERFAILED	(1<<2)
#define SFX_SFXLOAD_LOADBODYFAILED		(1<<3)
#define SFX_SFXPLAY_SOUNDRANGEERR		(1<<4)

typedef struct SFXStructType
{
	SHORT nVabID;			// Currently set to Zero, to be used later in multiple VAB loads
	SHORT nSound;			// Which one (0...15) is it within that VAB
	SHORT nPitch;			// What is the default pitch to play it at
	SHORT nVol;				// What is the default volume to play it at
	SHORT nVoiceUsed;		// Returned From SSUtKeyOn To Tell Us Which Voice Was Last Used To Play This Sound
}SFXType;


//long testPitch;

extern SFXType SoundEffects[];

typedef struct SFXCtrlStructType
{
	UBYTE	bSFXOn;					// Are we having SFX in the game at all?
	UBYTE	nStatus;

	UBYTE	fxVolume;				// 0...255
	UBYTE	voiceVolume;
	UBYTE	nError;					// Used To Store Success Or Failure Of Various Functions
									// See defines above for codes

	UBYTE	nTotalVabsLoaded;
	UBYTE	*VabHeadAddr[SFX_MAX_VABS];			// Address to which the file header was loaded
	UBYTE	*VabBodyAddr[SFX_MAX_VABS];			// Address to which the file body was loaded

	SHORT	VabID;
	ULONG	nVabSize;
	
	UBYTE	nLastLoadedVabID;		// Counter for loading file - (0 ... 15)
//	char	szFilename[64];			// Filename of last VH/VB pair loaded
	UBYTE pitch;
//	ULONG memory;
}SFXCTRL;
extern SFXCTRL SFXctrl;
#define MAXNUMOFVOICES 32
#define VOICEDELAY	64
extern UBYTE stopvoicesoverlapping[2][MAXNUMOFVOICES];

/**************************************** MACROS **************************************/


/********************************* FUNCTION DECLARATIONS ******************************/
LONG SFXLoad(char *szFilenameStem );
BOOLEAN SFXInitialise();
SHORT SFXPlay(SHORT nSound);
SHORT SFXPlaySpecial(USHORT nSound, USHORT nPitch, USHORT nLeftVol, USHORT nRightVol);
SHORT SFXPlay3D(USHORT nSound, SHORT nPlayerX, SHORT nPlayerY, SHORT nPlayerOrientation, SHORT nSourceX, SHORT nSourceY);

void SFXShutDown();
SHORT PlaySFX(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch);

/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/**********                                            ************************/
/**********                                            ************************/
/**********                                            ************************/
/**********     ALL NEW STUFF                          ************************/
/**********                                            ************************/
/**********                                            ************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
void	Reset_Music();	
void	LoadMusic();

void	Load_Game_Sounds();
void	PlaySFX3D(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch,LONG x,LONG y);

void	InitSound();
void	TestSoundfx();
void	Display_SFX_List();

#define SIX_MHZ 64
#define VOICE  128


extern UBYTE spellssfxvab;
extern UBYTE glovesfxvab;

#define DEFAULTPITCH 52
#define DEFAULTVOLUME 128

enum{ //glove.vab		  
SFX_GLOVEDIE,
SFX_GLOVEHURT,
SFX_GLOVEJUMP,
SFX_GLOVEPUSH,
SFX_GLOVELONGJUMP,
SFX_GLOVESPELL,
SFX_GLOVEVICTORY,
SFX_GLOVEWOW,
SFX_GLOVELAND,
SFX_GLOVESLAM,
SFX_GLOVETHROW,
SFX_GLOVEWHACK,
SFX_GLOVECOOL,
SFX_GLOVESKID,
SFX_GLOVEFALL,
SFX_GLOVEBOUNCE
};


enum{ //spells.vab
SFX_BEEEP,
SFX_BOIING,
SFX_BEEP1,
SFX_BEEP2,
SFX_BEEP3,
SFX_HURRY,
SFX_POBB,
SFX_PON,
SFX_TE,
SFX_TELETYPE
};

#endif