
#ifndef __SOUND_H
#define __SOUND_H

/*****************************************************************************
  Sound.h
  ==========

  CD and SFX library

  For Example Useage See Comments At End OF c File
*****************************************************************************/
extern ULONG firstmusictrack;

void	Pause_Music();
void	UnPause_Music();
void	Stop_Music(void);
extern	LONG fxvol;
typedef struct {UBYTE soundnum; UBYTE pitch; UBYTE vol;} SOUNDFX;
extern SOUNDFX sound[];
void	Start_Sfx(SHORT sfx,UBYTE lvol,UBYTE rvol,SHORT pitch);

#define BUTTONSOUND1 31

/************************** SINGLE GLOBAL STRUCTURE *************************/
// All CD Functions use this structure. There is no need for ANY other 
// global variables. Each function written stores any results in this 
// structure.

#define MAX_MUSIC_TRACKS	100

#define CD_SUCCESS			0
#define CD_GETTOC_FAILED	1
#define CD_PLAYTRACK_FAILED 2

//void Set_CD2AudioMode();

void Check_CD_Still_Playing();


typedef struct CDPlayerCtrlStructType
{
	UBYTE	nStatus;					// Last Command Issued To The CD SubSystem
	UBYTE	bMusicOn;					// Are we having CD Music in the game at all?
	UBYTE	Volume;					// 0 ... 255
	CdlLOC  loc;
  //	UBYTE	CurrentTrack;				// 0 ... MAX_MUSIC_TRACKS
  //	UBYTE   min;
  //	UBYTE	sec;
  //	UBYTE	milli;
	UBYTE	trackrequested;
	UBYTE	nooftracks;					// Actual Total Number Of Tracks On Disk 0 ... MAX_MUSIC_TRACKS
										
	UBYTE	nError;						// Used To Store Success Or Failure Of Various Functions
 										// See defines above for codes
	UBYTE 	firsttrack;

	CdlATV	sAttenuationVol;							// Stereo Mixing Volume etc

	unsigned char	caCtrlParams[4];			// Parameters Passed To CDControl
	unsigned char	caCtrlResult[8];			// Results Obtained From CDControl
	CdlLOC	toc[MAX_MUSIC_TRACKS];		// Essentially a Table Of Track Start Positions
	UBYTE opendoor;
	UBYTE tryagain;
	UBYTE wait;
}CDCTRL;
extern CDCTRL CDctrl;



/*typedef struct {
	USHORT  cnt;
	UBYTE	vab;					// Last Command Issued To The CD SubSystem
	UBYTE	sfx;					// Last Command Issued To The CD SubSystem
	UBYTE   pitch;
	UBYTE   volume;
	UBYTE	playside;		//0=normal stereo 1=left(player 1) 2=right(player2) 
}SFXQUEUE;
#define MAXSFXQUEUE 20

extern SFXQUEUE sfxqueue[MAXSFXQUEUE];
*/				
void 	ResetSFXQueue();
void 	UpdateSFXQueue();
void	PlaySFXQueue(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch,USHORT delay);


void Cd_Pause();
void Cd_UnPause();

/************************************ MACROS **********************************/

// These are re implementations of the standard CD library macros except 
// that they update a flag in the Global CDPlayerControl Function as well

#define CDSETVOLUME(vol, v) (vol)->val0=(vol)->val2=v,(vol)->val1=(vol)->val3=0,CdMix(vol)

#define CDSTANDBY(ctrl)	CdControl((ctrl)->nStatus = CdlStandby,  0, 0)
#define CDPAUSE(ctrl)	CdControl((ctrl)->nStatus = CdlPause,    0, 0)
#define CDSTOP(ctrl)	CdControl((ctrl)->nStatus = CdlStop,     0, 0)
#define CDMUTE(ctrl)	CdControl((ctrl)->nStatus = CdlMute,     0, 0)
#define CDDEMUTE(ctrl)	CdControl((ctrl)->nStatus = CdlDemute,   0, 0)
#define CDFORWARD(ctrl)	CdControl((ctrl)->nStatus = CdlForward,  0, 0)
#define CDBACKWARD(ctrl)	CdControl((ctrl)->nStatus = CdlBackward, 0, 0)

/***************************** FUNCTION DECLARATIONS *************************/

BOOLEAN CDInitialise();
BOOLEAN CDPlayTrack(UBYTE nTrackToPlay);
void CDReportToScreen();		// Really Only For Debugging
/******************************************************************************/
/************************** SINGLE GLOBAL STRUCTURE *************************/

//#define MAX_SFX 16

#define SFX_MAX_VABS 16

#define SFX_SUCCESS						(0)
#define SFX_SSVABOPENHEAD_FAILED		(1<<0)
#define SFX_SSVABTRANSBODY_FAILED		(1<<1)

#define SFX_SFXLOAD_LOADHEADERFAILED	(1<<2)
#define SFX_SFXLOAD_LOADBODYFAILED		(1<<3)
#define SFX_SFXPLAY_SOUNDRANGEERR		(1<<4)

typedef struct SFXStructType
{
	SHORT nVabID;			// Currently set to Zero, to be used later in multiple VAB loads
	SHORT nSound;			// Which one (0...15) is it within that VAB
	SHORT nPitch;			// What is the default pitch to play it at
	SHORT nVol;				// What is the default volume to play it at
	SHORT nVoiceUsed;		// Returned From SSUtKeyOn To Tell Us Which Voice Was Last Used To Play This Sound
}SFXType;


//long testPitch;

extern SFXType SoundEffects[];

typedef struct SFXCtrlStructType
{
	UBYTE	bSFXOn;					// Are we having SFX in the game at all?
	UBYTE	nStatus;

	UBYTE	fxVolume;				// 0...255
	UBYTE	voiceVolume;
	UBYTE	nError;					// Used To Store Success Or Failure Of Various Functions
									// See defines above for codes

	UBYTE	nTotalVabsLoaded;
	UBYTE	*VabHeadAddr[SFX_MAX_VABS];			// Address to which the file header was loaded
	UBYTE	*VabBodyAddr[SFX_MAX_VABS];			// Address to which the file body was loaded

	SHORT	VabID;
	ULONG	nVabSize;
	
	UBYTE	nLastLoadedVabID;		// Counter for loading file - (0 ... 15)
//	char	szFilename[64];			// Filename of last VH/VB pair loaded
	UBYTE pitch;
//	ULONG memory;
}SFXCTRL;
extern SFXCTRL SFXctrl;
#define MAXNUMOFVOICES 32
#define VOICEDELAY	64
extern UBYTE stopvoicesoverlapping[2][MAXNUMOFVOICES];

/**************************************** MACROS **************************************/


/********************************* FUNCTION DECLARATIONS ******************************/
LONG SFXLoad(char *szFilenameStem );
BOOLEAN SFXInitialise();
//SHORT SFXPlay(SHORT nSound);
SHORT SFXPlaySpecial(USHORT nSound, USHORT nPitch, USHORT nLeftVol, USHORT nRightVol);
//SHORT SFXPlay3D(USHORT nSound, SHORT nPlayerX, SHORT nPlayerY, SHORT nPlayerOrientation, SHORT nSourceX, SHORT nSourceY);

void SFXShutDown();
//SHORT PlaySFX(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch);
UBYTE GetSFXChannel(void);
void StopSFX(UBYTE channel);


/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/**********                                            ************************/
/**********                                            ************************/
/**********                                            ************************/
/**********     ALL NEW STUFF                          ************************/
/**********                                            ************************/
/**********                                            ************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
/******************************************************************************/
void	Reset_Music();	
void	LoadMusic();

void	Load_Game_Sounds();
void	PlaySFX3D(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch,LONG x,LONG y);

void	InitSound();
//void	TestSoundfx();
//void	Display_SFX_List();

#define SIX_MHZ 64
#define VOICE  128


extern UBYTE spellssfxvab;
extern UBYTE glovesfxvab;
extern UBYTE glvoiceAfxvab;



extern	UBYTE globalfxvab;
extern	UBYTE atlantisfxvab;
extern	UBYTE hubfxvab;
extern	UBYTE carnivalfxvab;
extern	UBYTE fortressfxvab;
extern	UBYTE prehistfxvab;
extern	UBYTE piratesfxvab;
extern	UBYTE spacefxvab;
extern	UBYTE levelfxvab;	// = one of the above
extern int music_bank_loaded;

extern int levelFX, globalFX;

#define DEFAULTPITCH 52
#define DEFAULTVOLUME 128

/*
enum {// Global.vab
SFX_BALLBOUNCE_RUBBER,
SFX_BALLBOUNCE_BOWLING,
SFX_BALLBOUNCE_POWER,
SFX_BALLBOUNCE_BEARING,
SFX_BALLBOUNCE_BEACH,
SFX_BALLBOUNCE_CRYSTAL,
SFX_BALLBOUNCE_CRYSTAL_SMASH,
SFX_BALL_BURST,

SFX_HAND_FOOTSTEP_LEFT,
SFX_HAND_FOOTSTEP_RIGHT,
SFX_HAND_SKID,
SFX_HAND_SKID_LOOP,
SFX_HAND_JUMP_SMALL,
SFX_HAND_JUMP_BIG,
SFX_HAND_LAND,		// 6k
SFX_HAND_HURT_1,
SFX_HAND_HURT_2,
SFX_HAND_HURT_3,
SFX_HAND_PUSH_1,
SFX_HAND_PUSH_2,
SFX_HAND_DIE_1,
SFX_HAND_DIE_2,
SFX_HAND_FINGERTAP_1,
SFX_HAND_FINGERTAP_2,

SFX_HAND_FINGERCLICK,
SFX_HAND_FISTSLAM,	// 6k
SFX_HAND_THROW_1,
SFX_HAND_THROW_2,
SFX_HAND_THROW_3,
SFX_HAND_THROW_4_LOOP,
SFX_HAND_WHACKBALL,
SFX_HAND_BOUNCETAP_1,	// 6k
SFX_HAND_BOUNCETAP_2,
SFX_HAND2_JUMP1,
SFX_HAND2_JUMP2,
SFX_HAND2_JUMP3,
SFX_HAND2_JUMP4,
SFX_HAND2_RUNJUMP1,
SFX_HAND2_RUNJUMP2,
SFX_HAND2_RUNJUMP3,

SFX_HAND2_RUNJUMP4,
SFX_HAND2_PUSH1,
SFX_HAND2_PUSH2,
SFX_HAND2_PUSH3,
SFX_HAND2_PUSH4,
SFX_HAND2_HURT1,
SFX_HAND2_HURT2,
SFX_HAND2_HURT3,
SFX_HAND2_HURT4,
SFX_HAND2_SPELL1,
SFX_HAND2_SPELL2,
SFX_HAND2_SPELL3,
SFX_HAND2_SPELL4,
SFX_HAND2_VICTORY1,
SFX_HAND2_VICTORY2,
SFX_HAND2_VICTORY3,

SFX_HAND2_VICTORY4,
SFX_HAND2_DIE1,
SFX_HAND2_DIE2,
SFX_HAND2_DIE3,
SFX_HAND2_WOW,

SFX_IMPACT_STONE_SMALL,		// note 45
SFX_IMPACT_STONE_MEDIUM,	// note 40
SFX_IMPACT_STONE_LARGE,		// note 35
SFX_IMPACT_WOOD_SMALL,		// 6k note 35
SFX_IMPACT_WOOD_MEDIUM,		// 6k note 30
SFX_IMPACT_WOOD_LARGE,		// 6k note 25
SFX_IMPACT_METAL_SMALL,		// 6k note 35
SFX_IMPACT_METAL_MEDIUM,	// 6k note 30
SFX_IMPACT_METAL_LARGE,		// 6k note 25
SFX_IMPACT_SAND_SMALL,		// note 45
SFX_IMPACT_SAND_MEDIUM,		// note 40
SFX_IMPACT_SAND_LARGE,		// note 35
SFX_IMPACT_SNOW_SMALL,		// note 45
SFX_IMPACT_SNOW_MEDIUM,		// note 40
SFX_IMPACT_SNOW_LARGE,		// note 35
SFX_IMPACT_MUD_SMALL,		// 6k note 35

SFX_IMPACT_MUD_MEDIUM,		// 6K note 30
SFX_IMPACT_MUD_LARGE,		// 6k note 25
SFX_IMPACT_WATER_SMALL,		// note 45
SFX_IMPACT_WATER_MEDIUM,	// note 40
SFX_IMPACT_WATER_LARGE,		// note 35

SFX_STONE_SCRAPE_LARGE,		// 6K note 30
SFX_STONE_SCRAPE_SMALL,		// 6K note 40
SFX_METAL_SCRAPE_LARGE,		// note 40
SFX_METAL_SCRAPE_SMALL, 	// note 50
SFX_WOOD_SCRAPE_LARGE,		// 6k note 30
SFX_WOOD_SCRAPE_SMALL,		// 6k note 40
SFX_ICE_SCRAPE_LARGE, 		// note 40
SFX_ICE_SCRAPE_SMALL,		// note 51

SFX_SWITCH_1,			// note 40
SFX_SWITCH_2,			// note 40
SFX_SWITCH_3,			// note 36
SFX_SWITCH_4,			// note 36
SFX_SWITCH_5,			// note 40
SFX_SWITCH_6,			// note 30
SFX_SWITCH_7,			// note 40
SFX_SWITCH_8,			// 6k note 30

SFX_BUBBLES_1,			// 6k note 35
SFX_BUBBLES_2,			// 6k note 30
SFX_BUBBLES_3,			// 6k note 25

SFX_CAST_SPELL_1,		
SFX_CAST_SPELL_2,		// 6k
SFX_CAST_SPELL_3,
SFX_COLLECT_BONUS_1,
SFX_COLLECT_BONUS_1_ECHO,
SFX_COLLECT_BONUS_2,
SFX_COLLECT_POWERUP_1,
SFX_COLLECT_POWERUP_2,
SFX_COLLECT_POWERUP_3,
SFX_COLLECT_POWERUP_4,
SFX_COLLECT_POWERUP_5,		// 6k
SFX_COLLECT_BONUS_3,
SFX_COLLECT_BONUS_4,
SFX_COLLECT_BONUS_5,
SFX_CAST_SPELL_4,
SFX_CAST_SPELL_5,

SFX_FROG_CALL,			// 6k
SFX_TELEPORT_1,
SFX_TELEPORT_2,
SFX_POINT_DIRECTION_1,
SFX_POINT_DIRECTION_2,
SFX_GENERIC_BLEEP_1,		// 6k note 30
SFX_GENERIC_BLEEP_2,		// 6k note 35
SFX_GENERIC_BLEEP_3,		// 6k note 30
SFX_GENERIC_BLEEP_4,		// 6k note 35
SFX_HEAVY_SWITCH,
SFX_HAND_FALL,
SFX_HAND2_FALL,
NUM_GENERIC_FX
};
*/
/*
enum { // global.vab
SFX_BALLBOUNCE_RUBBER,				//1
SFX_BALLBOUNCE_BOWLING,				//2
SFX_BALLBOUNCE_POWER,				//3
SFX_BALLBOUNCE_BEARING,				//4	
SFX_BALLBOUNCE_BEACH,				//5
SFX_BALLBOUNCE_CRYSTAL,				//6
SFX_BALLBOUNCE_CRYSTAL_SMASH,			//7
SFX_BALL_BURST,					//8
SFX_HAND_FOOTSTEP_LEFT,				//9
SFX_HAND_FOOTSTEP_RIGHT,			//10
SFX_HAND_SKID,					//11
SFX_HAND_SKID_LOOP,				//12
SFX_HAND_JUMP_SMALL,				//13
SFX_HAND_JUMP_BIG,				//14
SFX_HAND_LAND,		// 6k			//15
SFX_HAND_HURT_1,				//16
SFX_HAND_HURT_2,				//17
SFX_HAND_HURT_3,				//18
SFX_HAND_PUSH_1,				//19
SFX_HAND_PUSH_2,				//20
SFX_HAND_DIE_1,					//21
SFX_HAND_DIE_2,					//22
SFX_HAND_FINGERTAP_1,				//23
SFX_HAND_FINGERTAP_2,				//24
SFX_HAND_FINGERCLICK,				//25
SFX_HAND_FISTSLAM,	// 6k			//26
SFX_HAND_THROW_1,				//27
SFX_HAND_THROW_2,				//28
SFX_HAND_THROW_3,				//29
SFX_HAND_THROW_4_LOOP,				//30
SFX_HAND_WHACKBALL,				//31
SFX_HAND_BOUNCETAP_1,	// 6k			//32
SFX_HAND_BOUNCETAP_2,				//33
SFX_IMPACT_STONE_SMALL,		// note 45	//34	
SFX_IMPACT_STONE_MEDIUM,	// note 40	//35
SFX_IMPACT_STONE_LARGE,		// note 35	//36
SFX_IMPACT_WOOD_SMALL,		// 6k note 35	//37
SFX_IMPACT_WOOD_MEDIUM,		// 6k note 30	//38
SFX_IMPACT_WOOD_LARGE,		// 6k note 25	//39
SFX_IMPACT_METAL_SMALL,		// 6k note 35	//40
SFX_IMPACT_METAL_MEDIUM,	// 6k note 30	//41
SFX_IMPACT_METAL_LARGE,		// 6k note 25	//42
SFX_IMPACT_SAND_SMALL,		// note 45	//43
SFX_IMPACT_SAND_MEDIUM,		// note 40	//44
SFX_IMPACT_SAND_LARGE,		// note 35	//45
SFX_IMPACT_SNOW_SMALL,		// note 45	//46
SFX_IMPACT_SNOW_MEDIUM,		// note 40	//47
SFX_IMPACT_SNOW_LARGE,		// note 35	//48
SFX_IMPACT_MUD_SMAll,		// 6k note 35	//49
SFX_IMPACT_MUD_MEDIUM,		// 6K note 30	//50
SFX_IMPACT_MUD_LARGE,		// 6k note 25	//51
SFX_STONE_SCRAPE_LARGE,		// 6K note 30	//52
SFX_STONE_SCRAPE_SMALL,		// 6K note 40	//53
SFX_METAL_SCRAPE_LARGE,		// note 40	//54
SFX_METAL_SCRAPE_SMALL, 	// note 50	//55
SFX_WOOD_SCRAPE_LARGE,		// 6k note 30	//56
SFX_WOOD_SCRAPE_SMALL,		// 6k note 40	//57
SFX_ICE_SCRAPE_LARGE, 		// note 40	//58
SFX_ICE_SCRAPE_SMALL,		// note 51	//59
SFX_SWITCH_1,			// note 40	//60
SFX_SWITCH_2,			// note 40	//61
SFX_SWITCH_3,			// note 36	//62
SFX_SWITCH_4,			// note 36	//63
SFX_SWITCH_5,			// note 40	//64
SFX_SWITCH_6,			// note 30	//65
SFX_SWITCH_7,			// note 40	//66
SFX_SWITCH_8,			// 6k note 30	//67
SFX_FROG_CALL,			// 6k		//68
SFX_IMPACT_WATER_SMALL,		// note 45	//69
SFX_IMPACT_WATER_MEDIUM,	// note 40	//70
SFX_IMPACT_WATER_LARGE,		// note 35	//71
SFX_HAND2_JUMP1,				//72
SFX_HAND2_JUMP2,				//73
SFX_HAND2_JUMP3,				//74
SFX_HAND2_JUMP4,				//75
SFX_HAND2_PUSH1,				//76
SFX_HAND2_PUSH2,				//77
SFX_HAND2_PUSH3,				//78
SFX_HAND2_PUSH4,				//79
SFX_HAND2_RUNJUMP1,				//80
SFX_HAND2_RUNJUMP2,				//81
SFX_HAND2_RUNJUMP3,				//82
SFX_HAND2_RUNJUMP4,				//83
SFX_HAND2_HURT1,				//84
SFX_HAND2_HURT2,				//85
SFX_HAND2_HURT3,				//86
SFX_HAND2_HURT4,				//87
SFX_HAND2_SPELL1,				//88
SFX_HAND2_SPELL2,				//89
SFX_HAND2_SPELL3,				//90
SFX_HAND2_SPELL4,				//91
SFX_HAND2_VICTORY1,				//92
SFX_HAND2_VICTORY2,				//93
SFX_HAND2_VICTORY3,				//94
SFX_HAND2_VICTORY4,				//95
SFX_HAND2_DIE1,					//96
SFX_HAND2_DIE2,					//97
SFX_HAND2_DIE3,					//98
SFX_BUBBLES_1,			// 6k note 35	//99
SFX_BUBBLES_2,			// 6k note 30	//100
SFX_BUBBLES_3,			// 6k note 25	//101
SFX_HAND2_WOW,					//102
SFX_TELEPORT_1,					//103
SFX_TELEPORT_2,					//104
SFX_CAST_SPELL_1,				//105
SFX_CAST_SPELL_2,		// 6k		//106
SFX_CAST_SPELL_3,				//107
SFX_POINT_DIRECTION_1,				//108
SFX_POINT_DIRECTION_2,				//109
SFX_GENERIC_BLEEP_1,		// 6k note 30	//110
SFX_GENERIC_BLEEP_2,		// 6k note 35	//111
SFX_GENERIC_BLEEP_3,		// 6k note 30	//112
SFX_GENERIC_BLEEP_4,		// 6k note 35	//113
SFX_COLLECT_BONUS_1,				//114
SFX_COLLECT_BONUS_1_ECHO,			//115
SFX_COLLECT_BONUS_2,				//116
SFX_COLLECT_POWERUP_1,				//117
SFX_COLLECT_POWERUP_2,				//118
SFX_COLLECT_POWERUP_3,				//119
SFX_COLLECT_POWERUP_4,				//120
SFX_COLLECT_POWERUP_5,		// 6k		//121
SFX_COLLECT_BONUS_3,				//122
SFX_COLLECT_BONUS_4,				//123
SFX_COLLECT_BONUS_5,				//124
SFX_CAST_SPELL_4,				//125
SFX_CAST_SPELL_5,				//126
SFX_HEAVY_SWITCH,				//127
};							
*/


enum {// Global.vab
SFX_BALLBOUNCE_RUBBER = 0,
SFX_BALLBOUNCE_BOWLING,
SFX_BALLBOUNCE_POWER,
SFX_BALLBOUNCE_BEARING,
SFX_BALLBOUNCE_BEACH,
SFX_BALLBOUNCE_CRYSTAL,
SFX_BALLBOUNCE_CRYSTAL_SMASH,
SFX_BALL_BURST,

SFX_HAND_FOOTSTEP_LEFT = 0x10,
SFX_HAND_FOOTSTEP_RIGHT,
SFX_HAND_SKID,
SFX_HAND_SKID_LOOP,
SFX_HAND_JUMP_SMALL,
SFX_HAND_JUMP_BIG,
SFX_HAND_LAND,		// 6k
SFX_HAND_HURT_1,
SFX_HAND_HURT_2,
SFX_HAND_HURT_3,
SFX_HAND_PUSH_1,
SFX_HAND_PUSH_2,
SFX_HAND_DIE_1,
SFX_HAND_DIE_2,
SFX_HAND_FINGERTAP_1,
SFX_HAND_FINGERTAP_2,

SFX_HAND_FINGERCLICK = 0x20,
SFX_HAND_FISTSLAM,	// 6k
SFX_HAND_THROW_1,
SFX_HAND_THROW_2,
SFX_HAND_THROW_3,
SFX_HAND_THROW_4_LOOP,
SFX_HAND_WHACKBALL,
SFX_HAND_BOUNCETAP_1,	// 6k
SFX_HAND_BOUNCETAP_2,
SFX_HAND2_JUMP1,
SFX_HAND2_JUMP2,
SFX_HAND2_JUMP3,
SFX_HAND2_JUMP4,
SFX_HAND2_RUNJUMP1,
SFX_HAND2_RUNJUMP2,
SFX_HAND2_RUNJUMP3,

SFX_HAND2_RUNJUMP4 = 0x30,
SFX_HAND2_PUSH1,
SFX_HAND2_PUSH2,
SFX_HAND2_PUSH3,
SFX_HAND2_PUSH4,
SFX_HAND2_HURT1,
SFX_HAND2_HURT2,
SFX_HAND2_HURT3,
SFX_HAND2_HURT4,
SFX_HAND2_SPELL1,
SFX_HAND2_SPELL2,
SFX_HAND2_SPELL3,
SFX_HAND2_SPELL4,
SFX_HAND2_VICTORY1,
SFX_HAND2_VICTORY2,
SFX_HAND2_VICTORY3,

SFX_HAND2_VICTORY4 = 0x40,
SFX_HAND2_DIE1,
SFX_HAND2_DIE2,
SFX_HAND2_DIE3,
SFX_HAND2_WOW,

SFX_IMPACT_STONE_SMALL = 0x50,		// note 45
SFX_IMPACT_STONE_MEDIUM,	// note 40
SFX_IMPACT_STONE_LARGE,		// note 35
SFX_IMPACT_WOOD_SMALL,		// 6k note 35
SFX_IMPACT_WOOD_MEDIUM,		// 6k note 30
SFX_IMPACT_WOOD_LARGE,		// 6k note 25
SFX_IMPACT_METAL_SMALL,		// 6k note 35
SFX_IMPACT_METAL_MEDIUM,	// 6k note 30
SFX_IMPACT_METAL_LARGE,		// 6k note 25
SFX_IMPACT_SAND_SMALL,		// note 45
SFX_IMPACT_SAND_MEDIUM,		// note 40
SFX_IMPACT_SAND_LARGE,		// note 35
SFX_IMPACT_SNOW_SMALL,		// note 45
SFX_IMPACT_SNOW_MEDIUM,		// note 40
SFX_IMPACT_SNOW_LARGE,		// note 35
SFX_IMPACT_MUD_SMAll,		// 6k note 35

SFX_IMPACT_MUD_MEDIUM = 0x60,		// 6K note 30
SFX_IMPACT_MUD_LARGE,		// 6k note 25
SFX_IMPACT_WATER_SMALL,		// note 45
SFX_IMPACT_WATER_MEDIUM,	// note 40
SFX_IMPACT_WATER_LARGE,		// note 35

SFX_STONE_SCRAPE_LARGE = 0x70,		// 6K note 30
SFX_STONE_SCRAPE_SMALL,		// 6K note 40
SFX_METAL_SCRAPE_LARGE,		// note 40
SFX_METAL_SCRAPE_SMALL, 	// note 50
SFX_WOOD_SCRAPE_LARGE,		// 6k note 30
SFX_WOOD_SCRAPE_SMALL,		// 6k note 40
SFX_ICE_SCRAPE_LARGE, 		// note 40
SFX_ICE_SCRAPE_SMALL,		// note 51

SFX_SWITCH_1 = 0x80,			// note 40
SFX_SWITCH_2,			// note 40
SFX_SWITCH_3,			// note 36
SFX_SWITCH_4,			// note 36
SFX_SWITCH_5,			// note 40
SFX_SWITCH_6,			// note 30
SFX_SWITCH_7,			// note 40
SFX_SWITCH_8,			// 6k note 30

SFX_BUBBLES_1 = 0x90,			// 6k note 35
SFX_BUBBLES_2,			// 6k note 30
SFX_BUBBLES_3,			// 6k note 25

SFX_CAST_SPELL_1 = 0xa0,		
SFX_CAST_SPELL_2,		// 6k
SFX_CAST_SPELL_3,
SFX_COLLECT_BONUS_1,
SFX_COLLECT_BONUS_1_ECHO,
SFX_COLLECT_BONUS_2,
SFX_COLLECT_POWERUP_1,
SFX_COLLECT_POWERUP_2,
SFX_COLLECT_POWERUP_3,
SFX_COLLECT_POWERUP_4,
SFX_COLLECT_POWERUP_5,		// 6k
SFX_COLLECT_BONUS_3,
SFX_COLLECT_BONUS_4,
SFX_COLLECT_BONUS_5,
SFX_CAST_SPELL_4,
SFX_CAST_SPELL_5,

SFX_FROG_CALL = 0xb0,			// 6k
SFX_TELEPORT_1,
SFX_TELEPORT_2,
SFX_POINT_DIRECTION_1,
SFX_POINT_DIRECTION_2,
SFX_GENERIC_BLEEP_1,		// 6k note 30
SFX_GENERIC_BLEEP_2,		// 6k note 35
SFX_GENERIC_BLEEP_3,		// 6k note 30
SFX_GENERIC_BLEEP_4,		// 6k note 35
SFX_HEAVY_SWITCH,
SFX_HAND_FALL,
SFX_HAND2_FALL,
};



enum {// hub.vab
SFX_FLANNEL_WINGFLAP = 0,
SFX_FLANNEL_CALL,

SFX_CHICKEN_CLUCKNORMAL = 0x10,
SFX_CHICKEN_CLUCKHARFMAD,
SFX_CHICKEN_CLUCKMAD,
SFX_CHICKEN_FART,
SFX_CHICKEN_BELCH,

SFX_BIRD_TWEET_1 = 0x20,
SFX_BIRD_TWEET_2,
SFX_BIRD_TWEET_3,		// 6k
SFX_BIRD_TWEET_4,
SFX_BIRD_TWEET_5,
SFX_BIRD_TWEET_6,

SFX_WATERFALL = 0x30,
SFX_DRIPPING_WATER,
SFX_FOUNTAIN_1,
SFX_FOUNTAIN_2,			// note 45
SFX_SPLASH_SMALL1,
SFX_SPLASH_SMALL2,
SFX_SPLASH_SMALL3,
SFX_SPLASH_SMALL4,

SFX_BAT_WINGFLAP = 0x40,
SFX_BAT_CALL,
SFX_BAT_CALL_ECHO,

SFX_EERIE_WIND = 0x50,			// 6k
SFX_BADGLOVE_LAUGH_1,
NUM_HUB_FX
};


enum {// atlantis.vab
SFX_SHIRLEY_SWIM_FINS = 0,
SFX_SHIRLEY_LAND,
SFX_SHIRLEY_LAUNCH,

SFX_MALLET_WALK_LEFT = 0x10,
SFX_MALLET_WALK_RIGHT,
SFX_MALLET_STAMPEDE,
SFX_MALLET_WAIT,		// 6k

SFX_WATERFALL_A = 0x20,
SFX_SEA_WAVES_1,
SFX_SEA_WAVES_2,
SFX_SEA_OFF_EDGE,
SFX_SPLASH_SMALL1_A,
SFX_SPLASH_SMALL2_A,
SFX_SPLASH_SMALL3_A,
SFX_SPLASH_SMALL4_A,

SFX_SELWYNJOFF_ATTACK = 0x30,
SFX_SELWYNJOFF_LAND,
SFX_SELWYNJOFF_FLAP_L,
SFX_SELWYNJOFF_FLAP_R,
SFX_SELWYNCANCER_ATTACK,
SFX_SELWYNKIRK_FLY,

SFX_GENERALWU_DIVESNAP = 0x40,
SFX_GENERALWU_HITGROUND,	// 6k
SFX_GENERALWU_PULLUP,
SFX_GENERALWU_WALK_LEFT,
SFX_GENERALWU_WALK_RIGHT,
NUM_ATLANTIS_FX
};

enum {// carnival.vab
SFX_DENNIS_WALK = 0,			// 6k
SFX_DENNIS_LAUNCH,			// 6k
SFX_DENNIS_LAND,			// 6k

SFX_CHUCK_CALL = 0x10,				
SFX_CHUCK_ATTACK,
SFX_CHUCK_JUGGLE,
SFX_CHUCK_WALK,
SFX_CHUCK_JUGGLE_ENDING,		// 6k

SFX_BUGLE_CALL = 0x20,
SFX_BUGLE_ATTACK,
SFX_BUGLE_DEATH,

SFX_KLOSET_CALL = 0x30,
SFX_KLOSET_WALK_LEFT,
SFX_KLOSET_WALK_RIGHT,
SFX_KLOSET_ATTACK,
SFX_KLOSET_SPINFLOOR,
SFX_KLOSET_BOXINGGLOVE,
SFX_KLOSET_BOMB,
SFX_KLOSET_PIANOFALL,

SFX_TROUSERS_FALLDOWN = 0x40,
SFX_ROTORBLADE,
NUM_CARNIVAL_FX
};


enum {// fortress.vab
SFX_THRICE_ATTACK = 0,
SFX_THRICE_IDLE,

SFX_MIKE_WALK_LEFT = 0x10,
SFX_MIKE_WALK_RIGHT,
SFX_MIKE_ATTACK,		// 6k

SFX_FUMBLE_CALL = 0x20,		// 6k
SFX_FUMBLE_WALK,
SFX_FUMBLE_SPOTBALL,		// 6k
SFX_FUMBLE_KEEPBALANCE,
SFX_FUMBLE_PANTING_LOOP,

SFX_ETHEL_CALL = 0x30,			// 6k
SFX_ETHEL_WIND,			// 6k
SFX_ETHEL_ATTACK,		// 6k

SFX_FRANKIE_ATTACK_LOOPED = 0x40,
SFX_FRANKIE_ATTACK,
SFX_FRANKIE_ATTACK2,
SFX_FRANKIE_GENERALHUM,		// 6k
SFX_FRANKIE_WALK_LEFT,		// 6k
SFX_FRANKIE_WALK_RIGHT, 	// 6k
SFX_FRANKIE_CALL,
SFX_FRANKIE_DEATH,		// 6k

SFX_SAMTEX_WALK = 0x50,
SFX_SAMTEX_FUSE,
SFX_SAMTEX_EXPLODE,		// 6k

SFX_EERIE_WIND_F = 0x60,			// 6k
SFX_RAIN,			// lower volume
SFX_RAIN_HEAVY,
SFX_THUNDER, 			// 6k
SFX_PORTCULLIS1,		// 6k
SFX_PORTCULLIS2,
SFX_ROTORBLADE_F,
NUM_FORTRESS_FX
};

enum {// pirates.vab
SFX_SHIRLEYSWIM_FINS_P = 0,
SFX_SHIRLEY_LAND_P,
SFX_SHIRLEY_LAUNCH_P,
SFX_REGGIE_WALK,
SFX_REGGIE_DEATH,
SFX_SWISH_WALK_LEFT,
SFX_SWISH_WALK_RIGHT,
SFX_SWISH_ATTACK,
SFX_KEG_CALL,
SFX_KEG_WALK,			// 6k
SFX_CHESTER_ATTACK,
SFX_CHESTER_WALK,
SFX_CHESTER_CALL,
SFX_CANNONBALL_WALK,		// 6k
SFX_CHESTER_GROWL, 
SFX_EERIE_WIND_P,			// 6k

SFX_BIRD_TWEET_1_P = 0x10,
SFX_BIRD_TWEET_2_P,
SFX_BIRD_TWEET_3_P,		// 6k
SFX_BIRD_TWEET_4_P,
SFX_BIRD_TWEET_5_P,
SFX_BIRD_TWEET_6_P,

SFX_SEA_WAVES_1_P = 0x20,		// 6K note 30
SFX_SEA_WAVES_2_P,		// 6k note 26
SFX_SEA_OFF_EDGE_P,		// 6k note 30
SFX_WATER_LAPPING_1_P,		// 6k note 30
SFX_WATER_LAPPING_2_P,		// 6k note 25
SFX_SPLASH_SMALL1_P,
SFX_SPLASH_SMALL2_P,
SFX_SPLASH_SMALL3_P,
SFX_SPLASH_SMALL4_P,

SFX_SPANK_CALL_1 = 0x30,		// 6k
SFX_SPANK_CALL_2, 		// 6k
SFX_SPANK_SWING,
SFX_SPANK_ATTACK,
SFX_SPANK_DROP,			// 6k
SFX_SPANK_CALL_3,
SFX_SPANK_CALL_4,
SFX_SPANK_OOF,
NUM_PIRATES_FX
};


enum {// prehstoric.vab
SFX_CRUMPET_FLY = 0,
SFX_CRUMPET_ATTACK,
SFX_CRUMPET_CALL,

SFX_TRACY_DANCING = 0x10,
SFX_TRACY_CALL,
SFX_TRACY_WALK_LEFT,
SFX_TRACY_WALK_RIGHT,
SFX_TRACY_LAND,
SFX_TRACY_CHARGE,
SFX_TRACY_JUMP,

SFX_TREX_CALL = 0x20,
SFX_TREX_ATTACK,
SFX_TREX_FOOTSTEP_LEFT,
SFX_TREX_FOOTSTEP_RIGHT,
SFX_TREX_PANTING_LOOP,

SFX_BOVVA_GENERAL = 0x30,
SFX_BOVVA_ATTACK,

SFX_ROLLING_SNOWBALL = 0x40,
SFX_BALLBOUNCE_SNOW,
SFX_EERIE_WIND_PR,			// 6k
SFX_WATERFALL_PR,
SFX_LAVA_1,			// 6k
SFX_LAVA_2,			// 6k
SFX_ROCK_SMASH_1,		// note 45
SFX_ROCK_SMASH_2,		// note 40
SFX_ROCK_SMASH_3,		// note 35
NUM_PREHISTORIC_FX
};


enum {// space.vab
SFX_SUCKER_ATTACK_LOOP = 0,
SFX_SUCKER_ATTACK,
SFX_SUCKER_SPIT,
SFX_SUCKER_CALL_1,
SFX_SUCKER_CALL_2,
SFX_SUCKER_CALL_3,		// 6k
SFX_SUCKER_CRYSTAL,
SFX_SUCKER,

SFX_ROBOT_WALK = 0x10,
SFX_ROBOT_ATTACK,
SFX_ROBOT_GENERAL,		// 6k
SFX_ROBOT_GENERAL_2,
SFX_ROBOT_GENERAL_3,
SFX_ROBOT_GENERAL_4,
SFX_ROBOT_GENERAL_5,

SFX_YOOFOO_FLY = 0x20,			// 6k
SFX_YOOFOO_ATTACK,
SFX_OPEC_IDLE,			// 6k
SFX_OPEC_ATTACK_SINGLE,	
SFX_CYMON_GENERAL,
SFX_CYMON_WALK_LEFT,
SFX_CYMON_WALK_RIGHT,
SFX_ENGINE_FAIL,
SFX_ENGINE_START,
SFX_ENGINE_RUNNING,		// 6k
SFX_ENGINE_FAIL2,
SFX_JETPACK,
NUM_SPACE_FX
};































/*


enum{ //glove.vab		  
SFX_GLOVEDIE,
SFX_GLOVEHURT,
SFX_GLOVEJUMP,
SFX_GLOVEPUSH,
SFX_GLOVELONGJUMP,
SFX_GLOVESPELL,
SFX_GLOVEVICTORY,
SFX_GLOVEWOW,
SFX_GLOVELAND,
SFX_GLOVESLAM,
SFX_GLOVETHROW,
SFX_GLOVEWHACK,
SFX_GLOVECOOL,
SFX_GLOVESKID,
SFX_GLOVEFALL,
SFX_GLOVEBOUNCE
};


enum{ //spells.vab
SFX_BEEEP,
SFX_BOIING,
SFX_BEEP1,
SFX_BEEP2,
SFX_BEEP3,
SFX_HURRY,
SFX_POBB,
SFX_PON,
SFX_TE,
SFX_TELETYPE
};



enum {// glvoiceA.vab
SFX_GLDIE1,
SFX_GLDIE1B,
SFX_GLDIE2,
SFX_GLDIE2B,
SFX_GLDIE3B,

SFX_GLFALL,
SFX_GLFALLB,

SFX_GLHURT1,
SFX_GLHURT1B,
SFX_GLHURT2,
SFX_GLHURT2B,
SFX_GLHURT3,
SFX_GLHURT3B,
SFX_GLHURT4B,

SFX_GLPUSH1,
SFX_GLPUSH1B,
SFX_GLPUSH2,
SFX_GLPUSH2B,
SFX_GLPUSH3B,
SFX_GLPUSH4B,
};

*/

#endif