/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	texture.h:		Poly draw routines for general objects

************************************************************************************/

#ifndef _TEXTURE_H_
#define _TEXTURE_H_

// if this is set, then the top bit of the thing pointed to by a clut handle
// indicates that it's an index into vramfogpalette, to an array of clut handles

//#define CLUT_FOGGING_CODE


#define MAXBANKLONGS 32

#define VRAM_STARTX			512

#define VRAM_PAGECOLS		8
#define VRAM_PAGEROWS		2
#define VRAM_PAGES			16
#define VRAM_PAGEW			32
#define VRAM_PAGEH			32
#define VRAM_SETX(X)		(X)
#define VRAM_SETY(Y)		((Y)*VRAM_PAGEW)
#define VRAM_SETXY(X,Y)		((X)+((Y)*VRAM_PAGEW))
#define VRAM_SETPAGE(P)		((P)<<16)
#define VRAM_GETX(HND)		((HND) & (VRAM_PAGEW-1))
#define VRAM_GETY(HND)		(((HND)/VRAM_PAGEW) & (VRAM_PAGEW-1))
#define VRAM_GETXY(HND)		((HND) & 0xffff)
#define VRAM_GETPAGE(HND)	((HND)>>16)
#define VRAM_CALCVRAMX(HND)	(VRAM_STARTX+((VRAM_GETPAGE(HND)%(VRAM_PAGECOLS))*64)+(VRAM_GETX(HND)*2))
#define VRAM_CALCVRAMY(HND)	(((VRAM_GETPAGE(HND)/(VRAM_PAGECOLS))*256)+(VRAM_GETY(HND)*8))

// Current biggie is Carnival bonus (+generics, obv), at 468
#define VRAM_PALETTES		550

#define VRAM_256PALETTES	16

#define MAX_TEXTURE_FRAMES	16

typedef struct _TextureBankType {
	ULONG	nTextures;
	NSPRITE	*pNSprite;
	SPRITEX *pSpriteX;
	ULONG	pUsed[MAXBANKLONGS];// 1024 textures per bank
	ULONG	*CRC;
} TextureBankType;


extern	UBYTE	VRAMblock[VRAM_PAGES][VRAM_PAGEW*VRAM_PAGEH];
extern	UBYTE	VRAMpalBlock[VRAM_PALETTES];
extern	int		VRAMpalHandle[VRAM_PALETTES/32];
extern	USHORT	VRAMpalette[VRAM_PALETTES][16];
/**************************************************************************
	FUNCTION:	textureInitVRAM()
	PURPOSE:	Initialise VRAM/texture handling
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void uploadTimToVRAM(ULONG *addr);
void textureInitVRAM();

void textureCreate(SPRITEX *pSprX, char *pBitMap, short *pCLUT, int x, int y);

USHORT textureAddCLUT16(USHORT *palette);


/**************************************************************************
	FUNCTION:	textureClearVRAM()
	PURPOSE:	Clear VRAM
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void textureClearVRAM(LONG screenwidth);

/**************************************************************************
	FUNCTION:	textureLoadSPT()
	PURPOSE:	Load texture bank file as single sprite
	PARAMETERS:	Filename
	RETURNS:	Sprite info ptr
**************************************************************************/

SPRITEX *textureLoadSPT(UBYTE *name);


/**************************************************************************
	FUNCTION:	textureUnload()
	PURPOSE:	Unload texture from VRAM
	PARAMETERS:	Sprite info ptr
	RETURNS:	
**************************************************************************/

void textureUnload(SPRITEX *sprX);


/**************************************************************************
	FUNCTION:	textureLoadBank()
	PURPOSE:	Load texture bank
	PARAMETERS:	Filename
	RETURNS:	Ptr to texture bank info
**************************************************************************/

TextureBankType *textureLoadBank(char *sFile);


/**************************************************************************
	FUNCTION:	textureFindInBank()
	PURPOSE:	Find given texture in bank
	PARAMETERS:	Texture bank info ptr, Name of texture
	RETURNS:	Sprite info ptr
**************************************************************************/

#define FindTexture textureFindInAllBanks  /*should really do a Search & replace!*/

SPRITEX *textureFindInBank(TextureBankType *pData, char *name);
SPRITEX *textureFindCRCInBank(TextureBankType *bank, ULONG crc);


/**************************************************************************
	FUNCTION:	textureFindInAllBanks()
	PURPOSE:	Find given texture in all loaded banks
	PARAMETERS:	Name of texture
	RETURNS:	Sprite info ptr
**************************************************************************/

SPRITEX *textureFindInAllBanks(char *name);
SPRITEX *textureFindCRCInAllBanks(ULONG crc);

/**************************************************************************
	FUNCTION:	textureDownload()
**************************************************************************/

void textureDownLoad(NSPRITE *nspr,SPRITEX *sprx);

/**************************************************************************
	FUNCTION:	textureDownloadBank()
	PURPOSE:	Download entire texture bank to VRAM
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/

void textureDownloadBank(TextureBankType *bank);


/**************************************************************************
	FUNCTION:	textureDestroyBank()
	PURPOSE:	Free system RAM data for given texture bank
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/
void textureDestroyBank(TextureBankType *bank);
/**************************************************************************
	FUNCTION:	textureUnloadBank()
	PURPOSE:	Unload given texture bank from VRAM
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/
void textureUnloadBank(TextureBankType *bank);
void textureVRAMcounter();
int textureVRAMalloc(short w, short h);
SPRITEX *textureFindFramesAndGetNumber(char *sStr, int *nFrames);

#define textureFindFrames(S) textureFindFramesAndGetNumber(S, NULL);

void textureMakeScrolling(SPRITEX *pSpx);
void textureDoScrolling(void);

void texturePrintStatus();


#endif
