/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	texture.h:		Poly draw routines for general objects

************************************************************************************/

#ifndef _TEXTURE_H_
#define _TEXTURE_H_


//typedef struct {
//	UBYTE	*image; /*0*/
//	USHORT	*pal;	/*4*/
//	UBYTE	x;      /*8*/  
//	UBYTE	y;	     /*9*/	
//	UBYTE	w;      /*10*/
//	UBYTE	h;      /*11*/ 
//	SHORT	u;      /*12*/
//	SHORT	v;      /*14*/
//	USHORT	tpage; /*16*/ 
//	USHORT	clut;  /*18*/
//	USHORT	flags; /*20*/
//}SPRITE;       /*22*/  /*24 bytes*/

//typedef struct {
//	UBYTE *image; /*0*/
//	USHORT *pal;	/*4*/
//	UBYTE x;      /*8*/  
//	UBYTE y;		/*9*/	
//	UBYTE w;      /*10*/
//	UBYTE h;      /*11*/ 
//	SHORT u;      /*12*/
//	SHORT v;      /*14*/
//	USHORT tpage; /*16*/ 
//	USHORT clut;  /*18*/
//	USHORT flags; /*20*/
//	USHORT pad0;
//	u_char	u0, v0;	u_short	clut1; //this must start on a long boundary
//	u_char	u1, v1;	u_short	tpage1;
//	u_char	u2, v2;	u_short	pad1;
//	u_char	u3, v3;	u_short	pad2;
//	int		handle;
//}SPRITEX;
/*
typedef struct tagNSPRITE{
	UBYTE *image; 	//UBYTE *image; 
	USHORT *pal;    //UWORD *pal;	
	UBYTE w; 
	UBYTE h;   
	SHORT u;    
	SHORT v;     
	USHORT flags;
	ULONG crc;
}NSPRITE; 
*/

/*#ifndef _GLOBAL_H_

typedef struct {
	unsigned long length;
	GsOT_TAG *org;
	unsigned long offset;
	unsigned long point;
	GsOT_TAG *tag;
	unsigned long shift;
	ULONG *end;
	ULONG truncate;
} GsOTA;

typedef struct{UBYTE r;
			 UBYTE g;
			 UBYTE b;
			}RGB;

#endif
*/
#define MAXBANKLONGS 32

#define VRAM_STARTX			512

#define VRAM_PAGECOLS		8
#define VRAM_PAGEROWS		2
#define VRAM_PAGES			16
#define VRAM_PAGEW			32
#define VRAM_PAGEH			32
#define VRAM_SETX(X)		(X)
#define VRAM_SETY(Y)		((Y)*VRAM_PAGEW)
#define VRAM_SETXY(X,Y)		((X)+((Y)*VRAM_PAGEW))
#define VRAM_SETPAGE(P)		((P)<<16)
#define VRAM_GETX(HND)		((HND) & (VRAM_PAGEW-1))
#define VRAM_GETY(HND)		(((HND)/VRAM_PAGEW) & (VRAM_PAGEW-1))
#define VRAM_GETXY(HND)		((HND) & 0xffff)
#define VRAM_GETPAGE(HND)	((HND)>>16)
#define VRAM_CALCVRAMX(HND)	(VRAM_STARTX+((VRAM_GETPAGE(HND)%(VRAM_PAGECOLS))*64)+(VRAM_GETX(HND)*2))
//#define VRAM_CALCVRAMX(HND)	(640+((VRAM_GETPAGE(HND)%(VRAM_PAGECOLS))*64)+(VRAM_GETX(HND)*2))
#define VRAM_CALCVRAMY(HND)	(((VRAM_GETPAGE(HND)/(VRAM_PAGECOLS))*256)+(VRAM_GETY(HND)*8))

#define VRAM_PALETTES		800
#define VRAM_FOGPALETTES	256

#define MAX_TEXTURE_FRAMES	16

typedef struct _TextureBankType {
	ULONG	nTextures;
	NSPRITE	*pNSprite;
	SPRITEX *pSpriteX;
	//ULONG	*pUsed;
	ULONG	pUsed[MAXBANKLONGS];// 1024 textures per bank
	ULONG	*CRC;
} TextureBankType;


extern	UBYTE	VRAMblock[VRAM_PAGES][VRAM_PAGEW*VRAM_PAGEH];
extern	UBYTE	VRAMpalBlock[VRAM_PALETTES];
extern	int		VRAMpalHandle[VRAM_PALETTES/32];
extern	USHORT	VRAMpalette[VRAM_PALETTES][16];

extern  USHORT  VRAMfogPalette[];




/**************************************************************************
	FUNCTION:	textureInitVRAM()
	PURPOSE:	Initialise VRAM/texture handling
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void textureInitVRAM();

USHORT textureAddCLUT16(USHORT *palette);


/**************************************************************************
	FUNCTION:	textureClearVRAM()
	PURPOSE:	Clear VRAM
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void textureClearVRAM(LONG screenwidth);

/**************************************************************************
	FUNCTION:	textureLoadSPT()
	PURPOSE:	Load texture bank file as single sprite
	PARAMETERS:	Filename
	RETURNS:	Sprite info ptr
**************************************************************************/

SPRITEX *textureLoadSPT(UBYTE *name);


/**************************************************************************
	FUNCTION:	textureUnload()
	PURPOSE:	Unload texture from VRAM
	PARAMETERS:	Sprite info ptr
	RETURNS:	
**************************************************************************/

void textureUnload(SPRITEX *sprX);


/**************************************************************************
	FUNCTION:	textureLoadBank()
	PURPOSE:	Load texture bank
	PARAMETERS:	Filename
	RETURNS:	Ptr to texture bank info
**************************************************************************/

TextureBankType *textureLoadBank(char *sFile);


/**************************************************************************
	FUNCTION:	textureFindInBank()
	PURPOSE:	Find given texture in bank
	PARAMETERS:	Texture bank info ptr, Name of texture
	RETURNS:	Sprite info ptr
**************************************************************************/

SPRITEX *textureFindInBank(TextureBankType *pData, char *name);
SPRITEX *textureFindCRCInBank(TextureBankType *bank, ULONG crc);


/**************************************************************************
	FUNCTION:	textureFindInAllBanks()
	PURPOSE:	Find given texture in all loaded banks
	PARAMETERS:	Name of texture
	RETURNS:	Sprite info ptr
**************************************************************************/

SPRITEX *textureFindInAllBanks(char *name);
SPRITEX *textureFindCRCInAllBanks(ULONG crc);


/**************************************************************************
	FUNCTION:	textureDownloadBank()
	PURPOSE:	Download entire texture bank to VRAM
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/

void textureDownloadBank(TextureBankType *bank);


/**************************************************************************
	FUNCTION:	textureDestroyBank()
	PURPOSE:	Free system RAM data for given texture bank
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/
void textureDestroyBank(TextureBankType *bank);
/**************************************************************************
	FUNCTION:	textureUnloadBank()
	PURPOSE:	Unload given texture bank from VRAM
	PARAMETERS:	Texture bank info ptr
	RETURNS:	
**************************************************************************/
void textureUnloadBank(TextureBankType *bank);

// debugPrintf diagnostic of vram usage
void textureVRAMcounter();


//USHORT	Fog_Clut(USHORT *clut,struct NSPRITE *nspr);
int textureVRAMalloc(short w, short h);
SPRITEX *textureFindFrames(char *sStr);

#define FOGLEVELS 4
//#define FOGTOSKY

extern	ULONG fogpalette;
extern	ULONG fogpaletteno;
ULONG AverageOfClutAccurate(NSPRITE *);

#endif
