/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	utils.h:		General purpose utility functions

************************************************************************************/

#ifndef _UTILS_H_
#define _UTILS_H_

//#ifndef _GLOBAL_H_

typedef struct _Point2DType {
	int	x,y;
} Point2DType;

typedef struct _Point3DType {
	int	x,y,z;
} Point3DType;

//typedef Point2DType Vect2DType;
//typedef Point3DType Vect3DType;

#define Vect2DType Point2DType
#define Vect3DType Point3DType

//#endif

#undef N
typedef struct _CamClipPolyType {
	Vect3DType	V[3];				// Polygon Vertices
	Vect3DType	N;					// Surface Normal
	int			d;					// plane equation thing
	int			i0;					// not the major axes identifier
} CamClipPolyType;


/* Andy's macros for fixed-ish point multiplication and division */

#define FXMUL(a,b)	((a/4096)*b)
#define FXDIV(a,b)	((a/b)*4096)

#ifndef MAX
#define MAX(a,b)	(((a)>(b)) ? (a) : (b))
#endif

#ifndef MAX4
#define MAX4(a,b,c,d) MAX(MAX(a,b),MAX(c,d))
#endif

#ifndef MAX3
#define MAX3(a,b,c)	MAX(a,MAX(b,c))
#endif

#ifndef MIN
#define MIN(a,b) (((a)<(b)) ? (a) : (b))
#endif

#ifndef MIN4
#define MIN4(a,b,c,d) MIN(MIN(a,b),MIN(c,d))
#endif

#ifndef AVG4
#define AVG4(a,b,c,d) ((a+b+c+d)/4)
#endif

#ifndef POS
#define POS(a) (((a)<0) ? (-a) : (a))
#endif


/**************************************************************************
	FUNCTION:	upperStr()
	PURPOSE:	Convert string to upper case
	PARAMETERS:	String ptr
	RETURNS:	
**************************************************************************/

void upperStr(char *str);


/**************************************************************************
	FUNCTION:	seedRandomInt()
	PURPOSE:	Set random integer seed value
	PARAMETERS:	Seed value
	RETURNS:	
**************************************************************************/

void seedRandomInt(int seed);


/**************************************************************************
	FUNCTION:	randomInt()
	PURPOSE:	Generate pseudo random integer
	PARAMETERS:	Maximum value
	RETURNS:	Random value (0-limit)
**************************************************************************/

int randomInt(int limit);


/**************************************************************************
	FUNCTION:	getNextToken()
	PURPOSE:	Get next word from string
	PARAMETERS:	First time: string, subsequent calls: NULL
	RETURNS:	(Temporary) ptr to word
**************************************************************************/

char *getNextToken(char *str);


/**************************************************************************
	FUNCTION:	initCRC()
	PURPOSE:	Initialise internal table for CRC calculations
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void initCRC();


/**************************************************************************
	FUNCTION:	str2CRC()
	PURPOSE:	Calculate 32-bit CRC for given string
	PARAMETERS:	Ptr to string
	RETURNS:	32-bit CRC
**************************************************************************/

unsigned long str2CRC(char *ptr);


/**************************************************************************
	FUNCTION:	getFileFromStack()
	PURPOSE:	Get ptr to (sub)file from inside flatstack file
	PARAMETERS:	Ptr to flatstack file, name of (sub)file
	RETURNS:	Ptr to base of required file
**************************************************************************/

char *getFileFromStack(char *stackFile, char *name);


/**************************************************************************
	FUNCTION:	pointInPoly()
	PURPOSE:	Find if a point is in a poly
	PARAMETERS:	x,y of point, number of points, and a list of points
	RETURNS:	yes or no
**************************************************************************/

UBYTE pointInPoly(long x, long y, long numOfPoints, Point2DType *edge);

/**************************************************************************
	FUNCTION:	pointInPoly3D()
	PURPOSE:	Find if a point is in a poly
	PARAMETERS:	x,y of point, number of points, and a list of points
	RETURNS:	yes or no
**************************************************************************/

UBYTE pointInPoly3D(long x, long y, long numOfPoints, Point3DType *edge);

/**************************************************************************
	FUNCTION:	intersectLines()
	PURPOSE:	Find intersection of two lines
	PARAMETERS:	Line end points, actual point return ptrs
	RETURNS:	0/1
**************************************************************************/

UBYTE intersectLines(long x1,long y1,long x2,long y2,long x3,long y3,long x4,long y4, long *x,long *y);


/**************************************************************************
	FUNCTION:	interestVectPoly()
	PURPOSE:	Find intersection of vector and poly
	PARAMETERS:	Line end points, poly, point return ptrs
	RETURNS:	0/1
**************************************************************************/

UBYTE intersectVectPoly(long x0,long y0, long x1,long y1, long numOfPoints, Point2DType *edge, long *x, long *y);

int intersectVectPoly3D(int x0,int z0, int x1,int z1, long numOfPoints, Point3DType *edge);

/**************************************************************************
	FUNCTION:	interpolateVectPoly()
	PURPOSE:	Find intersection of vector and poly
	PARAMETERS:	Line end points, poly, point return ptrs
	RETURNS:	0/1
**************************************************************************/

UBYTE interpolateVectPoly(long x0,long y0, long x1,long y1, long numOfPoints, Point2DType *edge, long *x, long *y);

/**************************************************************************
	FUNCTION:	interpolateVectPoly3D()
	PURPOSE:	Find intersection of vector and poly
	PARAMETERS:	Line end points, poly, point return ptrs
	RETURNS:	0/1
**************************************************************************/

UBYTE interpolateVectPoly3D(long x0,long y0, long x1,long y1, long numOfPoints, Point3DType *edge, long *x, long *y);

/**************************************************************************
	FUNCTION:	interpolateTriangle()
	PURPOSE:	for finding the height at a x,z in a poly3
	PARAMETERS:	list of 3d points, and x,z co-ord of point
	RETURNS:	
**************************************************************************/

int interpolateTriangle(Point3DType *pList, LONG x, LONG z);


int findShortestAngle(int ang1, int ang2);

char *printFixed(long l);

void *Align4(void *);

#endif

