/************************************************************************************
	ACTION MAN PS	(c) 1998-9 ISL

	xa.h:		XA audio stream code

************************************************************************************/

#ifndef _XA_H_
#define	_XA_H_


typedef struct _XAFileType {
	CdlFILE		fileInfo;
	int			startPos;
	int			endPos;
	uchar		status;
	uchar		loop;
} XAFileType;


extern int XAenable;
extern int XAplaying;	// flag to the filing system


/**************************************************************************
	FUNCTION:	XAgetFileInfo()
	PURPOSE:	Get position information for XA file
	PARAMETERS:	Filename
	RETURNS:	
**************************************************************************/

XAFileType *XAgetFileInfo(char *fileName);


/**************************************************************************
	FUNCTION:	XAstart()
	PURPOSE:	Get CD ready to play XA audio stream
	PARAMETERS:	Speed 0 = single, 1 = double
	RETURNS:	
**************************************************************************/

void XAstart(int speed);


/**************************************************************************
	FUNCTION:	XAstop()
	PURPOSE:	CD back to data - finished playing XA audio streams
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void XAstop();


/**************************************************************************
	FUNCTION:	XAplayChannel()
	PURPOSE:	Start playing channel from given XA audio stream
	PARAMETERS:	XA file, channel number
	RETURNS:	
**************************************************************************/

void XAplayChannel(XAFileType *xaF, int channel, int loop);


/**************************************************************************
	FUNCTION:	XAcheckPlay()
	PURPOSE:	Test if XA has begun playback
	PARAMETERS:	
	RETURNS:	0 = Not playing yet, 1 = Is playing now
**************************************************************************/

int XAcheckPlay();


/**************************************************************************
	FUNCTION:	XAstorePrevious()
	PURPOSE:	Store current XA playback track/channel
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void XAstorePrevious();


/**************************************************************************
	FUNCTION:	XArestartPrevious()
	PURPOSE:	Restart previously stored XA playback track/channel
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void XArestartPrevious();



// Glover-specific insertion by Fred

int XA_SetMusicGoing(int track, int loop);

// values for track, which get split into
// file & channel internally
enum
{
	TRACK_AT1,		//ATLANT1  WAV    32,692,844
	TRACK_AT2,		//ATLANT2  WAV    31,493,324
	TRACK_AT3,		//ATLANT3  WAV    31,608,572
	TRACK_ATBOSS,	//ATLANBOS WAV    10,859,228
	TRACK_ATJING,	//ATLANJIN WAV     1,462,988

	TRACK_XTRA3,	//XTRA3    WAV    10,151,276
	TRACK_XTRA4,	//XTRA4    WAV    10,692,236
	TRACK_XTRA5,	//XTRA5    WAV     6,776,156

//track 2 carnival track
	TRACK_CA1,		//CARN1    WAV    28,769,708
	TRACK_CA2,		//CARN2    WAV    31,140,524
	TRACK_CA3,		//CARN3    WAV    29,882,204
	TRACK_CABOSS,	//CARNBOSS WAV    12,413,900
	TRACK_CABONUS,	//CARNBON  WAV    11,407,244

	TRACK_CAJING,	//CARNJING WAV     3,158,780

	TRACK_XTRA2,	//XTRA2    WAV    11,059,148
	TRACK_XTRA1,	//XTRA1    WAV    12,117,548

//track 3 pirates track
	TRACK_PI1,		//PIRATES1 WAV    30,037,436
	TRACK_PI2,		//PIRATES2 WAV    30,484,316
	TRACK_PI3,		//PIRATES3 WAV    29,592,908
	TRACK_PIBOSS,	//PIRBOSS  WAV    15,111,644
	TRACK_PIJING,	//PIRAJING WAV     6,190,508

	TRACK_PRESENTS,	//PRESENTS WAV     6,853,772
	TRACK_INTRO,	//INTRO    WAV    11,430,764
	TRACK_MAINMENU,	//MAINMENU WAV    14,857,628

//track 4 prehist track
	TRACK_PR1,		//PREHIST1 WAV    28,821,452
	TRACK_PR2,		//PREHIST2 WAV    26,354,204
	TRACK_PR3,		//PREHIST3 WAV    27,737,180
	TRACK_PRBOSS,	//PREHBOSS WAV    13,886,252
	TRACK_PRJING,	//PREJINGS WAV     6,896,108
	TRACK_HUB7,		//HUB7     WAV     9,662,060
	TRACK_HUB8,		//HUB8     WAV    12,493,868


//track 5 fortress track
	TRACK_FF1,		//FORT1    WAV    32,229,500
	TRACK_FF2,		//FORT2    WAV    29,809,292
	TRACK_FF3,		//FORT3    WAV    28,899,068
	TRACK_FFBOSS,	//FORTBOSS WAV    15,351,548
	TRACK_FFJING,	//FORTJING WAV     3,596,252

//track 6 ootw track
	TRACK_SP1,		//OOTW1    WAV    30,011,564
	TRACK_SP2,		//OOTW2    WAV    27,560,780
	TRACK_SP3,		//OOTW3    WAV    27,245,612
	TRACK_SPBOSS,	//OOTWBOSS WAV    13,253,564
	TRACK_SPJING,	//OOTWJING WAV     4,203,068

	TRACK_NUMTRACKS
};



#endif
