#ifndef _MEMCARD_H_
#define _MEMCARD_H_
/*
 * File:libmcrd.h	Rev. 4.0
*/
/*
 * $PSLibId: Run-time Library Release 4.2$
 */
#include <kernel.h>

typedef void (*MemCB)( unsigned long cmds, unsigned long rslt );

#define McFuncExist		(1)
#define McFuncAccept		(2)
#define McFuncReadFile		(3)
#define McFuncWriteFile		(4)
#define McFuncReadData		(5)
#define McFuncWriteData		(6)

#define	McErrNone		(0)
#define	McErrCardNotExist	(1)
#define	McErrCardInvalid	(2)
#define	McErrNewCard		(3)
#define	McErrNotFormat		(4)
#define	McErrFileNotExist	(5)
#define	McErrAlreadyExist	(6)
#define	McErrBlockFull		(7)
#define	McErrExtend		(0x8000)

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif

void MemCardInit( long flg );
void MemCardEnd( void );
void MemCardStart(void);
void MemCardStop(void);
long MemCardExist( long chan );
long MemCardAccept( long chan );
long MemCardOpen( long chan, char* fnam, unsigned long flag );
void MemCardClose(void);
long MemCardReadData( long* adrs, long ofs, long bytes );
long MemCardReadFile( long chan, char* fnam, long* adrs, long ofs, long bytes );
long MemCardWriteData( long* adrs, long ofs, long bytes );
long MemCardWriteFile( long chan, char* fnam, long* adrs, long ofs ,long bytes );
long MemCardCreateFile( long chan, char* fnam, long blocks );
long MemCardDeleteFile( long chan, char* fnam );
long MemCardFormat( long chan );
long MemCardUnformat(long chan);
long MemCardSync( long mode, unsigned long* cmds, unsigned long* rslt );
MemCB MemCardCallback( MemCB func );
long MemCardGetDirentry( long chan, char* name, struct DIRENTRY* pdir, long* files, long ofs, long max );

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif


#endif /* _MEMCARD_H_ */
