#define BFF_PSA_ID  (('P'<<0) | ('S'<<8) | ('A'<<16) | 0)



typedef struct BFF_HeaderTag
{
	unsigned long id;
	unsigned long len;
	unsigned long crc;
}BFF_Header;


// "Newmodel" BFF headers

typedef struct BFF_PSAHeaderTag
{
	unsigned long id;
	unsigned long len;
	unsigned long name_crc;

	int n_textures;
	int texturedef_offset;
	int n_objects;
	int objectdef_offset;
	int model_offset;
	int seg_offset;

}BFF_PSAHeader;

typedef struct BFF_PSATextureTag
{
	unsigned long name_crc;
}BFF_PSATexture;
typedef struct BFF_PSAObjectTag
{
	int object_offset;
}BFF_PSAObject;


// "Coll" BFF headers

#define BFF_COLL_ID (('C'<<0) | ('O'<<8) | ('L'<<16) | ('1'<<24))
typedef struct BFF_CollHeaderTag
{
	unsigned long id;
	unsigned long len;
	unsigned long name_crc;

	int base_mesh_offset;
	int base_mesh_len;
	int red_mesh_offset;
	int red_mesh_len;

	long offset;
	long xSteps,ySteps,zSteps;
	long xStepLen,yStepLen,zStepLen;
	long startX,startY,startZ;
	long endX,endY,endZ;

	int n_pointers;

}BFF_CollHeader;

// "Wld" BFF headers

//typedef struct {
//	ULONG nZones;
//	NEWMODEL **pZones;
//}PSAWORLD;
#define BFF_WLD_ID (('W'<<0) | ('L'<<8) | ('D'<<16) | 0)
typedef struct BFF_WorldHeaderTag
{
	unsigned long id;
	unsigned long len;
	unsigned long name_crc;
	PSAWORLD world;
}BFF_WorldHeader;


// ===================================================================================


BFF_Header *BFF_LoadFile(char *filename);
void BFF_ReleaseFile(BFF_Header *header);
BFF_Header *BFF_FindObject(int id, unsigned long crc);
BFF_Header *BFF_FindNamedObject(int id, char *name);

// If you're not interested in segs, send a null pointer in
NEWMODEL * BFF_IsModelLoaded(char *modelname, objectSegDataType **seg);
NEWMODEL * BFF_IsCRCModelLoaded(unsigned long crc, objectSegDataType **seg);

int BFF_IsInBFF(void *addr);


extern BFF_CollHeader *WorldBFFcoll;

