		 					  
#ifndef __H_CONVERT
#define __H_CONVERT


#define MODELSCALE	1


#define NUMOFSIDES 		3	   //NB 0=SPRITE 1=LINE 2=TRI 3=QUAD
#define TEXTURED   		4
#define DOUBLESIDED 	8
#define LIT	 			16
#define TILEDH			32
#define TILEDV			64
#define TRANSPAR		(256+128)  //0=solid 1=semi 2=add 3=sub
#define GOURAUD     	512

typedef struct {
	NEWMODEL *pModel;
}ZONE;

typedef struct {
	ULONG nZones;
	NEWMODEL **pZones;
}PSAWORLD;

typedef struct {
	UBYTE	u,v;
}UV;


typedef struct{
	short	x,y,z;
}NEWVERT;


typedef struct {
	USHORT	flags;
	USHORT	vert[4];
	RGBCD	rgb[4];		 // under my (CPW) proposal, rgb[].code = average texture colour
	UBYTE	texture[17];
	UBYTE	tiled;
	UV		uv[4];
}PSAFACE;


typedef struct _PSAMODEL {
	UBYTE			name[16];
	struct _PSAMODEL	*child;
	struct _PSAMODEL	*next;
	USHORT			numofpolys;
	USHORT			numofverts;
	PSAFACE			*polys;
	NEWVERT			*verts;
	USHORT			Animstart;
	USHORT			Animend;
	USHORT			numScaleKeys;
	USHORT			numMoveKeys;
	USHORT			numRotateKeys;
	USHORT			pad1;
	KEYFRAME		*scalekeys;
	KEYFRAME		*movekeys;
	KEYFRAME		*rotatekeys;
	USHORT			sortlistsize[8];
	USHORT			*sortlistptr[8];
} PSAMODEL;


#define ANIM_LOOP 1
#define ANIM_YOYO 2

#define CHUNK_PSA	0x415350

// first range is always entire anim
// if nRanges==0, PSA has no animation
typedef struct tagANIMRANGE
{
	ULONG	id;			// CRC of the name in jobe
	USHORT	startFrame;
	USHORT	nFrames;
	USHORT	nFPS;
	USHORT	flags;			// see # defines
}ANIMRANGE;


typedef struct tagPSAHEADER {
	union {
		ULONG	lid;
		char	id[4];			// ={'P','S','A', version number (0)}
	} u;
	PSAMODEL	*pRootModel;	// pointer (offset when in file)
	ULONG 		nRanges;		// number of animation ranges
	ANIMRANGE	*pAnimRanges;	// list of n anim ranges
}PSAHEADER;

PSAWORLD *LoadWorld(char *sFile);
void CreateSegment(PSAMODEL *psamodel, NEWOBJECT *newobject);
void CreateSegments(PSAMODEL *tmppsamodel, NEWOBJECT *holdobject);
void CreateNextSegment(PSAMODEL *tmppsamodel);
void CreateChildSegment(PSAMODEL *tmppsamodel);
LONG Add_Prim2NewTmd(NEWTMD *tmd, NEWVERT *verts, PSAFACE *face, PACKET *p);
void CopyVertsNew(NEWVERT*, VERT*, LONG);
void CopyVertsSpr(NEWVERT*, VERT*, LONG);
void Set_Model_CoordsNew(NEWMODEL *model, LONG x, LONG y, LONG z, LONG vx, LONG vy, LONG vz);
void Do_BoundBox(NEWTMD* tmd);
USHORT Model_Size(NEWTMD* newtmd);
void Reverse_SortTables(NEWTMD* tmptmd);
SPRITE*	FindTexture(UBYTE *name);
NEWMODEL *LoadPSA(char* filename);
NEWMODEL *ProcessPSA(PSAHEADER *pPSAHeader);
void	Normal2Plane(VERT *p0,VERT *p1,VERT *p2,NORM *n);


#endif /*H_CONVERT*/
