
#ifndef __CTRLLER_H_
#define __CTRLLER_H_

// deadzone needs to be 40% of full travel of stick!
// SONY strikes again!!!
#define DEADZONE 50
#define DEADMULT 53

typedef struct{
     SPRITE *spr;
     UBYTE	left;
     UBYTE	right;
     SHORT  x;  //divide by 16 for pixels
     SHORT  y;
     SHORT  xspd;
     SHORT  yspd;
  }Mouse;
extern Mouse mouse;
void	Pad_Mouse_Movement();
void	Mouse_Movement();
//void	Print_Mouse();
//UBYTE	Mouse_Coll(SHORT x,SHORT y,SHORT w,SHORT h);
//void _send_pad(void);



#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" 	void _send_pad(void);
//void cexceptionhandler(void);
//#endif
#else
extern void _send_pad(void);
//void cexceptionhandler(void);
#endif




/*+--------+----------+----------+----------+----------+----------+---------+*/
/* #defines for recognising the contents of the controller packet.           */

#define BAD_TRANSMISSION         0xff         /* No pad or bad transmission. */
#define NOKEY                    0xffff		  /* No digital key pressed      */

#define MAX_CONTROLLER_BYTES     64  /*34 changed to find bug*/           /* Size of the biggest packet  */
                                              /* You can possible have.      */

#define STD_PAD_DATA             1            /* Defines for the amount of   */
#define MOUSE_DATA               2            /* data controllers return.    */   
#define NEGCON_DATA              3
#define ANALOG_JOY_DATA			 8
#define MULTI_TAP_DATA           16

#define MOUSE                    1            /* Defines for recognising the */
#define NEGCON                   2            /* different controllers.      */
#define STD_PAD                  4
#define ANALOG_JOY			     5           
#define ANALOG_PAD				 7				
#define MULTI_TAP                8

/*+--------+----------+----------+----------+----------+----------+---------+*/
/* Pad controller data structure. */
/* The data returned by a pad is just a short bit mask for each key.         */


typedef unsigned short PadData;

/* Pad Controller Macros and masks. */
/* #defines for the keys on the pad. The best way to use these is to do      */
/* for example,  if (!(buffer1.data.pad & PAD_SEL)) { <handle select key> }  */
/* Or use the PadKeyIsPressed(&buffer,PAD_SEL).                              */

/* Front or shoulder buttons - F for front, L/R for left/right, T/B for      */
/* top or bottom, U/D for up/down.                                           */

//#define PAD_FRB                  0x0200
//#define PAD_FLB                  0x0100
//#define PAD_FRT                  0x0800
//#define PAD_FLT                  0x0400
///* Right directional;  RU = right up, RD = right down, and so on.            */
//#define PAD_RU                   0x1000
//#define PAD_RD                   0x4000
//#define PAD_RL                   0x8000
//#define PAD_RR                   0x2000
///* Left directional;  LU = left up, LD = left down, and so on.               */
//#define PAD_LU                   0x0010
//#define PAD_LD                   0x0040
//#define PAD_LL                   0x0080
//#define PAD_LR                   0x0020
///* The other two keys.                                                       */
//#define PAD_SEL                  0x0001
//#define PAD_START                0x0008
//
//
//#define PADo       (1<< 8) /*back top right*/
//#define PADm       (1<< 9) /*back top left*/
//#define PADn       (1<< 10) /*back bottom right*/
//#define PADl       (1<< 11) /*back bottom left*/
//
//#define PADRup     (1<< 12)
//#define PADRright  (1<< 13)
//#define PADRdown   (1<< 14)
//#define PADRleft   (1<< 15)
//
//#define PADk       (1<< 0) /*select*/
//#define PADi       (1<< 0) /*no longer used!*/
//#define PADj       (1<<3) /*no longer used!*/
//#define PADh       (1<<3) /*start*/
//
//#define PADLup     (1<<4)
//#define PADLright  (1<<5)
//#define PADLdown   (1<<6)
//#define PADLleft   (1<<7)
//#define PADselect   (1<<0)
//#define PADstart    (1<<3)
//
//#define PADLEFT	(PADLleft | PADLright | PADLup | PADLdown)
//#define PADRIGHT	(PADrleft | PADrright | PADrup | PADrdown)
//
//#define PADrup     (1<< 12)
//#define PADrright  (1<< 13)
//#define PADrdown   (1<< 14)
//#define PADrleft   (1<< 15)

#define PADLlower  (PADL2)
#define PADLupper  (PADL1)
#define PADRlower  (PADR2)
#define PADRupper  (PADR1)

/* Controller packet processing (pass in address of packet) for pads.        */

#define PadKeyIsPressed(x,y)      (!((x)->data.pad & (y)))
#define PadKeyPressed(x)          ((x)->data.pad != NOKEY)
#define NoPadKeyPressed(x)        ((x)->data.pad == NOKEY)

////////////////////////////////////////////
// defines used for the analog controller //
#define LEFT_MAIN_FIRE		0x0100
#define RIGHT_MAIN_FIRE		0x8000

#define JoystickRightX(x)           ( (x)->data.joystick.right_x)
#define JoystickRightY(x)           ( (x)->data.joystick.right_y)

#define JoystickLeftX(x)            ( (x)->data.joystick.left_x)
#define JoystickLeftY(x)            ( (x)->data.joystick.left_y)


#define JoystickKeyIsPressed(x,y)   (!((x)->data.joystick.digitalButtons & (y)))
#define JoystickKeyPressed(x)       ((x)->data.joystick.digitalButtons != NOKEY)
#define NojoystickKeyPressed(x)     ((x)->data.joystick.digitalButtons == NOKEY)

////defines used for neg-con////////////////
#define NEGCON_TR                0x0800

#define TZP_UPPER                128
#define TZP_LOWER                125
                                    
#define NegconKeyIsPressed(x,y)   (!((x)->data.negcon.digitalButtons & (y)))

#define NegconKeyPressed(x)       ((x)->data.negcon.digitalButtons != NOKEY)
#define NoNegconKeyPressed(x)     ((x)->data.negcon.digitalButtons == NOKEY)

#define NegconTopLeft(x)          ((x)->data.negcon.topLeft)
#define NegconI(x)                ((x)->data.negcon.buttonI)
#define NegconII(x)               ((x)->data.negcon.buttonII)

#define NegconTwisting(x)         ((x)->data.negcon.centralTwist < TZP_LOWER || \
                                   (x)->data.negcon.centralTwist > TZP_UPPER)

#define NegconTwist(x)            ((x)->data.negcon.centralTwist)
/////////////////////////////////////////////

/*+--------+----------+----------+----------+----------+----------+---------+*/
/* Mouse data packet returns. You can use the routines from mouse.obj to     */
/* work with the mouse packets if you like, but its not that tough to deal   */
/* with the raw data yourself by working with the x and y offsets.           */

typedef struct										//analog controller 
{
     unsigned short digitalButtons;               /* Bit mask of plain keys. */
     unsigned char  right_x;
     unsigned char  right_y;
     unsigned char  left_x;
     unsigned char  left_y;
} AnalogjoyData;

typedef struct
  {
     unsigned short digitalButtons;               /* Bit mask of plain keys. */
     char centralTwist;                           /* Analogue twisting thing.*/
     char buttonI;                                /* The I analogue button.  */
     char buttonII;                               /* The II analogue button. */
     char topLeft;                                /* The analogue tl button. */
  }
NegconData;

typedef struct
  {
     unsigned short buttons;
     signed char xOffset;
     signed char yOffset;
  }
MouseData;

/* Mouse Controller macros and masks. */
#define MOUSE_LEFT               0x0800               /* Left Mouse button.  */
#define MOUSE_RIGHT              0x0400               /* Right Mouse button. */
#define MOUSE_NOKEY              0xfcff               /* No buttons pressed. */

/* Mouse packet handling macros (pass address of packet).                    */

#define MouseXOffset(x)          ((x)->data.mouse.xOffset)
#define MouseYOffset(x)          ((x)->data.mouse.yOffset)
#define MouseMoving(x)           ((x)->data.mouse.xOffset || (x)->data.mouse.yOffset)

#define MouseKeyIsPressed(x,y)   (!((x)->data.mouse.buttons & (y)))
#define MouseKeyPressed(x)       ((x)->data.mouse.buttons != MOUSE_NOKEY)
#define NoMouseKeyPressed(x)     ((x)->data.mouse.buttons == MOUSE_NOKEY)
 /*+--------+----------+----------+----------+----------+----------+---------+*/
/* Controller packet structure. */

typedef struct
  {
     unsigned char transStatus;  /* 0xff = no pad, bad pad, bad transmission */
     unsigned char dataFormat;            /* Top 4 bits = type of controller */
                                       /* Bottom 4 == shorts of data written */
     union                                         /* Controller data union. */
      {
         PadData      pad;                               /* Plain pad.       */
       	 MouseData    mouse;                             /* Mouse.           */
         NegconData   negcon;                            /* Namco controller.*/
		 AnalogjoyData joystick;						 /* Anlog Joystick   */
//       MultiTapData tap;                               /* 4-way multi-tap. */
      }
     data;
	 UBYTE test[28]; //to try to solve bug!!!
  }
ControllerPacket;

/* Packet macros. */
/* Macros for handling the controller packets; pass in the packet address.   */

#define GoodData(x) ((x)->transStatus != 0xff)
#define GetType(x) (((x)->dataFormat & 0xf0) >> 4)
#define DataShortsReturned(x) ((x)->dataFormat & 0xf)
#define DataBytesReturned(x)  (((x)->dataFormat & 0xf) << 1 )
#define ControllerDataAddress(x) (&((x)->dataFormat)+1)

/*+--------+----------+----------+----------+----------+----------+---------+*/
//analog controller variable //
extern USHORT leftx[2];
extern USHORT lefty[2];
extern USHORT rightx[2];
extern USHORT righty[2];
//normalized deadzone variables
extern SHORT nleftx[2];
extern SHORT nlefty[2];
extern SHORT nrightx[2];
extern SHORT nrighty[2];

//and for l3/r3
extern USHORT right_but[2];
extern USHORT left_but[2];

extern UBYTE	remap1[16];
extern UBYTE	remap2[16];
extern UBYTE 	keyRemapping;

/////////////////SHOCK PAD STUFF//////////////
#define SHOCK_GENTLE 65
#define SHOCK_MEDIUM 16
#define SHOCK_WOBBLE 63

typedef struct
{
	UBYTE rumble;	//ON or OFF
	unsigned char motor0;	//0 or 1
	unsigned char motor1;	//0-255
	UBYTE life;		//duration
	UBYTE started;	//YES or NO - not a user var.
}SHOCKPAD;

extern SHOCKPAD shockPad[2];
extern UBYTE 	shockOn[2];

void updateShockPad();//in progress
void initShockPad(UBYTE pad);
///////////////////////////////////////////////
extern UBYTE analog[2]; //analog pad yes/no 2=negcon
///////////////////////////////
//neg-con controller variables//
extern USHORT twist[2];
extern USHORT but_i[2];
extern USHORT but_ii[2];
extern USHORT neg_left[2];	//analog
//////////////////////////////
extern int PadState[2];
extern int PadType[2]; 


void ReconectPad(UBYTE j);
void ReconnectPads();
void NewPADStart();
int NewPadRead(UBYTE j);

extern 	USHORT 	pad[2];
extern 	USHORT	debounce[2];

void initPadMaps();
//extern	USHORT	Pad;
//extern	USHORT	Debounce;


extern	USHORT	bothpads;
extern	USHORT	bothdebounces;

void 	Read_Pads();
void	Pads_Together();
void	Do_Mouse();

UBYTE	MouseLeftPressed();



void	PlayBackKeys(UBYTE no,LUSHORT temp);
void	RecordKeys(UBYTE no,LUSHORT old);


SHORT	getpadfromlist(UBYTE code);
UBYTE	getlistfrompad(SHORT pad);


void	Init_Demo_Keys();
void	End_Demo_Keys();
void	save_keys();

typedef struct{ USHORT keypat;
			 	UBYTE count;
			 	UBYTE spare;
				}PADDATA;


extern	SHORT recordkeypos[2];
extern	PADDATA *recordkeys[2];
extern	UBYTE demo_mode;
extern	volatile UBYTE gameon;

extern UBYTE keygrab;
#define PLAYKEYS 1
#define RECORDKEYS 2





#endif  

/*+--------+----------+----------+----------+----------+----------+---------+*/
/* End ctrller.h                                                             */
/*+--------+----------+----------+----------+----------+----------+---------+*/


