
#ifndef __H_EFFECTS
#define __H_EFFECTS

void	Init_All_Effects();
void	Update_All_Effects();
void	Draw_All_Effects();
void	Kill_All_Effects();

/******************************************************************************/
#define SPR_ACARD0001 0
#define SPR_ACARD0002 1
#define SPR_ACARD0003 2
#define SPR_ACARD0004 3
#define SPR_ACARD0005 4
#define SPR_ACARD0006 5
#define SPR_ACARD0007 6
#define SPR_ACARD0008 7
#define SPR_ACARD0009 8
#define SPR_ACARD0010 9
#define SPR_ACARD0011 10
#define SPR_ACARD0012 11
#define SPR_ACARD0013 12
#define SPR_AI_GLOW	13
#define SPR_AI_MCOMETS 14
#define SPR_AI_OPQFADE 15
#define SPR_AI_RIPPLE 16
#define SPR_AI_SAWBLADE2 17
#define SPR_AI_SMOKE 18
#define SPR_AI_SPL01 19
#define SPR_AI_WAKE	20
#define SPR_BEACH 21
#define SPR_BEARING	22
#define SPR_BLASTRING 23
#define SPR_BOWLING	24
#define SPR_BSTAR01	25
#define SPR_BSTAR02	26
#define SPR_BSTAR03	27
#define SPR_BSTAR04	28
#define SPR_BSTAR05	29
#define SPR_BSTAR06	30
#define SPR_BSTAR07	31
#define SPR_BSTAR08	32
#define SPR_BSTAR09	33
#define SPR_BUBBLE 34
#define SPR_BUBBLE01 35
#define SPR_CBALL 36
#define SPR_CLOCK 37
#define SPR_EXPAD1 38
#define SPR_FARDUS01 39
#define SPR_FARDUS02 40
#define SPR_FARDUS03 41
#define SPR_FARDUS04 42
#define SPR_FARDUS05 43
#define SPR_FIREA01	44
#define SPR_FIREB01	45
#define SPR_FIREB02	46
#define SPR_FIREB03	47
#define SPR_FIREB04	48
#define SPR_FIREB05	49
#define SPR_FIREB06	50
#define SPR_FIREB07	51
#define SPR_FIREB08	52
#define SPR_GLOVEPRNT 53
#define SPR_GLOW01 54
#define SPR_GLOW02 55
#define SPR_GLOW03 56
#define SPR_GLOW04 57
#define SPR_GLOW05 58
#define SPR_GLOW06 59
#define SPR_GLOW07 60
#define SPR_GLOW08 61
#define SPR_GLOW09 62
#define SPR_HEALTH01 63
#define SPR_HEALTH02 64
#define SPR_HITBAR2	65
#define SPR_LIGHTNING 66
#define SPR_LOCKON 67
#define SPR_LOCKON3	68
#define SPR_MARBLE01 69
#define SPR_MARBLE02 70
#define SPR_MARBLE03 71
#define SPR_MARBLE04 72
#define SPR_MARBLE05 73
#define SPR_MARBLE06 74
#define SPR_MARBLE07 75
#define SPR_MARBLE08 76
#define SPR_MRTIP 77
#define SPR_MRTIP2 78
#define SPR_NEWBALL2 79
#define SPR_NEWISP01 80
#define SPR_NEWISP02 81
#define SPR_NEWISP03 82
#define SPR_NEWISP04 83
#define SPR_NEWISP05 84
#define SPR_NEWISP06 85
#define SPR_NEWISP07 86
#define SPR_NEWSHADOW 87
#define SPR_NO 88
#define SPR_NUMLIVES 89
#define SPR_P01	90
#define SPR_P02	91
#define SPR_P03	92
#define SPR_P04	93
#define SPR_P05	94
#define SPR_P06	95
#define SPR_PLASTER	96
#define SPR_POPA01 97
#define SPR_POPB01 98
#define SPR_POWER  99
#define SPR_PPLASTER 100
#define SPR_PUFF01 101
#define SPR_RAINDROP 102
#define SPR_RESTART	103
#define SPR_SCORE01	104
#define SPR_SCORE02	105
#define SPR_SCORE03	106
#define SPR_SCORE04	107
#define SPR_SCORE05	108
#define SPR_SCORE06	109
#define SPR_SFAIR01	110
#define SPR_SFAIR02	111
#define SPR_SFAIR03	112
#define SPR_SFAIR04	113
#define SPR_SMK01 114
#define SPR_SMK02 115
#define SPR_SMK03 116
#define SPR_SMK04 117
#define SPR_SMK05 118
#define SPR_SMK06 119
#define SPR_SMK07 120
#define SPR_SNOW  121
#define SPR_SNOW2 122
#define SPR_SSPARK1	123
#define SPR_STAR01 124
#define SPR_TESTUBE	125
#define SPR_TGLOVE1	126
#define SPR_TGLOVE2	127
#define SPR_TGLOVE3B 128
#define SPR_THOUGHT	129
#define SPR_TIPPANE	130
#define SPR_TRAJ01 131


// From "Behave.h" in the n64 source...


//standard enemy animations			
enum								
{									
	NMEANIM_ACTION1,		//0
	NMEANIM_ACTION2,		//1
	NMEANIM_DEATH,			//2
	NMEANIM_ENDATTACK,		//3
	NMEANIM_HURT,			//4
	NMEANIM_IDLE,			//5
	NMEANIM_IDLE2,			//6
	NMEANIM_JUMP,			//7
	NMEANIM_LAND,			//8
	NMEANIM_RUN,			//9
	NMEANIM_SPECIAL1,		//10
	NMEANIM_SPECIAL2,		//11
	NMEANIM_STARTATTACK,	//12
	NMEANIM_STARTMOVE,		//13
	NMEANIM_STOPMOVE,		//14
	NMEANIM_WALK,			//15
};									

//actor types
enum
{
	CAMERA,				//0      
// In the N64 source, these are "HAND" and "BALL",
// but "ball" conflicted with something on the PSX. Luv, Fred
	ACTORTYPE_HAND,				//1      
	ACTORTYPE_BALL,				//2      
	DEBRIS,				//3      
	BULLET,				//4      
	SNEEZY,				//5      
	MOOCOW,				//6 
	BOVVA,				//7      
	CANNONBALL,			//8      
	SAMTEX,				//9      
	MALLET,				//10     
	GENERALWU,			//11     
	LIONFISH,			//12     
	CHESTER,			//13     
	KEG,				//14     
	REGGIE,				//15     
	SWISH,				//16     
	KNIGHT,				//17     
	ROBES,				//18     
	FUMBLE,				//19     
	MIKE,				//20     
	RAPTOR,				//21     
	CRUMPET,			//22     
	TRACEY,				//23     
	YOOFOW,				//24     
	OPEC,				//25     
	CYMON,				//26     
	SUCKER,				//27     
	BUGLE,				//28     
	DENIS,				//29     
	CHUCK,				//30     
	FRANKIE,			//31
	KLOSET,				//32
	FLANNEL,			//33
	SELWYN_WHALE,		//34
	SELWYN_CRAB,		//35
	SELWYN_FISH,		//36
	ROBOT,				//37
	SPANK,				//38
	BABY_SPANK,			//39
	EVIL_GLOVE,			//40
	DIBBER,				//41
	FLY,				//42
	SNAIL,				//43
	BIGFISH,			//44
	LITTLEFISH,			//45
	LADYBIRD,			//46
	WEEVIL,				//47
	CATERPILLAR,		//48
	BUTTERFLY,			//49
	SPIDER,				//50
	BAT,				//51
	FROG,				//52
	DRAGFLY,			//53
	BOXTHING,			//54
	BUG,				//55
	NME_FROG,			//56
	PLAT_ACTOR,			//57 
	LANDSCAPE_ACTOR,	//58
	COLLECTABLE_ACTOR,	//59
	WATER_ACTOR,		//60
	CAMEO_ACTOR,		//61
};							    
	

/****************************************************************************/
typedef struct tagRIPPLE{
	struct tagRIPPLE *next,*prev;			// list pointers
	VECTOR v;
	USHORT scale;
	UBYTE count;
	UBYTE speed;
}RIPPLE;

#define MAXRIPPLES 30
extern	RIPPLE ripples[MAXRIPPLES];
void	Start_Ripple(VECTOR *vector,ULONG scale,UBYTE count);
void	Update_Ripples();
void	Draw_Ripples();

extern	NEWMODEL	*pRipplePSA;
extern	NEWMODEL	*pWakePSA;
/*-------------------------------------*/	

void	SetupSky();
void	PrintSky();



extern SPRITEX*	overlayssprpointer;


//dont forget a bit field shpuld be set up of all the Garibs collected.
//Becuase this information needs to be saved onto memory card 
typedef struct tagGARIBPOS{
	USHORT num;  //set top bit of num if collected 
	SHORT shadowheight;
	SHORT x,y,z;
	BYTE type; // 0=normal, 2=extra life
	BYTE scoretimer;
	BYTE scorevalue;
}GARIBPOS;

// this is from "collect.h" in the n64
enum
{
	NORMAL_GARIB,
	SUPER_GARIB,
	EXTRA_LIFE,
	NUM_GARIB_TYPES
};


extern	GARIBPOS *garibpositions;
extern ULONG numberofgaribs; //set to garibs on THIS level, including extra lives;
extern ULONG numGaribs;	// number of garibs on level, including non-existant ones inside enemies
// temp mod by Fred till I get a better counting mech going
#define MAX_GARIBS 100

void	   	Update_Garibs();
void	   	Draw_Garibs();
/*********************************************/

// Again, Fred's been horrible for a while...
#define MAX_MR_TIPS 8

typedef struct tagMRTIPS{
	SHORT x,y,z,num;
}MRTIPS;

extern	MRTIPS *mrtippositions;
extern ULONG numberofmrtips; //set to garibs on THIS level, including extra lives;
void	   	Update_MrTips();
void	   	Draw_MrTips();
/*********************************************/
typedef struct tagGLITTER{
	struct tagGLITTER *next,*prev;			// list pointers
	VECTOR v;
	USHORT scale;
	UBYTE count;
	UBYTE speed;
}GLITTER;

#define MAXGLITTER 30
extern	GLITTER glitter[MAXGLITTER];
void	Start_Glitter(SHORT x,SHORT y,SHORT z,ULONG scale,UBYTE count);
void	Update_Glitter();
void	Draw_Glitter();


/*************************************************************/
//#define MAX_ENEMIES 10
// (max_enemies is defined in "types.mh" as 30)

void	Draw_Enemies();
typedef struct tagENEMYPOS{
//	USHORT num;  //set top bit of num if collected 
//	SHORT shadowheight;
	SHORT x,y,z;
	NEWMODEL *psa;
	SHORT type;
}ENEMYPOS;

extern ENEMYPOS *enemies;
extern ULONG numberofenemies;

/*************************************************************/
#endif /*EFFECTS*/

