
#ifndef __H_ENEMIES
#define __H_ENEMIES


/*
// playstation order
	NMEANIM_IDLE,			//0
	NMEANIM_IDLE2,			//1

	NMEANIM_STARTMOVE,		//2
	NMEANIM_WALK,			//3
	NMEANIM_RUN,			//4
	NMEANIM_STOPMOVE,		//5

	NMEANIM_JUMP,			//6
	NMEANIM_LAND,			//7

	NMEANIM_STARTATTACK,	//8
	NMEANIM_ENDATTACK,		//9

	NMEANIM_ACTION1,		//10
	NMEANIM_ACTION2,		//11

	NMEANIM_HURT,			//12
	NMEANIM_DEATH,			//13
	NMEANIM_SPECIAL1,		//14
	NMEANIM_SPECIAL2,		//15
// ---

// n64 order
	NMEANIM_ACTION1,		//0
	NMEANIM_ACTION2,		//1
	NMEANIM_DEATH,			//2
	NMEANIM_ENDATTACK,		//3
	NMEANIM_HURT,			//4
	NMEANIM_IDLE,			//5
	NMEANIM_IDLE2,			//6
	NMEANIM_JUMP,			//7
	NMEANIM_LAND,			//8
	NMEANIM_RUN,			//9
	NMEANIM_SPECIAL1,		//10
	NMEANIM_SPECIAL2,		//11
	NMEANIM_STARTATTACK,	//12
	NMEANIM_STARTMOVE,		//13
	NMEANIM_STOPMOVE,		//14
	NMEANIM_WALK,			//15

*/

/*
//#define	SCALE_MULTIPLIER 1
#define RADIUS_MULTIPLIER 4096
// as it turns out this is a waste of time
enum
{
	NME_BOVVA,				//0
	NME_CANNONBALL,			//1
	NME_SAMTEX,				//2
	NME_MALLET,				//3
	NME_GENERALWU,			//4
	NME_LIONFISH,			//5
	NME_CHESTER,			//6
	NME_KEG,				//7
	NME_REGGIE,				//8
	NME_SWISH,				//9
	NME_KNIGHTLY,			//10
	NME_ROBES,				//11
	NME_FUMBLE,				//12
	NME_MIKE,				//13
	NME_RAPTOR,				//14
	NME_CRUMPET,			//15
	NME_TRACEY,				//16
	NME_YOOFOW,				//17
	NME_OPEC,				//18
	NME_CYMON,				//19
	NME_SUCKER,				//20
	NME_BUGLE,				//21
	NME_DENIS,				//22
	NME_CHUCK,				//23
	NME_HUBCHICKEN,			//24
	NME_FRANKIE,			//25
	NME_FLANNEL,			//26
	NME_SELWYN_WHALE,		//27
	NME_SELWYN_CRAB,		//28
	NME_SELWYN_FISH,		//29
	NME_ROBOT,				//30
	NME_EVIL_ROBOT,			//31
	NME_SPANK,				//32
	NME_BABY_SPANK,			//33
	NME_EVIL_GLOVE,			//34
	NME_DIBBER,				//35
	NME_FLY,				//36
	NME_SNAIL,				//37
	NME_BIGFISH,			//38
	NME_LITTLEFISH,			//39
	NME_LADYBIRD,			//40
	NME_WEEVIL,				//41
	NME_CATERPILLAR,		//42
	NME_BUTTERFLY,			//43
	NME_SPIDER,				//44
	NME_BAT,				//45
	NME_FROG1,				//46
	NME_DRAGFLY,			//47
	NME_BOXTHING,			//48
	NME_BUG,				//49
	NME_NME_FROG1,			//50
	MAX_ENEMY_TYPES		//51
};


//ACTOR & PLATFORM flags
#define GRAVITY_FLAG	(1<<0) 
#define DESTROYED		(1<<1)
#define BACKGROUND_OBJ	(1<<2)

//ACTOR flags
#define COLLISION_ACTOR		(1<<3)  
#define COLLISION_LAND		(1<<4)  
#define ROLLING				(1<<5)  
#define LO_GRAVITY			(1<<6)  
#define DIESONCONTACT		(1<<7)  
#define SHADOW				(1<<8)  
#define DESTROYER			(1<<9)  
#define MAGNETIC			(1<<10) 
#define BLOWN_BY_WIND		(1<<11) 
#define BEING_BLOWN			(1<<12) 
#define CATAPULTING			(1<<13) 
#define QUAT_ROTATION		(1<<14) 
#define SUCTION_ON			(1<<15) 
#define LANDSCAPE_OBJ		(1<<16) 
#define HURT_HAND			(1<<17) 
#define HURT_BALL			(1<<18) 
#define KILL_HAND			(1<<19) 
#define KILL_BALL			(1<<20)
#define FLOATS				(1<<21) 
#define HURT_BY_LAVA		(1<<22) 
#define NO_UPDATE			(1<<23) 
#define NO_MAX_SPEED		(1<<24) 
#define DISABLE_SQUASH		(1<<25) 
#define TOUCHED_BALL		(1<<26) 
#define RELEASE_BALL		(1<<27)
#define NO_CURRENT			(1<<28)
#define NO_CAM_COLLISION	(1<<29)
#define NO_MASS				(1<<30)
#define SQUASH_HAND			(1<<31)


*/



// Instruction notes:-
// instr Special time (i,j,f, string,c1,c2) -> )i,j,c1,c2,f,cond)







//enemy flags
/*
// ** N64 ** low 2 digits
#define	NMEFLAGS_MOVE_ACCEL				(1<<0)	//1	signals to accellerate enemies
#define NMEFLAGS_MOVE_VEL				(1<<1)	//2	signals to add to velocity
#define NMEFLAGS_DONT_SLOW_WHEN_NEAR	(1<<2)	//4	used with moveto's
#define NMEFLAGS_USE_X_AXIS				(1<<3)	//8	used for circling

#define NMEFLAGS_USE_Y_AXIS				(1<<4)	//16	used for circling
#define NMEFLAGS_USE_Z_AXIS				(1<<5)	//32	used for circling
#define NMEFLAGS_SPECIFY_HAND			(1<<6)	//64	used for follow, flee, face
#define NMEFLAGS_SPECIFY_BALL			(1<<7)	//128	used for follow, flee, face
*/
/*
// ** N64 **   word 2 digits
#define NMEFLAGS_SPECIFY_CLOSEST		(1<<8)	//256	used for follow, flee, face
#define NMEFLAGS_DONT_CHANGE_ROT		(1<<9)	//512	used for circling
#define NMEFLAGS_ANTICLOCKWISE			(1<<10)	//1024	used to specify circling direction
#define NMEFLAGS_DONT_INTERUPT			(1<<11)	//2048	if a conditional instruction is al
lowed to happen
												//	act on it, but dont interupt normal instr list.
#define NMEFLAGS_DONT_FACE_DIR			(1<<12)	//4096	dont face in the direction of travel
#define NMEFLAGS_BANK					(1<<13)	//8192	allow enemy to bank when he turns
#define NMEFLAGS_DONTANIMATE			(1<<14) //16384 dont animate action

#define NMEFLAGS_NONEW					(1<<15) //32768 don't get a new action when done if condition still true - used for conditionals


*/

/*
// ** N64 **  above-word two digits
#define NMEFLAGS_ONLYATANIMSTART		(1<<16) //65536
#define NMEFLAGS_HOLDCOLLSPHERE			(1<<17) //131072
#define NMEFLAGS_RUN					(1<<18) //262144 use run animation
#define NMEFLAGS_NOMOVE					(1<<19) //524288 don't move in STARTMOVE animation

#define NMEFLAGS_FACEHAND				(1<<20) //1048576
#define NMEFLAGS_FACEBALL				(1<<21) //2097152
#define NMEFLAGS_FACECLOSEST			(1<<22)	//4194304
#define NMEFLAGS_LAND_ON_PLAYER			(1<<23) //8388608
*/

/*
// ** N64 ** wait flags
#define NMEFLAGS_SKID					(1<<0)	
#define NMEFLAGS_STOPMOVE				(1<<1)
#define NMEFLAGS_WAITFOREND				(1<<2) //queue the wait anim

// ** N64 ** special flags
#define ANIM_LOOP						(1<<0)	//1 loop animation
#define ANIM_QUEUE						(1<<1)	//2	queue animation
#define ANIM_KILLQ						(1<<2)	//4 kill anim queue
*/
//enemy action flags
//enum
/*
#define		ATTACK_BALL_IF_NEAR		(1 << 0)
#define 	ATTACK_HAND_IF_NEAR		(1 << 1)
#define 	ATTACK_NME_IF_NEAR		(1 << 2)
#define 	RETREAT_BALL_IF_NEAR	(1 << 3)
#define 	RETREAT_HAND_IF_NEAR	(1 << 4)
#define 	RETREAT_NME_IF_NEAR		(1 << 5)

#define 	DEFEND_BALL_IF_NEAR		(1 << 6)
#define 	DEFEND_HAND_IF_NEAR		(1 << 7)
#define 	DEFEND_NME_IF_NEAR		(1 << 8)

#define 	DROP_BALL_ON_ARRIVAL	(1 << 9)
#define 	DONT_PICK_UP_BALL		(1 << 10)

#define 	DONT_ATTACK				(1 << 11)

#define 	FACE_DIRECTION			(1 << 12)
#define 	FACE_POSITION			(1 << 13)

#define 	DONT_FACE_DIR			(1 << 14)
*/















#define NMEFLAG_VISIBLE 1
#define NMEFLAG_ACTIVE  2

#define NMEFLAG_STUNNED 4
#define NMEFLAG_FROGGED 8

// defines for nmes hitting glove 

#define	GENERALWUATTACKRADIUS	30*4096
#define	MALLETATTACKRADIUS		30*4096


#define NME_MAX_PATHVECTORS 4

// This is rapidly turning into an "actor" type structure, and should probably be transferred/renamed as such
typedef struct tagENEMYPOS
{
	SVECTOR init_pos;
	SHORT	init_ya;

//	USHORT num;  //set top bit of num if collected 
//	SHORT shadowheight;

// replace this with a "*4096" VECTOR
// (ummm, will stuff like homing in on the player be ok with 4096-scaled vecs?)
//	SHORT x,y,z;
	VECTOR pos;	// stored*4096
	VECTOR smPos; // not stored *4096
	VECTOR vel;

	SHORT xa,ya,za;
	NEWMODEL *psa;

	SHORT type;
	SHORT flags;
	SHORT tag;	// for puzzles

	AnimType animinfo;
	ACTOR_ANIMATION anim;

	SHORT doing;	// position in instruction list (I'm thinking of hardcoding this rather than parsing)
	SHORT ticker;	// time left on this instruction

	char n_points;
	VECTOR pathvectors[NME_MAX_PATHVECTORS];
}ENEMYPOS;

/******************************************************************************/
// the segs we've got on the playstation appear to be in a different order, dude...
enum								
{									
	NMEANIM_IDLE,			//0
	NMEANIM_IDLE2,			//1

	NMEANIM_STARTMOVE,		//2
	NMEANIM_WALK,			//3
	NMEANIM_RUN,			//4
	NMEANIM_STOPMOVE,		//5

	NMEANIM_JUMP,			//6
	NMEANIM_LAND,			//7

	NMEANIM_STARTATTACK,	//8
	NMEANIM_ENDATTACK,		//9

	NMEANIM_ACTION1,		//10
	NMEANIM_ACTION2,		//11

	NMEANIM_HURT,			//12
	NMEANIM_DEATH,			//13
	NMEANIM_SPECIAL1,		//14
	NMEANIM_SPECIAL2,		//15
};									


//actor types
enum
{
	CAMERA,				//0      
// In the N64 source, these are "HAND" and "BALL",
// but "ball" conflicted with something on the PSX. Luv, Fred
	ACTORTYPE_HAND,				//1      
	ACTORTYPE_BALL,				//2      
	DEBRIS,				//3      
	BULLET,				//4      
	SNEEZY,				//5      
	MOOCOW,				//6 
	BOVVA,				//7      

	CANNONBALL,			//8      
	SAMTEX,				//9      
	MALLET,				//10     
	GENERALWU,			//11     
	LIONFISH,			//12     
	CHESTER,			//13     
	KEG,				//14     
	REGGIE,				//15     

	SWISH,				//16     
	KNIGHT,				//17     
	ROBES,				//18     
	FUMBLE,				//19     
	MIKE,				//20     
	RAPTOR,				//21     
	CRUMPET,			//22     
	TRACEY,				//23     

	YOOFOW,				//24     
	OPEC,				//25     
	CYMON,				//26     
	SUCKER,				//27     
	BUGLE,				//28     
	DENNIS,				//29     
	CHUCK,				//30     
	HUBCHICKEN,			//31

	KLOSET,				//32
	FLANNEL,			//33
	BUG,				//34
	SELWYN_WHALE,		//35
	SELWYN_CRAB,		//36
	SELWYN_FISH,		//37
	ROBOT,				//37
	BIGFISH,				//39

	SPANK,				//40
	BABY_SPANK,			//41
	EVIL_GLOVE,			//42
	DIBBER,				//43
	FLY,				//44
	SNAIL,				//45
	FROG,				//46
	LITTLEFISH,			//47

	LADYBIRD,			//48
	WEEVIL,				//49
	CATERPILLAR,		//50
	BUTTERFLY,			//51
	SPIDER,				//52
	BAT,				//53
	BOXTHING,			//54
	DRAGFLY,			//55

	NME_FROG,			//56

// Fred's cheap & nasty way of plugging the pickup code into the enemy handling code
	PICKUP_ENEMY_STUN,
	PICKUP_ENEMY_DEATH,
	PICKUP_ENEMY_FROGGY,
	PICKUP_ENEMY_SUCTION,
	PICKUP_ENEMY_HERCULES,
	PICKUP_ENEMY_SPEEDUP,
	PICKUP_ENEMY_ROTORBLADES,
	PICKUP_ENEMY_BOWLINGBALL,
	PICKUP_ENEMY_POWERBALL,
	PICKUP_ENEMY_BALLBEARING,
	PICKUP_ENEMY_BEACHBALL,
	PICKUP_ENEMY_SNOWBALL,
	PICKUP_ENEMY_CRYSTALBALL,
	PICKUP_ENEMY_BOOMERANGBALL,
	PICKUP_ENEMY_VANISHBALL,

	PORTAL_ENEMY,

	CAMEO_ENEMY,

};							    
	

extern ENEMYPOS *enemies;
extern ULONG numberofenemies;


void enemiesBeginFile();
void enemiesLoadShapes();

int enemiesParseTokenEnemy(short token,UBYTE **data);
void enemiesEndFile();

void enemiesFreeEnemies();
void enemiesAddExitPortal(int x, int y, int z);


// call when glover dies (and, indeed, post load)
void Respawn_Enemies();


void Update_Enemies();

void Draw_Enemies();

// Funtions for enemies hitting the glove (will also need to hit ball as well)

void	CheckGeneralHit(ENEMYPOS *nme);
void	CheckMalletHitGlove(ENEMYPOS *nme);
void	CheckMalletHitBall(ENEMYPOS *nme);


void nmeDismountDenis(ENEMYPOS *nme);
void nmeDismountSwish(ENEMYPOS *nme);

ENEMYPOS * nmeFindEnemyToShootAt();


void EnemyStun(ENEMYPOS *enemy);
void EnemyKill(ENEMYPOS *enemy);
void EnemyFroggify(ENEMYPOS *enemy);

void CheckForNmeHitsBlast(VECTOR *pos, int radius, int height);


#endif
