/************************************************************************************
	ACTION MAN PS	(c) 1998-9 ISL

	fileio.c:		New file handling

************************************************************************************/

#ifndef _FILEIO_H_
#define _FILEIO_H_

//#define LoadFile fileLoad

/**************************************************************************
	FUNCTION:	fileInitialise()
	PURPOSE:	Initialise file I/O
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void fileInitialise();

/**************************************************************************
	FUNCTION:	fileLoadBinary()
	PURPOSE:	Load in file to specific location (for overlays etc.)
	PARAMETERS:	Filename and location
	RETURNS:	0 if success, 1 if fail
**************************************************************************/

UBYTE fileLoadBinary(UBYTE *fName, UBYTE *loc);


/**************************************************************************
	FUNCTION:	fileLoad()
	PURPOSE:	Load in file
	PARAMETERS:	Filename
	RETURNS:	Ptr to file data or NULL
**************************************************************************/

//UBYTE *fileLoad(UBYTE *fName);
//UBYTE *fileTempLoad(UBYTE *fName);


/**************************************************************************
	FUNCTION:	fileLoad()
	PURPOSE:	Load in file
	PARAMETERS:	Filename, ptr to length var
	RETURNS:	Ptr to file data or NULL
**************************************************************************/

UBYTE *fileLoad(UBYTE *fName, int *length);
UBYTE *fileTempLoad(UBYTE *fName, int *length);


/**************************************************************************
	FUNCTION:	fileBkgLoad()
	PURPOSE:	Load file in background
	PARAMETERS:	Filename
	RETURNS:	
	NOTE:		DON'T DO DEBUG OUTPUT WHILE BACKGROUND LOADING
**************************************************************************/

int fileBkgLoad(UBYTE *fName, int *length, int temp);


/**************************************************************************
	FUNCTION:	fileBkgComplete()
	PURPOSE:	Check on file loading in background
	PARAMETERS:	
	RETURNS:	Ptr to buffer or NULL
	NOTE:		DON'T DO DEBUG OUTPUT WHILE BACKGROUND LOADING
**************************************************************************/

UBYTE *fileBkgComplete();


#endif
