/*****************************************************************************

	files.h

	hard disc/cd-rom file handling

	(c) 1998 Interactive Studios Ltd.

*****************************************************************************/


#ifndef __H_FILES
#define __H_FILES

// globals!!

#define MAXSECTORFILES 20

typedef struct
{
	LONG  sector;
	UBYTE name[28];
} FILESECTOR;


#define fileLoad LoadFileRaw

extern FILESECTOR		filesector[MAXSECTORFILES];
extern UBYTE			*fileroot; 
extern LONG				filehandle;
extern ULONG			lastfilelength;
extern UBYTE			filename[];
extern CdlFILE			fp;
extern UBYTE			cdstopped;
extern UBYTE			cdresult[8];
extern UBYTE			numberofreaderrors;
extern LONG				firstsector;
extern ULONG			sectorstoread;
extern UBYTE			indexbuffer[];
extern volatile	LONG	startsector;
extern LONG				fileindex;
extern UBYTE			param[8];
extern LONG				startDATsector;
extern ULONG			filechecksum[];
extern int				cd_trackplaying;
extern ULONG			checksumoffiletable;


UBYTE*	LoadCDFile(UBYTE* name);

UBYTE	ShowCDStatus();

void	InitialiseFiles(void);

LONG	fopen(UBYTE *name);

LONG	fclose(LONG filehandle);

SHORT	fgetc(LONG filehandle);

LONG	fread(VOID *ptr,USHORT var_size,LONG size,LONG filehandle);

LONG	fseek(LONG filehandle,LONG offset,LONG mode);

ULONG	ftell(LONG filehandle);

UBYTE*	LoadFile(UBYTE* name);

void	RestartCD();

UBYTE	CheckSumFile();

LONG	FileInfo(UBYTE *index,BYTE *filespec,LONG *firstsec,LONG *size,LONG *number);

UBYTE	CDload(BYTE *bufferarea,BYTE *filename,LONG no_of_sectors,LONG offset);

void	Print_Loading_Mess(UBYTE *filename);

void	Play_CD_track(UBYTE);

void	SetCD2DataMode();

void	PollCD();

ULONG	Checksum(ULONG *addr,ULONG len);

#endif



