typedef struct _GloveCtrl
{
	long	radius;
	long	height;
	long	frontProbeHeight;
	USHORT	speed;
	USHORT	oldSpeed;
	USHORT	targetSpeed;
	USHORT	direction;
//	USHORT	animFrame;
//	USHORT	animState;
//	USHORT	animSpeed;
//	USHORT	animCount;
	USHORT	action;
	USHORT	lastAction;
	USHORT	currentAnim;
	USHORT	active;
	USHORT	disableTimer;
	USHORT	throwDelay;
	USHORT	preDelay;
	USHORT	idleTimer;
	USHORT	actionTime;
	USHORT	walkType;
	USHORT	onGround;
	USHORT	ballWithHand;
	USHORT	hitBall;
	USHORT	handOnBall;
	UBYTE	flags;
	UBYTE	stopXZ;
	UBYTE	idleAction;
	UBYTE	idleSelection;
	UBYTE	frontProbeHit;
}GLOVECTRL;

// defines for flag



//#define	IDLE	0
//#define	WALK	1
//#define	RUN		2
//#define	SLIDE	3
//#define	JUMP	4

// Flag defines
#define GLOVEMOVE		(1<<0)
#define STOPGLOVEMOVE	(1<<1)
#define STOPAIRMOVE		(1<<2)

#define HAND_SNATCH_RANGE 40
#define	CRAWLSTARTDELAY	6
#define CRAWLSPEED		1

#define TOPSPEED 128
#define CARTWHEELSPEED 8
#define SKIDSPEED (TOPSPEED/8)
#define JUMPHEIGHT GRAVITY/2

#define	RESTSPEED	4095

//#define	CATCHDISTANCE	10*4096

#define	ROTATESPEED 	256
#define	LEANANGLE		300/3
#define	BOUNCEFALLSPEED	GRAVITY*5

//#define	GRAVITY	4096
#define	GRAVITY	2048

#define	FRONTPROBEDIST	5
#define	FRONTPROBECHECK	70000


#define ABUTTON		(1<<0)
#define BBUTTON		(1<<1)

typedef struct _GloverSeg
{
	USHORT	start;
	USHORT	end;
}GLOVERSEG;

//------------------------------------------------------
//hand animations needs to be reordered due to seg files being in different order
enum
{
	HANDANIM_TIPTOE,			//0  
	HANDANIM_JOG,				//1  
	HANDANIM_SKID,				//2  
	HANDANIM_IDLE,				//3  
	HANDANIM_JUMP,				//4  

	HANDANIM_SUPERJUMP,			//5
	HANDANIM_LAND,				//6
	HANDANIM_CARTWHEEL,			//7
	HANDANIM_DUCK,				//8
	HANDANIM_BORED,				//9

	HANDANIM_DUCK2STAND,		//10
	HANDANIM_SLAM,				//11
	HANDANIM_SLAM2STAND,		//12
	HANDANIM_ROLL,				//13
	HANDANIM_ROLL2BOUNCE,		//14

	HANDANIM_BOUNCE,			//15
	HANDANIM_BOUNCE2ROLL,		//16
	HANDANIM_RELEASE,			//17
	HANDANIM_THROWAIM,			//18
	HANDANIM_THROW,				//19

	HANDANIM_WHACKAIM,			//20
	HANDANIM_WHACK,				//21
	HANDANIM_RUN,				//22
	HANDANIM_SELFSPELL,			//23
	HANDANIM_BALLSPELL,			//24

	HANDANIM_NMESPELL,			//25
	HANDANIM_HURT,				//26
	HANDANIM_FALLDEATH,			//27
	HANDANIM_CARDIACDEATH,		//28
	HANDANIM_CRAWL,				//29

	HANDANIM_GETDOWN,			//30
	HANDANIM_GETUP,				//31
	HANDANIM_ROLLBLINK,			//32
	HANDANIM_ROLL2SPIN,			//33
	HANDANIM_SPIN,				//34

	HANDANIM_SPIN2ROLL,			//35
	HANDANIM_SIT,				//36
	HANDANIM_LOB,				//37
	HANDANIM_POINT,				//38
	HANDANIM_POINTCYCLE,		//39

	HANDANIM_CLING,				//40
	HANDANIM_CLINGDOWN,			//41
	HANDANIM_POINT2IDLE,		//42
	HANDANIM_CLINGUP,			//43
	HANDANIM_CLINGIDLE,			//44

	HANDANIM_WHACKIDLE,			//45
	HANDANIM_SITIDLE,			//46
	HANDANIM_GRABBALL,			//47
	HANDANIM_SITDOWN,			//48
	HANDANIM_SITUP,				//49

	HANDANIM_IDLE2PUSH,			//50
	HANDANIM_PUSH,				//51
	HANDANIM_PUSH2IDLE,			//52
	HANDANIM_BALLWALK,			//53
	HANDANIM_RIDEDENNIS,		//54

	HANDANIM_GRABSWISH,			//55
	HANDANIM_FALLOVER,			//56
	HANDANIM_EMPTYFIRE,			//57
	HANDANIM_THUMBSUP,			//58
	HANDANIM_OKAY,				//59

	HANDANIM_FALL,				//60
	HANDANIM_BALLWALK2,			//61
	HANDANIM_SQUASH,			//62
	HANDANIM_IDLE2STRETCH,		//63
	HANDANIM_STRETCH,			//64

	HANDANIM_STRETCH2IDLE,		//65
	HANDANIM_CELEBRATE,			//66
	HANDANIM_PEDDLE,			//67
	HANDANIM_ROLL2PEDDLE,		//68
	HANDANIM_VICTORY,			//69

	HANDANIM_CLICKFINGER,		//70
	HANDANIM_IDLE2WAVE,			//71
	HANDANIM_WAVE,				//72
	HANDANIM_BALLWALK2IDLE,		//73

	MAX_HANDANIMS			 

/*	HANDANIM_BALLWALK,			 //0  
	HANDANIM_MISFIRE,			 //1  
	HANDANIM_FALL,				 //2  
	HANDANIM_GETDOWN,			 //3  
	HANDANIM_GETUP,				 //4  
								  
	HANDANIM_SNATCH,			 //5  
	HANDANIM_SWISH,				 //6  
	HANDANIM_WALK,				 //7  
	HANDANIM_OKAY,				 //8  
	HANDANIM_DENIS,				 //9
								   
	HANDANIM_SIT2DOWN,			 //10 
	HANDANIM_SITIDLE,			 //11 
	HANDANIM_SITUP,				 //12 
	HANDANIM_THUMBSUP,			 //13 
	HANDANIM_TIPTOE,			 //14 
								  
	HANDANIM_BALLSPELL,			 //15 
	HANDANIM_IDLE1,				 //16 
	HANDANIM_BOUNCE2,			 //17 
	HANDANIM_BOUNCE2CUP,		 //18 
	HANDANIM_CARTWHEEL,			 //19 
								  
	HANDANIM_CLING,				 //20 
	HANDANIM_CLINGDOWN,			 //21 
	HANDANIM_CLINGIDLE,			 //22 
	HANDANIM_CLINGUP,			 //23 
	HANDANIM_CRAWL,				 //24 
								  
	HANDANIM_ST2DUCK,			 //25 
	HANDANIM_DUCK2ST,			 //26 
	HANDANIM_FALLDEATH,			 //27 
	HANDANIM_FALLOVER,			 //28 
	HANDANIM_CARDIACDEATH,		 //29 
								  
	HANDANIM_HURT,				 //30 
	HANDANIM_STAND,				 //31 
	HANDANIM_STAND2PUSH,		 //32 
	HANDANIM_JUMP,				 //33 
	HANDANIM_THROW2LAND,		 //34 
								  
	HANDANIM_LOB,				 //35 
	HANDANIM_NMESPELL,			 //36 
	HANDANIM_POINT,				 //37 
	HANDANIM_POINTCYCLE,		 //38 
	HANDANIM_POINT2IDLE,		 //39 
								      
	HANDANIM_PUSH,				 //40    
	HANDANIM_PUSH2STAND,		 //41    
	HANDANIM_CUP2ST,			 //42    
	HANDANIM_ST2CUP,			 //43    
	HANDANIM_CUP2BOUNCE,		 //44
								 
	HANDANIM_CUP2SPIN,			 //45
	HANDANIM_CUPIDLE,			 //46    
	HANDANIM_RUN,				 //47
	HANDANIM_HANDSPELL,			 //48
	HANDANIM_SIT,				 //49

	HANDANIM_SKID,				 //50
	HANDANIM_SLAM,				 //51
	HANDANIM_SLAM2ST,			 //52
	HANDANIM_SPIN,				 //53
	HANDANIM_SPIN2CUP,			 //54

	HANDANIM_LONGJUMP,			 //55
	HANDANIM_THROW,				 //56
	HANDANIM_THROWAIM,			 //57
	HANDANIM_WHACK2,			 //58
	HANDANIM_WHACK1,			 //59

	HANDANIM_WHACKIDLE,			 //60


	HANDANIM_BNCE2THROWAIM,		//61
	HANDANIM_THROW2CUP,			//62
	HANDANIM_BOUNCE3,			//63
	HANDANIM_IDLE3,				//64
	HANDANIM_SPECIAL1,			//65
	HANDANIM_SPECIAL2,			//66
	HANDANIM_STUN,				//67
	HANDANIM_PAT,				//68
	HANDANIM_CLIMBDOWN,			//69
	HANDANIM_CLIMBUP,			//70

	HANDANIM_CLIMBDOWNIDLE,		//71
	MAX_HANDANIMS
*/
};

//------------------------------------------------------
//hand actions
enum
{
	HAND_IDLE,			 	//0  
	HAND_WALK,			 	//1  
	HAND_JUMP,			 	//2  
	HAND_JOINED,		 	//3  
	HAND_THROW,			 	//4  
	HAND_PREWHACK,		 	//5  
	HAND_WHACK,			 	//6  
	HAND_SKIDDING,		 	//7  
	HAND_DUCK,			 	//8  
	HAND_RELEASE,		 	//9  
	HAND_GETUP,			 	//10 
	HAND_THROWAIM,		 	//11 
	HAND_THROW2CUP,		 	//12 
	HAND_FALLING,		 	//13 
	HAND_BOUNCE,		 	//14 
	HAND_BOUNCE2CUP,	 	//15 
	HAND_AIRBOURNEWHACK, 	//16 
	HAND_THROW2LAND,	 	//17 
	HAND_SLAM,			 	//18 
	HAND_SLAM2ST,		 	//19 
	HAND_BALLWALK,		 	//20 
	HAND_CRAWL,			 	//21 
	HAND_CARTWHEEL,		 	//22 
	HAND_CLIMBUP,		 	//23 
	HAND_CLIMBDOWN,		 	//24 
	HAND_CLING,			 	//25 
	HAND_CLINGUP,		 	//26 
	HAND_DROPDOWN,		 	//27 
	HAND_HURT,			 	//28 
	HAND_PUSH,			 	//29 
	HAND_LOB,			 	//30 
	HAND_CATCH,			 	//31 
	HAND_CASTSPELL,		 	//32 
	HAND_ROTOR,			 	//33 
	HAND_SNATCH,		 	//34 
	HAND_SLIDING,			//35
	HAND_HOPPING,			//36
	HAND_FROG_IDLE,			//37
	HAND_FROG_JUMP,			//38
	HAND_FROG_WALK,			//39
	HAND_SWISH,				//40
	HAND_NOTHING,			//41
	HAND_LOCATE,			//42
	HAND_SPIN,				//43
	HAND_FROG_TONGUE,		//44
	MAX_HAND_ACTIONS	 	//45
};								

enum
{
	HANDWALK_TIPTOE,
	HANDWALK_WALK,
	HANDWALK_RUN,
	HANDWALK_ONBALL
};


extern GLOVECTRL	GloveCtrl;
extern BEHAVIOUR_PHYSICS	GloveBehaviour;


void	Load_And_Init_Glove();
void	Control_Glove();
void	moveGlove();
void	MaintainAction();
int		GrabBallAllowed();
int		CatchBallAllowed();
int		HandOnBall();
void	HandCollision();