
#ifndef __H_INTERUPT
#define __H_INTERUPT



extern unsigned long __heapbase;
extern unsigned long __heapsize;
extern unsigned long __bss;
extern unsigned long __bsslen;
extern unsigned long __data;
extern unsigned long __datalen;
extern unsigned long __text;
extern unsigned long __textlen;

#define PAL_CINEMA	360
#define NTSC_CINEMA	360
#define PAL_TV		273
#define	NTSC_TV		240
  
// Tidied up by CPW on 19/2/1999
// NOTE: There's no longer a fixed max number of polygons,
//       just a maximum size that the polygon list can be.

#define MAXPACKETSIZE (sizeof(POLY_GT4))
#define OT_LENGTH 11  // size of order table, in bits
#define MAXPOLYDEPTH ((1<<OT_LENGTH)-1)
#define MAXOTZ		 ((1<<OT_LENGTH)-1)

#define PACKETMAX 0x18000 // max size of poly table (0x28000 = 160K)

extern UBYTE *dodgeypolys; //this is the address to check, if polys overrun

extern UBYTE *PacketBuildList;	//malloc'd with PACKETMAX *2 ('cos of 2 tables)
extern	UBYTE		scr_toggle;
extern 	SHORT	scrcenterx;
extern 	SHORT	scrcentery;
extern	SHORT	screenwidth;
extern	SHORT	screenheight;
extern USHORT resolution;
extern DRAWENV	GsDRAWENV;
extern DISPENV	GsDISPENV;


extern	DRAWENV		drawenv[2];			/* drawing environment */
extern	DISPENV		dispenv[2];			/* display environment */

extern	int xOffset[2];
extern	int yOffset[2];


									      
void Check_Stack(UBYTE num);
extern	int  oldSp;

void 		Start_Loop(void);
void 		End_Loop(ULONG );
void		rts(void);
void 		Cls(void);
void		Turn_Screen_Off();

extern 	volatile 	ULONG	vblank;
extern 	volatile 	ULONG	iframe;
extern 				ULONG	ovblank;
extern int		frameLock;
extern int		showProgress, currProgress;

extern USHORT framerate;
extern int	projection;
extern int	cinemascopeToggle;
extern int	yScale;

extern 	ULONG 	frame;
extern	ULONG	activeframe;	/* frame counter that pauses when paused */


void		VblCallback();

/*********************************************************/

extern	RGBCD  	clscol;

void	Set_Up_Display();

void	Show_VRAM(void);

typedef struct{
			volatile  	UBYTE		dblbuf;
			UBYTE		*id; 
			GsOTA		Wot[2];
			GsOT_TAG	*sorttable;
			PACKET		*poly_packets;
			UBYTE*		topofdrawlist[2];
			UBYTE*		bottomofdrawlist[2];
			}OBJECTPOLYLIST;

UBYTE TooManyPolys(LONG size,UBYTE *mess);

#if (GOLDCD==NO) && (RELEASE==NO)
#define TOOMANYPOLYS(A,B)  TooManyPolys(A,B)	
#else
#define TOOMANYPOLYS(A,B) 	(A+(LONG)GsOUT_PACKET_P)>(ULONG)(CurrentPolyList->topofdrawlist[CurrentPolyList->dblbuf])
#endif

OBJECTPOLYLIST polylist;
extern	OBJECTPOLYLIST *CurrentPolyList;

void	brokenscreenoffon();
void 	solidscreenonoff();
void	ShowScreen(int);

void	Init_PolyLists();
OBJECTPOLYLIST*	Register_ObjectPolyList(UBYTE bitdepth,UBYTE* id,ULONG packetbuildsize);
void			Do_ObjectPolyList(OBJECTPOLYLIST *ptr);

void	endpoly();

extern	GsOTA *PolyList;

void	VblCallback();
extern	OBJECTPOLYLIST *defaultpolylist;


extern	volatile LONG finisheddrawing;
void	enddrawing();

// We need some scratchpad in fastram, as well as the stack
// (specifically in the recursive routines in the object animator)

#define SCRATCHPAD (DCACHE)
#define SCRATCHPADSIZE 32

extern int		stackinfastmode;
//extern int 		scratchpadsize;
#define FASTSTACK() {EnterCriticalSection(); \
			      	oldSp=SetSp(DCACHETOP); \
					stackinfastmode=YES; \
					ExitCriticalSection();}
#define SLOWSTACK(){EnterCriticalSection(); \
					SetSp(oldSp); \
					stackinfastmode=NO;	\
					ExitCriticalSection();}




extern ULONG stack;
extern ULONG shouldcrash;
extern ULONG stacktmp;
extern ULONG stacklimit;
#define STACKCHECK {EnterCriticalSection(); \
					stacktmp=SetSp(oldSp); \
					SetSp(stacktmp); \
					stack=stacktmp-DCACHE; \
					ExitCriticalSection(); \
					if (stack<stacklimit)CRASH;}







extern int oldstack;

void	CheckStack();

void progressMeter(int foo);

void	SnapShot(void);
/*******************************************************************************/
/*******************************************************************************/
/*****  TIMERS    **************************************************************/
/*******************************************************************************/
/*******************************************************************************/
//timers are now all removed on GOLDCD (or TIMERS define).  Andrew

#define TIMERS (!GOLDCD && !RELEASE)

extern char	timerActive;
#if TIMERS==ON
enum {
	TIMER_TOTAL,
	TIMER_TIMERS,
	TIMER_LSCAPE,
	TIMER_COLLISION,
	TIMER_NME,
	TIMER_NMEMOVE,
	TIMER_BALLGLOVE,
	TIMER_DRAWSYNC,
	TIMER_CAMERA,
	TIMER_GPU,
	TIMER_NUMTIMERS
};

#define TIMER_NAMES		"TOT", \
						"TIMS", \
						"SCAPE", \
						"COLL",\
						"NMED", \
						"NMEM", \
						"B N G", \
						"SYNC", \
						"CAM", \
						"GPU"


extern char	*timerName[TIMER_NUMTIMERS];
extern int	globalTimer[TIMER_NUMTIMERS];
extern int	prevTimer[TIMER_NUMTIMERS];
extern int 	TimerStarted[TIMER_NUMTIMERS];

void timerDisplay();
void dispGraph(short x,short y, short w, short h, UBYTE r, UBYTE g, UBYTE b);
#define TIMER_START(n)		{TimerStarted[n] = VSync(1);}

#define TIMER_STOP(n)		{globalTimer[n] += VSync(1)-TimerStarted[n];}

#define TIMER_ENDFRAME		{ \
	memcpy(prevTimer, globalTimer, sizeof(globalTimer)); \
	memset(TimerStarted,0,sizeof(globalTimer)); \
	memset(globalTimer,0,sizeof(globalTimer)); \
	}
#else

#define TIMER_START(n) 	{};
#define TIMER_STOP(n) 	{};
#define TIMER_ENDFRAME	{};
#define timerDisplay(); {};

#endif


extern int interrupt_cyclebar;


#if GOLDCD==NO
	extern char no_pollhosts;
#endif


#endif /*H_INTERUPT*/





  