/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	lscape.h:		Landscape specific draw routines

************************************************************************************/

#ifndef _LSCAPE_H_
#define _LSCAPE_H_

#define LIGHTING_OFF 0
#define LIGHTING_DYNAMIC 1
#define LIGHTING_PARALLEL 2

// sub division stuff
#define	SUBDIVISIONDEPTH	16032/8

#define	NOTINSIDE		0
#define	FULLINSIDE		1
#define	PARTINSIDE		2

typedef	struct	_SUBDIVCTRL
{
	LONG	distance;
	LONG	maxAmount;
	LONG	currentAmount;

}SUBDIVCTRL;



extern	long *transVerts;
extern	long *transDepths;

extern	SPRITEX *pWaterSprites;

void lscapeDrawAll(PSAWORLD *);

void lscapeInit(void);
/**************************************************************************
	FUNCTION:	lscapeDraw()
	PURPOSE:	Draw a landscape object (with proper depth sort)
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void lscapeDraw(NEWMODEL *model);

/**************************************************************************
	FUNCTION:	lscapeDrawSub()
	PURPOSE:	Draw a landscape object (with proper depth sort) allso includes sub division checks
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/

void lscapeDrawSub(NEWMODEL *model);


/**************************************************************************
	FUNCTION:	lscapeDraw()
	PURPOSE:	Draw a landscape object (with proper depth sort), can rotate
	PARAMETERS:	Model structure
	RETURNS:	
**************************************************************************/
void lscapeDrawRotate(NEWMODEL *model);

/**************************************************************************
	FUNCTION:	lscapeDrawBoundPoly()
	PURPOSE:	highlights the collision polys
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void lscapeDrawBoundPoly(int numPoints, Point2DType *points, int height, uchar r,uchar g,uchar b);

/**************************************************************************
	FUNCTION:	lscapeDrawBoundPoly3D()
	PURPOSE:	highlights the collision polys
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void lscapeDrawBoundPoly3D(int numPoints, Point3DType *points, uchar r,uchar g,uchar b);

//static  PACKET *divideTri (TMD_P_TG3A *opTG3,long *transformedVerts, long *transformedDepths,PACKET *packet);
//static  PACKET *divideQuad(TMD_P_TG4A *opTG4,long *transformedVerts, long *transformedDepths,PACKET *packet);


//static  PACKET *divideTriCrack (TMD_P_TG3A *opTG3,long *transformedVerts, long *transformedDepths,PACKET *packet);
//static  PACKET *divideQuadCrack(TMD_P_TG4A *opTG4,long *transformedVerts, long *transformedDepths,PACKET *packet);


extern PSAWORLD *pWld;


#endif

