/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	main.h:		Main game loop control

************************************************************************************/

#ifndef _MAIN_H_
#define _MAIN_H_


enum {
	GAMEMODE_MENU,
	GAMEMODE_DEMO,
	GAMEMODE_PREVIEW
};

enum {
	GAMELEV_PARA,
	GAMELEV_DESERT,
	GAMELEV_TRAIN,
	GAMELEV_STREET,
	GAMELEV_LAUNCH,
	GAMELEV_ICEBRG,

	GAMELEV_MAX,
};



typedef struct _GameInfoType {
	int		mode;
	int		initialise;
	int		frame;
	int		level;
	char	sectionName[20];
	char	roomName[20];
	struct psFont	*font;
//	SPRITEX	*white;
	int		fadeLevel;
	int		destFadeLevel;
} GameInfoType;


extern GameInfoType	gameInfo;


/**************************************************************************
	FUNCTION:	gameInitialise()
	PURPOSE:	Initialise game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void gameInitialise();


/**************************************************************************
	FUNCTION:	gameFrame()
	PURPOSE:	Do one frame of game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void gameFrame();


/**************************************************************************
	FUNCTION:	gameDestroy()
	PURPOSE:	Clean up game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void gameDestroy();




#define	MAX_VEL		15*4096


#endif
