/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	main.h:		Main game loop control

************************************************************************************/

#ifndef _MAIN_H_
#define _MAIN_H_


enum {
	GAMEMODE_MENU,
	GAMEMODE_DEMO,
	GAMEMODE_PREVIEW,
	GAMEMODE_RESTART
};
/*
enum {
	GAMELEV_PARA,
	GAMELEV_DESERT,
	GAMELEV_TRAIN,
	GAMELEV_STREET,
	GAMELEV_LAUNCH,
	GAMELEV_ICEBRG,

	GAMELEV_MAX,
};
*/


typedef struct _GameInfoType {
	int		mode;
//	int		initialise;
	int		frame;
	int		level;
//	char	sectionName[20];
//	char	roomName[20];
//	struct _psFont	*font;
//	SPRITEX	*white;
//	int		fadeLevel;
//	int		destFadeLevel;
	int		timePadLastHit;
	int		keyTime;
	int		levelStartTime;
	int		levelEndTime;
	int		levelType;
	int		timeAllowed;
	UBYTE	keyRecordFlag;
	char	sKeyDemo[32];
}GameInfoType;


typedef struct _HiScoreType
{
	int		yes;
	int		timeTook; // in cS
	short	betterTime, betterGaribs;
	short	nGaribs, nTotalGaribs;
	int		score;
	char	name[3];
}HiScoreType;

#define	RECORD		1
#define PLAYBACK	2

#define NORMAL_LEVEL	0
#define BONUS_LEVEL		1
#define BOSS_LEVEL		2


extern GameInfoType	gameInfo;
extern HiScoreType hiScores[];



/**************************************************************************
	FUNCTION:	gameInitialise()
	PURPOSE:	Initialise game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void gameInitialise();


/**************************************************************************
	FUNCTION:	gameFrame()
	PURPOSE:	Do one frame of game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/

void gameFrame();


/**************************************************************************
	FUNCTION:	gameDestroy()
	PURPOSE:	Clean up game
	PARAMETERS:	
	RETURNS:	
**************************************************************************/
void gameDestroy();

//#define	MAX_VEL		15*4096


#endif
