
#include "glover.h"

void menuMusicSelect(void);


#define TIMELIMIT 3
//#define QUICK
#define NUMLEVELS (NUM_LEVELS-1)
#define N_SPLASH_SCREENS 12

int fader=32,fadeout=0,fadein=0	;
UBYTE world;
TextureBankType	*spin_pBank;
UBYTE language=0;


#if RELEASE==NO
	UBYTE cheatMenuOn=1;
#else
	UBYTE cheatMenuOn=0;
#endif

char *WorldDirectoryNames[] =
{
	"HUB",
	"ATLANTIS",
	"CARNIVAL",
	"PIRATES",
	"PREHIST",
	"FEAR",
	"OOTW",
	"GENERIC"
};

char *sAbbrevNames[]=
{
	"HUB",
	"AT",
	"CA",
	"PI",
	"FF",
	"SP",
	NULL
};

char *sSubLevelDirNames[]=
{
	"L1",
	"L2",
	"L3",
	"BOSS",
	"BONUS"
};

char *sSubLevelNames[]=
{
	"1",
	"2",
	"3",
	"BOSS",
	"BONUS"
};


char *sLevelNames[]=
{
	"!TEST MESH",
	"!HUB 1",
	"!HUB 2",
	"!HUB 3",
	"!HUB 4",
	"!HUB 5",
	"!HUB 6",
	"!HUB 7",
	"!HUB 8",
	"!CAVE",
	"ASSAULT COURSE",
	"!ATLANTIS 1",
	"!ATLANTIS 2",
	"!ATLANTIS 3",
	"!ATLANTIS BOSS",
	"!ATLANTIS BONUS",
	"!CARNIVAL 1",
	"!CARNIVAL 2",
	"!CARNIVAL 3",
	"!CARNIVAL BOSS",
	"!CARNIVAL BONUS",
	"!PIRATES 1",
	"!PIRATES 2",
	"!PIRATES 3",
	"!PIRATES BOSS",
	"!PIRATES BONUS",
	"!PREHISTORIC 1",
	"!PREHISTORIC 2",
	"!PREHISTORIC 3",
	"!PREHISTORIC BOSS",
	"!PREHISTORIC BONUS",
	"!FEAR 1",
	"!FEAR 2",
	"!FEAR 3",
	"!FEAR BOSS",
	"!FEAR BONUS",
	"!OOTW 1",
	"!OOTW 2",
	"!OOTW 3",
	"!OOTW BOSS 1",
	"!OOTW BOSS 2",
	"!OOTW BONUS",
	"!WAYROOM",
	"!WAYROOM2",
	"!WAYROOM3",
	"!WAYROOM4",
	"!WAYROOM5",
	"!ATLAN TEST",
	"!CARNIV TEST",
	"!PIRATE TEST",
	"!PREHIST TEST",
	"!FEAR TEST",
	"!OOTW TEST"
};

#define BLANK  {"",""},



int menuStart[]={0,6};
#ifdef DEMO
int menuLength[]={4,4};
#else
int menuLength[]={6,4};
#endif

MENUITEM menuItem[]=
{
#ifdef DEMO
	{"MODEL VIEWER",	0,	120, 48,	280, 48,	300,280},//0
	{"START",			0,	120, 96,	280, 96,	300,360},//0
	{"LEVEL SELECT",	0,	120, 144,	280, 144,	300,440},
	{"SOUND TEST",		0,	120, 192,	280, 192,	300,520},
#else
	{"START",			0,	120, 48,	280, 48,	300,280},//0
	{"PRACTICE",		0,	120, 96,	280, 96,	300,360},
	{"OPTIONS",			0,	120, 144,	280, 144,	300,440},
	{"TIME TRIAL",		0,	120, 192,	280, 192,	300,520},
#endif
	{"",				3,	32,	240,	0,0,		0,0},
	{"",				3,	32,	32,		0,0,		0,0},

	{"",				1,	120, 48,	280, 48,	300,280},//6
	{"",				1,	120, 96,	280, 96,	300,360},
	{"CREDITS",			0,	120, 144,	280, 144,	300,440},
	{"HI SCORES",		0,	120, 192,	280, 192,	300,520}
};




GsRVIEW2 menuCam,backCam;

NEWMODEL *p3DLetters;
NEWMODEL *pLosenge,*fadeStar;
OVERLAY hand;//,horn,note;
//SPRITEX *pLS;
TextureBankType *pTitBank;
TextureBankType *pHubBank;

//static PSAWORLD *pWld;
//static NEWMODEL *pSky;
//extern NEWMODEL *pSky;
static int zoom=1024;

/*****************************************************************************************************/
void menuPrintBack(int zoom)
{
static int ang=800;
	backCam.vpx=(rsin(ang&0xfff)*zoom)/4096;
	backCam.vpz=(rcos(ang&0xfff)*zoom)/4096;
	backCam.vpy=backCam.vry-200+rcos((ang*3)&0xfff)/8;
	ang+=4;
	//ang&=0xfff;

	GsSetRefView2L(&backCam);

	lscapeDraw(pSky,0);

	lscapeDrawAll(pWld);// draw world last, so sky can't flick out ...
}
/*****************************************************************************************************/
VECTOR staticCamPosition[]=
{
	{500,-500,500}, //test
	{500,-500,500}, //hub1
	{500,-500,500}, 
	{500,-500,500},
	{500,-500,500},
	{500,-500,500},
	{500,-500,500},
	{500,-500,500},
	{500,-500,500},
	{500,-500,500}, //cave
	{500,-500,500}, //acourse
	{292,-310,2049}, //at1
	{194,-456,-5021}, //at2
	{1915,-156,-1788}, //at3
	{391,-175,445}, //atboss
	{211,-698,901}, //atbonus
	{-572,-858,1521}, //carn1
	{319,-323,-468}, //carn2
	{1880,-195,1433}, //carn3
	{-186,-436,-353}, //carnboss
	{74,-200,-39}, //carbonus
	{3071,9,1566}, //pir1
	{-823,-207,682}, //pir2
	{2239,-497,117}, //pir3
	{369,-50,-919}, //pirboss
	{14,-2833,-43}, //pirbonus
	{-1332,-475,1446}, //pre1
	{-2344,197,350}, //pre2
	{3746,-202,-904}, //pre3
	{-300,-240,-100}, //preboss
	{13,-86,-658}, //prebonus
	{2012,-69,3900}, //ff1
	{2337,-213,1078}, //ff2
	{-2766,-644,9480}, //ff3
	{-3,-293,241}, //ffboss
	{48,-707,-20}, //ffbonus
	{2129,-646,-1562}, //sp1
	{-124,228,231}, //sp2
	{1266,-1063,-657}, //sp3
	{500,-500,500}, //spboss
	{-300,-450,-50}, //spboss2
	{5,-1006,132}, //spbonus
	{500,-500,500},
	{500,-500,500},
	{500,-500,500},
};

VECTOR staticCamTarget[]=
{
	{500,500,500}, //test
	{500,500,500}, //hub1
	{500,500,500}, 
	{500,500,500},
	{500,500,500},
	{500,500,500},
	{500,500,500},
	{500,500,500},
	{500,500,500},
	{500,500,500}, //cave
	{0,0,0}, //acourse
	{54,-263,2579}, //at1
	{-205,-248,-5539}, //at2
	{2471,-123,-2503}, //at3
	{-30,-24,110}, //atboss
	{-348,-326,467}, //atbonus
	{-287,-700,1066}, //carn1
	{126,-241,3}, //carn2
	{1147,-141,1178}, //carn3
	{46,-47,46}, //carnboss
	{31,-205,718}, //carbonus
	{2653,-257,1903}, //pir1
	{-304,-163,244}, //pir2
	{2623,-260,448}, //pir3
	{53,91,-168}, //pirboss
	{-16,-1194,-44}, //pirbonus
	{-662,-420,1810}, //pre1
	{-3245,-50,133}, //pre2
	{4354,-400,-916}, //pre3
	{-300,225,816}, //preboss
	{-31,16,-1409}, //prebonus
	{2517,-350,4289}, //ff1
	{2619,-378,1481}, //ff2
	{-2862,-483,9965}, //ff3
	{-18,-375,-392}, //ffboss
	{48,-72,57}, //ffbonus
	{1321,-293,-1935}, //sp1
	{32,176,-42}, //sp2
	{747,-560,-158}, //sp3
	{0,0,0}, //spboss
	{-300,-430,-200}, //spboss2
	{-121,-821,-380}, //spbonus
	{0,0,0},
	{0,0,0},
	{0,0,0},
};



#define	SCALE	16384
void menuPrintBackStatic()
{
	static int ang=800;
	VECTOR	scale,oldP,oldR;



	
	//-------------------------------------
	//this is for predfined static shots
	CamVars.camera.vpx=staticCamPosition[level].vx;
	CamVars.camera.vpy=staticCamPosition[level].vy;
	CamVars.camera.vpz=staticCamPosition[level].vz;

	CamVars.camera.vrx=staticCamTarget[level].vx;
	CamVars.camera.vry=staticCamTarget[level].vy;
	CamVars.camera.vrz=staticCamTarget[level].vz;
	//-------------------------------------



	//-------------------------------------
	//this is for last-view wobble shots
//	CamVars.camera.vpy=CamVars.camera.vry-80+rcos((ang*3)&0xfff)/160;
//	ang+=4;
    //-------------------------------------

	oldR.vx=CamVars.camera.vrx;
	oldR.vy=CamVars.camera.vry;
	oldR.vz=CamVars.camera.vrz;

	oldP.vx=CamVars.camera.vpx;
	oldP.vy=CamVars.camera.vpy;
	oldP.vz=CamVars.camera.vpz;





	CamVars.camera.vrx=(CamVars.camera.vrx*SCALE)/4096;
	CamVars.camera.vry=(CamVars.camera.vry*SCALE)/4096;
	CamVars.camera.vrz=(CamVars.camera.vrz*SCALE)/4096;

	CamVars.camera.vpx=(CamVars.camera.vpx*SCALE)/4096;
	CamVars.camera.vpy=(CamVars.camera.vpy*SCALE)/4096;
 	CamVars.camera.vpz=(CamVars.camera.vpz*SCALE)/4096;


	GsSetRefView2L(&CamVars.camera);
	scale.vx=SCALE;
	scale.vy=SCALE;
	scale.vz=SCALE;
	ScaleMatrixL(&GsWSMATRIX,&scale);

	CamVars.camera.vrx=oldR.vx;
	CamVars.camera.vry=oldR.vy;
	CamVars.camera.vrz=oldR.vz;

	CamVars.camera.vpx=oldP.vx;
	CamVars.camera.vpy=oldP.vy;
	CamVars.camera.vpz=oldP.vz;


	
	puzzleCheckPuzzles();

	lscapeDrawAll(pWld);// draw world last, so sky can't flick out ...

	if(pSky)   	lscapeDraw(pSky,0);

	//Draw_All_Effects();
	platformDrawDynamicBoxes();
	waterDraw();

}
/*****************************************************************************************************/
BFF_Header *Menu_Bff;

void menuLoadMenuData()
{
	overlayClearAll();
	ClearAllText();
  
	spin_pBank=textureLoadBank("GFX\\MENU.SPT");
	ASSERT(spin_pBank);
	textureDownloadBank(spin_pBank);
	textureDestroyBank(spin_pBank);

	//pTitBank=textureLoadBank("WORLDS\\FRONTEND\\FRONTEND.SPT");

  	pHubBank=textureLoadBank("WORLDS\\HUB\\HUB8\\HUB8.SPT");
	

	textureDownloadBank(pHubBank);
	textureDestroyBank(pHubBank);

	Menu_Bff = BFF_LoadFile("WORLDS\\GENERIC\\MENU.BFF");
	
	

	pLosenge   = BFF_IsModelLoaded("LOSENGE", NULL);
	p3DLetters = BFF_IsModelLoaded("FINALLOG", NULL);
	objectSetupSegmentSort(p3DLetters);
	objectSetupSegmentSort(pLosenge);

	{
		BFF_WorldHeader *head;
		head = (void *)BFF_FindNamedObject(BFF_WLD_ID, "WORLD");
		if(head)
		{
			pWld = &head->world;
		}
	}

	pSky = BFF_IsModelLoaded("SKY", NULL);

	//this is in generic.bff so make sure it is loaded
	fadeStar = BFF_IsModelLoaded("FADESTAR", NULL);	

	ASSERT(fadeStar);
	objectSetupSegmentSort(fadeStar);

	SETRGBC(clscol.r, 128,255,255, GPU_COM_F4);

	SETRGBC(lscapeFogColour.r, 0,128,0, GPU_COM_F4);
	lscapeFogStartZ = 10000;
	lscapeFogEndZ	= 10200;
	lscapeFogFlatZ	= 10400;



	GsSetProjection(projection);	//default distance of projection; alters perspective
	SetGeomOffset(0,0);	// the video player corrupts this
}

void menuDitchMenuData()
{
	overlayClearAll();
	ClearAllText();

	textureDestroyBank(spin_pBank);
	textureUnloadBank(spin_pBank);

   //	textureDestroyBank(pTitBank);
  //	textureUnloadBank(pTitBank);

	textureDestroyBank(pHubBank);
	textureUnloadBank(pHubBank);

// still needed, to free the segment sorts. The actual shape-free will attempt to free an un-mallocced space, & will just return
	//objectFree(pLosenge, NULL);
	//objectFree(p3DLetters, NULL);

	BFF_ReleaseFile(Menu_Bff);

}
/*****************************************************************************************************/
void menuGetUpDown(int *menuLit, int lim)
{
	static int buttonTimer=0;

	if(nlefty[0]==0)
			buttonTimer=TIMELIMIT;

	if(buttonTimer>TIMELIMIT)
	{// move pointer
		if(nlefty[0]>3000)
		{
			(*menuLit)++;
			if((*menuLit)==lim)
				(*menuLit)--;
			else
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);

			buttonTimer=0;
		}

		if((nlefty[0]<3000) && ((*menuLit)>0))
		{
			(*menuLit)--;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			buttonTimer=0;
		}
	}

	buttonTimer++;
}

void menuGetLeftRight(int *menuLit, int lim)
{
	static int buttonTimer=0;

	if(nleftx[0]==0)
			buttonTimer=TIMELIMIT;

	if(buttonTimer>TIMELIMIT)
	{// move pointer
		if(nleftx[0]>3000)
		{
			(*menuLit)++;
			if((*menuLit)==lim)
				(*menuLit)--;
			else
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			buttonTimer=0;
		}

		if((nleftx[0]<-3000) && ((*menuLit)>0))
		{
			(*menuLit)--;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			buttonTimer=0;
		}
	}

	buttonTimer++;
}

/*****************************************************************************************************/

//char fn[32];
#ifdef MULTI_LANGUAGE
#define N_LANGUAGES 4
#else
#define N_LANGUAGES 3
#endif

void menuShowScreen(char *name)
{
	ULONG *pTim;

	STRCPY(message, "TIMOTHY\\");
	strcat(message, name);

	pTim=(ULONG *)fileLoad(message,0);
	uploadTimToVRAM(pTim);
	FREE(pTim);

	VSync(0);
	ShowScreen(1);
}


OVERLAY glovLogo,controlPic,flagPic[N_LANGUAGES],leftArrow,rightArrow;

OVERLAY	note,horn,slider[3];

TEXT *spin_pText;
//------------------------------------------------------------------
//
//------------------------------------------------------------------
void menuSpinHubInit(char *loadscnname)
{
 //	int i;
/*
	if(!loadscnname)
		loadscnname = "GLOVLOAD.TIM";
	menuShowScreen(loadscnname);
*/
	if(loadscnname)
	{
		menuShowScreen(loadscnname);
	}

	interrupt_cyclebar = 1;
	ClearAllText();

	menuLoadMenuData();

	overlayInitialiseList();

	overlaySetupAndAdd(&glovLogo,		textureFindInBank(spin_pBank, "GLOVLOGO"),		256,48,4, 0);

	DB("glovLogo.texture = %p\n", glovLogo.texture);
	ASSERT(glovLogo.texture);
	//CRASH;

	overlaySetupAndAdd( &controlPic,		textureFindInBank(spin_pBank, "CONTROL"),256,128,5, 0);
	DB("controlPic.texture = %p\n", controlPic.texture);
	ASSERT(controlPic.texture);
	controlPic.active=0;

	
	overlaySetupAndAdd( &flagPic[0],textureFindInBank(spin_pBank, "FLAG1"),256,70,5, 0);
	ASSERT(flagPic[0].texture);
	flagPic[0].active=0;
	overlaySetupAndAdd( &flagPic[1],textureFindInBank(spin_pBank, "FLAG2"),256,70,5, 0);
	ASSERT(flagPic[1].texture);
	flagPic[1].active=0;
	overlaySetupAndAdd( &flagPic[2],textureFindInBank(spin_pBank, "FLAG3"),256,70,5, 0);
	ASSERT(flagPic[2].texture);
	flagPic[2].active=0;
#ifdef MULTI_LANGUAGE
	overlaySetupAndAdd( &flagPic[3],textureFindInBank(spin_pBank, "FLAG4"),256,70,5, 0);
	ASSERT(flagPic[3].texture);
	flagPic[3].active=0;
#endif

	overlaySetupAndAdd( &leftArrow,textureFindInBank(spin_pBank, "ARROWL"),95,56,5, 0);
	ASSERT(leftArrow.texture);
	leftArrow.active=0;

	overlaySetupAndAdd( &rightArrow,textureFindInBank(spin_pBank, "ARROW"),410,56,5, 0);
	ASSERT(rightArrow.texture);
	rightArrow.active=0;


#if PALMODE == NO
	rightArrow.yPos=leftArrow.yPos=64;
#endif

	//overlaySetupAndAdd(&o,		textureFindInBank(pTitBank, "NOTE0002"),			240,40,0, 0);
	overlaySetupAndAdd(&horn, NULL, 0,0, 0, 0);// I have got the faaaarrkin horn
	overlayFindFrames(&horn, "HORN00");
	horn.active=0;

	overlaySetupAndAdd(&note, NULL, 0,0, 0, 0);
	overlayFindFrames(&note, "NOTE00");
	note.active=0;

	//overlaySetupAndAdd(&slider,	textureFindInBank(pTitBank, "SLIDER"),		32,32,0, 0);
	overlaySetupAndAdd(&slider[0],	textureFindInAllBanks("HITBARB"),		32,32,0, 0);
	overlaySetupAndAdd(&slider[1],	textureFindInAllBanks("HITBARO"),		32,32,0, 0);
	overlaySetupAndAdd(&slider[2],	textureFindInAllBanks("HITBARR"),		32,32,0, 0);
	slider[0].active=slider[1].active=slider[2].active=0;
	

	XA_SetMusicGoing(TRACK_MAINMENU,1);
	SETRGBC(clscol.r,128,255,255,GPU_COM_F4);

	// look at 0,0,0
	ZEROVECTOR((VECTOR *)&menuCam.vrx);
	ZEROVECTOR((VECTOR *)&menuCam.vpx);
	menuCam.vry=menuCam.vpy=-512;

	ZEROVECTOR((VECTOR *)&backCam.vrx);
	ZEROVECTOR((VECTOR *)&backCam.vpx);
	backCam.vry=backCam.vpy=-512;

	interrupt_cyclebar = 0;

	modelctrl.subdivflag=FALSE;
	SETSUBDIVDEPTH(-16000);


}
//------------------------------------------------------------------
//
//------------------------------------------------------------------
void menuSpinHubLeave()
{
	overlaySub(&horn);
	overlaySub(&note);
	overlaySub(&slider[0]);
	overlaySub(&slider[1]);
	overlaySub(&slider[2]);
	overlaySub(&glovLogo);
	overlaySub(&controlPic);
	overlaySub(&rightArrow);
	overlaySub(&leftArrow);

	ClearAllText();
	menuDitchMenuData();
//	SFXShutDown();	// the world music bank isn't loaded in the menu anyway
	SETSUBDIVDEPTH(SUBDIVISIONDEPTH);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

enum
{
	TD_FINISHED,

	TD_SPIN1,	// thing_doing loops round to 1, not zero
	TD_SPLASH0,
	TD_SPLASH1,
	TD_PLAY1,

	TD_SPIN2,
	TD_SPLASH2,
	TD_SPLASH3,
	TD_VID1,
	TD_PLAY2,

	TD_SPIN3,
	TD_SPLASH4,
	TD_SPLASH5,
	TD_PLAY3,

	TD_SPIN4,
	TD_SPLASH6,
	TD_SPLASH7,
	TD_VID2,
	TD_PLAY4,

	TD_SPIN5,
	TD_SPLASH8,
	TD_SPLASH9,
	TD_PLAY5,

	TD_SPIN6,
	TD_SPLASH10,
	TD_SPLASH11,
	TD_VID3,

	TD_N_THINGS
};

#define SPIN_TIME 400
#define SPLASH_TIME_SMALL  150
#define SPLASH_TIME_MEDIUM 280
#define SPLASH_TIME_LONG   400

//------------------------------------------------------------------
//
//------------------------------------------------------------------
void menuPlayKeyDemo(char *s, int lev, int time)
{
	int seed;

	menuSpinHubLeave();

	spriteReset();
	ClearAllText();

	gameCtrl.previousLevel = TITLE;
	gameInfo.keyRecordFlag=NULL;

	STRCPY(gameInfo.sKeyDemo, "DEMOS\\");
	strcat(gameInfo.sKeyDemo, s);

#if RECORDKEYS==YES
	{
		UBYTE *temp;
		temp = fileLoad(gameInfo.sKeyDemo,0);
		memcpy(&keyRecord[0],temp,32768);
		FREE(temp);
	}
#else
	keyRecord=(USHORT*)fileLoad(gameInfo.sKeyDemo,0);
#endif
	keyRecordCount=0;

	level=lev;
	gameInfo.keyRecordFlag=PLAYBACK;
	gameInfo.keyTime=time;
	cardInitialGameState();



	seed=GetRandomSeed();
	SetRandomSeed(123);

	gameMainGame(lev);

	SetRandomSeed(seed);
#if RECORDKEYS==NO
	FREE( (UBYTE*)keyRecord );
#endif

	menuSpinHubInit(NULL);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void GameSequence(int cLevel)
{
	menuSpinHubLeave();

	spriteReset();
	ClearAllText();
//	menuShowScreen("GLOVLOAD.TIM");
#if RECORDKEYS==YES
	gameInfo.keyRecordFlag=RECORD;
	SetRandomSeed(123);
#else
	gameInfo.keyRecordFlag=NULL;
#endif

	level=cLevel;
	noHintText=0;

	gameMainGame(cLevel);

	

  	while( (gameCtrl.dropOutFlag==GAME_COMPLETED || gameCtrl.dropOutFlag==GAME_BACKTOCASTLE || gameCtrl.dropOutFlag==GAME_FAILEDBONUS) && gameCtrl.nextLevel != TITLE)
	{
//		menuShowScreen("GLOVLOAD.TIM");
		level=gameCtrl.nextLevel;
		gameMainGame(level);

	}

	if(gameCtrl.dropOutFlag==GAME_COMPLETED && level != HUB8)
	{

		if (dovideo==YES)newvideo("OUTRO.STR",OUTRO_VIDEO_LEN);

		menuSpinHubInit(NULL);	//"FINISHED.TIM");

		ShowCredits();
		GameOverScreen(gameScore);
	}
	else
	{
		menuSpinHubInit(NULL);
		GameOverScreen(gameScore);
	}
}

////////////////////////////////////////////////////////////////////////////////
#ifdef MULTI_LANGUAGE
unsigned short mainMenuIds[] =
{
	STR_START,
	STR_OPTIONS,
	STR_HISCORES
};
unsigned short startOptionsIds[] =
{
	STR_NG_NEWGAME,
	STR_NG_LOADGAME
};

unsigned short statsOptionsIds[] =
{
	STR_SAVE,
	STR_CONTINUE
};

unsigned short optionScreenIds[] =
{
	STR_SOUND,
	STR_CONTROLS,
	STR_CENTER,
	STR_LANGUAGE,
	STR_INTRO,
	STR_VIBRATION,	// nb - enough space in the string for "off" to be poked in
	STR_CHEATS
};

#else

char *mainMenuText[] =						                          	                                                
{												                          	                                                
	"START\0",
  //	"LEVEL SELECT\0",
    "OPTIONS\0",
    "HI SCORES\0"
};
char *startOptions[] =
{
	"NEW GAME\0",
	"LOAD GAME\0"
};
char *statsOptions[] =
{
	"SAVE\0",
	"CONTINUE\0"
};

char *optionScreen[] =
{
//	"DIFFICULTY\0",
	"SOUND OPTIONS\0",
	"CONTROLS\0",
	"CENTER SCREEN\0",
#ifdef MULTI_LANGUAGE
	"LANGUAGE\0",
#endif
	"SHOW INTRO\0",
	"VIBRATION ON \0",	// nb - enough space in the string for "off" to be poked in
//	"EXTRAS\0",
	"CHEATS MENU\0",
};
#endif



enum
{
	OPTION_DIFFICULTY,
	OPTION_SOUND,
	OPTION_CONTROLS,
	OPTION_SCREEN,
#ifdef MULTI_LANGUAGE
	OPTION_LANGUAGE,
#endif
	OPTION_INTRO,
	OPTION_SHOCK,
	OPTION_CHEATS

};

char *difficulty[] =    //still needed????
{
	"EASY\0",
	"MEDIUM\0",
	"HARD\0"
};


char *difficultyHint[] =	//still needed???
{												                          	                                                
	"LOADS OF HEALTH AND LIVES\0",
	"A BIT MORE DIFFICULT\0",
	"VERY VERY DIFFICULT\0"
};

#ifdef MULTI_LANGUAGE
unsigned short menuInfoTextIds[] =
{
	STR_BUT_SEL		,
	STR_BUT_SELCANCEL,
	STR_BUT_PLAYCANCEL,
	STR_BUT_CANCEL,
	STR_BUT_PLAYCANCEL2,
	STR_HI_CONTINUE
};
#else
char *menuInfoText[] =
{
	"% SELECT\0",
	"% SELECT    $ CANCEL\0",
	"% PLAY      $ CANCEL\0",
	"$ CANCEL\0",
	"% PLAY    $ CANCEL\0",
	"% CONTINUE\0",
};
#endif

#define	MAIN		0
#define	START		1
#define	TIMETRIAL	2
#define	OPTIONS		3

#define	DIFFICULTY	4
#define	SOUND		5
#define	CONTROLS	6
#define	LANGUAGE	7
#define HISCORES	8

MENUCTRL	menuCtrl;

long	selectionNum[]=
{
	3,		// main menu
	2,		// start menu
	0,		// Time trial
	6,		// options
	3		// difficulty
};


int infoTextScale=4096;

long	upDown,debouncePad,debounceCount;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
#define UpDownReset() {debouncePad = 0;debounceCount = 0;}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
int UpDownCycle(int selection, int max)
{
	upDown=-(nlefty[0]);
	if(!fadeout)
	{
		if (upDown<0)
		{
			if (debouncePad<0)
			{
				if (debounceCount)
				{
					upDown=0;
					debounceCount--;
				}
			}
			else
			{
				debouncePad=0;
				debounceCount=0;
			}
		}
		else if (upDown>0)
		{
			if (debouncePad>0)
			{
				if (debounceCount)
				{
					upDown=0;
					debounceCount--;
				}
			}
			else
			{
				debouncePad=0;
				debounceCount=0;
			}
		}
		else
		{
			debouncePad=0;
			debounceCount=0;
		}

		if (upDown>1024)
		{
			debouncePad=upDown;
			debounceCount=6;
			if (selection==0) selection=max-1;
			else selection--;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
		}
		if (upDown<-1024)
		{
			debouncePad=upDown;
			debounceCount=6;
			selection++;
			if (selection==max) selection=0;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
		}
	}
	return selection;
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void	newFrontEnd(void)
{
long loop,a,i;
long	counter=0;
long	selection=0;
long	doing=MAIN;
int		cLevel=0;
UBYTE	textInList,doingDemo=FALSE;
TEXT	*pText[8],*infoText=NULL,*hintText[3];

int textPosX,menuFrame=0,lastInput=0;

	CDctrl.Volume=64;
	CDSETVOLUME(&CDctrl.sAttenuationVol,CDctrl.Volume);

	UpDownReset();

	textReset();				// Setup font scale ect
	messctrl.font=fontList[1];

	spriteReset();
	sprctrl.stretch=1;

	sprctrl.scalex=4096;//2048;
	sprctrl.scaley=4096;//2048;

	textInList=FALSE;

	MenuFadeIn();

#ifdef MULTI_LANGUAGE
		languageScreen(0);
#endif

#ifndef MULTI_LANGUAGE
	if(!cheatMenuOn)
		selectionNum[3]=5;
	else
		selectionNum[3]=6;
#else
	if(!cheatMenuOn)
		selectionNum[3]=6;
	else
		selectionNum[3]=7;
#endif

	for (;;)
	{
		
		a=(rsin(counter*32)+4096)>>5;
		if(a>255)
		a=255;



		counter++;

		SETRGBC(sprctrl.r,128,128,128,0);

		selection = UpDownCycle(selection,selectionNum[doing]);



#ifdef MULTI_LANGUAGE
		switch(doing)
		{
			case OPTIONS:
				if(dualShockOn)
				{
					sprintf(pText[OPTION_SHOCK-1]->message,"%s %s",
						fontFindLangString(STR_VIBRATION),
						fontFindLangString(STR_ON));
				}
				else
				{
					sprintf(pText[OPTION_SHOCK-1]->message,"%s %s",
						fontFindLangString(STR_VIBRATION),
						fontFindLangString(STR_OFF));
				}
//				textInList=TRUE;
				break;
		}
#endif



		if ((debounce[0]&PAD_CROSS)||((fadeout)&&(doingDemo==0)))
		{

			if(debounce[0]&PAD_CROSS)
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
				DB(">>> Memory state in the menu <<<\n");
				memoryShowStats();
				texturePrintStatus();
			}


			lastInput=menuFrame;

			if((!fadeout)&&(!((doing==OPTIONS)&&(selection==OPTION_SHOCK-1))) )
			{
				ClearAllText();
				textInList=FALSE;
			}

			switch (doing)
			{
				case MAIN:
					
					switch (selection)
					{
						case 0:	// Start
							doing=START;
							//selection=0;
							break;
					   /*	case 1:	// Time Trial
							doing=TIMETRIAL;
							break; */
						case 1: // Options
							doing=OPTIONS;
							break;
						case 2:	// hi scores
							//doing=HISCORES;
							hiScoreScreen();
							textInList=FALSE;
							doing=MAIN;
	  							
							break;
					}
					break;
				case START:
					switch (selection)
					{
						case 0:	// start game

							// Quick way of flagging to the game that it needs to reset stuff
							gameCtrl.previousLevel = TITLE;
							
							if(!fadeout)
								{
								MenuFadeOut();
								}
							
							if((fadeout)&&(fader>1))
								break;

							cardInitialGameState();
							cLevel = HUB1;//menuLevelSelect();

							GameSequence(cLevel);

							textInList=FALSE;

							textReset();				// Setup font scale ect
							messctrl.font=fontList[1];
							spriteReset();
							sprctrl.stretch=1;
					
							sprctrl.scalex=4096;//2048;
							sprctrl.scaley=4096;//2048;
							doing=MAIN;

							level=TITLE;

#ifndef MULTI_LANGUAGE
							if(!cheatMenuOn)
								selectionNum[3]=5;
							else
								selectionNum[3]=6;
#else
							if(!cheatMenuOn)
								selectionNum[3]=6;
							else
								selectionNum[3]=7;
#endif

							MenuFadeIn();
							break;

						case 1:	// Load Game
							if(!MemCardControl(MEMCARD_LOAD))
							{
								break;
								cardInitialGameState();
							}

//							if(!fadeout)
//							{
								selection = 0;
								cLevel= gameCtrl.hub_to_use;//menuLevelSelect();
							gameCtrl.previousLevel = TITLE;

//								MenuFadeOut();
//							}
//							if((fadeout)&&(fader>1))
//								break;

							GameSequence(cLevel);

							textInList=FALSE;

							textReset();				// Setup font scale ect
							messctrl.font=fontList[1];
							spriteReset();
							sprctrl.stretch=1;

							sprctrl.scalex=4096;//2048;
							sprctrl.scaley=4096;//2048;
							doing=MAIN;
#ifndef MULTI_LANGUAGE
							if(!cheatMenuOn)
								selectionNum[3]=5;
							else
								selectionNum[3]=6;
#else
							if(!cheatMenuOn)
								selectionNum[3]=6;
							else
								selectionNum[3]=7;
#endif

							MenuFadeIn();
							break;
					}
				case TIMETRIAL:								//SHOULD THIS BE REMOVED NOW?
					// put time trial select screen here
					break;

				case DIFFICULTY:							//SHOULD THIS BE REMOVED NOW?
					menuCtrl.difficulty=selection;
					selection=0;
					doing=OPTIONS;
					break;

				

				case OPTIONS:
					switch(selection+1)
					{
						case 0:	// difficulty				//SHOULD THIS BE REMOVED NOW?
							doing=DIFFICULTY;
							break;

						case OPTION_SOUND:	// sound
							
							soundSetup();
							break;

						case OPTION_CONTROLS:	// controls
							controlsScreen();
							break;

						case OPTION_SCREEN:	// center screen
							centerScreen();
							break;
#ifdef MULTI_LANGUAGE
						case OPTION_LANGUAGE:	// Language
							languageScreen(1);
							break;
#endif


						case OPTION_INTRO:	// Show Intro
							
							if (dovideo==YES)
							{
								menuSpinHubLeave();
								newvideo("GLOVER.STR",INT_VIDEO_LEN);	//1354);
								menuSpinHubInit(NULL);
							}
							break;



#ifdef MULTI_LANGUAGE
						case OPTION_SHOCK:	// dual shock
							if(dualShockOn)
							{
								dualShockOn=FALSE;
							}
							else
							{
								dualShockOn=TRUE;
							}
							textInList=TRUE;
							break;
#endif

#ifndef MULTI_LANGUAGE
						case OPTION_SHOCK:	// dual shock
							if(dualShockOn)
							{
								dualShockOn=FALSE;
								optionScreen[OPTION_SHOCK-1][11]='F';
								optionScreen[OPTION_SHOCK-1][12]='F';
								optionScreen[OPTION_SHOCK-1][13]=0;
								strcpy(pText[selection]->message,optionScreen[OPTION_SHOCK-1]);
							}
							else
							{
								dualShockOn=TRUE;

								optionScreen[OPTION_SHOCK-1][11]='N';
								optionScreen[OPTION_SHOCK-1][12]=0;
								strcpy(pText[selection]->message,optionScreen[OPTION_SHOCK-1]);
							}
							textInList=TRUE;
							break;
#endif
						case OPTION_CHEATS:	// cheat menu
								CheatMenu();
								
								textInList=FALSE;
							break;
					}
			}

			if((!fadeout)&&(!((doing==OPTIONS)&&(selection==OPTION_SHOCK-1))) )
				selection=0;
		}
		

		if((!fadeout)&&(debounce[0]&PAD_TRIANGLE)&&(doing!=MAIN))
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);

			lastInput=menuFrame;

			ClearAllText();
			textInList=FALSE;
			switch(doing)
			{
				case MAIN:
					break;
				case START:
				case TIMETRIAL:
				case OPTIONS:
					doing=MAIN;
					break;
				case DIFFICULTY:
					doing=OPTIONS;
					break;
			}
			selection=0;
		}

	
		glovLogo.xPos=256;glovLogo.yPos=64-8*PALMODE;	

#if PALMODE==YES
		glovLogo.scaleY=4096;
#else
		glovLogo.scaleY=3072;
#endif
		for (loop=0;loop<selectionNum[doing];loop++)
		{
			if (textInList)
			{
				if (loop==selection)
				{
#ifdef MULTI_LANGUAGE
	if(doing==OPTIONS && language==2 && loop == 2)
	{
		pText[loop]->scaleX = 3000;
	}
#endif

					pText[loop]->font=fontList[0];
					SETRGBC(pText[loop]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
					SETRGBC(pText[loop]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
					pText[loop]->flags|=TEXT_ANIMATED;
					
					if(doing==DIFFICULTY)
						{
						SETRGBC(hintText[loop]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
						SETRGBC(hintText[loop]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);

						}
				}
				else
				{
#ifdef MULTI_LANGUAGE
	if(doing==OPTIONS && language==2 && loop == 2)
	{
		pText[loop]->scaleX = 4096;
	}
#endif
					pText[loop]->flags&=-1-TEXT_ANIMATED;
					pText[loop]->font=fontList[1];
					SETRGBC(pText[loop]->r,128,128,0,FULLALPHA);
					SETRGBC(pText[loop]->r1,128,40,8,FULLALPHA);
					if(doing==DIFFICULTY)
						{
						SETRGBC(hintText[loop]->r,128,128,0,FULLALPHA);
						SETRGBC(hintText[loop]->r1,128,40,8,FULLALPHA);
						}
				}
			}
	
			switch (doing)
			{
				case MAIN:

					if (!textInList)
					{
						textPosX=256;
#ifdef MULTI_LANGUAGE
						NEW_TEXT(textPosX, 170+(loop*20)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, fontFindLangString(mainMenuIds[loop]), TRUE);
#else
						NEW_TEXT(textPosX, 170+(loop*20)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, mainMenuText[loop], TRUE);
#endif
						pText[loop]=mtext;
						mtext->flags=TEXT_SHADED;
						SETRGBC(mtext->r1,128,40,8,FULLALPHA);

						if(loop==0)
						{
#ifdef MULTI_LANGUAGE
							NEW_TEXT(256, 220, 128,128,128,255, infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[0]), TRUE);
#else
							NEW_TEXT(256, 220, 128,128,128,255, infoTextScale,infoTextScale, TRUE, menuInfoText[0], TRUE);
#endif
							infoText=mtext;
							mtext->flags=TEXT_SHADED;
							mtext->font=fontList[2];
							SETRGBC(mtext->r1,0,0,0,FULLALPHA);
						}
					}
#ifdef MULTI_LANGUAGE
					sprintf(infoText->message,"%s",fontFindLangString(menuInfoTextIds[0]));
#else
					sprintf(infoText->message,"%s",menuInfoText[0]);
#endif
					break;
				case START:
					if (!textInList)
					{
#ifdef MULTI_LANGUAGE
						NEW_TEXT(256, 160+(loop*25)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, fontFindLangString(startOptionsIds[loop]), TRUE);
#else
						NEW_TEXT(256, 160+(loop*25)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, startOptions[loop], TRUE);
#endif
						pText[loop]=mtext;
						mtext->flags=TEXT_SHADED;
						SETRGBC(mtext->r1,128,40,8,FULLALPHA);
						
						if(loop==0)
						{
#ifdef MULTI_LANGUAGE
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
							infoText=mtext;
							mtext->flags=TEXT_SHADED;
							mtext->font=fontList[2];
							SETRGBC(mtext->r1,0,0,0,FULLALPHA);
						}
					}
#ifdef MULTI_LANGUAGE
					sprintf(infoText->message,"%s",fontFindLangString(menuInfoTextIds[1]));
#else
					sprintf(infoText->message,"%s",menuInfoText[1]);
#endif
					
					break;
				case OPTIONS:
					if (!textInList)
					{
#ifdef MULTI_LANGUAGE
						NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_OPTIONS), TRUE);
#else
						NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "OPTIONS", TRUE);
#endif
						mtext->flags=TEXT_SHADED;
						mtext->font=fontList[0];
						SETRGBC(mtext->r, 128,128,0,FULLALPHA);
						SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

#ifdef MULTI_LANGUAGE
						NEW_TEXT(256, 140+(loop*20)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, fontFindLangString(optionScreenIds[loop]), TRUE);
#else
						NEW_TEXT(256, 140+(loop*20)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, optionScreen[loop], TRUE);
#endif
						pText[loop]=mtext;
						mtext->flags=TEXT_SHADED;
						SETRGBC(mtext->r1,128,40,8,FULLALPHA);

						if(loop==0)
						{
#ifdef MULTI_LANGUAGE
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
							infoText=mtext;
							mtext->flags=TEXT_SHADED;
							mtext->font=fontList[2];
							SETRGBC(mtext->r1,0,0,0,FULLALPHA);
						}
					}
#ifdef MULTI_LANGUAGE
					sprintf(infoText->message,"%s",fontFindLangString(menuInfoTextIds[1]));
#else
					sprintf(infoText->message,"%s",menuInfoText[1]);
#endif
					
					break;
				case DIFFICULTY:
					if (!textInList)
					{
						NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "DIFFICULTY", TRUE);
						mtext->flags=TEXT_SHADED;
						mtext->font=fontList[0];
						SETRGBC(mtext->r, 128,128,0,FULLALPHA);
						SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

						NEW_TEXT(256, 100+(loop*50)-(selectionNum[doing]*10), 128,128,0,255, 4096,4096, TRUE, difficulty[loop], TRUE);
						pText[loop]=mtext;
						mtext->flags=TEXT_SHADED;
						SETRGBC(mtext->r1,128,40,8,FULLALPHA);

						NEW_TEXT(256, 120+(loop*50)-(selectionNum[doing]*10), 128,128,0,255, infoTextScale,infoTextScale, TRUE, difficultyHint[loop], TRUE);
						hintText[loop]=mtext;
						mtext->flags=TEXT_SHADED;
						mtext->font=fontList[2];
						SETRGBC(mtext->r1,128,40,8,FULLALPHA);
						if(loop==0)
						{
#ifdef MULTI_LANGUAGE
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
							NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
							infoText=mtext;
							mtext->flags=TEXT_SHADED;
							mtext->font=fontList[2];
							SETRGBC(mtext->r1,0,0,0,FULLALPHA);
						}
					}
#ifdef MULTI_LANGUAGE
					sprintf(infoText->message,"%s",fontFindLangString(menuInfoTextIds[1]));
#else
					sprintf(infoText->message,"%s",menuInfoText[1]);
#endif
					
					break;
			}
		}
		textInList=TRUE;


		//timetrial is now level select
		switch(doing)
		{
			case TIMETRIAL:
				timeTrialScreen();
				textInList=FALSE;
				doing=MAIN;
				
				break;
		}

#if RECORDKEYS==YES
		if(((menuFrame-lastInput)>100)&&(!doingDemo))
#else
		if(((menuFrame-lastInput)>550)&&(!doingDemo))
//		if(((menuFrame-lastInput)>100)&&(!doingDemo))
#endif
		{
			doingDemo=TRUE;
			MenuFadeOut();
		}

		if((doingDemo)&&(fader<=1))
		{
			static int i = 0;
			
			ClearAllText();
			
#if RECORDKEYS==YES
			menuPlayKeyDemo("RECORD.DEM", HUB1, 16000);	// replay the game you just recorded
//			menuPlayKeyDemo("RECORD.DEM", ATLANTIS1, 16000);	// replay the game you just recorded
#else
			i = (i+1) % 4;

			switch(i)
			{
				case 0:
					menuPlayKeyDemo("STEPS.DEM", HUB1, 710);
					break;
				case 1:
					menuPlayKeyDemo("CHICKEN.DEM", HUB1, 752);
					break;

				case 2:
					menuPlayKeyDemo("BALLWALK.DEM", HUB1, 726);
					break;
// Rats, now this one's breaking the second lap of things, too
//				case 3:
//					menuPlayKeyDemo("BRIDGE.DEM", HUB1, 1220);
//					break;
// The AT demo is breaking things at the moment
//				case 4:
//					menuPlayKeyDemo("ATDEMO1.DEM", ATLANTIS1, 880);
//					break;


				default:
					if (dovideo==YES)
					{
						menuSpinHubLeave();
						newvideo("GLOVER.STR",INT_VIDEO_LEN);	//1354);
						menuSpinHubInit(NULL);
					}
					break;
			}
#endif
			lastInput=menuFrame;
			textInList=FALSE;
			doingDemo=FALSE;
			level=TITLE;
			MenuFadeIn();
		}

		Start_Loop();

		menuPrintBack(zoom);	// zoom = 1024
	
		MenuDrawFade();

		ShowText();
		
		if((doing==MAIN)||(doing==START))
			{
			overlayPrintAll();

			}

		menuFrame++;
		End_Loop(0);
	}

	printf("?????????????????????????????????????????????????????????????????????????\n");
	VSync(0);
	CRASH;
}
////////////////////////////////////////////////////////////////////////////////
void	soundSetup(void)
{
long	loop,upDown,debouncePad,debounceCount,temp,temp1;
long	selection=0,oldVolume;
long	leftRight;
TEXT	*pText[8];
int menuFrame=0;
int xoffset=140;

	horn.xPos=80;
	horn.yPos=141;
	note.xPos=80;
	note.yPos=93;

	//volume
	debounce[0]=0;
	debounceCount = 0;
	debouncePad = 0;

	oldVolume=menuCtrl.soundVol=volume;	// 0 128
	menuCtrl.musicVol=CDctrl.Volume; // 0 128 ?

	ClearAllText();
	messctrl.font=fontList[1];

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_SOUNDTITLE), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "SOUND CONTROL", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	pText[0]=mtext;
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);


#ifdef MULTI_LANGUAGE

	#if PALMODE == YES
		NEW_TEXT(256, 93, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_MUSICVOL), TRUE);
	#else
		NEW_TEXT(256, 88, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_MUSICVOL), TRUE);
	#endif

		pText[1]=mtext;
		mtext->flags=TEXT_SHADED;
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);

	#if PALMODE == YES
		NEW_TEXT(256, 141, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_EFFECTSVOL), TRUE);
	#else
   		NEW_TEXT(256, 136, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_EFFECTSVOL), TRUE);
	#endif

#else

	#if PALMODE == YES
		NEW_TEXT(256, 93, 128,128,0,255, 4096,4096, TRUE, "MUSIC VOL", TRUE);
	#else
		NEW_TEXT(256, 88, 128,128,0,255, 4096,4096, TRUE, "MUSIC VOL", TRUE);
	#endif

		pText[1]=mtext;
		mtext->flags=TEXT_SHADED;
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);

	#if PALMODE == YES
		NEW_TEXT(256, 141, 128,128,0,255, 4096,4096, TRUE, "EFFECTS VOL", TRUE);
	#else
   		NEW_TEXT(256, 136, 128,128,0,255, 4096,4096, TRUE, "EFFECTS VOL", TRUE);
	#endif

#endif
	pText[2]=mtext;
	mtext->flags=TEXT_SHADED;
	SETRGBC(mtext->r1,128,40,8,FULLALPHA);

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	for (;;)
	{
		ShowText();
		upDown=-(nlefty[0]);
		leftRight=(nleftx[0]);
		if (upDown<0)
		{
			if (debouncePad<0)
			{
				if (debounceCount)
				{
					upDown=0;
					debounceCount--;
				}
			}
			else
			{
				debouncePad=0;
				debounceCount=0;
			}
		}
		else if (upDown>0)
		{
			if (debouncePad>0)
			{
				if (debounceCount)
				{
					upDown=0;
					debounceCount--;
				}
			}
			else
			{
				debouncePad=0;
				debounceCount=0;
			}
		}
		else
		{
			debouncePad=0;
			debounceCount=0;
		}

		if (upDown>1024)
		{
			debouncePad=upDown;
			debounceCount=6;
			if (selection==0) selection=1;
			else selection--;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
		}
		if (upDown<-1024)
		{
			debouncePad=upDown;
			debounceCount=6;
			selection++;
			if (selection==2) selection=0;
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);

		}

		if (debounce[0]&PAD_CROSS)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			volume=sfxvolume=menuCtrl.soundVol;
			CDctrl.Volume=menuCtrl.musicVol;
			CDSETVOLUME(&CDctrl.sAttenuationVol,CDctrl.Volume);
			ClearAllText();
			return;
		}

		if (debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			volume=sfxvolume=oldVolume;
			ClearAllText();
			CDSETVOLUME(&CDctrl.sAttenuationVol,CDctrl.Volume);
			return;
		}

		Start_Loop();

		sprctrl.scalex=4096;//2048;
		sprctrl.scaley=4096;//2048;

		if (selection==0)
		{
			pText[1]->flags|=TEXT_ANIMATED;
			pText[1]->font=fontList[0];
			SETRGBC(pText[1]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
			SETRGBC(pText[1]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);

		}
		else
		{
			pText[1]->flags&=-1-TEXT_ANIMATED;
			pText[1]->font=fontList[1];
			SETRGBC(pText[1]->r,128,128,0,FULLALPHA);
			SETRGBC(pText[1]->r1,128,40,8,FULLALPHA);
		}


		if (selection==1)
		{
			pText[2]->flags|=TEXT_ANIMATED;
			pText[2]->font=fontList[0];
			SETRGBC(pText[2]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
			SETRGBC(pText[2]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
				
		}
		else
		{
			pText[2]->flags&=-1-TEXT_ANIMATED;
			pText[2]->font=fontList[1];
			SETRGBC(pText[2]->r,128,128,0,FULLALPHA);
			SETRGBC(pText[2]->r1,128,40,8,FULLALPHA);
		}


		menuPrintBack(zoom);	// zoom = 1024

		overlayPrint(&horn);
		overlayPrint(&note);

		if (selection==1){SETRGBC(slider[0].r,1,1,128,FULLALPHA);}
		else 		   	 {SETRGBC(slider[0].r,128,128,128,FULLALPHA);}

		slider[1].yPos=113;

		temp=menuCtrl.musicVol/16;
		temp1=8-temp;

		for (loop=0;loop<temp;loop++)
		{
			slider[1].xPos=xoffset+(loop*32);
			overlayPrint(&slider[1]);
		}

		DrawBox(-(256-(xoffset-17)),-(128-84)+25,260,10,0,0,0,0,4);

		DrawBox(-(256-(xoffset-17)),-(128-132)+25,260,10,0,0,0,0,4);

		slider[0].yPos=113;
		for (loop=temp;loop<8;loop++)
		{
			slider[0].xPos=xoffset+(loop*32);
			overlayPrint(&slider[0]);
		}
		

		if (selection==0){SETRGBC(slider[0].r,1,1,128,FULLALPHA);}
		else			 {SETRGBC(slider[0].r,128,128,128,FULLALPHA);}

		temp=menuCtrl.soundVol/16;
		temp1=8-temp;


		slider[1].yPos=161;
		for (loop=0;loop<temp;loop++)
		{
			slider[1].xPos=xoffset+(loop*32);
			overlayPrint(&slider[1]);
		}

		slider[0].yPos=161;
		for (loop=temp;loop<8;loop++)
		{
			slider[0].xPos=xoffset+(loop*32);
			overlayPrint(&slider[0]);
		}
		for (loop=0;loop<menuCtrl.soundVol;loop+=3)
		{
			slider[0].xPos=xoffset+loop;
			overlayPrint(&slider[0]);
		}


		switch (selection)
		{
			case 0:		// music vol
				slider[0].yPos=113;
				if (leftRight>1024 && menuCtrl.musicVol<=124)
				{
					sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
					menuCtrl.musicVol+=4;
				}
				else if (leftRight<-1024 && menuCtrl.musicVol>=4)
				{
					sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
					menuCtrl.musicVol-=4;
				}
				break;
			case 1:		// sound vol
				slider[0].yPos=161;
				if (leftRight>1024 && menuCtrl.soundVol<=124)
				{
					sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
					menuCtrl.soundVol+=4;
				}
				else if (leftRight<-1024 && menuCtrl.soundVol>=4)
				{
					sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
					menuCtrl.soundVol-=4;
				}
				break;
		}
		volume=sfxvolume=menuCtrl.soundVol;
		CDSETVOLUME(&CDctrl.sAttenuationVol,menuCtrl.musicVol);

		menuFrame++;
		End_Loop(0);

	}
}
////////////////////////////////////////////////////////////////////////////////
void	centerScreen(void)
{
long	deltaX=xOffset[0];
long	deltaY=yOffset[0];

long	oldx,oldy;


	oldx=deltaX;
	oldy=deltaY;
	debounce[0]=0;

	ClearAllText();
	messctrl.font=fontList[1];
#ifdef MULTI_LANGUAGE
	if(language==2)
	{
		NEW_TEXT(256, 24, 255,255,255,255, 3000,4096, FALSE, fontFindLangString(STR_CENTRETITLE), TRUE);
	}
	else
	{
		NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_CENTRETITLE), TRUE);
	}
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "CENTER SCREEN", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

/*
	NEW_TEXT(256, 120, 128,128,0,255, 4096,4096, TRUE, "DIRECTIONAL OR ANALOG", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;

	NEW_TEXT(256, 140, 128,128,0,255, 4096,4096, TRUE, "PAD TO MOVE", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;
*/

// Change for Sony TRC
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 120, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_DIRECTIONAL), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;

	if(language==1)
	{
	NEW_TEXT(256, 160, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_DIRECTIONAL+2), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;
	}
	NEW_TEXT(256, 140, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(STR_DIRECTIONAL+1), TRUE);

#else
	NEW_TEXT(256, 120, 128,128,0,255, 4096,4096, TRUE, "DIRECTIONAL BUTTON", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;

	NEW_TEXT(256, 140, 128,128,0,255, 4096,4096, TRUE, "OR LEFT STICK TO MOVE", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->r1=128;
	mtext->g1=40;
	mtext->b1=8;


#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);



	for ( ;; )
	{
		Start_Loop();
		ShowText();
		menuPrintBack(zoom);	// zoom = 1024

		//vertical bits of corners
		DrawBox(-220,-100,12,16,250,50,0,0,2);
		DrawBox(-220,84,12,16,250,50,0,0,2);
		DrawBox(220-12,-100,12,16,250,50,0,0,2);
		DrawBox(220-12,84,12,16,250,50,0,0,2);

		//horizontal bits of corners
		DrawBox(-220,-108,36,8,250,50,0,0,2);
		DrawBox(-220,100,36,8,250,50,0,0,2);
		DrawBox(220-36,-108,36,8,250,50,0,0,2);
		DrawBox(220-36,100,36,8,250,50,0,0,2);

		xOffset[0]=xOffset[1]=deltaX;
		yOffset[0]=yOffset[1]=deltaY;

		if (((pad[0]&PAD_UP)||(nlefty[0]<0)) && deltaY>0)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			deltaY--;
		}
		if (((pad[0]&PAD_DOWN)||(nlefty[0]>0)) && deltaY<30)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			deltaY++;
		}

		if (((pad[0]&PAD_LEFT)||(nleftx[0]<0)) && deltaX>-20)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			deltaX--;
		}
		if (((pad[0]&PAD_RIGHT)||(nleftx[0]>0))&& deltaX<30)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			deltaX++;
		}

		End_Loop(0);

		if (debounce[0]&PAD_CROSS)
		{
			debounce[0]=0;
			ClearAllText();
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			return;
		}
		if (debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			xOffset[0]=xOffset[1]=oldx;
			yOffset[0]=yOffset[1]=oldy;
			ClearAllText();
			return;
		}


	}
}
////////////////////////////////////////////////////////////////////////////////
#ifndef MULTI_LANGUAGE
char *controllerButtons[]=
{
	"MOVE\0",//dpad
	"MOVE\0",
	"MOVE\0",
	"ZOOM\0",//triangle
	"MAGIC\0",
	"DROP\0",
	"THROW\0",//circle
	"JUMP\0",
	"SLAP\0",
	"JUMP\0",//cross
	"SLAP\0",
	"THROW\0",
	"SLAP\0",//square
	"THROW\0",
	"JUMP\0",
	"CAMERA\0",//L1/R1
	"CAMERA\0",
	"CAMERA\0",
	"DROP\0",//L2
	"DROP\0",
	"ZOOM\0",
	"MAGIC\0",//R2
	"ZOOM\0",
	"MAGIC\0",
	"PAUSE\0",//start
	"PAUSE\0",
	"PAUSE\0",
};
#endif
//------------------------------------------------------------------
//
//------------------------------------------------------------------

UBYTE controlConfig=0;

void	controlsScreen(void)
{
	TEXT *buttonText[9];
	int controlMode=controlConfig,i=0;
	sprctrl.scalex=4096;//2048;
	sprctrl.scaley=4096;//2048;

	SETRGBC(sprctrl.r,128,128,128,0);
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_CONTROLTITLE), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "CONTROLLER LAYOUT", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
#ifdef MULTI_LANGUAGE
	if(strlen(mtext->message) > 18)
	{
		mtext->scaleX = 4096 * 18 / strlen(mtext->message);
	}
	else
	{
		mtext->scaleX = 4096;
	}
#endif
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);


//	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[5]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[5], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	//button text
#ifdef MULTI_LANGUAGE
//	NEW_TEXT(75, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_MOVE), TRUE);
	if(language==1)
		NEW_TEXT(75+16, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_MOVE), TRUE);
	else
		NEW_TEXT(75, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_MOVE), TRUE);
#else
	NEW_TEXT(75, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "DPAD", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[0]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 93-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_ZOOM), FALSE);
#else
	NEW_TEXT(410, 93-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "TRIANGLE", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[1]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 123-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_THROW), FALSE);
#else
	NEW_TEXT(410, 123-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "CIRCLE", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[2]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 150-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_JUMP), FALSE);
#else
	NEW_TEXT(410, 150-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "CROSS", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[3]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 172-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_SLAP), FALSE);
#else
	NEW_TEXT(410, 172-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "SQUARE", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[4]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(244, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_CAMERA), TRUE);
#else
	NEW_TEXT(244, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "L1R1", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[5]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(70, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_DROP), TRUE);
#else
	NEW_TEXT(70, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "L", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[6]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_MAGIC), FALSE);
#else
	NEW_TEXT(410, 65-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "R", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[7]=mtext;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(245, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_PAUSE), TRUE);
#else
	NEW_TEXT(245, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "START", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	buttonText[8]=mtext;


	//non changing text
#ifdef MULTI_LANGUAGE
	NEW_TEXT(70, 111-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_HELP), TRUE);
#else
	NEW_TEXT(70, 111-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "HELP", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
	
#ifdef MULTI_LANGUAGE
	NEW_TEXT(410-16, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, fontFindLangString(STR_CTRL_CAMERA), FALSE);
#else
	NEW_TEXT(410, 195-(5-(5*PALMODE)), 255,255,255,255, infoTextScale,infoTextScale, FALSE, "CAMERA", FALSE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);





	controlPic.active=TRUE;

	for ( ;; )
	{
		Start_Loop();

	
#ifndef MULTI_LANGUAGE
		for(i=0;i<9;i++)
		{
			strncpy(buttonText[i]->message,controllerButtons[(i*3)+controlMode],8);
			buttonText[i]->message[8]=0;
		//	sprintf(buttonText[i]->message,"%s\n",controllerButtons[(i*3)+controlMode]);
		}
#endif

		menuPrintBack(zoom);	// zoom = 1024

		ShowText();
		overlayPrint(&controlPic);

/*		if (debounce[0]&PAD_LEFT)
		{
			if(controlMode>0)
			{
				controlMode--;
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			}
		}
		if (debounce[0]&PAD_RIGHT)
		{
			if(controlMode<2)
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
				controlMode++;
			}
		}*/
		End_Loop(0);

		if (debounce[0]&PAD_CROSS)
		{
			debounce[0]=0;
			ClearAllText();
			controlPic.active=FALSE;
			controlConfig=controlMode;
			return;
		}
		if (debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			ClearAllText();
			controlPic.active=FALSE;
			return;
		}
	}
	
}

////////////////////////////////////////////////////////////////////////////////

char *levelNames[]=
{
	"ATLANTIS\0",
	"CARNIVAL\0",
	"PIRATES\0",
	"PREHISTORIC\0",
	"FEAR\0",
	"SPACE\0",
};

//------------------------------------------------------------------
//
// This is now the level select screen
//------------------------------------------------------------------

void	timeTrialScreen(void)
{
	TEXT *levelText,*pText[5],*tText[5];
	int levelNum=0,numLevels=6,i,actualLevel,selection=0,menuFrame=0,startLevel=0;
	

	ClearAllText();
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_LEVELSELECT), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "LEVEL SELECT", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[4]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[4], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

   


/*	NEW_TEXT(256, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "LEVEL\0", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);*/

/*	NEW_TEXT(330, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "TIME NAME\0", FALSE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);*/


	NEW_TEXT(256, 56, 255,255,255,255, 4096,4096, FALSE, "THE CASTLE", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	levelText=mtext;
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

	for(i=0;i<5;i++)
	{
		NEW_TEXT(256, 100+(i*24), 255,255,255,255, 4096,4096, FALSE, "THE CASTLE", TRUE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		pText[i]=mtext;
		SETRGBC(mtext->r, 128,128,0,FULLALPHA);
		SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

	/*	NEW_TEXT(330, 100+(i*24), 255,255,255,255, 4096,4096, FALSE, "0.01", FALSE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		tText[i]=mtext;
		SETRGBC(mtext->r, 128,128,0,FULLALPHA);
		SETRGBC(mtext->r1, 255,0,0,FULLALPHA);*/
	}

	for ( ;; )
	{
	
		
		//update text
#ifdef MULTI_LANGUAGE
		sprintf(levelText->message,"%s",fontFindLangString(STR_ATLANTIS+(levelNum<<8)));
#else
		sprintf(levelText->message,"%s",levelNames[levelNum]);
#endif
		SETRGBC(levelText->r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(levelText->r1,0,0,75+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);


		for(i=0;i<5;i++)
		{
			
#ifdef MULTI_LANGUAGE
			if(i < 3)
			{
				sprintf(pText[i]->message,"%s %d",fontFindLangString(STR_ATLANTIS+(levelNum<<8)),i+1);
			}
			else
			{
				sprintf(pText[i]->message,"%s %s",
					fontFindLangString(STR_ATLANTIS+(levelNum<<8)),
					fontFindLangString(STR_BOSS+((i-3)<<8))
					);
			}
#else
			sprintf(pText[i]->message,"%s %s",levelNames[levelNum],sSubLevelNames[i]);
#endif

			if((levelNum==5)&&(i==4))//space bonus isn't where you would expect
				actualLevel=10+(levelNum*5)+i+1;
			else
				actualLevel=10+(levelNum*5)+i;
			
		//	sprintf(tText[i]->message,"%d %s",timeTrialData[actualLevel].bestTime,timeTrialData[actualLevel].name);
			if (selection==i)
			{

				pText[i]->flags |= TEXT_ANIMATED;
				pText[i]->font=fontList[1];
				SETRGBC(pText[i]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(pText[i]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);

			/*	tText[i]->flags |= TEXT_ANIMATED;
				SETRGBC(tText[i]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(tText[i]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);*/
			}
			else
			{
				pText[i]->flags &= -1-TEXT_ANIMATED;
				pText[i]->font=fontList[1];
				SETRGBC(pText[i]->r,128,128,0,FULLALPHA);
				SETRGBC(pText[i]->r1,128,40,8,FULLALPHA);

		/*		tText[i]->flags &= -1-TEXT_ANIMATED;
				SETRGBC(tText[i]->r,128,128,0,FULLALPHA);
				SETRGBC(tText[i]->r1,128,40,8,FULLALPHA);*/
			}
		}
		

		//draw everything
		Start_Loop();

		menuPrintBack(zoom);	// zoom = 1024

		MenuDrawFade();	
		

		ShowText();

		SETRGBC(leftArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(rightArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(sprctrl.r1,30,30,105+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);
		
		sprctrl.shaded=TRUE;

		if(levelNum!=0)
			overlayPrint(&leftArrow);
		if(levelNum!=5)
			overlayPrint(&rightArrow);
		
		End_Loop(0);

		menuFrame++;

		//check controller
		if ((debounce[0]&PAD_CROSS)&&(!fadeout))
		{
			debounce[0]=0;
			MenuFadeOut();
			startLevel=1;
		}

		if((startLevel)&&(fader<=1))
			{
				menuSpinHubLeave();

				gameCtrl.previousLevel = TITLE;

				spriteReset();
				ClearAllText();
//				menuShowScreen("GLOVLOAD.TIM");
#if RECORDKEYS==YES
//				DB("Recording - setting seed\n");
				gameInfo.keyRecordFlag=RECORD;
				SetRandomSeed(123);
				keyRecordCount=0;
#else
				gameInfo.keyRecordFlag=NULL;
#endif
				
				if((levelNum==5)&&(selection==3 || selection==4))//space bonus isn't where you would expect
					level=actualLevel=10+(levelNum*5)+selection+2;
				else
					level=actualLevel=10+(levelNum*5)+selection+1;
				cardInitialGameState();
				gameMainGame(level);

  			

				menuSpinHubInit(NULL);

				level=TITLE;	
				textReset();
				messctrl.font=fontList[1];
				spriteReset();
				sprctrl.stretch=1;

				sprctrl.scalex=4096;
				sprctrl.scaley=4096;
				MenuFadeIn();

				return;
			}


		if(!fadeout)
		{
			if (debounce[0]&PAD_TRIANGLE)
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
				debounce[0]=0;
				ClearAllText();
				leftArrow.active=FALSE;
				rightArrow.active=FALSE;
				return;
			}

		

			

			menuGetLeftRight(&levelNum,6);
			

			selection = UpDownCycle(selection,5);

		}

	}
	
}
//////////////////////////////////////////////////////////////////////////////
#ifdef MULTI_LANGUAGE
unsigned short cheatOptionsIds[] =
{
	STR_SOUNDTEST,
	STR_MUSICTEST,
	STR_CREDITS,
	STR_LEVELSELECT
};

#else
char *cheatOptions[]=
{
	"SOUND TEST",
	"MUSIC TEST",
	"CREDITS",
	"LEVEL SELECT",
	"BLAH",
};
#endif
//------------------------------------------------------------------
//
//------------------------------------------------------------------

void	CheatMenu(void)
{
	TEXT *pText[5];
	int i,selection=0,menuFrame=0,textInList=0;
//	int levelNum=0,startLevel=0;
	
	ClearAllText();	

	for ( ;; )
	{
	
		if(!textInList)
		{
#ifdef MULTI_LANGUAGE
			NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_CHEATMENU), TRUE);
#else
			NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "CHEAT MENU", TRUE);
#endif
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[0];
			SETRGBC(mtext->r, 128,128,0,FULLALPHA);
			SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
#ifdef MULTI_LANGUAGE
			NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
			NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);

			for(i=0;i<4;i++)
			{
#ifdef MULTI_LANGUAGE
				NEW_TEXT(256, 80+(i*24), 255,255,255,255, 4096,4096, FALSE, fontFindLangString(cheatOptionsIds[i]), TRUE);
#else
				NEW_TEXT(256, 80+(i*24), 255,255,255,255, 4096,4096, FALSE, cheatOptions[i], TRUE);
#endif
				mtext->flags=TEXT_SHADED;
				mtext->font=fontList[1];
				pText[i]=mtext;
				SETRGBC(mtext->r, 128,128,0,FULLALPHA);
				SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
			}
			textInList=1;
		}

		for(i=0;i<4;i++)
		{
			
			if (selection==i)
			{
				pText[i]->flags |= TEXT_ANIMATED;
				pText[i]->font=fontList[0];
				SETRGBC(pText[i]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(pText[i]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
			}
			else
			{
				pText[i]->flags &= -1-TEXT_ANIMATED;
				pText[i]->font=fontList[1];
				SETRGBC(pText[i]->r,128,128,0,FULLALPHA);
				SETRGBC(pText[i]->r1,128,40,8,FULLALPHA);
			}
		}

		//draw everything
		Start_Loop();

		menuPrintBack(zoom);	// zoom = 1024

		MenuDrawFade();	
		

		ShowText();
		End_Loop(0);

		menuFrame++;

		//check controller
		if ((debounce[0]&PAD_CROSS))
		{
			debounce[0]=0;

			switch(selection)
			{
				case 0:
					ClearAllText();
					menuSoundSelect();
					ClearAllText();
					textInList=0;
					break;
				case 1:
					ClearAllText();
					menuMusicSelect();
					ClearAllText();
					textInList=0;
					break;
				case 2:
					ShowCredits();
					ClearAllText();
					textInList=0;
					break;
				case 3:
					ClearAllText();
					timeTrialScreen();
					textInList=FALSE;
					ClearAllText();
				case 4:
					break;

			}

			debounce[0]=0;
		}
		
		if (debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			ClearAllText();
			return;
		}

		selection = UpDownCycle(selection,4);
	
	}
}
////////////////////////////////////////////////////////////////////////////////

char hiScoreNames[6][4]=
{
	"DAN\0",
	"JON\0",
	"TIM\0",
	"MBC\0",
	"TOM\0",
	"RFW\0",
};

int hiScoreValues[]=
{
	10000,
	9000,
	8000,
	7000,
	6000,
	5000
};

int numHiScores=6;

void	hiScoreScreen(void)
{
//	TEXT *levelText;
	TEXT *pText[6],*tText[6];
//	int levelNum=0,numLevels=6
	int i,menuFrame=0,textInList=0;;
	
	ClearAllText();

	for ( ;; )
	{
	
		if(!textInList)
		{
#ifdef MULTI_LANGUAGE
			NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_HISCORE_TITLE), TRUE);
#else
			NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "HI SCORES\0", TRUE);
#endif
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[0];
			SETRGBC(mtext->r, 128,128,0,FULLALPHA);
			SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
#ifdef MULTI_LANGUAGE
			NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[5]), TRUE);
#else
			NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[5], TRUE);
#endif
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);


#ifdef MULTI_LANGUAGE
			NEW_TEXT(110, 58, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(STR_HIS_SCORE), FALSE);
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);

			NEW_TEXT(330, 58, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(STR_HIS_NAME), FALSE);
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);
#else
			NEW_TEXT(110, 58, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "SCORE\0", FALSE);
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);

			NEW_TEXT(330, 58, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "NAME\0", FALSE);
			mtext->flags=TEXT_SHADED;
			mtext->font=fontList[2];
			SETRGBC(mtext->r1,0,0,0,FULLALPHA);
#endif

			for(i=0;i<numHiScores;i++)
			{
				NEW_TEXT(110, 80+(i*24), 255,255,255,255, 4096,4096, FALSE, "100\0", FALSE);
				mtext->flags=TEXT_SHADED;
				mtext->font=fontList[1];
				pText[i]=mtext;
//				sprintf(pText[i]->message,"%d\n",hiScoreValues[i]);
				sprintf(pText[i]->message,"%d",hiScoreValues[i]);
				SETRGBC(mtext->r, 128,128,0,FULLALPHA);
				SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
	
				NEW_TEXT(330, 80+(i*24), 255,255,255,255,4096,4096, FALSE, hiScoreNames[i], FALSE);
				mtext->flags=TEXT_SHADED;
				mtext->font=fontList[1];
				tText[i]=mtext;		
				SETRGBC(mtext->r, 128,128,0,FULLALPHA);
				SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
			}
			textInList=1;
		}
		

		//draw everything
		Start_Loop();

		menuPrintBack(zoom);	// zoom = 1024

		ShowText();
	   	SETRGBC(rightArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(sprctrl.r1,30,30,105+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);
		
		sprctrl.shaded=TRUE;

		
		overlayPrint(&rightArrow);

		End_Loop(0);

		menuFrame++;

	

	

		if((nleftx[0]>100) &&(menuFrame &1))
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
		
				debounce[0]=0;
				ClearAllText();
				bestTimesScreen();
				textInList=0;

		}

		if (debounce[0]&PAD_CROSS)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			ClearAllText();
			return;
		}
	}
}
//------------------------------------------------------------------------
//
//
//------------------------------------------------------------------------
void	bestTimesScreen(void)
{
	TEXT *levelText,*pText[5],*tText[5];
	int levelNum=0,numLevels=6,i,actualLevel,menuFrame=0;
//	int selection=0;

	ClearAllText();
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_HIS_BESTTIMES), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "BEST TIMES", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[5]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[5], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);


#ifdef MULTI_LANGUAGE
	NEW_TEXT(40, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE,fontFindLangString(STR_HIS_LEVEL) , FALSE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	NEW_TEXT(360, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(STR_HIS_TIME), FALSE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);
#else
	NEW_TEXT(40, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "LEVEL\0", FALSE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	NEW_TEXT(360, 78, 128,128,128,255,infoTextScale,infoTextScale, TRUE, "TIME\0", FALSE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);
#endif

	NEW_TEXT(256, 56, 255,255,255,255, 4096,4096, FALSE, "THE CASTLE", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	levelText=mtext;
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

   

	for(i=0;i<5;i++)
	{
		NEW_TEXT(40, 100+(i*24), 255,255,255,255, 4096,4096, FALSE, "THE CASTLE", FALSE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		pText[i]=mtext;
		SETRGBC(mtext->r, 128,128,0,FULLALPHA);
		SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

		NEW_TEXT(360, 100+(i*24), 255,255,255,255, 4096,4096, FALSE, "0.01", FALSE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		tText[i]=mtext;
		SETRGBC(mtext->r, 128,128,0,FULLALPHA);
		SETRGBC(mtext->r1, 255,0,0,FULLALPHA);
	}

	for ( ;; )
	{
		//update text
#ifdef MULTI_LANGUAGE
		sprintf(levelText->message,"%s",fontFindLangString(STR_ATLANTIS+(levelNum<<8)));
#else
		sprintf(levelText->message,"%s",levelNames[levelNum]);
#endif
		SETRGBC(levelText->r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(levelText->r1,0,0,75+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);


		for(i=0;i<5;i++)
		{
			if((levelNum==5)&&((i==4)||(i==3)))//space bonus/boss isn't where you would expect
				actualLevel=11+(levelNum*5)+i+1;
			else
				actualLevel=11+(levelNum*5)+i;

#ifdef MULTI_LANGUAGE
			if(language == 2)	// German level names are a tad howge
			{
				if(i < 3)
				{
					sprintf(pText[i]->message,"%d",i+1);
				}
				else
				{
					sprintf(pText[i]->message,"%s",
						fontFindLangString(STR_BOSS+((i-3)<<8))
						);
				}
			}
			else
			{
				if(i < 3)
				{
					sprintf(pText[i]->message,"%s %d",fontFindLangString(STR_ATLANTIS+(levelNum<<8)),i+1);
				}
				else
				{
					sprintf(pText[i]->message,"%s %s",
						fontFindLangString(STR_ATLANTIS+(levelNum<<8)),
						fontFindLangString(STR_BOSS+((i-3)<<8))
						);
				}
			}
#else
			sprintf(pText[i]->message,"%s %s",levelNames[levelNum],sSubLevelNames[i]);
#endif
			menuGetTimerString(hiScores[actualLevel].timeTook, tText[i]->message);
			
		
			pText[i]->flags &= -1-TEXT_ANIMATED;
			pText[i]->font=fontList[1];
			SETRGBC(pText[i]->r,128,128,0,FULLALPHA);
			SETRGBC(pText[i]->r1,128,40,8,FULLALPHA);

			tText[i]->flags &= -1-TEXT_ANIMATED;
			SETRGBC(tText[i]->r,128,128,0,FULLALPHA);
			SETRGBC(tText[i]->r1,128,40,8,FULLALPHA);
		
		}
		

		//draw everything
		Start_Loop();

		menuPrintBack(zoom);	// zoom = 1024

		ShowText();

		SETRGBC(leftArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(rightArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(sprctrl.r1,30,30,105+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);
		
		sprctrl.shaded=TRUE;

		
		overlayPrint(&leftArrow);
		if(levelNum!=5)
			overlayPrint(&rightArrow);


		End_Loop(0);

		menuFrame++;

		//if ((debounce[0]&PAD_L1)||(debounce[0]&PAD_LEFT))
		if((nleftx[0]<-100)&&(menuFrame&1))
		{
			if(levelNum>0)
			{
				levelNum--;
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			}
			else
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
				ClearAllText();
				return;
			}
		}

	 //	if ((debounce[0]&PAD_R1)||(debounce[0]&PAD_RIGHT))
		if((nleftx[0]>100)&&(menuFrame&1))
		{
			if(levelNum<numLevels-1)
			{
				levelNum++;
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
			}
		}

		if (debounce[0]&PAD_CROSS)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			ClearAllText();
			return;
		}
	}
}
////////////////////////////////////////////////////////////////////////////////

#ifdef MULTI_LANGUAGE
unsigned short languageIds[] =
{
	STR_ENGLISH,
	STR_FRENCH,
	STR_GERMAN,
	STR_ITALIAN
};
#else
char *languages[] =
{												                          	                                                
	"ENGLISH\0",
	"FRENCH\0",
	"GERMAN\0",
#ifdef MULTI_LANGUAGE
	"ITALIAN\0",
#endif
};
#endif
//------------------------------------------------------------------
//
//------------------------------------------------------------------

void	languageScreen(int restart_music)
{
long	selector=0;
//long	prev,loop;
long	next,menuFrame=0;
TEXT	*pText[8];

	ClearAllText();
	messctrl.font=fontList[1];

#ifdef MULTI_LANGUAGE
// removed rather than having to do onscreen translation
//	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_LANGTITLE), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "LANGUAGE SELECT", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 128,40,8,FULLALPHA);

#ifdef MULTI_LANGUAGE
// removed rather than having to do onscreen translation
//	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[1]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[1], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);
	for (next=0;next<N_LANGUAGES;next++)
	{
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256,513, 128,128,0,255, 4096,4096, TRUE, fontFindLangString(languageIds[next]), YES);
#else
		NEW_TEXT(256,513, 128,128,0,255, 4096,4096, TRUE, languages[next], YES);
#endif
		pText[next]=mtext;
		mtext->flags=TEXT_SHADED;
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);
	}

	UpDownReset();

	for ( ;; )
	{
		selector = UpDownCycle(selector,N_LANGUAGES);
/*
		if ((debounce[0]&PAD_UP)||(nlefty[0]<0))
		{
			if (selector>0) 
				selector--;
		}

		if ((debounce[0]&PAD_DOWN)||(nlefty[0]>0))
		{
			if (selector<N_LANGUAGES-1) 
				selector++;
		}
*/
		flagPic[0].active=0;
		flagPic[1].active=0;
		flagPic[2].active=0;
#ifdef MULTI_LANGUAGE
		flagPic[3].active=0;
#endif
		flagPic[selector].active=1;

//		while(!MENUSELECT(0))	and just how does this work?
//		{
//			// Show selected menu item on screen here
//			menuGetUpDown(&language, 7);
//		}


		pText[0]->y=110;
		pText[0]->font=fontList[1];
		SETRGBC(pText[0]->r,128,128,0,FULLALPHA);
		SETRGBC(pText[0]->r1,128,40,8,FULLALPHA);
		pText[0]->flags=TEXT_SHADED;	
				
		pText[1]->y=140;
		pText[1]->font=fontList[1];
		SETRGBC(pText[1]->r,128,128,0,FULLALPHA);
		SETRGBC(pText[1]->r1,128,40,8,FULLALPHA);
		pText[1]->flags=TEXT_SHADED;
		
		pText[2]->y=170;
		pText[2]->font=fontList[1];
		SETRGBC(pText[2]->r,128,128,0,FULLALPHA);
		SETRGBC(pText[2]->r1,128,40,8,FULLALPHA);
		pText[2]->flags=TEXT_SHADED;		

#ifdef MULTI_LANGUAGE
		pText[3]->y=200;
		pText[3]->font=fontList[1];
		SETRGBC(pText[3]->r,128,128,0,FULLALPHA);
		SETRGBC(pText[3]->r1,128,40,8,FULLALPHA);
		pText[3]->flags=TEXT_SHADED;		
#endif
		SETRGBC(pText[selector]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
		SETRGBC(pText[selector]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
		pText[selector]->flags|=TEXT_ANIMATED;
		pText[selector]->font=fontList[0];
		menuFrame++;

		Start_Loop();


		menuPrintBack(zoom);	// zoom = 1024
#ifdef MULTI_LANGUAGE
		MenuDrawFade();			// The very front-end one
#endif

		flagPic[selector].scaleX=8192;
		if(&flagPic[selector])
			overlayPrint(&flagPic[selector]);
		flagPic[selector].scaleX=4096;
		ShowText();

		End_Loop(0);


		if (debounce[0]&PAD_CROSS)
		{
			debounce[0]=0;
			flagPic[0].active=0;
			flagPic[1].active=0;
			flagPic[2].active=0;
#ifdef MULTI_LANGUAGE
			flagPic[3].active=0;
#endif
			ClearAllText();
			language=selector;
#ifdef MULTI_LANGUAGE
			loadLangFile(language);
#endif
			if(restart_music)
				XA_SetMusicGoing(TRACK_MAINMENU,1);
			return;
		}
		if (debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			debounce[0]=0;
			flagPic[0].active=0;
			flagPic[1].active=0;
			flagPic[2].active=0;
#ifdef MULTI_LANGUAGE
			flagPic[3].active=0;
#endif
			ClearAllText();
			return;
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
void menuSpinHub(void)
{
	static int thing_doing = 0;
	int doing_timer = 1;
	int i = 0;

	menuSpinHubInit(NULL);

	newFrontEnd();		// Use This to take controll for now

	for(;;)
	{
		i++;
		doing_timer--;
		if(doing_timer <= 0)
		{

// stop doing old thing
// go to next thing

// okay, we are now memleak free on the rolling demo!
//			printf(">>>Thing Switch\n");
//			memoryShow();

			thing_doing++;
			if(thing_doing >= TD_N_THINGS)
				thing_doing = 1;

// switch between things
			switch(thing_doing)
			{
				case TD_SPIN1:
				case TD_SPIN2:
				case TD_SPIN3:
				case TD_SPIN4:
				case TD_SPIN5:
				case TD_SPIN6:
					doing_timer = SPIN_TIME;
					break;

				case TD_SPLASH0:
					menuShowScreen("SPLASH0.TIM");
					doing_timer = SPLASH_TIME_LONG;
					break;
				case TD_SPLASH1:
					menuShowScreen("SPLASH1.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH2:
					menuShowScreen("SPLASH2.TIM");
					doing_timer = SPLASH_TIME_MEDIUM;
					break;
				case TD_SPLASH3:
					menuShowScreen("SPLASH3.TIM");
					doing_timer = SPLASH_TIME_MEDIUM;
					break;
				case TD_SPLASH4:
					menuShowScreen("SPLASH4.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH5:
					menuShowScreen("SPLASH5.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH6:
					menuShowScreen("SPLASH6.TIM");
					doing_timer = SPLASH_TIME_MEDIUM;
					break;
				case TD_SPLASH7:
					menuShowScreen("SPLASH7.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH8:
					menuShowScreen("SPLASH8.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH9:
					menuShowScreen("SPLASH9.TIM");
					doing_timer = SPLASH_TIME_SMALL;
					break;
				case TD_SPLASH10:
					menuShowScreen("SPLASH10.TIM");
					doing_timer = SPLASH_TIME_LONG;
					break;
				case TD_SPLASH11:
					menuShowScreen("SPLASH11.TIM");
					doing_timer = SPLASH_TIME_MEDIUM;
					break;

				case TD_VID1:
				case TD_VID2:
				case TD_VID3:
					if (dovideo==YES)
					{
						menuSpinHubLeave();

						newvideo("GLOVER.STR",INT_VIDEO_LEN);	//1354);

						menuSpinHubInit(NULL);
					}
					doing_timer = 0;
					break;

				case TD_PLAY1:
					menuPlayKeyDemo("STEPS.DEM", HUB8, 680);
					doing_timer = 0;
					break;
				case TD_PLAY2:
					menuPlayKeyDemo("CHICKEN.DEM", HUB8, 580);
					doing_timer = 0;
					break;
				case TD_PLAY3:
					menuPlayKeyDemo("ATDEMO1.DEM", ATLANTIS1, 1050);
					doing_timer = 0;
					break;
				case TD_PLAY4:
					menuPlayKeyDemo("BRIDGE.DEM", HUB8, 390);
					doing_timer = 0;
					break;
				case TD_PLAY5:
					menuPlayKeyDemo("BALLWALK.DEM", HUB8, 480);
					doing_timer = 0;
					break;
	   		}
		}


// do a main loop of whatever the menu's doing
		switch(thing_doing)
		{
			case TD_SPIN1:
			case TD_SPIN2:
			case TD_SPIN3:
			case TD_SPIN4:
			case TD_SPIN5:
			case TD_SPIN6:
			{

				Start_Loop();
				menuPrintBack(zoom);
				ShowText();
				overlayPrintAll();

				End_Loop(0);
				break;
			}
			default:
				VSync(2);
				padHandler();

				break;
		}

// check for game
		if(debounce[0] & (PAD_CROSS | PAD_START))
		{
#ifndef TWOLEVEL_DEMO
			{
				int cLevel;
				cLevel=menuLevelSelect();
				if(cLevel != -1)
				{
					menuSpinHubLeave();
					level = cLevel;	// set the global so subroutines can pick up on it
					gameInfo.keyRecordFlag=NULL;
					cardInitialGameState();
					gameMainGame(cLevel);
					menuSpinHubInit(NULL);
				}
			}
#else
			menuSpinHubLeave();
//			menuShowScreen("GLOVLOAD.TIM");

			gameInfo.keyRecordFlag=NULL;
			//gameInfo.keyRecordFlag=RECORD;

			level=HUB8;
			cardInitialGameState();
			gameMainGame(HUB8);

			if(gameCtrl.dropOutFlag==GAME_COMPLETED)
			{
//				menuShowScreen("GLOVLOAD.TIM");
				level=ATLANTIS1;
				gameMainGame(ATLANTIS1);

				if(gameCtrl.dropOutFlag==GAME_COMPLETED)
				{
					menuSpinHubInit("FINISHED.TIM");
// They finished the demo...
					thing_doing = TD_FINISHED;
//					menuShowScreen("FINISHED.TIM");
					doing_timer = SPLASH_TIME_MEDIUM;
				}
				else
				{
					menuSpinHubInit(NULL);
					doing_timer = 0;
				}

			}
			else
			{
				menuSpinHubInit(NULL);
				doing_timer = 0;
			}
#endif
		}
	}
}
/***************************************************************************************/

int menuLevelSelect(void)
{
	int c,m;
	TEXT *pText[8];
	int cLevel=0;
	
	TEXTSETFONT(fontList[0]);
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, "SELECT A LEVEL", TRUE);

	mtext->flags=TEXT_SHADED;

	SETRGBC(mtext->r1,128,40,8,FULLALPHA);

	TEXTSETFONT(fontList[0]);
	for(c=0; c<7; c++)
	{
		NEW_TEXT(256, 64+(c*24), 128,128,128,255, 3072,3072, FALSE, "", TRUE);
		pText[c]=mtext;
	}

	for(;;)
	{
		Start_Loop();

		menuPrintBack(zoom);

		menuGetUpDown(&cLevel, NUMLEVELS);

		for(c=0; c<7; c++)
		{
			if(c==3)
			{
				pText[c]->scaleX=4096;
				pText[c]->scaleY=4096;
				SETRGBC(pText[c]->r, 128,128,128,255);
				pText[c]->flags=0;
			}
			else
			{
				int y;
				pText[c]->scaleX=3072;
				pText[c]->scaleY=3072;

				y=pText[c]->y;
				SETRGBC(pText[c]->r,  128+((rsin(y*16))/64), 128+((rsin((y*16)+1365))/64), 128+((rsin((y*16)+2731))/64), 128);
				y+=24;
				SETRGBC(pText[c]->r1, 128+((rsin(y*16))/64), 128+((rsin((y*16)+1365))/64), 128+((rsin((y*16)+2731))/64), 128);

				pText[c]->flags=TEXT_SHADED;
			}

			m=(c+cLevel)-3;
			if((m<0)||(m>=NUMLEVELS))
				pText[c]->message[0]=0;
			else
			{
				if(sLevelNames[m][0]!='!')
				{
					pText[c]->flags=0;
					SETRGBC(pText[c]->r, 63,63,63, 255);
					STRCPY(pText[c]->message, sLevelNames[m]);
				}
				else
					STRCPY(pText[c]->message, sLevelNames[m]+1);
			}
		}

		ShowText();

		End_Loop(0);

		if(MENUSELECT(0) && (sLevelNames[cLevel][0]=='!'))
			break;

		if((debounce[0]&PAD_TRIANGLE))	// go up a menu level
		{
			cLevel = -1;
			break;
		}
	}

	overlayClearAll();
	ClearAllText();

	return(cLevel);
}

/*****************************************************************************************************/

char *trackNames[]=
{
	"ATLANTIS1",		
	"ATLANTIS2",		
	"ATLANTIS3",	
	"ATLANTIS BOSS",	
	"ATLANTIS JINGLE",	

	"EXTRA3",
	"EXTRA4",
	"EXTRA5",

	"CARNIVAL1",
	"CARNIVAL2",
	"CARNIVAL3",	
	"CARNIVAL BOSS",
	"CARNIVAL BONUS",

	"CARNIVAL JINGLE",	

	"EXTRA2",
	"EXTRA1",

	"PIRATES1",
	"PIRATES2",
	"PIRATES3",
	"PIRATES BOSS",
	"PIRATES JINGLE",	

	"PRESENTS",
	"INTRO",
	"MAINMENU",

	"PREHIST1",
	"PREHIST2",
	"PREHIST3",
	"PREHIST BOSS",
	"PREHIST JINGLE",
	"HUB7",

	"HUB8",

	"FEAR1",	
	"FEAR2",
	"FEAR3",
	"FEAR BOSS",	
	"FEAR JINGLE",

	"SPACE1",
	"SPACE2",
	"SPACE3",	
	"SPACE BOSS",	
	"SPACE JINGLE",


};

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void menuMusicSelect(void)
{
	int c,m,track=0,menuFrame=0;
	TEXT *pText[8];
	
	TEXTSETFONT(fontList[0]);
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_MUSICTEST), TRUE);
#else
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, "MUSIC TEST", TRUE);
#endif

	mtext->flags=TEXT_SHADED;

	SETRGBC(mtext->r1,128,0,0,FULLALPHA);

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[2]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE, menuInfoText[2], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	TEXTSETFONT(fontList[0]);
	for(c=0; c<7; c++)
	{

		NEW_TEXT(256, 56+(c*24), 128,128,128,255, 3072,3072, FALSE, "", TRUE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		SETRGBC(mtext->r, 128,128,0,FULLALPHA);
		SETRGBC(mtext->r1, 128,40,8,FULLALPHA);
		pText[c]=mtext;
	}

	for(;;)
	{
		Start_Loop();

		menuPrintBack(zoom);

		menuGetUpDown(&track, TRACK_NUMTRACKS);

		for(c=0; c<7; c++)
		{
			if(c==3)
			{
				pText[c]->scaleX=4096;
				pText[c]->scaleY=4096;

				pText[c]->font=fontList[0];
				SETRGBC(pText[c]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(pText[c]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
				pText[c]->flags|=TEXT_ANIMATED;	

			}
			else
			{
				int y;
				pText[c]->scaleX=4096;
				pText[c]->scaleY=4096;

				pText[c]->font=fontList[1];
				y=pText[c]->y;
		
				pText[c]->flags=TEXT_SHADED;
			}

			m=(c+track)-3;
			if((m<0)||(m>=TRACK_NUMTRACKS))
				pText[c]->message[0]=0;
			else
			{
				STRCPY(pText[c]->message, trackNames[m]);
			}

		}

		ShowText();

		End_Loop(0);

		if(debounce[0]&PAD_TRIANGLE)
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			ClearAllText();
			return;
		}

		if(debounce[0]&PAD_CROSS)
		{
			XA_SetMusicGoing(track, 1);
		}

		menuFrame++;
	}
	ClearAllText();
	return;
}

/*****************************************************************************************************/
// call this before printing text
/*****************************************************************************************************/
void MenuDrawFade()
{
		long oldvrx,oldvry,oldvrz;
		long oldvpx,oldvpy,oldvpz;
		int val,x,y;
		POLY_G4 *si = (POLY_G4 *) GsOUT_PACKET_P; 
		register	GsOTA 	*ot = (GsOTA*)(PolyList->org);	
		MATRIX temp;

		if((!fadeout) && (!fadein))
			return;

		if((fadeout) &&(fader>0))
			fader--;
		else if(fader<32)
			fader++;
		
		if(((fader==0)&&(fadeout))||((fader==32)&&(fadein)))
		{
			fadeout=fadein=0;
			return;
		}

		if(fadeout)
		{
			x=256-(fader*8);
			if(x>230)
				x=255;
		}
		else
		{
// Just so the camera has one frame of blackout at the start of the game, which can be useful for cam-cases to kick in nicely
			if(fader < 4)
			{
				x=256-(fader*64);
			}
			else
			{
				x = 0;
			}

		}

		if(x)
		{
			SETRGBC(si->r0, x, x, x, GPU_COM_G4);
			SETRGBC(si->r1, x, x, x, GPU_COM_G4);
			SETRGBC(si->r2, x, x, x, GPU_COM_G4);
			SETRGBC(si->r3, x, x, x, GPU_COM_G4);

			x =256;
			y =128;

			si->x0=si->x2=-x;
			si->x1=si->x3=x;
			si->y0=si->y1=-y;
			si->y2=si->y3=y;

			si->code = si->code | 2;

	 		PUTPACKETINTABLE(si,ot,POLYG4_LEN);
			GsOUT_PACKET_P+=sizeof(POLY_G4);
			si++;

			{
				DR_TPAGE *si = (DR_TPAGE *) GsOUT_PACKET_P;
				setDrawTPage(si,1,1,((2<<5)));	// macro

				PUTPACKETINTABLE(si,ot,DRTPAGE_LEN);
				GsOUT_PACKET_P+=sizeof(DR_TPAGE);
			}

		}

		val=fader;

		oldvrx=backCam.vrx;
		oldvry=backCam.vry;
		oldvrz=backCam.vrz;

		oldvpx=backCam.vpx;
		oldvpy=backCam.vpy;
		oldvpz=backCam.vpz;

		temp = GsWSMATRIX;


		backCam.vpx=0;
		backCam.vpz=-2080+(val*64);
	
		backCam.vpy=0;
	
		backCam.vrx=0;
		backCam.vrz=0;
		backCam.vry=0;

		modelctrl.depthoveride=1;
		modelctrl.lighting=0;
		

		fadeStar->position.vx=0;
		fadeStar->position.vy=0;
		fadeStar->position.vz=0;
		fadeStar->world.rotate.vx = 0; 
		fadeStar->world.rotate.vy = 0;
		fadeStar->world.rotate.vz = (val*48) MOD 4096;
//		fadeStar->globalscale.vx = 2200+(val*30);
//		fadeStar->globalscale.vy = 2200+(val*30);
//		fadeStar->globalscale.vz = 2200+(val*30);
		GsSetRefView2L(&backCam);	

		objectSetAnimation(fadeStar,0);
		objectDraw(fadeStar);
		modelctrl.depthoveride=0;

		GsWSMATRIX = temp;	// restore the camera matrix, coz stuff relies on it!

		backCam.vrx=oldvrx;
		backCam.vrz=oldvrz;
		backCam.vry=oldvry;

		backCam.vpx=oldvpx;
		backCam.vpz=oldvpz;
		backCam.vpy=oldvpy;
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void menuSoundSelect(void)
{
	int c,m,n_groups;
	TEXT *pText[8],*bankText;
	int cSound=1;
	int max;
	int remap_counter;
	int pitch=52;
	int track;
	int menuFrame=0;

	int groups[10];
	int groupNum=0;

	char *names;
	char **pointers;
	unsigned char *remaps;
	int lastfilelength;

	names = fileLoad("SOUND\\FX_NAMES.TXT", &lastfilelength);
	if(!names)
		return;
	pointers = MALLOC(500 * 4,"sfx names");
	remaps   = MALLOC(500,"sfx remaps");

	pointers[0] = names;
	remaps[0] = 0;

	leftArrow.active=TRUE;
	rightArrow.active=TRUE;


   //	XA_SetMusicGoing(23, 1);
// c is the charpos in the text
// m is the line in the menu
// g is vab number containing sfx "m"
// remap_counter is the real sfx number of sfx "m"

	for(c = 0,m=1,n_groups=0,remap_counter = 0; c<lastfilelength && m < 500;c++)
	{
		if(names[c] == 0x0d)	// *END* of name "m-1"
		{
			names[c] = 0;
			remaps[m-1]   = remap_counter;

			if(names[c+2] == 0x0d)	// double newline
			{
				//remap_counter = ((remap_counter+15) & 0xfff0) - 1;	// -1 coz it'll be +1'd in a minute
				c+=2;
			}

			pointers[m] = &names[c+2];	// (start of name "m")

			if(*pointers[m-1] == '!')
			{
				groups[n_groups] = m;
				n_groups++;
				remap_counter = 0;
			}
			else
			{
				remap_counter++;
			}

//			printf("%s\n",pointers[m-1]);

			m++;
		}
	}
	max = m-1;
	
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, fontFindLangString(STR_SOUNDTEST), TRUE);
#else
	NEW_TEXT(256, 24, 255,255,255,255, 4096,4096, FALSE, "SOUND TEST", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r, 128,128,0,FULLALPHA);
	SETRGBC(mtext->r1, 255,0,0,FULLALPHA);

	NEW_TEXT(256, 56, 255,255,255,255, 4096,4096, FALSE, "bank", TRUE);
	bankText=mtext;
	mtext->font=fontList[1];
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255, infoTextScale,infoTextScale, TRUE, fontFindLangString(menuInfoTextIds[2]), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255, infoTextScale,infoTextScale, TRUE, menuInfoText[2], TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);

	TEXTSETFONT(fontList[1]);
	for(c=0; c<7; c++)
	{
		NEW_TEXT(256, 80+(c*20), 255,255,255,255, 4096,4096, FALSE, "", TRUE);
		pText[c]=mtext;
	}

/*	NEW_TEXT(20, 202, 255,255,255,255, 4096,4096, FALSE, "PITCH 52", FALSE);
	pitch = DEFAULTPITCH;
	track = 0;
	pText[7] = mtext;
*/
	for(;;)
	{
		Start_Loop();

		menuPrintBack(zoom);


	   
		SETRGBC(leftArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(rightArrow.r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(sprctrl.r1,30,30,100+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);
		
		sprctrl.shaded=TRUE;

		if(groupNum!=0)
			overlayPrint(&leftArrow);
		if(groupNum!=7)
			overlayPrint(&rightArrow);

  //		menuSpinHub();
		
		//menuGetUpDown(&cSound, groups[groupNum+1]-1);


		if((pad[0]&PAD_UP)||(nlefty[0]<-1000))
		{
			if(cSound>groups[groupNum])
				cSound--;

		}

		if((pad[0]&PAD_DOWN)||(nlefty[0]>1000))
		{
		
			if(strlen(pointers[cSound+1])>0)
				{
				if((groupNum<n_groups-1)&&(cSound<groups[groupNum+1]-2))
					cSound++;
				else if((groupNum>=n_groups-1)&&(cSound<max))
					cSound++;
				}

		}

		for(c=0; c<7; c++)
		{

			m=(c+cSound)-3;
			if((m<groups[groupNum])||(m>=max)||((groupNum<n_groups-1)&&(m>=(groups[groupNum+1]-1)) ) )
				pText[c]->message[0]=0;
			else
			{
				if(*(pointers[m]) == '!')
				{
					SETRGBC(pText[c]->r, 255,128,0,FULLALPHA);
					SETRGBC(pText[c]->r1, 0,0,128,FULLALPHA);
					pText[c]->flags=TEXT_SHADED;
					STRCPY(pText[c]->message, pointers[m]+1);
				}
				else
				{
					
					if(*(pointers[m]) == '+')
					{
						STRCPY(pText[c]->message, pointers[m]+1);
					}
					else
					{
						STRCPY(pText[c]->message, pointers[m]);
					}
				}

			}
			if(c==3)
			{
				pText[c]->scaleX=4096;
				pText[c]->scaleY=4096;
				pText[c]->flags=TEXT_SHADED;
				pText[c]->font=fontList[0];
				SETRGBC(pText[c]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(pText[c]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
				pText[c]->flags|=TEXT_ANIMATED;	
				if(strlen(pText[c]->message) > 16)
				{
					pText[c]->scaleX = 4096 * 16 / strlen(pText[c]->message);
				}
				else
				{
					pText[c]->scaleX = 4096;
				}

			}
			else
			{
				pText[c]->scaleX=4096;
				pText[c]->scaleY=4096;
				pText[c]->font=fontList[1];
				pText[c]->flags=TEXT_SHADED;
				SETRGBC(pText[c]->r, 128,128,0,FULLALPHA);
				SETRGBC(pText[c]->r1, 255,0,0,FULLALPHA);
				pText[c]->scaleX=4096;
			}
		}

		SETRGBC(bankText->r,255,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),0,FULLALPHA);
		SETRGBC(bankText->r1,0,0,75+(rsin((menuFrame*100) MOD 4096)/82),FULLALPHA);


		bankText->flags=TEXT_SHADED;
		strcpy(bankText->message, pointers[groups[groupNum]-1]+1);

		if(*pointers[cSound] != '!')
		{
	//		sprintf(pText[7]->message,"PITCH %d",pitch);
			
		}
		else
		{
			sprintf(pText[7]->message,"TRACK %d",track);
			menuGetLeftRight(&track, TRACK_NUMTRACKS);
		}

		ShowText();


		if((debounce[0]&PAD_R1)||(debounce[0]&PAD_RIGHT))
		{
			if(groupNum<n_groups-1)
				groupNum++;
			cSound=groups[groupNum];

		}
		if((debounce[0]&PAD_L1)||(debounce[0]&PAD_LEFT))
		{
			if(groupNum>0)
				groupNum--;

			cSound=groups[groupNum];

		}

		if(debounce[0]&PAD_R2)
		{
			if(pitch<128)
				pitch++;
			

		}
		if(debounce[0]&PAD_L2)
		{
			
			if(pitch>0)
				pitch--;
		}

//		if(MENUSELECT(0))
		if(debounce[0]&PAD_CROSS)
		{
			if((*pointers[cSound] != '!'))
			{
				int group_rqd;

	// play the effect
				for(group_rqd = 0; group_rqd < n_groups; group_rqd++)
				{
					if(cSound < groups[group_rqd])
						break;
				}
				group_rqd--;


//				if(group_rqd != 0 && group_rqd != world+1)
				if(group_rqd != 0 && group_rqd != music_bank_loaded+1)
				{
	//				printf("loading group %d\n",group_rqd);
					//Reset_Music();
					world = group_rqd-1;
					if(music_bank_loaded != -1)
						sfxDestroy(1);
					LoadMusic();
				}

				//if(group_rqd == 0)
					//;//SFXPlayAmbient(globalFX, remaps[cSound], AMBIENT_PROLOGIC, 127, pitch, 400);
					//PlaySFX(globalFX,remaps[cSound],64,pitch);
					if (group_rqd==0)sfxPlayVoice(0,remaps[cSound]);
					else   		     sfxPlayVoice(1,remaps[cSound]);
//					sfxPlayVoice(0,remaps[cSound]);

				//else
				//	;//SFXPlayAmbient(levelFX, remaps[cSound], AMBIENT_PROLOGIC, 127, pitch, 400);
				//	PlaySFX(levelFX,remaps[cSound],64,pitch);

	//			printf("playing sound %d from group %d\n",remaps[cSound], group_rqd);
			}
		 /*	else
			{
				XA_SetMusicGoing(track, 1);
			}*/
		}

		End_Loop(0);

		if((debounce[0]&PAD_START || debounce[0]&PAD_SELECT || debounce[0]&PAD_TRIANGLE))
		{
			leftArrow.active=FALSE;
			rightArrow.active=FALSE;
			break;
		}

		menuFrame++;
	}
//	overlayClearAll();
	ClearAllText();

	FREE(remaps);
	FREE(pointers);
	FREE(names);

	
	XA_SetMusicGoing(23, 1);

	
	if(music_bank_loaded != -1)
	{
		sfxDestroy(1);
	}
	world = HUB;

/*
	if(world != HUB)
	{
		//Reset_Music();
		world = HUB;
		sfxDestroy(1);
		LoadMusic();
	}
*/
	return;
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void menuGetTimerString(int time, char *sTime)
{
	int tenths=time/10;
	int secs=time/100;
	int mins=time/6000;

	tenths=tenths%10;
	secs=secs%60;

	sprintf(sTime, "%d:%02d.%d", mins, secs, tenths);
}

//int menuShowStats(int time, int level) // time is in centi-seconds

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void menuInitHiScores(void)
{
	int i;
	for(i=0; i<NUMLEVELS; i++)
	{
		hiScores[i].timeTook=(180*100)*30; // = 3 mins in iframes
		hiScores[i].nGaribs=0;
		hiScores[i].score=0;
		STRCPY(hiScores[i].name,"XXX");
	}
}

#define STATS_YOUR_Y	(70-15)
#define STATS_BEST_Y	(100-15)
#define STATS_YOURG_Y	(135-30)
#define STATS_BESTG_Y	(175-30)
#if PALMODE==YES
	#define STATS_MENU_Y	(195)
#else
	#define STATS_MENU_Y	(190)
#endif
//------------------------------------------------------------------
//
//------------------------------------------------------------------

int menuShowStats(GameInfoType *pGameInfo, HiScoreType *pHiScores, HiScoreType *pTheseScores)
{
	//int time=pHiScores[pGameInfo->level].timeTook;

	static char sTime[16];
	static char sGaribs[16];
	int selection;
	TEXT	*pText[2];
	TEXT *pTime;	//, *pGaribs;
	int loop;
	int exiting=0,menuFrame=0;

	ClearAllText();
	InitTextList();

	TEXTSETFONT(fontList[0]);
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_CONGRATS), TRUE);
#else
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, "CONGRATULATIONS", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);

	// times
#ifdef MULTI_LANGUAGE
	NEW_TEXT(140, STATS_YOUR_Y, 0,128,128, 255, 4096,4096, FALSE, fontFindLangString(STR_YOURTIME), TRUE);
#else
	NEW_TEXT(140, STATS_YOUR_Y, 0,128,128, 255, 4096,4096, FALSE, "YOUR TIME", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,8,40,128,FULLALPHA);

#ifdef MULTI_LANGUAGE
	NEW_TEXT(140, STATS_BEST_Y, 0,128,128, 255,4096,4096, FALSE, fontFindLangString(STR_BESTTIME), TRUE);
#else
	NEW_TEXT(140, STATS_BEST_Y, 0,128,128, 255,4096,4096, FALSE, "BEST TIME", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,8,40,128,FULLALPHA);

	menuGetTimerString(pTheseScores->timeTook, sTime);
	NEW_TEXT(360, STATS_YOUR_Y, 128,128,0, 255, 4096,4096, FALSE, sTime, TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	SETRGBC(mtext->r1,128,40,8,FULLALPHA);

	menuGetTimerString(pHiScores[pGameInfo->level].timeTook, sTime);
	NEW_TEXT(360, STATS_BEST_Y, 128,128,0, 255, 4096,4096, FALSE, sTime, TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	SETRGBC(mtext->r1,128,40,8,FULLALPHA);
	pTime=mtext;


	if(pTheseScores->nTotalGaribs)	// No garibs on the boss levels
	{
		// garibs
#ifdef MULTI_LANGUAGE
		NEW_TEXT(360, STATS_YOURG_Y, 0,128,128, 255,4096,4096, FALSE, fontFindLangString(STR_YOURCARDS), TRUE);
#else
		NEW_TEXT(360, STATS_YOURG_Y, 0,128,128, 255,4096,4096, FALSE, "CARDS", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,8,40,128,FULLALPHA);

#ifdef MULTI_LANGUAGE
		NEW_TEXT(360, STATS_YOURG_Y+16, 0,128,128, 255,4096,4096, FALSE, fontFindLangString(STR_YOURCARDS+1), TRUE);
#else
		NEW_TEXT(360, STATS_YOURG_Y+16, 0,128,128, 255,4096,4096, FALSE, "COLLECTED", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,8,40,128,FULLALPHA);

#ifdef MULTI_LANGUAGE
		NEW_TEXT(360, STATS_BESTG_Y, 0,128,128, 255,4096,4096, FALSE, fontFindLangString(STR_BESTCARDS), TRUE);
#else
		NEW_TEXT(360, STATS_BESTG_Y, 0,128,128, 255,4096,4096, FALSE, "BEST CARDS", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,8,40,128,FULLALPHA);

#ifdef MULTI_LANGUAGE
		if(language != 2)	// german fits "best cards collected" into one word
			NEW_TEXT(360, STATS_BESTG_Y+16, 0,128,128, 255,4096,4096, FALSE, fontFindLangString(STR_BESTCARDS+1), TRUE);
#else
		NEW_TEXT(360, STATS_BESTG_Y+16, 0,128,128, 255,4096,4096, FALSE, "COLLECTED", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,8,40,128,FULLALPHA);

		sprintf(sGaribs, "%d/%d", pTheseScores->nGaribs, pTheseScores->nTotalGaribs);
		NEW_TEXT(126, STATS_YOURG_Y+4, 128,128,0, 255, 4096,4096, FALSE, sGaribs, TRUE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);

		sprintf(sGaribs, "%d/%d", pHiScores[pGameInfo->level].nGaribs, pTheseScores->nTotalGaribs);
		NEW_TEXT(126, STATS_BESTG_Y+4, 128,128,0, 255, 4096,4096, FALSE, sGaribs, TRUE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);

	}
	else //for boss levels
	{
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, STATS_YOURG_Y+16, 128,128,0, 255,4096,4096, FALSE,fontFindLangString(STR_BONUS_OPEN) , TRUE);
#else
		NEW_TEXT(256, STATS_YOURG_Y+16, 128,128,0, 255,4096,4096, FALSE, "BONUS LEVEL NOW OPEN", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);
		
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, STATS_YOURG_Y+42, 128,128,0, 255,4096,4096, FALSE, fontFindLangString(STR_BONUS_OPEN+1), TRUE);
#else
		NEW_TEXT(256, STATS_YOURG_Y+42, 128,128,0, 255,4096,4096, FALSE, "IN PORTAL ROOM", TRUE);
#endif
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[2];
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);


	}

	for(loop=0; loop < 2; loop++)
	{
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, STATS_MENU_Y+(loop*25), 128,128,0,255, 4096,4096, TRUE, fontFindLangString(statsOptionsIds[loop]), TRUE);
#else
		NEW_TEXT(256, STATS_MENU_Y+(loop*25), 128,128,0,255, 4096,4096, TRUE, statsOptions[loop], TRUE);
#endif
		pText[loop]=mtext;
		mtext->flags=TEXT_SHADED;
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);
	}
	UpDownReset();
	selection = 1;


	MenuFadeIn();
	while(1)
	{
//		int flash=(((iframe>>6)&31)>10)?255:0;

		selection = UpDownCycle(selection,2);
		for(loop=0; loop < 2; loop++)
		{
			if(loop == selection)
			{
				pText[loop]->font=fontList[0];
				SETRGBC(pText[loop]->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
				SETRGBC(pText[loop]->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
				pText[loop]->flags|=TEXT_ANIMATED;
			}
			else
			{
				pText[loop]->flags&=-1-TEXT_ANIMATED;
				pText[loop]->font=fontList[1];
				SETRGBC(pText[loop]->r,128,128,0,FULLALPHA);
				SETRGBC(pText[loop]->r1,128,40,8,FULLALPHA);
			}
		}

/*
		if(pTheseScores->betterTime)
		{

			SETRGBC(pTime->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
			SETRGBC(pTime->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
		

		}

		if(pTheseScores->betterGaribs)
		{
			SETRGBC(pGaribs->r,0,150+(rsin(((menuFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
			SETRGBC(pGaribs->r1,0,75+(rsin((menuFrame*100) MOD 4096)/82),200,FULLALPHA);
		
		}*/

		Start_Loop();
		menuPrintBackStatic();
		MenuDrawFade();

#if PALMODE==YES
		DrawBoxOutline(-180,45,360,70,0,0,0,2,4);
		DrawBox(-180,45,360,70,40,40,120,1,4);
#else
		DrawBoxOutline(-180,52,360,58,0,0,0,2,4);
		DrawBox(-180,52,360,58,40,40,120,1,4);
#endif

		ShowText();
		End_Loop(framerate);


		if ((debounce[0]&PAD_CROSS) && !fadeout && !fadein)
		{
			MenuFadeOut();
			exiting=1;
		}
		menuFrame++;

		if((exiting)&&(fader<=1))
			break;
	}


	overlayClearAll();
	ClearAllText();

// return 0 for "save required", 1 for "carry on"
// so gameflow can free stuff before going to the savegame
	return(selection);
/*
	switch(selection)
	{
		case 0:
			MenuFadeIn();
			MemCardControl(MEMCARD_SAVE);
			break;
		default:
			break;
	}
*/
}

/*****************************************************************************************************/
//--------------------------------------------------------------------------

int menuShowMe(int menu)
{
	int c,i,j;
	TEXT *pText[8];
	GsF_LIGHT light;

	int menuLit=0;

 	light.vx = -2896;
	light.vy = -2896;
	light.vz = 0;
	SETRGBC(light.r,255>>1,246>>1,255>>1,0);

	GsSetFlatLight(0, &light);

	overlaySetupAndAdd(&hand, NULL, 0,0, 0, 0);
	overlayFindFrames(&hand, "GLOB");

	TEXTSETFONT(fontList[0]);
	for(i=0; i<menuLength[menu]; i++)
	{
		if(!(menuItem[menuStart[menu]+i].flags&1))
		{
			NEW_TEXT(menuItem[menuStart[menu]+i].x, menuItem[menuStart[menu]+i].y,
				 255,255,255,255, 3277,3277, FALSE, menuItem[menuStart[menu]+i].sText, TRUE);
			pText[i]=mtext;
		}
	}

	i=0;
	for(;;)
	{
		c=0;
		Start_Loop();

		menuPrintBack(zoom);

		hand.xPos=menuItem[menuStart[menu]+menuLit].hx;
		hand.yPos=menuItem[menuStart[menu]+menuLit].hy;

		menuGetUpDown(&menuLit, menuLength[menu]);

		ZEROVECTOR(&p3DLetters->position);

		p3DLetters->world.scalekeys->vect.x=4096;
		p3DLetters->world.scalekeys->vect.y=4096;
		p3DLetters->world.scalekeys->vect.z=4096;

		p3DLetters->world.rotatekeys->vect.x=0;
		p3DLetters->world.rotatekeys->vect.y=0;
		p3DLetters->world.rotatekeys->vect.z=0;

		p3DLetters->world.movekeys->vect.x=0;
		p3DLetters->world.movekeys->vect.y=0;
		p3DLetters->world.movekeys->vect.z=0;


		p3DLetters->globalscale.vx=4096;
		p3DLetters->globalscale.vy=4096;
		p3DLetters->globalscale.vz=4096;

		ZEROVECTOR(&p3DLetters->world.rotate);

		ZEROVECTOR((VECTOR *)&menuCam.vrx);
		menuCam.vrx=280;
		menuCam.vry=410;

		COPYVECTOR((VECTOR *)&menuCam.vpx, (VECTOR *)&menuCam.vrx);
		menuCam.vpz=-640;

		GsSetRefView2L(&menuCam);

		i++;
		if(i==60) i=121;
		if(i>150) i=121;

		p3DLetters->world.scalekeys->time=i;
		p3DLetters->world.movekeys->time=i;
		p3DLetters->world.rotatekeys->time=i;

		objectSetAnimation(p3DLetters, i);
		objectDraw(p3DLetters);

		// draw losenges now
		pLosenge->position.vz=0;

		pLosenge->globalscale.vx=5120;
		pLosenge->globalscale.vy=5120;
		pLosenge->globalscale.vz=5120;

		for(j=0; j<menuLength[menu]; j++)
		{
			if(!(menuItem[menuStart[menu]+j].flags&1))
			{
				if(j==menuLit)
					pText[j]->scaleX=pText[j]->scaleY=4096;
				else
					pText[j]->scaleX=pText[j]->scaleY=3277;
			}

			if(!(menuItem[menuStart[menu]+j].flags&2))
			{
				pLosenge->position.vx=menuItem[menuStart[0]+j].lx;
				pLosenge->position.vy=menuItem[menuStart[0]+j].ly;

				objectSetAnimation(pLosenge, i&31);
				objectDraw(pLosenge);
			}
		}

		ShowText();
		overlayPrintAll();

		End_Loop(0);

		if(MENUSELECT(0))
		{
			sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
			break;
		}

		//if(debounce[0]&PAD_CIRCLE)
		//{
		//	menuLit=~0;
		//	break;
		//}
	}

	// get rid of menu text
	ClearAllText();
	overlayClearAll();

	return(menuLit);
}
/*****************************************************************************************************/


/****************************************************************************************************/
// Pause menu stuff moved here so we're not fighting over gameflow so much...

int menuLit=0;
int PauseItems = 0;

TEXT *cp_text;
TEXT *cheat1_text;
TEXT *cheat2_text;
int pause_cp = -1;

signed char pause_item_continue;
signed char pause_item_help;
signed char pause_item_checkpoint;
signed char pause_item_castle;
signed char pause_item_quit;
signed char pause_item_callball;
signed char pause_item_winlevel;

TEXT *pauseMenuItem[8];

//------------------------------------------------------------------
//
//------------------------------------------------------------------

int CheckpointAllowed()
{
	if(level == SPACEBOSS2)
		return FALSE;

	if(	handpower_timer != 0 && handpower_type == SPELL_ROTORBLADES)
		return FALSE;

	if(GloveCtrl.handOnBall || GloveCtrl.ballWithHand)
	{
		if(!BallCtrl.ballOnGround)
			return FALSE;
	}
	else
	{
		if(!(GloveCtrl.onGround))
			return FALSE;
	}
	return TRUE;
}
//------------------------------------------------------------------
//
//------------------------------------------------------------------

void pauseBegin()
{
	if(GloveCtrl.levelFinished!=0)
		return;

	gameCtrl.fadeIn=0;
	gameCtrl.state=FALSE;
	gameCtrl.gameActive=FALSE;
	gameCtrl.PauseActive = TRUE;
	//gameCtrl.handFrameRate=Glover.animInfo->speed;//animate(&Glover);
	//Glover.animInfo->speed=0;
	ActorStartRoll(pBallPSA,0,0);
	gloveVel.vx=gloveVel.vz=0;
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void pauseSetText()
{
	int i;
	PauseItems = 0;

	menuLit = 0;	//"continue"

	messctrl.font=fontList[0];

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 80+16*PauseItems, 128,128,8,255, 4096,4096, TRUE, fontFindLangString(STR_PAUSED), TRUE);
#else
	NEW_TEXT(256, 80+16*PauseItems, 128,128,8,255, 4096,4096, TRUE, "PAUSED", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;


	pause_item_continue = PauseItems;
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, fontFindLangString(STR_PAUSE_CONTINUE), TRUE);
#else
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, "CONTINUE", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;
	pause_item_checkpoint = -1;


	pause_item_help = PauseItems;
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, fontFindLangString(STR_HELPOFF), TRUE);
#else
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, "HELP OFF", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;

	

	if(level > HUB8 && level != CAVE)
	{
		pause_item_castle = PauseItems;
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, fontFindLangString(STR_BACKTOSTLE), TRUE);
#else
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, "BACK TO CASTLE", TRUE);
#endif
		pauseMenuItem[PauseItems++]=mtext;
	}
	else
	{
		pause_item_castle = -1;
	}

	if(CheckpointAllowed())
	{
		pause_item_checkpoint = PauseItems;
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE,fontFindLangString(STR_CHECKPOINT) , TRUE);
#else
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "CHECKPOINT 0", TRUE);
#endif
		pauseMenuItem[PauseItems++]=mtext;

		pause_cp = lasthoopused;
	}
	else
	{
		pause_item_checkpoint = -1;
		pause_cp = -1;
	}

	pause_item_quit = PauseItems;
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE,fontFindLangString(STR_QUIT) , TRUE);
#else
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, TRUE, "QUIT", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;

/*
	pause_item_callball = PauseItems;
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "CALL BALL", TRUE);
	pauseMenuItem[PauseItems++]=mtext;

//	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "POWERWHACK", TRUE);
	pause_item_winlevel = PauseItems;
	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "WIN LEVEL", TRUE);
	pauseMenuItem[PauseItems++]=mtext;

*/

	if(cheatActivated & SUMMON_BALL_CHEAT)
	{
		pause_item_callball = PauseItems;
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, fontFindLangString(STR_CALLBALL), TRUE);
#else
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "CALL BALL", TRUE);
#endif
		pauseMenuItem[PauseItems++]=mtext;
	}
	else
	{
		pause_item_callball = -1;
	}

//	NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "POWERWHACK", TRUE);
	if(cheatActivated & WIN_LEVEL_CHEAT)
	{
		pause_item_winlevel = PauseItems;
#ifdef MULTI_LANGUAGE
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, fontFindLangString(STR_WINLEVEL), TRUE);
#else
		NEW_TEXT(256, 90+16*PauseItems, 128,128,128,255, 4096,4096, FALSE, "WIN LEVEL", TRUE);
#endif
		pauseMenuItem[PauseItems++]=mtext;
	}
	else
	{
		pause_item_winlevel = -1;
	}


	for(i = 1; i < PauseItems;i++)
	{
		pauseMenuItem[i]->scaleX=3072;
		pauseMenuItem[i]->scaleY=3072;
	}

}
//------------------------------------------------------------------
//
//------------------------------------------------------------------

void pauseSetConfirmText()
{
	int i;
	PauseItems = 0;

	menuLit = 1;	//NO

	messctrl.font=fontList[0];

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 80+16*PauseItems, 128,128,8,255, 4096,4096, TRUE, fontFindLangString(STR_AREYOUSURE), TRUE);
#else
	NEW_TEXT(256, 80+16*PauseItems, 128,128,8,255, 4096,4096, TRUE, "ARE YOU SURE?\0", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;
	mtext->font=fontList[1];

	
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 110+20*PauseItems, 128,128,128,255, 4096,4096, TRUE, fontFindLangString(STR_YES2), TRUE);
#else
	NEW_TEXT(256, 110+20*PauseItems, 128,128,128,255, 4096,4096, TRUE, "YES\0", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;
	


#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 110+20*PauseItems, 128,128,128,255, 4096,4096, TRUE, fontFindLangString(STR_NO2), TRUE);
#else
	NEW_TEXT(256, 110+20*PauseItems, 128,128,128,255, 4096,4096, TRUE, "NO\0", TRUE);
#endif
	pauseMenuItem[PauseItems++]=mtext;
	



	for(i = 1; i < PauseItems;i++)
	{
		pauseMenuItem[i]->scaleX=3072;
		pauseMenuItem[i]->scaleY=3072;
	}

}

/****************************************************************************************************/

void pauseEnd()
{
	int i;
	for(i=0; i<PauseItems; i++)
	{
		SubText(pauseMenuItem[i]);
	}
}

/****************************************************************************************************/

int pauseFrame=0;
UBYTE confirmExit=0;
void pauseDisplay()
{
//	register	GsOTA 	*ot = (GsOTA*)(PolyList->org+1);
	int		x,y,i;
	int		displayFlag=FALSE;


	if(fadeout)
		return;


//	sprintf(&pauseMenuItem[pause_cheatmenupos+1]->message[0],"POWERWHACK %d",cheat_any_ball_powerwhacks);

	if(gameCtrl.state==FALSE)// pause on
	{
		if (gameCtrl.fadeIn<60)
		{
			gameCtrl.fadeIn+=4;
			if(gameCtrl.fadeIn>=60)
				pauseSetText();

		}
		else
		{
			displayFlag=TRUE;
		}

		gameCtrl.fadeOut=gameCtrl.fadeIn;


		x = (gameCtrl.fadeIn*182)/60;
		y = (gameCtrl.fadeIn*70)/60;

		DrawBoxOutline(-x,-y,x*2,y*2,0,0,0,2,4);
		DrawBox(-x,-y,x*2,y*2,40,40,120,1,4);
		

// *** NB NB NB!!! ***
// Do *NOT* alter the pauseMenuItems unless displayFlag has been set !
// (coz they won't have been mallocced)

		if(displayFlag)
		{
#ifdef MULTI_LANGUAGE
			if(!confirmExit)
			{
				if(noHintText==FALSE)
				{
					sprintf(&pauseMenuItem[pause_item_help]->message[0],fontFindLangString(STR_HELPON));
				}
				else
				{
					sprintf(&pauseMenuItem[pause_item_help]->message[0],fontFindLangString(STR_HELPOFF));
				}
			}
#else
			if(!confirmExit)
			{
				if(noHintText==FALSE)
				{
					pauseMenuItem[pause_item_help]->message[6]='N';
					pauseMenuItem[pause_item_help]->message[7]=0;
				}
				else
				{
					pauseMenuItem[pause_item_help]->message[6]='F';
					pauseMenuItem[pause_item_help]->message[7]='F';
					pauseMenuItem[pause_item_help]->message[8]=0;
				}
			}
#endif
			if((pause_item_checkpoint >= 0)&&(!confirmExit))	// Woohoo! Random poke bug solved!
			{
				if(numberofhoops == 1 )
				{
#ifdef MULTI_LANGUAGE
					sprintf(pauseMenuItem[(int)pause_item_checkpoint]->message,fontFindLangString(STR_RESTART));
#else
					sprintf(pauseMenuItem[(int)pause_item_checkpoint]->message,"RESTART LEVEL");
#endif
				}

				if((pause_cp >= 0 )&&(numberofhoops >1 ))
				{
#ifdef MULTI_LANGUAGE
					int len;
					len = strlen(fontFindLangString(STR_CHECKPOINT));
					sprintf(&pauseMenuItem[(int)pause_item_checkpoint]->message[len]," %d/%d",pause_cp+1,numberofhoops);
#else
					sprintf(&pauseMenuItem[(int)pause_item_checkpoint]->message[11],"%d/%d",pause_cp+1,numberofhoops);
#endif
				}
			}

		  //	menuGetUpDown(&menuLit, PauseItems-1);
	
			menuLit=UpDownCycle(menuLit,PauseItems-1);
			gameCtrl.select=menuLit;

			if(confirmExit)
			{
				if(MENUSELECT(0))
				{
					if(gameCtrl.select == 0) //confirm exit
					{
						pauseEnd();
						gameCtrl.dropOutFlag=GAME_EXITED;
						MenuFadeOut();
						gameCtrl.state = TRUE;
						gameCtrl.gameActive=TRUE;
						gameCtrl.PauseActive = FALSE;
						gameCtrl.fadeIn=0;
						gameCtrl.fadeOut=0;
						showGameOver=255;
						confirmExit=0;
					}
					else //no, we don't want to exit
					{
						pauseEnd();
						pauseSetText();
						confirmExit=0;
					}
				}
				
			}
			else if(cheatCheck())
			{
				pauseEnd();
				gameCtrl.state = TRUE;
			}
			else if(MENUSELECT(0))
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);

				if(gameCtrl.select+1 == pause_item_continue)
				{
					pauseEnd();
					gameCtrl.state = TRUE;
				}
				else if(gameCtrl.select+1 == pause_item_help)
				{

					if(noHintText)
						noHintText=FALSE;
					else
						noHintText=TRUE;
				}
				else if(gameCtrl.select+1 == pause_item_castle)
				{
					pauseEnd();
					gameCtrl.dropOutFlag=GAME_BACKTOCASTLE;
					MenuFadeOut();
					gameCtrl.state = TRUE;
					gameCtrl.gameActive=TRUE;
					gameCtrl.PauseActive = FALSE;
					gameCtrl.fadeIn=0;
					gameCtrl.fadeOut=0;
				}
				else if(gameCtrl.select+1 == pause_item_quit)
				{
					pauseEnd();
				/*	gameCtrl.dropOutFlag=GAME_EXITED;
					MenuFadeOut();
					gameCtrl.state = TRUE;
					gameCtrl.gameActive=TRUE;
					gameCtrl.PauseActive=TRUE;
					gameCtrl.fadeIn=0;
					gameCtrl.fadeOut=0;
					showGameOver=255;*/
					pauseSetConfirmText();
					confirmExit=1;
					gameCtrl.select=1;
				}
				else if(gameCtrl.select+1 == pause_item_checkpoint)
				{
					pauseEnd();
					gameCtrl.state = TRUE;
					Use_Hoop(pause_cp);
				}
				else if(gameCtrl.select+1 == pause_item_callball)
				{
					cheatDoCallBall();
					pauseEnd();
					gameCtrl.state = TRUE;

				}
				else if(gameCtrl.select+1 == pause_item_winlevel)
				{
					cheatDoWinLevel();


//					cheat_any_ball_powerwhacks = !cheat_any_ball_powerwhacks;
					pauseEnd();
					gameCtrl.state = TRUE;
					gameCtrl.gameActive=TRUE;
					gameCtrl.PauseActive = FALSE;
					gameCtrl.fadeIn=0;
					gameCtrl.fadeOut=0;
				}

			}


// Left/Right on the checkpoint selector, with a botch to skip unavailable ones
			if(gameCtrl.select+1 == pause_item_checkpoint)
			{
				int temp;
				temp = pause_cp;
				menuGetLeftRight(&temp, 200);
				if(temp != pause_cp)
					pause_cp = nextHoopAvailable(pause_cp, temp - pause_cp);	// find the next one in that direction
			}

/*
			if(gameCtrl.select+1==pause_cheatmenupos+1)
			{
				int temp;
				temp = cheat_any_ball_powerwhacks;
				menuGetLeftRight(&temp, 2);
				cheat_any_ball_powerwhacks = temp;
			}
*/

			pauseFrame++;

			pauseMenuItem[0]->flags=TEXT_SHADED;
			SETRGBC(pauseMenuItem[0]->r, 128,128,0,255);
			SETRGBC(pauseMenuItem[0]->r1, 128,40,8,255);

			for(i=1; i<PauseItems; i++)
			{
				if(gameCtrl.select==i-1)
				{
					pauseMenuItem[i]->scaleX=4096;
					pauseMenuItem[i]->scaleY=4096;
//#ifdef MULTI_LANGUAGE
// French Checkpoint's now been reduced in width, so this ain't necessary
//					if(language==1 && i == pause_item_checkpoint)
//					{
//						pauseMenuItem[i]->scaleX = 3400;	// deal with a long string
//					}
//#endif
					pauseMenuItem[i]->font=fontList[0];
					pauseMenuItem[i]->flags=TEXT_SHADED|TEXT_ANIMATED;
				
					SETRGBC(pauseMenuItem[i]->r,0,150+(rsin(((pauseFrame*100) MOD 4096)+1024)/82),200,FULLALPHA);
					SETRGBC(pauseMenuItem[i]->r1,0,75+(rsin((pauseFrame*100) MOD 4096)/82),200,FULLALPHA);
				
				}
				else
				{
					pauseMenuItem[i]->scaleX=4096;
					pauseMenuItem[i]->scaleY=4096;
					pauseMenuItem[i]->font=fontList[1];
					pauseMenuItem[i]->flags=TEXT_SHADED;
					SETRGBC(pauseMenuItem[i]->r, 128,128,0,255);
					SETRGBC(pauseMenuItem[i]->r1, 128,40,8,255);
				}
			}


//			overlayPrintAll();
		}
	}
	else if (gameCtrl.fadeOut>0)
	{
		gameCtrl.fadeOut-=4;
		x = (gameCtrl.fadeOut*182)/60;
		y = (gameCtrl.fadeOut*70)/60;

		DrawBoxOutline(-x,-y,x*2,y*2,0,0,0,2,4);
		DrawBox(-x,-y,x*2,y*2,40,40,120,1,4);
	}
	else
	{
		//gameCtrl.state = TRUE;
		gameCtrl.gameActive=TRUE;
		gameCtrl.PauseActive = FALSE;
		gameCtrl.fadeIn=0;
		gameCtrl.fadeOut=0;
		//Glover.animInfo->speed=gameCtrl.handFrameRate;
	}

/*
	ClearText();

	overlaySub(&paused);
	for(i = 0; i < PauseItems; i++)
	{
		overlaySub(PauseMenuItem+i);
	}
*/
}


/****************************************************************************************************/
/****************************************************************************************************/
/****************************************************************************************************/
ULONG	numTips;
ULONG	*tipRecStart;
UBYTE	*tipDataStart;
ULONG	*tipNumbersStart;
int		tipRemappedNumber;

unsigned short	frameCount=0;

	ULONG	*recordPtr;
	UBYTE	*textPtr;
	ULONG	textLines,loop,lineStart,lineEnd;
// put back leter here for debug only

//------------------------------------------------------------------
//
//------------------------------------------------------------------

void	tipDisplay(void)
{

//	POLY_G4 *si = (POLY_G4 *) GsOUT_PACKET_P; 
//	register	GsOTA 	*ot = (GsOTA*)(PolyList->org+1);
	int		x,y,i;
	int		displayFlag=FALSE;

	
	if(gameCtrl.state==FALSE)// pause on
	{
		if (gameCtrl.fadeIn==0) tipBegin();

		recordPtr=(void*)tipRecStart[tipRemappedNumber];
	
		recordPtr--;
		textLines=(ULONG)recordPtr[0];
		recordPtr++;

		if (gameCtrl.fadeIn<60) gameCtrl.fadeIn+=4;
		else displayFlag=TRUE;
		gameCtrl.fadeOut=gameCtrl.fadeIn;
		i=gameCtrl.fadeIn;

		x = (gameCtrl.fadeIn*208)/60;
		y = (gameCtrl.fadeIn*60)/60;

		DrawBoxOutline(-x,-y,x*2,y*2,0,0,0,2,4);
		DrawBox(-x,-y,x*2,y*2,40,40,120,1,4);

		if(displayFlag)
		{
			if(debounce[0])
			{
				sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);

				lineStart=lineEnd;
				lineEnd+=6;
				if(lineEnd>=textLines)
					lineEnd=textLines;

				if(lineStart>=textLines)
					gameCtrl.state=TRUE;
			}
				
			if(lineEnd>=textLines)		// necessary for tips with < 6 lines total
				lineEnd=textLines;

			textReset();				// Setup font scale ect
			messctrl.font=fontList[2];

			spriteReset();
			
			sprctrl.scalex=2048;
			sprctrl.scaley=2048;

			frameCount++;
			spritePrint(SPR_mrtipbase+(frameCount MOD 12),-x+36,-y+36,0);
			
			sprctrl.stretch=1;
			sprctrl.scalex=infoTextScale;
			sprctrl.scaley=infoTextScale;
			SETRGBC(sprctrl.r,128,128,0,0);
			SETRGBC(sprctrl.r1,128,40,8,TRUE);


			//textPrintf( "MR TIP");
//			TEXTSETPOS(140,80 );
//			textPrintf( "NUMBER %d/%d (%d lines)",GloveCtrl.tipNumber,numTips,textLines);

			for (loop=lineStart;loop<lineEnd;loop++)
			{
				textPtr=(void *)(ULONG)recordPtr[loop];
				TEXTSETPOS((72),(90+((loop-lineStart)*14)) );
				textPrintf( textPtr );
			}

			if((lineEnd)<textLines)
			{

				SETRGBC(sprctrl.r,128,128,128,0);
				SETRGBC(sprctrl.r1,0,0,128,TRUE);

//				TEXTSETPOS((360),(90+(6*14)) );
#ifdef MULTI_LANGUAGE
				{
					char *ptr;
					ptr = fontFindLangString(STR_MORE);
					TEXTSETPOS((360 +8*7- 8 *(strlen(ptr))),(90+(6*14 - 4)) );
				textPrintf(ptr);
				}
#else
				TEXTSETPOS((360),(90+(6*14 - 4)) );
				textPrintf( "MORE...");
#endif
			}
			//reset sprite colour
			SETRGBC(sprctrl.r,128,128,128,0);
			SETRGBC(sprctrl.r1,128,128,128,TRUE);
		}
	}
	else if (gameCtrl.fadeOut>0)
	{
		gameCtrl.fadeOut-=4;

		i=gameCtrl.fadeIn;
		

		x = (gameCtrl.fadeOut*208)/60;
		y = (gameCtrl.fadeOut*60)/60;

		DrawBoxOutline(-x,-y,x*2,y*2,0,0,0,2,4);
		DrawBox(-x,-y,x*2,y*2,40,40,120,1,4);

	}
	else
	{
		gameCtrl.MrTipActive=FALSE;
		gameCtrl.gameActive=TRUE;
		GloveCtrl.tipFlag=FALSE;

		gameCtrl.fadeIn=0;
		gameCtrl.fadeOut=0;
		tipEnd();
	}
	ClearText();
}

/****************************************************************************************************/
/****************************************************************************************************/
/****************************************************************************************************/

UBYTE *tipaddr = NULL;
void	Load_And_Init_Tips(void)
{
ULONG	*filePtrsStart;
//UBYTE	*fileDataStart;	
ULONG	headerSize;
ULONG	numLines,loop,loop1;

	switch(language)
	{
	case 0:
		tipaddr = (void *)BFF_FindObject(BFF_TIP_ID_ENG, 0);
		break;
	case 1:
		tipaddr = (void *)BFF_FindObject(BFF_TIP_ID_FRE, 0);
		break;
	case 2:
		tipaddr = (void *)BFF_FindObject(BFF_TIP_ID_GER, 0);
		break;
#ifdef MULTI_LANGUAGE
	case 3:
		tipaddr = (void *)BFF_FindObject(BFF_TIP_ID_ITA, 0);
		break;
#endif
	}

	if(!tipaddr)	// no tips for this level
	{
		DB("no tips on this level\n");
		return;
	}
	tipaddr = ADD2POINTER(tipaddr,8);

	memcpy(&numTips,&tipaddr[0],4);// int = Number of tips
	memcpy(&headerSize,&tipaddr[4],4);// int = offset to the text data


	DB("num tips=%d\n",(int)numTips);

	tipDataStart=&tipaddr[headerSize];	// addr of the text data

	tipNumbersStart=(ULONG*)&tipaddr[8];	// pointer to a collection of ints
	tipRecStart=(ULONG*)&tipaddr[8+(numTips*4)];	// pointer to a collection of offsets (which we'll now convert to pointers)

	DB("hsize=%d 0x%x 0x%x 0x%x\n",headerSize,tipDataStart,tipRecStart,tipNumbersStart);

//	offset=(ULONG*)&tipaddr[8+(numTips*4)];
	filePtrsStart=(ULONG*)&tipaddr[8+(numTips*4)];		// get 1st prt addr

// Somewhere along the line, I've screwed these offsets in tipmaker, so they get filled in by the next loop instead
// (sorry bout that!), luv Fred
/*
	for (loop1=0;loop1<numTips;loop1++) //convert record offsets to mem. ptrs
	{
		DB("offset %d = %d\n",loop1,*(filePtrsStart));
		*(filePtrsStart) +=(ULONG)offset;
		filePtrsStart++;
	}
*/

	filePtrsStart += numTips;	

	for (loop1=0;loop1<numTips;loop1++) //convert text line offsets to mem. ptrs
	{

//		DB("wrong = %d\n",((ULONG)(tipRecStart[loop1])) - ((ULONG)(filePtrsStart+1)));
		tipRecStart[loop1] = (ULONG)(filePtrsStart+1);

		numLines=(ULONG)filePtrsStart[0];
//		DB("num lines at conversion time = %d\n",numLines);
		filePtrsStart++;
		for (loop=0;loop<numLines;loop++)
		{
			*(filePtrsStart) +=(ULONG)tipDataStart;
			filePtrsStart++;
		}
	}
}

void Free_Tips()
{
	tipaddr = NULL;
//	if(tipaddr)
//		FREENULL(tipaddr);	// tipaddr is now in the BFF
}

/****************************************************************************************************/
/****************************************************************************************************/
/****************************************************************************************************/

/****************************************************************************************************/

void	tipBegin(void)
{
	DB("Beginning tip\n");

	gameCtrl.fadeIn=0;
	//gameCtrl.handFrameRate=Glover.animInfo->speed;//animate(&Glover);
	//Glover.animInfo->speed=0;
	ActorStartRoll(pBallPSA,0,0);
	enemyDimTip(GloveCtrl.tipNumber);

	for(tipRemappedNumber = 0; tipRemappedNumber < numTips; tipRemappedNumber++)
	{
		if(tipNumbersStart[tipRemappedNumber] == GloveCtrl.tipNumber)
			break;
	}
	if(tipRemappedNumber == numTips)
	{
		tipRemappedNumber = 0;
	}
	lineStart=0;
	lineEnd=6;
	gameCtrl.gameActive=FALSE;

}

/****************************************************************************************************/
void	tipEnd(void)
{
	DB("Ending tip\n");
	//Glover.animInfo->speed=gameCtrl.handFrameRate;

}

//------------------------------------------------------------------------------------
// Credit stuff
//------------------------------------------------------------------------------------
UBYTE *creditFile;

void ShowCredits()
{
	int i,n,menuFrame=0,fsize=0;
//	int lineNum=0;
	TEXT *pText[20];
	UBYTE *linePtr,*temp;

	//load in the text file

#ifndef MULTI_LANGUAGE
	creditFile=fileLoad("TEST\\CREDITS.TXT",&fsize);
	linePtr=creditFile;
#else
	switch(language)
	{
	case 0:
		creditFile=fileLoad("TEST\\CRED_ENG.TXT",&fsize);
		break;
	case 1:
		creditFile=fileLoad("TEST\\CRED_FRE.TXT",&fsize);
		break;
	case 2:
		creditFile=fileLoad("TEST\\CRED_GER.TXT",&fsize);
		break;
	case 3:
		creditFile=fileLoad("TEST\\CRED_ITA.TXT",&fsize);
		break;

	}
	linePtr=creditFile;
#endif

	XA_SetMusicGoing(TRACK_XTRA5, 1);
	ClearAllText();
	//set up 20 text strings (20 should be enough!)
	for(i=0;i<20;i++)
	{
		NEW_TEXT(256, 100+(i*20), 128,128,0, 255, 4096,4096, FALSE, "text\0", TRUE);
		mtext->flags=TEXT_SHADED;
		mtext->font=fontList[1];
		SETRGBC(mtext->r1,128,40,8,FULLALPHA);
		pText[i]=mtext;
	}

	
	while (linePtr<(creditFile+fsize))
	{
		//every 20 frames remove top line and add another
		//do this by making linePtr point to the current 2nd line
		if((menuFrame MOD 20)==0)
		{
			while((*linePtr)!=0x0D)
				linePtr++;
			linePtr+=2;
		}

		if(pad[0] & PAD_DOWN)
		{
			for(i = 0; i < 2; i++)
			{
				menuFrame++;
				if((menuFrame MOD 20)==0)
				{
					while((*linePtr)!=0x0D)
						linePtr++;
					linePtr+=2;
				
				}
			}
		}
		//copy next 20 lines of text into the 20 text strings
		temp=linePtr;
		for(i=0;i<20;i++)
		{
			pText[i]->font=fontList[1];
			pText[i]->y=-20+(i*20)-(menuFrame MOD 20); //scroll smoothly
			
			if(temp>=(creditFile+fsize))
				break;

			n=0;
			while(temp[n]!=0x0D)
			{
				//check for a heading(1st letter NOT upper case(?!?))
				if(n==0)
				{
					if(!((temp[n]>='A')&&(temp[n]<='Z')))
					{
						SETRGBC(pText[i]->r,200,200,200,FULLALPHA);
						SETRGBC(pText[i]->r1,0,0,200,FULLALPHA);

						if((temp[n]>='a')&&(temp[n]<='z'))
							pText[i]->message[n]=temp[n]+('A'-'a'); //make it upper case
						else if((temp[n]=='<')||(temp[n]=='>')||(temp[n]=='[')||(temp[n]>=']'))
						{
							
							SETRGBC(pText[i]->r,128,128,0,FULLALPHA);
							SETRGBC(pText[i]->r1,128,40,8,FULLALPHA);
							pText[i]->message[n]=temp[n];
							pText[i]->font=fontList[2];	 //special characters are only in tipfont
						}
						else
							pText[i]->message[n]=temp[n]; //numbers etc
					}
					else
					{
						SETRGBC(pText[i]->r,128,128,0,FULLALPHA);
						SETRGBC(pText[i]->r1,128,40,8,FULLALPHA);
						
						pText[i]->message[n]=temp[n];
					}
				}
				else
					pText[i]->message[n]=temp[n];

				n++;
			}

			pText[i]->message[n]=0;
			pText[i]->scaleX=pText[i]->scaleY=4096;
			pText[i]->centre=1;

			n+=2;
			temp+=n;
		}

		//draw everything
		Start_Loop();
		ShowText();
		menuPrintBack(zoom);	// zoom = 1024

		End_Loop(0);

		//get input
		if (debounce[0]&PAD_CROSS)
		{
			debounce[0]=0;
			FREENULL(creditFile);
			ClearAllText();
			XA_SetMusicGoing(TRACK_MAINMENU, 1);
			return;
		}
		if (debounce[0]&PAD_TRIANGLE)
		{
			debounce[0]=0;
			FREENULL(creditFile);
			ClearAllText();
			XA_SetMusicGoing(TRACK_MAINMENU, 1);
			return;
		}

		menuFrame++;
/*
		//fast forward
		if(pad[0] & PAD_DOWN)
		{
			menuFrame++;
			if(menuFrame MOD 2) //make sure menuFrame is even or check at top won't work
				menuFrame++;
		}
*/
	}

	ClearAllText();
	FREENULL(creditFile);
	XA_SetMusicGoing(TRACK_MAINMENU, 1);

}



//------------------------------------------------------------------
//
//------------------------------------------------------------------
UBYTE noHintText=0;

#ifndef MULTI_LANGUAGE

void ShowHintText()
{
//	int mode =0;
	int ypos;//hand alone
	static char buf[50];
	short action = GloveCtrl.action;

	if(debounce[0] & PAD_SELECT)
		noHintText=((noHintText)?0:1);

	if(gameInfo.keyRecordFlag==PLAYBACK)
		noHintText=TRUE;

//	if((gameCtrl.MrTipActive)||(!gameCtrl.gameActive)||(noHintText))
	if((!gameCtrl.gameActive)||(noHintText))
		return;

	//setup correct text settings
	sprctrl.scalex=sprctrl.scaley=4096;
	SETRGBC(sprctrl.r,128,128,0,0);
	SETRGBC(sprctrl.r1,128,40,8,0);
	sprctrl.shaded=1;
	sprctrl.center=0;
	messctrl.font=fontList[2];
	messctrl.justify=0;

	//ypos of first line
#if PALMODE==YES
	ypos=205;
#else
	ypos=195;
#endif


	//level specific cases
	if(level==SPACEBOSS2)
	{
		sprintf(buf,"%c FIRE",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;

		sprintf(buf,"%c LASER SHIELD",'&');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
		return;
	}
	else if(level==CARNIVALBONUS)
	{
		sprintf(buf,"%c FIRE",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;


		return;
	}
	else if(level==PREHISTORICBONUS)
	{
		sprintf(buf,"%c BOUNCE",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;


		return;
	}
	else if(level==FEARBONUS)
	{
		sprintf(buf,"%c BOUNCE",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;


		return;
	}

//	if(handpower_type == SPELL_ROTORBLADES)
	if(GloveCtrl.action == HAND_ROTOR)
	{
		sprintf(buf,"%c HOVER",'&');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
		sprintf(buf,"%c THRUST",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
		if(GloveCtrl.lastAction==HAND_JOINED && !BallCtrl.ballOnGround)
		{
			sprintf(buf,"%c DROP BALL",'<');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
		return;
	}


	//cross
	if(action==HAND_JUMP|| action == HAND_THROWAIM || action==HAND_PREWHACK|| (action == HAND_WHACK)|| (action == HAND_THROW))
	{
	}
	else if(GloveCtrl.handOnBall)
	{
		sprintf(buf,"%c JUMP",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else if(GloveCtrl.ballWithHand)
	{
		sprintf(buf,"%c BOUNCE BALL",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else
	{
		sprintf(buf,"%c JUMP",'%');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}

	//circle

	if(action==HAND_PREWHACK)
	{
	}
	else if(action == HAND_THROWAIM)
	{
		//if(pad[0] & PAD_CIRCLE)//held down
		if(InputState.aHeld && InputState.aStateChange)
		{
			sprintf(buf,"RELEASE %c TO THROW",'&');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
		else //tapped
		{
			sprintf(buf,"%c THROW",'&');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
	}
	else if(action == HAND_THROW || action==HAND_PREWHACK)
	{
	}
	else if(GloveCtrl.tipFlag)
	{
		sprintf(buf,"%c SHOW TIP",'&');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		sprintf(buf,"%c THROW BALL",'&');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else if(!GloveCtrl.handOnBall)
	{
		sprintf(buf,"%c POINT TO BALL",'&');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;

	}



	//square
	if(action == HAND_THROWAIM)
	{
	}
	else if(action == HAND_PREWHACK)
	{
	//	if(pad[0] & PAD_SQUARE)//held down
		if(InputState.cHeld && InputState.cStateChange)
		{
			sprintf(buf,"RELEASE %c TO SLAP",'#');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
		else //tapped
		{
			sprintf(buf,"%c SLAP",'#');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
	}
	else if(action == HAND_WHACK || action == HAND_THROW )
	{
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		sprintf(buf,"%c SLAP BALL",'#');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else if((handpower_type == SPELL_DEATH)||(handpower_type == SPELL_FROGGY))
	{
		sprintf(buf,"%c CAST SPELL",'#');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	
	}
	else if(action==HAND_JUMP)
	{
		sprintf(buf,"%c FIST SLAM",'#');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}

	else
	{
	    sprintf(buf,"%c-%c FIST SLAM",'%','#');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}

	//L2
	if((action == HAND_THROWAIM))
	{
	
		sprintf(buf,"%c CANCEL",'<');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	
	}
	else if((action == HAND_PREWHACK))
	{
		
		sprintf(buf,"%c CANCEL",'<');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
		
	}
	else if(action == HAND_WHACK || action == HAND_THROW || action== HAND_JUMP)
	{
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		sprintf(buf,"%c LEAVE BALL",'<');
		TEXTPRINTAT(24,ypos,buf);
		ypos-=15;
	}
	else if(GloveCtrl.handOnBall)
	{
		if((BallCtrl.inWaterFlag==0)&&(!BallCtrl.shallowWater))
		{
			sprintf(buf,"%c GET OFF BALL",'<');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
		else
		{
			sprintf(buf,"%c HOLD BALL",'<');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
		}
	}

	// R2 (which works all the time, but we need to keep the tips down to 4 lines, really!
	if(!GloveCtrl.handOnBall && !GloveCtrl.ballWithHand && BallCtrl.enabled)
	{
			sprintf(buf,"%c BALL SPELL",'>');
			TEXTPRINTAT(24,ypos,buf);
			ypos-=15;
	}
}
#else
void ShowHintText()
{
//	int mode =0;
	int ypos;//hand alone
	static char buf[50];
	short action = GloveCtrl.action;

	if(debounce[0] & PAD_SELECT)
		noHintText=((noHintText)?0:1);

	if(gameInfo.keyRecordFlag==PLAYBACK)
		noHintText=TRUE;

//	if((gameCtrl.MrTipActive)||(!gameCtrl.gameActive)||(noHintText))
	if((!gameCtrl.gameActive)||(noHintText))
		return;

	//setup correct text settings
	sprctrl.scalex=sprctrl.scaley=4096;
	SETRGBC(sprctrl.r,128,128,0,0);
	SETRGBC(sprctrl.r1,128,40,8,0);
	sprctrl.shaded=1;
	sprctrl.center=0;
	messctrl.font=fontList[2];
	messctrl.justify=0;

	//ypos of first line
#if PALMODE==YES
	ypos=205;
#else
	ypos=195;
#endif


	//level specific cases
	if(level==SPACEBOSS2)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_FIRE));
		ypos-=15;

		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_SHIELD));
		ypos-=15;
		return;
	}
	else if(level==CARNIVALBONUS)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_FIRE));
		ypos-=15;
		return;
	}
	else if(level==PREHISTORICBONUS)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_BOUNCE));
		ypos-=15;
		return;
	}
	else if(level==FEARBONUS)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_BOUNCE));
		ypos-=15;
		return;
	}

//	if(handpower_type == SPELL_ROTORBLADES)
	if(GloveCtrl.action == HAND_ROTOR)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_HOVER));
		ypos-=15;
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_THRUST));
		ypos-=15;
		if(GloveCtrl.lastAction==HAND_JOINED && !BallCtrl.ballOnGround)
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_DROP));
			ypos-=15;
		}
		return;
	}


	//cross
	if(action==HAND_JUMP|| action == HAND_THROWAIM || action==HAND_PREWHACK|| (action == HAND_WHACK)|| (action == HAND_THROW))
	{
	}
	else if(GloveCtrl.handOnBall)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_JUMP));
		ypos-=15;
	}
	else if(GloveCtrl.ballWithHand)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_BOUNCEBALL));
		ypos-=15;
	}
	else
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_JUMP));
		ypos-=15;
	}

	//circle

	if(action==HAND_PREWHACK)
	{
	}
	else if(action == HAND_THROWAIM)
	{
		//if(pad[0] & PAD_CIRCLE)//held down
		if(InputState.aHeld && InputState.aStateChange)
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_RELTHROW));
			ypos-=15;
		}
		else //tapped
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_THROW));
			ypos-=15;
		}
	}
	else if(action == HAND_THROW || action==HAND_PREWHACK)
	{
	}
	else if(GloveCtrl.tipFlag)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_TIP));
		ypos-=15;
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_THROWBALL));
		ypos-=15;
	}
	else if(!GloveCtrl.handOnBall)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_POINT));
		ypos-=15;

	}



	//square
	if(action == HAND_THROWAIM)
	{
	}
	else if(action == HAND_PREWHACK)
	{
	//	if(pad[0] & PAD_SQUARE)//held down
		if(InputState.cHeld && InputState.cStateChange)
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_RELSLAP));
			ypos-=15;
		}
		else //tapped
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_SLAP));
			ypos-=15;
		}
	}
	else if(action == HAND_WHACK || action == HAND_THROW )
	{
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_SLAPBALL));
		ypos-=15;
	}
	else if((handpower_type == SPELL_DEATH)||(handpower_type == SPELL_FROGGY))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_CASTSPELL));
		ypos-=15;
	
	}
	else if(action==HAND_JUMP)
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_1BUTSLAM));
		ypos-=15;
	}

	else
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_2BUTSLAM));
		ypos-=15;
	}

	//L2
	if((action == HAND_THROWAIM))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_CANCEL));
		ypos-=15;
	}
	else if((action == HAND_PREWHACK))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_CANCEL));
		ypos-=15;
		
	}
	else if(action == HAND_WHACK || action == HAND_THROW || action== HAND_JUMP)
	{
	}
	else if((GloveCtrl.ballWithHand)&&(!GloveCtrl.handOnBall))
	{
		TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_LEAVE));
		ypos-=15;
	}
	else if(GloveCtrl.handOnBall)
	{
		if((BallCtrl.inWaterFlag==0)&&(!BallCtrl.shallowWater))
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_GETOFF));
			ypos-=15;
		}
		else
		{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_HOLD));
			ypos-=15;
		}
	}

	// R2 (which works all the time, but we need to keep the tips down to 4 lines, really!
	if(!GloveCtrl.handOnBall && !GloveCtrl.ballWithHand && BallCtrl.enabled)
	{
			TEXTPRINTAT(24,ypos,fontFindLangString(STR_HLP_BALLSPELL));
			ypos-=15;
	}
}
#endif
//------------------------------------------------------------------
//
//------------------------------------------------------------------
int currentLetter=0;
int enterNameFrame=0;
char hi_clist[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ.,_!?";

int	EnterName(char *str,int firstTime)
{
	char buf[2];

	if(firstTime)
	{
		str[0]=0;
		str[1]=0;
		str[2]=0;
		currentLetter=0;
		enterNameFrame=0;
	}
	str[3]=0; //ensure text is only 3 letters long

	enterNameFrame++;


	if((nleftx[0]<-100)&&(enterNameFrame&1)&&(currentLetter>0))
	{
		debounce[0]=0;
		currentLetter--;
		sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
	}

	if((nleftx[0]>100)&&(enterNameFrame&1)&&(currentLetter<2))
	{
		debounce[0]=0;
		currentLetter++;
		sfxPlay(globalFX,SFX_GENERIC_BLEEP_3);
	}

	
	
	if((nlefty[0]<-100)&&(enterNameFrame&1))
	{
		if(str[currentLetter]<strlen(hi_clist)-1)
			str[currentLetter]++;
		else
			str[currentLetter]=0;

		sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
	}
	if((nlefty[0]>100)&&(enterNameFrame&1))
	{
		if(str[currentLetter]>0)
			str[currentLetter]--;
		else
			str[currentLetter]=strlen(hi_clist)-1;

		sfxPlay(globalFX,SFX_GENERIC_BLEEP_1);
	}



	buf[1]=0;

	if(currentLetter==0)
	{
		SETRGBC(sprctrl.r,0,150+(rsin(((enterNameFrame*100) MOD 4096)+1024)/82),200,0);
		SETRGBC(sprctrl.r1,0,75+(rsin((enterNameFrame*100) MOD 4096)/82),200,0);
		
	}		
	else
	{
		SETRGBC(sprctrl.r,128,128,0,0);
		SETRGBC(sprctrl.r1,128,40,8,0);
	}

	sprctrl.shaded=1;
	buf[0]=hi_clist[(int)str[0]];
	TEXTPRINTAT(195-textFindLineLen(buf)/2,128,&buf[0]);



	if(currentLetter==1)
	{
		SETRGBC(sprctrl.r,0,150+(rsin(((enterNameFrame*100) MOD 4096)+1024)/82),200,0);
		SETRGBC(sprctrl.r1,0,75+(rsin((enterNameFrame*100) MOD 4096)/82),200,0);
	}		
	else
	{
		SETRGBC(sprctrl.r,128,128,0,0);
		SETRGBC(sprctrl.r1,128,40,8,0);
	}

	sprctrl.shaded=1;
	buf[0]=hi_clist[(int)str[1]];
	TEXTPRINTAT(230-textFindLineLen(buf)/2,128,&buf[0]);


	if(currentLetter==2)
	{
		SETRGBC(sprctrl.r,0,150+(rsin(((enterNameFrame*100) MOD 4096)+1024)/82),200,0);
		SETRGBC(sprctrl.r1,0,75+(rsin((enterNameFrame*100) MOD 4096)/82),200,0);
	}		
	else
	{
		SETRGBC(sprctrl.r,128,128,0,0);
		SETRGBC(sprctrl.r1,128,40,8,0);
	}

	sprctrl.shaded=1;
	buf[0]=hi_clist[(int)str[2]];
	TEXTPRINTAT(265-textFindLineLen(buf)/2,128,buf);

	

	if (debounce[0]&PAD_CROSS)
	{
		debounce[0]=0;

		if(currentLetter<2)
			currentLetter++;
		else if(currentLetter==2)
			return TRUE;
	}
	return FALSE;
}


//------------------------------------------------------------------
//
//------------------------------------------------------------------

void GameOverScreen(int score)
{


	int selection;

	int nameEntered=0;
	int exiting=0,menuFrame=0,rating=6,i;

	char name[4];



	ClearAllText();
	InitTextList();

	while((rating>0)&&(score>hiScoreValues[rating-1]))
		rating--;
	
	DB("You are position %d in the hiscores\n",rating);
	if(rating==6)
		return;

#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_ENTERNAME), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
	NEW_TEXT(256, 44, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_ENTERNAME+1), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
#else
	NEW_TEXT(256, 24, 128,128,0, 255, 4096,4096, FALSE, "ENTER YOUR NAME", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[0];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
#endif

	
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 64, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_GOTHIGHSCORE), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
	NEW_TEXT(256, 84, 128,128,0, 255, 4096,4096, FALSE, fontFindLangString(STR_GOTHIGHSCORE+1), TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
#else
	NEW_TEXT(256, 54, 128,128,0, 255, 4096,4096, FALSE, "YOU HAVE A HI SCORE!", TRUE);
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[1];
	SETRGBC(mtext->r1,255,0,0,FULLALPHA);
#endif
	
#ifdef MULTI_LANGUAGE
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE,fontFindLangString(STR_HI_CONTINUE), TRUE);
#else
	NEW_TEXT(256, 220, 128,128,128,255,infoTextScale,infoTextScale, TRUE,"% CONTINUE", TRUE);
#endif
	mtext->flags=TEXT_SHADED;
	mtext->font=fontList[2];
	SETRGBC(mtext->r1,0,0,0,FULLALPHA);


	UpDownReset();
	selection = 1;


	MenuFadeIn();
	while(1)
	{
		//setup correct text settings
		sprctrl.scalex=sprctrl.scaley=4096;
		
		sprctrl.center=0;
		messctrl.font=fontList[0];
		messctrl.justify=0;

		Start_Loop();
		menuPrintBack(1024);
		MenuDrawFade();
		
		if(!nameEntered)
			nameEntered=EnterName(name,(menuFrame?0:1));

		ShowText();

		End_Loop(framerate);

		if((exiting))//&&(fader==0))
			break;

		//if ( !fadeout && !fadein && nameEntered)
		if(nameEntered)
		{
			//MenuFadeOut();
			exiting=1;
		}
		menuFrame++;
		
	}

	name[0] = hi_clist[(int)name[0]];
	name[1] = hi_clist[(int)name[1]];
	name[2] = hi_clist[(int)name[2]];

	ClearAllText();
	debounce[0]=0;

	DB("Previous table\n");
	for(i=0;i<6;i++)
	{
		DB("%d %s %d\n",i,hiScoreNames[i],hiScoreValues[i]);

	}


	//insert hiscore into hiscore table
	for(i=4;i>=rating;i--)
	{
		strncpy(hiScoreNames[i+1],hiScoreNames[i],3);
		hiScoreValues[i+1]=hiScoreValues[i];
	}

	hiScoreValues[rating]=score;
	strncpy(hiScoreNames[rating],name,3);


	hiScoreScreen();

	//fadeout so main menu can fade in
	MenuFadeOut();
	while(fader>1)
	{
		Start_Loop();
		menuPrintBack(1024);
		MenuDrawFade();
		
		ShowText();

		End_Loop(framerate);
	}

}

