#ifndef _PLATFORM_H_
#define _PLATFORM_H_

#define WAITFORHANDSLAM		(-1)
#define WAITFORBALLHIT		(-3)
#define WAITFOREVER			(-100)

#define X_PLATAXIS 0
#define Y_PLATAXIS 1
#define Z_PLATAXIS 2

#define PLAT_SEESAW		0
#define PLAT_PENDULUM	1

#define MAX_OBJDEBRIS 10
#define MAX_CHILD_PLATS 4

#define MAGNET_RANGE	64

typedef struct tagDYNCOLLBOX
{
	struct tagDYNCOLLBOX *next,*prev;
	COLLBOX *pBoxes;
	int		nCollBoxes;
	int		tiltSpin;
	VECTOR	pos;
	VECTOR  oldPos;
	VECTOR	cumPos;
	//COLLBOX cb;			// automatic box created from PSA
	VECTOR	platOffs;
	int platNumber;
//	int nChildPlats;
	struct tagDYNCOLLBOX *pParentPlat;

//	struct tagDYNCOLLBOX *pChildPlat[MAX_CHILD_PLATS];
	struct tagDYNCOLLBOX *pFirstChildPlat;
	struct tagDYNCOLLBOX *pNextChildPlat;

	char active;
	char moveticker;		// used as an interval ticker for sound effects
	int deadTimer;
	PLATFORM_DEFSTR *pPlatDef;
	int ballTouchTime;
	int ballTouchFrame;
	int ballTouchCounter;
	int handTouchTime;

	int snatch_ball_time;	// used by the exit portals to ensure the ball doesn't escape

	struct
	{
		int waitTimer;
		int pointCtr;
		int progress;
		int dir;
		int point;
		int jap;
		int moving;
		int speed;
	}move;

	struct
	{
		int timer;
		int progress;
		int dist;
	}seesaw;

	struct
	{
		int progress;
		int dir;
	}pendulum;

	struct
	{
		int timer;
		int currentAngle;
		int progress;
		VECTOR touchPos;
	}spin;
	
	struct
	{
		int progress;	// progress (zeroed when at point)
		int timer;
		int jar;		// just at rot
	}spinpause;

	struct
	{
		int progress;
		int dir;
		int timer;
	}spinflip;

	struct
	{
		int progress;
		int falling;
		int jar;
	}topple;

	struct
	{
		int active;
		int atEnd;
		int movingToMiddle;
	}magnet;
}DYNCOLLBOX;

typedef struct tagDYNBOXCOLLLIST
{
	DYNCOLLBOX head;
	int numEntries;
}DYNCOLLBOXLIST;

#define MAXPLATSLOADED 64

typedef struct tagPLATSLOADED
{
	ULONG crc;				// CRC of filename of box (minus .ext)
	NEWMODEL *pModel;		// pointer to PSA model
	NEWMODEL *pFragModel;	// pointer to fragment model (if any)
	int nCollBoxes;			// number of collboxes in collision
	COLLBOX *pBoxes;		// pointer to collision mesh
	int collRadiusSqr;
}PLATSLOADED;


typedef struct _BodgeCtrl
{
	DYNCOLLBOX	*carnivalPlat;
	UBYTE		hitPlat;
}BODGECTRL;

extern	BODGECTRL	BodgeCtrl;


extern DYNCOLLBOXLIST dyncollList;
extern PLATSLOADED pPlatsLoaded[];

void platformInitialise(void); // initialises platform system (also used for resetting)
int platformCreatePlatform(PLATFORM_DEFSTR *def);
void platformGenerateShrapnel(VECTOR *pPos, int nBits, int radius, NEWMODEL *pModel, NEWMODEL *pFragModel);

void platformCreateDynamicBoxList(void);
DYNCOLLBOX *platformCreateDynamicBox(int);
void platformLinkDynamicBox(COLLBOX **, NEWMODEL *pModel, int);
void platformMoveDynamicBox(DYNCOLLBOX *pBox, int x, int y, int z);
void platformDrawDynamicBoxes(void);
void platformDestroyDynamicBox(DYNCOLLBOX *ptr);
ULONG platformTryAndFindInstance(ULONG crc);
void platformSmash(DYNCOLLBOX *pBox);
//void platformLoadFragmentBodge(void);
void platformEndFile(void);

void platformStartMove(DYNCOLLBOX *pBox,int flags, int value);

#endif
