
#define WAITFORHANDSLAM		(-1)
#define WAITFORBALLHIT		(-3)
#define WAITFOREVER			(-100)

typedef struct tagDYNCOLLBOX
{
	struct tagDYNCOLLBOX *next,*prev;
	COLLBOX cb;		// automatic box created from PSA. pX,pY,pZ could be used as global xyz for multiple plats
	int platNumber;
	int active;
	int deadTimer;
	PLATFORM_DEFSTR *pPlatDef;
	int waitTimer;
	int progress;
	int point;
	int jap;
}DYNCOLLBOX;

typedef struct tagDYNBOXCOLLLIST
{
	DYNCOLLBOX head;
	int numEntries;
}DYNCOLLBOXLIST;

#define MAXPLATSLOADED 64

typedef struct tagPLATSLOADED
{
	ULONG crc;				// CRC of filename of box (minus .ext)
	NEWMODEL *pModel;		// pointer to PSA model
	NEWMODEL *pFragModel;	// pointer to fragment model (if any)
	int nCollBoxes;			// number of collboxes in collision
	COLLBOX *pBoxes;		// pointer to collision mesh
}PLATSLOADED;

extern DYNCOLLBOXLIST dyncollList;
extern PLATSLOADED pPlatsLoaded[];

void platformCreateDynamicBoxList(void);
DYNCOLLBOX *platformCreateDynamicBox(void);
void platformLinkDynamicBox(PLATSLOADED *pBox, NEWMODEL *pModel);
void platformMoveDynamicBox(DYNCOLLBOX *pBox, int x, int y, int z);
void platformDrawDynamicBoxes(void);
void platformDestroyDynamicBox(DYNCOLLBOX *ptr);
ULONG platformTryAndFindInstance(ULONG crc);
void platformSmash(DYNCOLLBOX *pBox);
void platformLoadFragmentBodge(void);

