/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	poly.h:		Poly draw routines for general objects

************************************************************************************/

#ifndef _POLY_H_
#define _POLY_H_


/*************** cpumac.h  ASSEMBLER GTE MACROS ******/

// cpu_ldr(cpu register,data pointer)
// copy 32bit data from dp to r
#define cpu_ldr(r,dp)\
asm(\
  "lw %0, 0(%1);"\
  : "=r" (r)\
  : "r"  (dp)\
)

// cpu_gted0(cpu register)
// copy 32bit data from r to gte register 0
#define cpu_gted0(r)\
asm(\
  "mtc2 %0, $0;"\
  :\
  : "r" (r)\
)

// cpu_gted1(cpu register)
// copy 32bit data from r to gte register 1
#define cpu_gted1(r)\
asm(\
  "mtc2 %0, $1;"\
  :\
  : "r" (r)\
)

// cpu_gted2(cpu register)
// copy 32bit data from r to gte register 2
#define cpu_gted2(r)\
asm(\
  "mtc2 %0, $2;"\
  :\
  : "r" (r)\
)

// cpu_gted3(cpu register)
// copy 32bit data from r to gte register 3
#define cpu_gted3(r)\
asm(\
  "mtc2 %0, $3;"\
  :\
  : "r" (r)\
)

// cpu_gted4(cpu register)
// copy 32bit data from r to gte register 4
#define cpu_gted4(r)\
asm(\
  "mtc2 %0, $4;"\
  :\
  : "r" (r)\
)

// cpu_gted5(cpu register)
// copy 32bit data from r to gte register 5
#define cpu_gted5(r)\
asm(\
  "mtc2 %0, $5;"\
  :\
  : "r" (r)\
)
/******************************************************/




#define LINEF2_LEN	0x03000000
#define POLYF3_LEN	0x04000000
#define POLYTF3_LEN	0x07000000
#define POLYG3_LEN	0x06000000
#define POLYTG3_LEN	0x09000000
#define POLYF4_LEN	0x05000000
#define POLYTF4_LEN	0x09000000
#define POLYG4_LEN	0x08000000
#define POLYTG4_LEN	0x0C000000
#define DRMODE_LEN  0x02000000
#define DRAREA_LEN  0x02000000

#define GPU_COM_TF4SPR (0x64)


typedef struct {
	u_long	tag;
	UBYTE	tpage,y,z,code;
	ULONG	clip;
}DR_MODEA;


typedef struct {
	u_char  out, in, dummy, cd;

	u_char  tu0, tv0;
	u_short clut;

	u_char  tu1, tv1;
	u_short tpage;

	u_char  tu2, tv2;
	u_short n0;

	u_char  tu3, tv3;
	u_short n1;

	u_char  r0, g0, b0, code;
	u_char  r1, g1, b1, tile;
	u_char  r2, g2, b2, code2;
	u_char  r3, g3, b3, code3;
	u_short v0, v1;
	u_short v2, v3;
	u_short n2, n3;
	SPRITE	*spr;
 	ULONG	tileduvs;
	RGBCD avgTexCol;
}TMD_P_TG4A;


typedef struct {
	u_char  out, in, dummy, cd;

	u_char  tu0, tv0;
	u_short clut;

	u_char  tu1, tv1;
	u_short tpage;

	u_char  tu2, tv2;
	u_short n0;

	u_char  r0, g0, b0, code;
	u_char  r1, g1, b1, tile;	  
	u_char  r2, g2, b2, code2;
	u_short v0, v1;
	u_short v2, n1;
	u_short n2, p;
	SPRITE	*spr;
 	ULONG	tileduvs;
	RGBCD avgTexCol;
} TMD_P_TG3A;


typedef struct {
	u_char  out, in, dummy, cd;
	u_char  tu0, tv0;
	u_short clut;
	u_char  tu1, tv1;
	u_short tpage;
	u_char  tu2, tv2;
	u_char  tile,p;
	u_char  r0, g0, b0, code;
	u_short n0, v0;
	u_short v1, v2;
	SPRITE	*spr;
 	ULONG	tileduvs;
	RGBCD avgTexCol;
} TMD_P_TF3A;


typedef struct {
	u_char  out, in, dummy, cd;
	u_char  tu0, tv0;
	u_short clut;
	u_char  tu1, tv1;
	u_short tpage;
	u_char  tu2, tv2;
	u_char  tile,p0;
	u_char  tu3, tv3;
	u_short p1;
	u_char  r0, g0, b0, code;
	
	u_short n0, v0;
	u_short v1, v2;
	u_short v3, p2;
	SPRITE *spr;
 	ULONG tileduvs;
	RGBCD avgTexCol;
}TMD_P_TF4A;

typedef struct {
	u_char	out, in, dummy, cd;
	u_char	r0, g0, b0, code;
	u_char	r1, g1, b1, dummy1;
	u_char	r2, g2, b2, dummy2;
	u_char	r3, g3, b3, dummy3;
	u_short n0, v0;
	u_short v1, v2;
	u_short v3, dummy4;
	RGBCD	avgTexCol;
}TMD_P_F4GA;

typedef struct {
	u_char	out, in, dummy, cd;
	u_char	r0, g0, b0, code;
	u_char	r1, g1, b1, dummy1;
	u_char	r2, g2, b2, dummy2;
	u_short n0, v0;
	u_short v1, v2;
	RGBCD	avgTexCol;
}TMD_P_F3GA;

#define MODELSCALE 1

//#define TOOMANYPOLYS(A,B) 	(A+(LONG)GsOUT_PACKET_P)>(ULONG)(CurrentPolyList->topofdrawlist[CurrentPolyList->dblbuf])

//#define MAXPACKETSIZE	24
#define INCPOLYSCLIPPED	  modelctrl.preclipped++
#define INCPOLYSDRAWN	  modelctrl.polysdrawn++

#define PUTPACKETINTABLE(POLY,TABLE,CODE){	*(unsigned long *) POLY = (*((unsigned long *)(TABLE))) | CODE; \
			   	   							*((unsigned long *)(TABLE)) = (unsigned long) POLY;}


//#endif



/**************************************************************************
	FUNCTION:	polyDrawPrimitives()
	PURPOSE:	Add primitives to packet draw list
	PARAMETERS:	Ptr to order table entry
	RETURNS:	
**************************************************************************/

void polyDrawPrimitives(GsOTA *ot);

void polyTransformVertices(long numVerts);


/**************************************************************************
	FUNCTION:	polyDrawLine()
	PURPOSE:	Add line to packet draw list
	PARAMETERS:	Depth value
	RETURNS:	
**************************************************************************/

extern LINE_F2	polyLine;

void polyDrawLine(ULONG depth);

void DrawBox(SHORT x,SHORT y,SHORT w,SHORT h,UBYTE r,UBYTE g,UBYTE b,UBYTE semi,SHORT pri);

#endif
