/************************************************************************************
	GLOVER PSX	(c) 1998-9 ISL

	quatern.h:		Quaternion rotation routines

************************************************************************************/

#ifndef _QUATERN_H_
#define _QUATERN_H_


typedef struct
{
	LONG	x, y, z, w;
}IQUATERNION;

typedef struct{
	SHORT x,y,z,w;
}SHORTQUAT;


typedef struct
{
	LONG	matrix[4][4];
}MATRIXI;


/**************************************************************************
	FUNCTION:	quaternionSlerp()
	PURPOSE:	interpolate between two quaternions
	PARAMETERS:	quaternion #1, quaternion #2, interpolant (normalised), dest quaternion
	RETURNS:	
**************************************************************************/

//void quaternionSlerp(IQUATERNION *src1, IQUATERNION *sp2, ULONG t, IQUATERNION *dquat);
//void quatSlerp2(IQUATERNION *from, IQUATERNION  *to, ULONG t, IQUATERNION *res);


/**************************************************************************
	FUNCTION:	quaternionGetMatrix()
	PURPOSE:	Convert quarternion to rotation matrix
	PARAMETERS:	Source quaternion, dest matrix
	RETURNS:	
**************************************************************************/

void quaternionGetMatrix(IQUATERNION *squat, MATRIX *dmatrix);

void quaternionSlerpMatrix(IQUATERNION *src1, IQUATERNION *sp2, ULONG t,MATRIX *dmatrix);


void RotateVectorByQuaternion(VECTOR *result,VECTOR *vect,IQUATERNION *q);

void RotateVectorByRotation(VECTOR *result,VECTOR *vect,IQUATERNION *rot);

void GetRotationFromQuaternion(IQUATERNION *destQ,IQUATERNION *srcQ);

void GetQuaternionFromRotation(IQUATERNION *destQ,IQUATERNION *srcQ);

void QuaternionMultiply(IQUATERNION *dest,IQUATERNION *src1,IQUATERNION *src2);

/* Faster Quat multiply, where dest != src */
void QuaternionMultiplyDestNESrc(IQUATERNION *dest,IQUATERNION *src1,IQUATERNION *src2);


long MagnitudeQuat(IQUATERNION *v);

void UnifyQuat(IQUATERNION *quat);

void ShortquaternionGetMatrix(SHORTQUAT *squat, MATRIX *dmatrix);
void ShortquaternionSlerpMatrix(SHORTQUAT *src1, SHORTQUAT *sp2, ULONG t,MATRIX *dmatrix);


#endif
