// SFX.H
// by Chris Wilson
// Started on 19/4/99

#ifndef __SFX_H
#define __SFX_H

#define	SFXPlayDist(vab, sfx, vol, pos, pitch, time)\
	SFXPlay3D(vab, sfx, 64, pos, pitch, time)


void PlaySFX(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch);

typedef struct tagSFX3DQUEUE
{
	UBYTE priority;//0
	UBYTE volume;
	UBYTE pitch;
	UBYTE vab;
	UBYTE sfx;//4
	UBYTE pad[3];
	long timer;//8
	long endTimer;
	VECTOR *pPos;
	ENEMYPOS *pEnemy;
}SFX3DQUEUE;


#define AMBIENT_STEREO (0)
#define AMBIENT_PROLOGIC (1)

typedef int SFXHANDLE;

SFXHANDLE SFXPlay3D(UBYTE vab, UBYTE sfx, UBYTE vol, VECTOR *pObj, UBYTE pitch, int time);
short SFXPlay(UBYTE channel,UBYTE vab,UBYTE sfx,int rVol, int lVol, UBYTE pitch);
void SFXPlayStereo(int vab, int sfx, int rVol, int lVol, int pitch, int timer);
void SFXPlayAmbient(int vab, int sfx, int flags, int vol, int pitch, int timer);
void SFXUpdate3D(void);
void SFXShutUp(SFXHANDLE);
#endif

