/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//
//	Sound.c
//	==========
//
//  CD and SFX library.
//
//  For Example Useage See Comments At End OF File
//
/////////////////////////////////////////////////////////////////////////////////

#include "glover.h"

//#define ONE_FX_PER_BANK

/*
how sound effects work.
To load sound effects. Call ResetMusic, then load several vab files eg:-

	Reset_Music();	
	spellssfxvab=SFXLoad("SPELLS");
  	glovesfxvab=SFXLoad("GLOVE");  //+VOICE (+SIX_MHZ)

	a ????fxvab for each VAB, must be set up, and cleared in the ResetMusic routine


obviously work out some tables to load it a set of several vabs, dependant on the world.

then in the code, play the Sound effect with:-

	PlaySFX(glovesfxvab,SFX_BALL_BOUNCE,DEFAULTVOLUME,DEFAULTPITCH); 

default pitch and vol. are both 64. You may wish to add a slight random to pitch or make higher or lower, dependant on something.
volume, can be set. It may be a good idea to write a PlaySfx3D  with an X,Y,Z, and volume is calulated by distance from camera or glove.

	The defines are offsets from the vab variable which holds the start of that bank.

	all quite easy.
	
	At the end of the level, music must be flushed.

	There is some extra bits, to stop a voice, cutting off another voice, and queue. but dont worry about that now.

*/

//UBYTE stopvoicesoverlapping[2][MAXNUMOFVOICES];


/*
UBYTE globalfxvab;
UBYTE hubfxvab;
UBYTE atlantisfxvab;
UBYTE carnivalfxvab;
UBYTE fortressfxvab;
UBYTE prehistfxvab;
UBYTE piratesfxvab;
UBYTE spacefxvab;

UBYTE levelfxvab;	// = one of the above

int levelFX, globalFX;

int music_bank_loaded = -1;
*/

//ULONG firstmusictrack=1;

//SFXQUEUE sfxqueue[MAXSFXQUEUE];


//void Stop_Music(void)
//{
//	SFXctrl.bSFXOn=NO;
//	SsSetMute(SS_MUTE_ON);
//	SsSetMVol(0,0);		/* set main volume SOUNDFX*/
//	SsInit();
//}
/******************************************************************************************/
//void Pause_Music(void)
//{
//	SsSetMute(SS_MUTE_ON);
//	SFXctrl.bSFXOn=NO;
//}
/***********************************************************************************/
//void UnPause_Music(void)
//{
//	SsSetMute(SS_MUTE_OFF);
//	SFXctrl.bSFXOn=YES;
//}
/***********************************************************************************/

//CDCTRL CDctrl;
//SFXCTRL SFXctrl;

///// START OF CD CODE //////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//
//	CDInitialise
//	------------
//
//  Sets up the CD Sub System. Must be called before any other CD functions.
//
/////////////////////////////////////////////////////////////////////////////////

/*BOOLEAN CDInitialise(void)
{
	CDctrl.nError = CD_SUCCESS;
	CDctrl.nStatus = CdlStop;	// Fred, so the file-load can detect this properly

	CdInit();

	CDctrl.firsttrack=1;
	CDctrl.Volume=128;

	CDSETVOLUME(&(CDctrl.sAttenuationVol),CDctrl.Volume);		// Calls CdMix to set the volume automagically

//	CDctrl.nooftracks=CdGetToc(CDctrl.toc);
//	debugPrintf("number of CD tracks=%d\n",CDctrl.nooftracks);
	return(TRUE);
}
*/
//void Check_CD_Still_Playing()
//{
/*	UBYTE result[8];

//	printf("c?");

//	printf("CD here %d,%d\n",pausectrl.active,CDctrl.wait);
	if (pausectrl.active==YES)
	{
//		printf("pausectrled\n");
		return;
	}
	if (CDctrl.wait!=0)
	{
//		printf("waiting\n");
		CDctrl.wait--;
		return;
	}
  	CdControl(CdlNop,0,(UBYTE*)&result); //get status flag
//	printf("CD got here %x\n",result[0]);

	if ((CDctrl.opendoor==NO)&&(result[0]&CdlStatShellOpen))
	{
//		printf("shut that door!\n");
		CDctrl.opendoor=YES;
	}
   	if ((CDctrl.opendoor==YES)&&(result[0]&(255-2))==0)
   	{
//   			printf("door closed\n");
   			CDInitialise();
   			CDPlayTrack(CDctrl.trackrequested-CDctrl.firsttrack);
   			CDctrl.opendoor=NO;
   			return;
   	}

	if (((result[0]&CdlStatPlay)==0)||(CDctrl.tryagain==YES))
	{	//is CD playing audi track.
//		printf("l1");
		if(pausectrl.active==NO)
		{
//			printf("l2");
			if (result[0]&CdlStatShellOpen)
			{
				; //do nothing
			}
			else
			{
//				printf("l3");
	   	   		CDPlayTrack(CDctrl.trackrequested-CDctrl.firsttrack);
				debugPrintf("start track %d,result=%x\n",CDctrl.trackrequested,result[0]);
			}
		}
	}
*/
//#define CdlStatPlay		0x80	/* playing CD-DA */
//#define CdlStatSeek		0x40	/* seeking */
//#define CdlStatRead		0x20	/* reading data sectors */
//#define CdlStatShellOpen	0x10	/* once shell open */
//#define CdlStatSeekError	0x04	/* seek error detected */
//#define CdlStatStandby 	0x02	/* spindle motor rotating */
//#define CdlStatError		0x01	/* command error detected */
//}
/////////////////////////////////////////////////////////////////////////////////
//
//  CDPlayTrack
//  -----------
//
//  Moves the head to the track requested and starts to play the disk from there. 
//  Returns immediatly. Should not be called until after CDInitialise!!!
// 
/////////////////////////////////////////////////////////////////////////////////
/*
BOOLEAN CDPlayTrack(UBYTE nTrackToPlay)
{
	CDctrl.opendoor=NO;
	CDctrl.tryagain=NO;
	CDctrl.wait=0;

	debugPrintf("play CD track %d (1st @%d)",nTrackToPlay,CDctrl.firsttrack); //firstmusictrack);
  	nTrackToPlay+=CDctrl.firsttrack; //InCDFirstTrack; //firstmusictrack-1;

  	CDctrl.trackrequested=nTrackToPlay;
	if (nTrackToPlay>CDctrl.nooftracks){nTrackToPlay=CDctrl.nooftracks; //-1;
		debugPrintf("whoops, not that many tracks, playing track %d\n",nTrackToPlay);
	}
		CDctrl.caCtrlParams[0] = CdlModeDA;
		CdControl(CdlSetmode, (CDctrl.caCtrlParams) , 0);
		CdControl(CdlPlay, (u_char *)&(CDctrl.toc[nTrackToPlay]), 0);

		CDctrl.nStatus = CdlPlay;	// Fred, so the file-load can detect this properly

		CDSETVOLUME(&(CDctrl.sAttenuationVol),CDctrl.Volume); //cdgamevolume);		
		CDctrl.nError = CD_SUCCESS;
		CDctrl.bMusicOn = YES;
		return(TRUE);
}
*/
/*************************************/
//void Cd_Pause(void)
//{
//	if (music==YES)
//		CdControl(CdlPause,    0, 0);
//}
/*************************************/

//void Cd_UnPause(void)
//{
//	   	if (music==YES){
//	   		CdControl(CdlPlay,0, 0);  //play from where it left off
//	 	  CDctrl.wait=1;
//		}
//}
/*************************************/
//#define cdSetVol(vol, v) (vol)->val0=(vol)->val2=v,(vol)->val1=(vol)->val3=0,CdMix(vol)
/******************************************************************************************************/

///// END OF CD CODE ///////////////////////////////////////////////////////////

///// START OF SFX CODE ////////////////////////////////////////////////////////
/*
////////////////////////////////////////////////////////////////////////////////
//
//  SFXLoad
//  -------
//
//  Loads a specific (hardwired) VB and VH pair in from datafile. This must 
//  be called before any other of the SFX Functions
//
////////////////////////////////////////////////////////////////////////////////


LONG
SFXLoad(char *szFilenameStem )
{
SFXCTRL *SFXCtrl=&SFXctrl;
UBYTE bInitSuccess;
UBYTE tempmess[32];
LONG temp;
	sprintf(tempmess, "SOUND\\%s.VH", szFilenameStem);
	SFXCtrl->VabHeadAddr[SFXCtrl->nTotalVabsLoaded] = (UBYTE *)fileLoad(tempmess);
	sprintf(tempmess,"SOUND\\%s.VB", szFilenameStem);
	SFXCtrl->VabBodyAddr[SFXCtrl->nTotalVabsLoaded] = (UBYTE *)fileLoad(tempmess);
    if (( SFXCtrl->nVabSize+lastfilelength)<(512*1024)){
			bInitSuccess = SFXInitialise();
			FREENULL(SFXCtrl->VabBodyAddr[SFXCtrl->nTotalVabsLoaded]);
			SFXCtrl->nLastLoadedVabID++;
			SFXCtrl->nTotalVabsLoaded++;
	}
	else{
	 	FREENULL(SFXCtrl->VabBodyAddr[SFXCtrl->nTotalVabsLoaded]);
	 	FREENULL(SFXCtrl->VabHeadAddr[SFXCtrl->nTotalVabsLoaded]);
	}
	SFXctrl.bSFXOn = YES;

	temp=(512*1024)-(SFXCtrl->nVabSize+lastfilelength);

	if (goldcd==NO){
	if (temp>0)debugPrintf("SFX size=%dk, Sound memory left=%dk\n",lastfilelength/1024,temp/1024);
	else  {debugPrintf("SFX ERROR, ran out of SOUND memory (%dk) by %dk",lastfilelength/1024,-temp/1024);
		return 255;
	}
	}
	SFXCtrl->nVabSize += lastfilelength;
	
	return SFXCtrl->nTotalVabsLoaded-1; //++;
}
*/
////////////////////////////////////////////////////////////////////////////////
//
//  SFXInitialise
//  -------------
//
//  This is a private function called by SFXLoad. The Programmer should NEVER 
//  need to call this directly from Game Code
//
////////////////////////////////////////////////////////////////////////////////
/*
BOOLEAN
SFXInitialise()
{
	SFXCTRL *SFXCtrl=&SFXctrl;
	// Interprets the VA Header in Main Memory
	SFXCtrl->VabID = SsVabOpenHeadSticky((u_char *)SFXCtrl->VabHeadAddr[SFXCtrl->nTotalVabsLoaded], 
							SFXCtrl->nLastLoadedVabID, 
							0x1010+(SFXCtrl->nVabSize));

	if (SFXCtrl->VabID  < 0)
	{
		SFXCtrl->nError = SFX_SSVABOPENHEAD_FAILED;
		debugPrintf ("SsVabOpenHead : failed!\n");  VSync(0);
		return(FALSE);
	}

	// Transfers Sound Data From Main memory to sound buffer
	if (SsVabTransBody ((u_char *)SFXCtrl->VabBodyAddr[SFXCtrl->nTotalVabsLoaded], 
							SFXCtrl->VabID) != SFXCtrl->VabID)
	{
		SFXCtrl->nError = SFX_SSVABTRANSBODY_FAILED;
		debugPrintf ("SsVabTransBody : sound failed!\n"); VSync(0);
		return(FALSE);
	}

	SsVabTransCompleted(SS_WAIT_COMPLETED);
	return(TRUE);
}
*/
/////////////////////////////////////////////////////////////////////////////////
//
//	SFXShutDown()
//  -------------
//
//	Frees THe Memory Used By SFX 
//
/*
void
SFXShutDown()
{
	ULONG nTmp;
	SFXCTRL *SFXCtrl=&SFXctrl;

	for ( nTmp = 0; nTmp < SFXCtrl->nLastLoadedVabID; nTmp++ )
	{
		FREENULL(SFXCtrl->VabHeadAddr[nTmp]);
		SsVabClose(nTmp);
	}
	SsQuit();

	SFXCtrl->nTotalVabsLoaded = 0;
	SFXCtrl->nLastLoadedVabID = 0;

	SFXCtrl->VabID = 0;
	SFXCtrl->nVabSize = 0;

}
*/
/////////////////////////////////////////////////////////////////////////////////
//	
//	SFXPlay
//	-------
//
//	Plays a sound on the next available voice. If this sound has already 
//	played, then switches it off first.  
//
//	All SsUtKeyOff Does Is Free a sound channel by killing the current sound
//	playing on it. So to schedule sounds properly we must know when they 
//	started and their length.
//
/*
//there are 24 sound channels!
UBYTE usethissfxchannel=0;	 //(0-19inc)
UBYTE usethisvoicechannel=0; //20-23inc)


SHORT
PlaySFX(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch){  //default pitch=40
USHORT vol=128;
SHORT result;
	//printf("sfx=%d,%d\n",vab,sfx);
	if (vab==255){
	return 0;}

	if (vab&SIX_MHZ)pitch-=10; //change pitch, becuase sampled at 6mhz // WOW! That's a pretty high samplerate!

//	if (vab==humanfxvab){
//		if (stopvoicesoverlapping[0][sfx]!=0){return -1;}	//already playing, so dont!
//		stopvoicesoverlapping[0][sfx]=VOICEDELAY;
//	}
//	if (vab==woprfxvab){
//		if (stopvoicesoverlapping[1][sfx]!=0){return -1;}	//already playing, so dont!
//		stopvoicesoverlapping[1][sfx]=VOICEDELAY;
//	}

#ifdef ONE_FX_PER_BANK
	if (vab & VOICE){
		usethisvoicechannel =(usethisvoicechannel+1)&3;
	 	result=SsUtKeyOnV(usethisvoicechannel+20,vab&63,sfx,0,pitch,0,(volume*vol)/128,(volume*vol)/128); 
	}
	else{
		usethissfxchannel=(usethissfxchannel+1)MOD 20;
		result=SsUtKeyOnV(usethissfxchannel,vab&63,sfx,0,pitch,0,(volume*vol)/128,(volume*vol)/128); 
	}
#else
	if (vab & VOICE){
		usethisvoicechannel =(usethisvoicechannel+1)&3;
	 	result=SsUtKeyOnV(usethisvoicechannel+20,vab&63,sfx>>4,sfx & 15,pitch,0,(volume*vol)/128,(volume*vol)/128); 
	}
	else{
		usethissfxchannel=(usethissfxchannel+1)MOD 20;
		result=SsUtKeyOnV(usethissfxchannel,vab&63,sfx>>4,sfx & 15,pitch,0,(volume*vol)/128,(volume*vol)/128); 
	}
#endif
	return 0;
}

UBYTE GetSFXChannel(void)
{
	DB("SFX channel = %d\n", (int)usethissfxchannel);
	return usethissfxchannel;
}

void StopSFX(UBYTE channel)
{
	DB("StopSFX(%d) ", (int)channel);
	if(!SsUtKeyOffV(channel))
		DB("suceeded!?\n");
	else
		DB("failed dismally!\n");
}
*/
/**************************************************************************************************/
//void ResetSFXQueue(){
//ULONG j;
//	for (j=0;j<MAXSFXQUEUE;j++)sfxqueue[j].cnt=0;
//}
/**************************************************************************************************/
//void UpdateSFXQueue(){
/*ULONG j;
	for (j=0;j<MAXSFXQUEUE;j++){
		if (sfxqueue[j].cnt!=0){
			sfxqueue[j].cnt--;
			if (sfxqueue[j].cnt==0){
				PlaySFX(sfxqueue[j].vab,sfxqueue[j].sfx,DEFAULTVOLUME,sfxqueue[j].pitch);		
			}
		}
	}
  	if ((vblank&3)==0){
		//ptr=&stopvoicesoverlapping[0][0];
		for (j=0;j<MAXNUMOFVOICES;j++){
			if (stopvoicesoverlapping[0][j]!=0)stopvoicesoverlapping[0][j]--;
			if (stopvoicesoverlapping[1][j]!=0)stopvoicesoverlapping[1][j]--;
			//if (*ptr!=0)*ptr--;
			//ptr++;
		}
  	}
	*/
//}

/**************************************************************************************************/
/*void
PlaySFXQueue(UBYTE vab,UBYTE sfx,UBYTE volume,UBYTE pitch,USHORT delay){
ULONG j;
	for (j=0;j<MAXSFXQUEUE;j++)if (sfxqueue[j].cnt==0)goto gotslot;
	return;
gotslot:
	sfxqueue[j].cnt=delay;
	sfxqueue[j].pitch=pitch;
	sfxqueue[j].sfx=sfx;
	sfxqueue[j].vab=vab;
	sfxqueue[j].volume=volume;	


}
*/
/**************************************************************************************************/

//#define MAX_SOUND_DISTANCE 1024

/*void 
Reset_Music(){
ULONG j;
	SFXctrl.bSFXOn = NO;
//	SFXShutDown();
//	SsInit();						// RESET SOUND SYSTEM 




	sfxInitialise();
//{
//	unsigned long loop;
//	debugPrintf("\nInitialising sound system...");
//	SpuInit ();									// initialise spu
//	SpuSetCommonMasterVolume(0x3fff,0x3fff);	// set master volume to max
//	SpuSetCommonCDMix(SPU_ON);					// turn cd audio off
//	SpuSetCommonCDVolume(0x3fff,0x3fff);
//	SpuSetTransferCallback(NULL);
//	SpuInitMalloc(4,sampleBank.rec);
//	sfxFrame = 0;
//	for (loop=0; loop<MAX_SAMPLES; loop++)
//		lastSampleCall[loop] = 0;
//}
















//SFXctrl.bSFXOn = NO;
//	SsInit();			
 //	return;
  //	ResetSFXQueue();
	SFXctrl.nTotalVabsLoaded=0;
	SFXctrl.pitch=40;
	SFXctrl.nVabSize=0;
	   
  	//reset all VAB varibles here!
//  	glovesfxvab=255;
//	spellssfxvab=255;


//	globalfxvab=255;
//	atlantisfxvab=255;
//	hubfxvab=255;
//	carnivalfxvab=255;
//	fortressfxvab=255;
//	prehistfxvab=255;
//	piratesfxvab=255;
//	spacefxvab=255;
//	levelfxvab = 255;

	music_bank_loaded = -1;

//  	for (j=0;j<MAXNUMOFVOICES;j++){
//  		stopvoicesoverlapping[0][j]=0;  //human
//  		stopvoicesoverlapping[1][j]=0;	//wopr
//  	};
	SFXctrl.bSFXOn = YES;

}
*/
/**************************************************************************************************/

/******************************************************************************************/
/*
SHORT sfxlistpos=0;


typedef struct {
	UBYTE	*vabid;
	UBYTE	sfx;
	SHORT	loopdelay;
	UBYTE	*name;
}SFXLIST;

#define MAXSFXLIST (16+16)
SFXLIST sfxlist[MAXSFXLIST]={
	{&glovesfxvab,0,0,"GLOVE    DIE"},
	{&glovesfxvab,1,0,"         HURT"},
	{&glovesfxvab,2,0,"         JUMP"},
	{&glovesfxvab,3,0,"         PUSH"},
	{&glovesfxvab,4,0,"         LONG"},
	{&glovesfxvab,5,0,"         SPELL"},
	{&glovesfxvab,6,0,"         VICTORY"},
	{&glovesfxvab,7,0,"         WOW"},
	{&glovesfxvab,8,0,"         LAND"},
	{&glovesfxvab,9,0,"         SLAM"},
	{&glovesfxvab,10,0,"         THROW"},
	{&glovesfxvab,11,0,"         WHACK"},
	{&glovesfxvab,12,0,"         COOL"},
	{&glovesfxvab,13,0,"         SKID"},
	{&glovesfxvab,14,0,"         FALL"},
	{&glovesfxvab,15,0,"         BOUNCE"},


	{&spellssfxvab,0,0,"SPELLS   POP"},
	{&spellssfxvab,1,0,"         POP"},
	{&spellssfxvab,2,0,"         POP"},
	{&spellssfxvab,3,0,"         POP"},
	{&spellssfxvab,4,0,"         POP"},
	{&spellssfxvab,5,0,"         POP"},
	{&spellssfxvab,6,0,"         POP"},
	{&spellssfxvab,7,0,"         POP"},
	{&spellssfxvab,8,0,"         POP"},
	{&spellssfxvab,9,0,"         POP"},
	{&spellssfxvab,10,0,"         POP"},
	{&spellssfxvab,11,0,"         POP"},
	{&spellssfxvab,12,0,"         POP"},
	{&spellssfxvab,13,0,"         POP"},
	{&spellssfxvab,14,0,"         POP"},
	{&spellssfxvab,15,0,"         POP"}
	};

#define SFXLISTX 104		
#define SFXLISTY 40
#define SFXLISTSPC 10
SHORT pitch=40;
UBYTE testsfx=NO;
void
Display_SFX_List(){
USHORT j;
USHORT startprint;
	//if (noofplayers==2)return;
	if (goldcd==NO){
		if (debounce[1]&PAD_START)testsfx^=1;
  	}else
	{
		if (testsfx==NO){
			if ((debounce[1]&PAD_START)&&(pad[1]==(PAD_START|PAD_R2|PAD_L2)))testsfx^=1;
		}
		else{
			if (debounce[1]&PAD_START)testsfx^=1;
	   }
	}
  	if (testsfx==NO)return;
	if ((frame &1)==0){
		if (pad[1]&PAD_UP){sfxlistpos--;if (sfxlistpos<0)sfxlistpos=0;}
		if (pad[1]&PAD_DOWN){sfxlistpos++;if (sfxlistpos==(MAXSFXLIST))sfxlistpos=MAXSFXLIST-1;}
	}


  	if (debounce[1]&PAD_L1){sfxlist[sfxlistpos].loopdelay--;if (sfxlist[sfxlistpos].loopdelay<0)sfxlist[sfxlistpos].loopdelay=0;}
  	if (debounce[1]&PAD_R1){sfxlist[sfxlistpos].loopdelay++;}

	if ((frame &3)==0){
		if (pad[1]&PAD_L2){pitch--;if (pitch<0)pitch=0;}
		if (pad[1]&PAD_R2){pitch++;if (pitch>127)pitch=127;}
	}

	SFXctrl.pitch=pitch;
	if (debounce[1]&PAD_R2){
		debounce[1]^=PAD_R2;
		PlaySFX(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch);
	}
	if (debounce[1]&PAD_CIRCLE){
		debounce[1]^=PAD_CIRCLE;
		PlaySFX(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch);
		if (sfxlist[sfxlistpos].loopdelay!=0){
  			PlaySFXQueue(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch,sfxlist[sfxlistpos].loopdelay);
			PlaySFXQueue(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch,sfxlist[sfxlistpos].loopdelay*2);
			PlaySFXQueue(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch,sfxlist[sfxlistpos].loopdelay*3);
			PlaySFXQueue(*sfxlist[sfxlistpos].vabid,sfxlist[sfxlistpos].sfx,DEFAULTVOLUME,pitch,sfxlist[sfxlistpos].loopdelay*4);
		}
	}
	SFXctrl.pitch=40;
	startprint=0;
//	SETRGBC(sprctrl.r,0,128,0,0);
//	Print_Message_At(SFXLISTX, SFXLISTY-15,"SOUND EFFECTS TEST");
//	SETRGBC(sprctrl.r,108,0,108,0);

//	Print_Message_At(SFXLISTX, SFXLISTY+13*SFXLISTSPC,"PAD UP/ DOWN=SELECT");
//	Print_Message_At(SFXLISTX, SFXLISTY+13*SFXLISTSPC+10,"X=PLAY SFX   O=LOOP SFX");
//	sprintf(message,"UPPER R/ L=LOOP DELAY UP/ DOWN %d",sfxlist[sfxlistpos].loopdelay);
//	Print_Message_At(SFXLISTX, SFXLISTY+13*SFXLISTSPC+20,message);
//	sprintf(message,"LOWER R/ L=PITCH UP/ DOWN %d",pitch);
//	Print_Message_At(SFXLISTX, SFXLISTY+13*SFXLISTSPC+30,message);
//	sprintf(message,"PRESS START TO EXIT");
//	SETRGBC(sprctrl.r,100,0,0,0);
//	Print_Message_At(SFXLISTX-50, SFXLISTY+13*SFXLISTSPC+70,message);

	if (sfxlistpos>5)startprint=sfxlistpos-5;
		for (j=0;j<11;j++){
				
			if ((j+startprint)==sfxlistpos){
//					SETRGBC(sprctrl.r,128,128,0,0);
			}
			else{
//					SETRGBC(sprctrl.r,128,128,128,0);
			}
//			Print_Message_At(SFXLISTX, SFXLISTY+SFXLISTSPC*j,sfxlist[j+startprint].name);
		if ((j+startprint)>=MAXSFXLIST)break;
		}
//	SETRGBC(sprctrl.r,128,128,128,0);
}



*/