
#ifndef __WATER_H__
#define __WATER_H__

// =============================================


typedef struct WATERSTR
{
	struct WATERSTR *next;
	VECTOR	box_pos;
	VECTOR	box_high;
	int		level;
	int		target;
	int		vx,vz;
	int		tag;
	int		active;
	NEWMODEL *model;	// instancable
	VECTOR	obj_pos;
}WATERSTR;

extern WATERSTR *waterlist;

void waterParseToken(UBYTE *data);
void waterFlush();
void waterSetDepth(int tag, int depth);
void waterEnable(int tag, int enable);
void waterUpdate();
void waterDraw();


#define INWATER          0
#define ABOVEWATER       1
#define BELOWWATER       2
#define NOWHERENEARWATER 3
#define WATERYWATER		 4
int waterGetWaterInfo(VECTOR *in, int radius, int *waterheight);


//#define SPLASHY_OLD    1
#define SPLASHY_MOVING 128
#define SPLASHY_WATERY 256
#define SPLASHY_JUSTINFO 512
#define SPLASHY_BUBBLES	1024
// "flags" is assumed to be the previous return value, +128 if the object is moving sufficiently to
// draw wakes & generate splashes
int waterDoSplashiness(VECTOR *in, int radius, int flags, int *waterheight);

// ===================================================

typedef struct tagRIPPLE
{
	struct tagRIPPLE *next,*prev;			// list pointers
//	VECTOR v;
	SVECTOR sv;
	USHORT scale;
	UBYTE count;
//	UBYTE speed;
}RIPPLE;
typedef struct tagWAKE
{
	struct tagWAKE *next,*prev;			// list pointers
//	VECTOR v;
	SVECTOR sv;
	USHORT scale;
	UBYTE count;
//	UBYTE speed;
}WAKE;
typedef struct tagDROPLET
{
	struct tagDROPLET *next,*prev;			// list pointers
	VECTOR pos;
	VECTOR vel;
	UBYTE count;
	UBYTE sprno;
	UBYTE type;	// 0 = droplet (falls till it hits water), 1= bubble (rises till it leaves water)
}DROPLET;

#define MAXRIPPLES  30
#define MAXWAKES    30
#define MAXDROPLETS 30
extern	RIPPLE ripples[MAXRIPPLES];

void Start_Ripple(VECTOR *vector,ULONG scale,UBYTE count);
void Start_Wake(VECTOR *vector,ULONG scale,UBYTE count);

// set base_vel = 0 for normal upwards splashiness.
// type = 0 for droplets, 1 for bubbles
void Start_Droplet(VECTOR *vector,VECTOR *base_vel, int type);
void Start_Splash(VECTOR *vector);


void	Update_Ripples();
void	Draw_Ripples();

extern SPRITEX *SPR_ripbase;
extern SPRITEX *SPR_wakebase;
extern SPRITEX *SPR_dropbase;

extern WATERSTR *used_water;

void waterParseSound(LNDAMBIENTSOUNDDEFSTR * def);

// ===================================================
#endif
