#include <libsn.h> 


#define SEMITRANS			(1<<0)
#define STOPATEND			(1<<1)
#define DIEATEND			(1<<2)
#define TWOLAYERS			(1<<3)
#define SEMITRANS2			(1<<4)
#define DELAYATEND			(1<<5)
#define DELAYING			(1<<6)
#define NOCLIP				(1<<7)
#define NOSPRATEND			(1<<8)
#define ANIREVERSE			(1<<9)
#define HALFSCALE			(1<<10)
#define RANDOMDELAYATEND	(1<<11)
#define CARFIRED			(1<<12)


#define FIRO 		(0)
#define KLAWD		(1)

#define RALPH		(2)
#define JAKE		(3)
#define BRUCE		(4)
#define FERGUS	(5)
#define HAMISH	(6)
#define SPIKE		(7)
#define FINGERS	(8)
#define FRENCHY	(9)

#define TROFFA	(10)
#define HAMMY		(11)
#define SID		(12)
#define JOHNNY	(13)
#define HANS		(14)
#define GUS		(15)
#define QUACK		(16)
#define NELLIE	(17)
#define JOFF		(18)
#define HANK		(19)
#define ZAK		(20)
#define RICARDO	(21)
#define HUGGY		(22)
#define LOUIE		(23)
#define TUSKER	(24)
#define RONNIE	(25)
#define VINNIE	(26)
#define HUDSON	(27)
#define BOARMAN	(28)
#define SAM		(29)
#define KITTY		(30)
#define CHAN		(31)
#define GRAMPS	(32)
#define LASER		(33)

#define HYDRANT			(82)

#define TOVRAM		(1)
#define TOMEM			(2)

#define ALLDIRS (-1)
#define ENDENEMY (255)
#define WHOLEENEMY (254)

#define BYTE            char
#define UBYTE  unsigned char
#define SHORT           short
#define USHORT unsigned short
#define LONG            long
#define ULONG  unsigned long
#define VOID                    void
#define u_int unsigned short 

#define STEAM		(68)


#define NONE		(0)
#define STAND		(1)
#define WALK		(2)
#define RUN			(3)
#define FIRE		(4)
#define FIRESPEC	(5)
#define WALKFIRE	(6)
#define JUMP		(7)
#define JUMPWALK	(8)
#define WAIT		(9)
#define WAITSILY	(10)
#define WAITLOOK	(11)
#define DEAD		(12)
#define UPQUICK		(13)
#define UPSLOW		(14)
#define FIREMUZ		(15)
#define WALKMUZ		(16)
#define PUNCH		(17)
#define PUNCHL		(18)
#define PUNCHR		(19)
#define PNCHSPEC	(20)
#define CLIMBLAD	(21)
#define CLIMBOVR	(22)
#define PUSH		(23)
#define KICK		(24)
#define PICKUP		(25)
#define POSTERIP	(26)
#define DUCK		(27)
#define CLMBSIDE	(28)
#define CLIMBON		(29)
#define SIT			(30)
#define LOBGREN		(31)
#define TEETER		(32)
#define SITSTAND	(33)
#define DERVISH		(34)
#define SPINUP		(35)

#define PSEUDOACTION (36)

#define HIT			(36)
#define FALL		(37)
#define KNOCKOUT	(38)
#define THRUSTUP	(39)
#define THRUST		(40)
#define PAUSE		(41)
#define SPINDOWN	(42)
#define DIZZY		(43)



#define NONAME		35

#define GUNBELTB			(101)
#define BIGBUL			(102)
#define GUNBELT		     (103)
#define MULTIBUL		     (104)
#define ROCKET		     (105)
#define HOMING			(106)

#define GRENBOX			(107)
#define RICO				(108)
#define AIDBOX			(109)
#define FLIFE				(110)
#define KLIFE				(111)

#define MINE				(112)
#define JACKET			(113)

#define ENDLEVEL			(114)
#define FPOSTNW			(115)
#define FPOSTNE			(116)
#define KPOSTNW			(117)
#define KPOSTNE			(118)

#define RICOCHET			(108)
#define RANDOMCOLLECTABLE	(255)

#define GENRALPH        (1<<0)
#define GENJAKE 		(1<<1)
#define GENBRUCE        (1<<2)
#define GENFERGUS       (1<<3)
#define GENHAMISH       (1<<4)
#define GENSPIKE        (1<<5)
#define GENFINGERS      (1<<6)
#define GENFRENCHY      (1<<7)

#define GENHAMMY        (1<<9)
#define GENTROFFA       (1<<8)

#define GENSID  		(1<<10)
#define GENJOHNNY       (1<<11)
#define GENJOHNY        (1<<11)  //just because!

#define GENHANS 		(1<<12)

#define GENGUS  		(1<<13)
#define GENQUACK        (1<<14)
#define GENNELLIE       (1<<15)

#define GENJOFF 		(1<<16)
#define GENHANK 		(1<<17)
#define GENZAK  		(1<<18)

#define GENRICARDO      (1<<19)
#define GENHUGGY        (1<<20)
#define GENLOUIE        (1<<21)

#define GENTUSKER       (1<<22)
#define GENRONNIE       (1<<23)
#define GENVINNIE       (1<<24)

#define GENHUDSON       (1<<25)
#define GENBOARMAN      (1<<26)
#define GENSAM  		(1<<27)

#define GENKITTY        (1<<28)
#define GENCHAN 		(1<<29)
#define GENGRAMPS       (1<<30)

#define GENLASER        (1<<31)

#define GENALLDOGS      (GENRALPH|GENJAKE|GENBRUCE|GENFERGUS|GENHAMISH|GENSPIKE|GENFINGERS|GENFRENCHY)
#define GENALLPIGS      (GENHAMMY|GENTROFFA)
#define GENALLRATS      (GENSID|GENJOHNNY)
#define GENALLCHEM      (GENGUS|GENQUACK|GENNELLIE)
#define GENALLPENG      (GENJOFF|GENHANK|GENZAK)

#define MAXGENPOINTS    (100)
#define NUMENEMYTYPES   (32)
#define RANDOMDIR               (-1)
#define RANDOMCOL               (-1)
#define GENFOREVER              (-1)

#define EASY            (1<<0)
#define MEDIUM  (1<<1)
#define HARD            (1<<2)

#define ALLLEVELS       (EASY|MEDIUM|HARD)

#define IMMUNE  		(1<<0)
#define NOCOLCHECK      (1<<1)
#define GENONSCREEN     (1<<2)
#define FEETNAILED		(1<<3)
#define THICKGIT		(1<<4)
#define NOSPIN			(1<<5)

typedef struct {
	UBYTE action;
	UBYTE pad0;
	SHORT flags;
	SHORT countto;
	SHORT counter;
}TWAIT;

typedef struct {
	LONG            x,y,z;
	LONG            enemies;                // OR together the above flags for which enemies are allowed
	SHORT   dir;                    // use direct if 0-255, if -1 then use random(256)
	SHORT   numtogenerate;  // infinite if == -1
	SHORT   counter;                // increment every frame
	SHORT   countto;                // generate every time counter == countto
	UBYTE   numpointers;
	TWAIT   *pointer[3];    // enemy->trailpointer = pointer[random(3)]
	UBYTE   action;
	SHORT   col;
	UBYTE   difficulty;     // flags for which difficulty levels it appears on
	UBYTE   flags;          
	UBYTE   node;
	UBYTE	collectable;
	UBYTE	wave;		
}GENPOINT;


#define JUST_BOX (0)
#define CYL_VERT (1)
#define CYL_SW2NE (2)
#define CYL_SE2NW (3)
#define RAMP_SW (4)
#define RAMP_NE (5)
#define RAMP_SE (6)
#define RAMP_NW (7)
#define WEDGE_N (8)
#define WEDGE_E (9)
#define WEDGE_S (10)
#define WEDGE_W (11)

#define SHAPEOFF (255)


#define NO_MASS 		    (65535)

#define VIRTUALLY_NO_MASS   (240)
#define VERY_LIGHT 	    (225)
#define LIGHT 		    (210)
#define QUITE_LIGHT	    (195)
#define MEDIUM_LIGHT	    (180) 
#define MEDIUM_HEAVY	    (165)
#define QUITE_HEAVY	    (150)
#define HEAVY			    (135)
#define HEAVIER		    (120)
#define VERY_HEAVY		    (105)
#define REALLY_HEAVY	    (90)
#define MASSIVE		    (65)
#define REALLY_MASSIVE	    (40)
#define VIRTUALLY_IMMOVABLE (10)

#define IMMOVABLE                   (0)

#define MASSOFF (0)



#define FLASH			(1<<31)
#define FLASH2			(1<<0)
#define WILLFLASH		(1<<30)
#define STAYDUCKED		(1<<4)
#define WILLBURN		(1<<20)
#define FLIPX			(1<<28)

#define CHANSWORD		(1<<31)
#define STUPID			(1<<30)
#define EXPLO			(1<<29)
#define MOVED			(1<<28)

#define NOZCOL			(1<<26)
#define MOBILE			(1<<25)
#define NOSLOWDOWN		(1<<24)
#define NEVERPRTSPRITE	(1<<23)
#define DONTPRTSPRITE	(1<<22)
#define WILLEXPLODE		(1<<21)
#define NOTPLAYING		(1<<20)
#define INLIST			(1<<19)
#define ONICE			(1<<18)
#define ICE				(1<<17)
#define WATER			(1<<16)
#define LEAVEON			(1<<15)
#define WALKTHRUFK		(1<<14)
#define DAMAGING		(1<<13)
#define IS3DSM			(1<<12)
#define DEADLY2			(1<<11)
#define DUCKBOX			(1<<10)
#define WALKTHRUNME		(1<<9)
#define DEADLY			(1<<8)
#define BOUNCY 			(1<<7)
#define MASSON   		(1<<6)
#define BULLET			(1<<5)
#define STEPS			(1<<4)
#define INVISIBLE		(1<<3)
#define NOGRAVITY		(1<<2)
#define EXPLODING		(1<<1)
#define IS3DS 			(1<<0)

#define WALKTHRU                (WALKTHRUNME|WALKTHRUFK)

/*                 .dir                                 16  different directions possible*/
#define DIRN    (0x0001)        /*(0000000000000001b) */
#define DIRNNE  (0x0002)        /*(0000000000000010b)   */
#define DIRNE   (0x0004)        /*(0000000000000100b)   */
#define DIRENE  (0x0008)        /*(0000000000001000b)   */
#define DIRE    (0x0010)        /*(0000000000010000b)   */
#define DIRESE  (0x0020)        /*(0000000000100000b)   */
#define DIRSE   (0x0040)        /*(0000000001000000b)   */
#define DIRSSE  (0x0080)        /*(0000000010000000b)   */
#define DIRS    (0x0100)        /*(0000000100000000b)   */
#define DIRSSW  (0x0200)        /*(0000001000000000b)   */
#define DIRSW   (0x0400)        /*(0000010000000000b)   */
#define DIRWSW  (0x0800)        /*(0000100000000000b)   */
#define DIRW    (0x1000)        /*(0001000000000000b)   */
#define DIRWNW  (0x2000)        /*(0010000000000000b)   */
#define DIRNW   (0x4000)        /*(0100000000000000b)   */
#define DIRNNW  (0x8000)        /*(1000000000000000b)   */


#define COMPN   0
#define COMPNNE 16
#define COMPNE  32
#define COMPENE 48
#define COMPE   64
#define COMPESE 80
#define COMPSE  96
#define COMPSSE 112
#define COMPS   128
#define COMPSSW 144
#define COMPSW  160
#define COMPWSW 176
#define COMPW   192
#define COMPWNW 208
#define COMPNW  224
#define COMPNNW 240


#define LADNE (32)
#define LADE  (64)
#define LADW  (192)
#define LADNW (224)


#define COLOURMASK (15)
#define SPTRCAST  

#define COL2      (0)
#define COL4      (1)
#define COL8      (2)
#define COL16     (3)
#define COL32     (4)
#define COL64     (5)
#define COL128    (6)
#define COL256    (7)
#define COL16BIT  (8)
#define COL24BIT  (9)

#define FLIP                   (1<<4)
#define BITSTREAM              (1<<5)
#define RUNLENGTH              (1<<6)
#define RESPAGE                (1<<7)
#define LASTSPR                (1<<8)
#define NOIMAGE  		       (1<<9)
#define TEMPVRAM               (1<<10)
#define DONTXORVRAM     	   (1<<11)         
#define OLDSPR                 (1<<12)
#define INVRAM                 (1<<13)
#define SPLIT                  (1<<14)
#define FIRSTSPR               (0)


typedef struct {
			 ULONG image;  /*0*/     /*whoops should be a *UBYTE */
			 ULONG pal;      /*4*/   /*whoops should be a *USHORT */
			 UBYTE x;      /*8*/  
			 UBYTE y;        /*9*/  
			 UBYTE w;      /*10*/
			 UBYTE h;      /*11*/ 
			 SHORT u;      /*12*/
			 SHORT v;      /*14*/
			 USHORT clut;  /*16*/
			 USHORT tpage; /*18*/ 
			 USHORT flags; /*20*/
			 }SPRITE;       /*22*/  /*24 bytes*/

typedef struct {
	LONG    x;
	LONG    y;    // fraction in lo  <<16
	LONG    z;
	SHORT   l;    // No Fraction 
	SHORT   w;
	SHORT   h;        
	UBYTE   shape;
	ULONG   flags;

	SPRITE  *sprite;
	SHORT   xco;
	SHORT   yco;
}BOX3DS;

typedef struct {
	LONG    x;
	LONG    y;    /* fraction in lo  <<16*/
	LONG    z;
	SHORT   l;    /*No Fraction */
	SHORT   w;
	SHORT   h;        
	UBYTE   shape;
	ULONG   flags;
}BOX3D;



typedef struct {    
	LONG    x;
	LONG    y;
	LONG    z;
	SHORT   l;
	SHORT   w;
	SHORT   h;
	UBYTE   shape;
	ULONG   flags;
	UBYTE   name;
	USHORT  ani;

	USHORT  mass;  /*255(no mass) - 0(unmoveable)*/
	LONG    velx;  /* <<16*/
	LONG    vely;
	LONG    velz;
	UBYTE   dir;
	SHORT   owner;
	SHORT   hitpoints;
	SHORT   objnum;
	BOX3D   *ramp;

	SPRITE  *sprite;
	SHORT   xoffset;
	SHORT   yoffset;
	SHORT   anicounter;
	SHORT   anicountto;
	USHORT  aniflags;
	UBYTE   spritenum;
	UBYTE   numframes;
	LONG    zagain;
	BYTE    col;
}BOX3DSM; 


// aniflags:


typedef struct {
	LONG    x;
	LONG    y;    /* fraction in lo  <<16*/
	LONG    z;
	SHORT   l;    /*No Fraction */
	SHORT   w;
	SHORT   h;        
	UBYTE   shape;
	ULONG   flags;
	UBYTE   dir;
}BOX3DL;

typedef struct {    // collectables
	LONG            x;
	LONG            y;
	LONG            z;
	SHORT   l;
	SHORT   w;
	SHORT   h;
	UBYTE   shape;
	ULONG   flags;
	UBYTE   name;
	USHORT  ani;
}BOX3DM; 
	
typedef struct {    // bullets
	LONG            x;
	LONG            y;
	LONG            z;
	SHORT   l;
	SHORT   w;
	SHORT   h;
	UBYTE   shape;
	ULONG   flags;
	UBYTE   name;
	USHORT  ani;

	USHORT  mass;  /*255(no mass) - 0(unmoveable)*/
	LONG    velx;  /* <<16*/
	LONG    vely;
	LONG    velz;
	UBYTE   dir;
	SHORT   owner;
	SHORT   hitpoints;
}BOX3DMOV; 
	

typedef struct {	// enemies
	LONG 	x;
	LONG 	y;    /* fraction in lo  <<16*/
	LONG 	z;
	SHORT 	l;    /*No Fraction */
	SHORT 	w;
	SHORT 	h;        
	UBYTE 	shape;
	ULONG	flags;
	UBYTE	name;
	USHORT	ani;

	USHORT 	mass;  /*255(no mass) - 0(unmoveable)*/
	LONG 	velx;  /* <<16*/
	LONG 	vely;
	LONG 	velz;
	UBYTE	dir;
	SHORT	owner;
	SHORT	hitpoints;
	SHORT	objnum;
	BOX3D	*ramp;

	UBYTE	action;
	UBYTE	col;
	UBYTE	fade;
	LONG  	floor;
	LONG  	shadowfloor;
	SHORT	forcedir;
	SHORT	target;
	SHORT	whoshot;
	USHORT	trailflags;
	TWAIT	*trailpointer;
	SHORT	targethits;
	LONG  	confinecounter;
	SHORT	trailcounter;
	SHORT	shootcounter;
	UBYTE	collectable;
	UBYTE	wave;
	UBYTE	extracounter;
	SHORT	extradir;
	UBYTE	soundcounter;
}BOX3DMOVE;

typedef struct {
	BOX3D* box;
	BYTE   num;
	USHORT* points;
	USHORT minx;
	USHORT maxx;
	USHORT miny;
	USHORT maxy;
}BEHINDBOX;



typedef struct
	{
		UBYTE	fonttype;
		USHORT	x,y;
		UBYTE	textstuff[32-3];
	}TEXT;




