#include "StdAfx.h"
#include ".\appwindow.h"

TCHAR cAppWindow::mWindowClassName[] = _T("IRIS Client v0.0a");
HANDLE cAppWindow::mMutexHandle = NULL;

cAppWindow::cAppWindow()
{
}

cAppWindow::~cAppWindow()
{
	if( mMutexHandle )
		::CloseHandle(mMutexHandle);

	::DestroyWindow(mWnd);
}

/* ------------------------------------------------------------------
 * Լ̸ :	Create( NiInstanceRef hi, unsigned int width, unsigned int height )
 *      :	 
 * ǻ :	
 * ------------------------------------------------------------------ */
NiWindowRef cAppWindow::Create( NiInstanceRef hi, unsigned int width, unsigned int height ) 
{
	/// set window style (window mode )
	mWidth = width;
	mHeight = height;

	RECT rect = { 0, 0, mWidth, mHeight };
	mWindowStyle = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_CLIPCHILDREN;

	/// Create Window
	::AdjustWindowRect(&rect, mWindowStyle, FALSE);
	mWnd = ::CreateWindow( GetWindowClassName(), GetWindowClassName(), mWindowStyle, 
		CW_USEDEFAULT, CW_USEDEFAULT, rect.right - rect.left, rect.bottom - rect.top, NULL, NULL, hi, NULL );

	mWindowStyle = ::GetWindowLong( mWnd, GWL_STYLE );
	::ShowWindow( mWnd, SW_HIDE );

	return mWnd;
}

void cAppWindow::AdjustWindowForChange( bool isFullScreen )
{
	HWND order = HWND_TOPMOST;
	if( isFullScreen )
	{
		mWindowStyle = WS_POPUP|WS_SYSMENU|WS_VISIBLE;
	}
	else
	{
		mWindowStyle = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|WS_CLIPCHILDREN;
		order = HWND_TOP;
	}
	::SetWindowLong( mWnd, GWL_STYLE, mWindowStyle );

	mWindowStyle = ::GetWindowLong( mWnd, GWL_STYLE );
	::SetWindowPos( mWnd, order, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE );
}

void cAppWindow::AdjustWindowRect( unsigned int width, unsigned int height, bool Init )
{
	mWidth = width;
	mHeight = height;

	if( mWidth >= (unsigned int)GetSystemMetrics(SM_CXSCREEN) && 
		mHeight >= (unsigned int)GetSystemMetrics(SM_CYSCREEN) )
	{
		mWindowStyle = WS_OVERLAPPED|WS_SYSMENU|WS_MINIMIZEBOX|WS_CLIPCHILDREN;
		::SetWindowLong( mWnd, GWL_STYLE, mWindowStyle );

		mWindowStyle = ::GetWindowLong( mWnd, GWL_STYLE );
	}

	RECT rect = { 0, 0, mWidth, mHeight };
	::AdjustWindowRect( &rect, mWindowStyle, GetMenu(mWnd) != NULL );

	if( mWindowStyle & WS_VSCROLL ) 
		rect.right += GetSystemMetrics( SM_CXVSCROLL );
	if( mWindowStyle & WS_HSCROLL ) 
		rect.bottom += GetSystemMetrics( SM_CYVSCROLL );

	HWND order = HWND_TOPMOST;
	if( mWindowStyle & WS_MINIMIZEBOX )
		order = HWND_NOTOPMOST;

	if( Init )
		::SetWindowPos( mWnd, order, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_FRAMECHANGED|SWP_HIDEWINDOW );
	else
		::SetWindowPos( mWnd, order, 0, 0, rect.right - rect.left, rect.bottom - rect.top, SWP_FRAMECHANGED|SWP_SHOWWINDOW );

	// ü ȭ Ѵ.
	::InvalidateRect( NULL, 0, TRUE );  

	RECT r;
	::GetClientRect( mWnd, &r );
	if( r.right - r.left != mWidth || r.bottom - r.top != mHeight )
	{
		assert(0);
	}
}