#include "StdAfx.h"
#include "resource.h"
#include "Application.h"

#include "DXVersion.h"
#include "AppWindow.h"
#include "AppTimer.h"

#include "RenderSystem.h"
#include "InputSystem.h"
#include "FilePackSystem.h"
#include "SoundSystem.h"

#include "OptionManager.h"
#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"
#include "ObjectManager.h"
#include "UIManager.h"
#include "StageManager.h"

#include "UICursor.h"

#ifdef _GMTOOL
#include "GMTool.h"
#endif


#ifdef _DEVSYS
#include "DevSystem.h"
#endif

cApplication* cApplication::mpSingleton = 0;

/// directx version data size
const unsigned int BUFSIZE = 80;

cApplication::cApplication()
: mpFileSystem( 0 )
, mpOptionManager( 0 )
, mpRenderSystem( 0 )
, mpSoundSystem( 0 )
, mpInputSystem( 0 )
, mpResourceManager( 0 )
, mpCameraManager( 0 )
, mpSceneManager( 0 )
, mpInstance( 0 )
, mpStageManager( 0 )
, mpCursor(0)
#ifdef _GMTOOL
, mGMTool( 0 )
#endif
#ifdef _DEVSYS
, mpDevSystem( 0 )
#endif
, mSaveScreenShot( false )
, mResetFlag( false )
{

	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	mIsActive = true;
	mIsResolution = false;

	mpWindow = new cAppWindow;		
	
	mpTimer = NULL;
	/// 070110 PKH ȭ Ÿ̸
	mAccumTime = 0;
	mDeltaTime = 0;
}

cApplication::~cApplication()
{
	///  Ŵ Ƿ  Ѵ.
	SAFE_DELETE( mpWindow );

#ifdef _GMTOOL
	SAFE_DELETE( mGMTool );
#endif
#ifdef _DEVSYS
	SAFE_DELETE( mpDevSystem );
#endif

	SAFE_DELETE( mpCursor );
	if( mpStageManager )
	{
		mpStageManager->Exit();
		delete mpStageManager;
		mpStageManager = 0;
	}
	SAFE_DELETE( mpSceneManager );
	SAFE_DELETE( mpCameraManager );
	SAFE_DELETE( mpTimer );
	SAFE_DELETE( mpInputSystem );
	SAFE_DELETE( mpOptionManager );
	SAFE_DELETE( mpResourceManager );
	SAFE_DELETE( mpSoundSystem );
	SAFE_DELETE( mpRenderSystem );
	SAFE_DELETE( mpFileSystem );

	mpSingleton = 0;
}

HWND cApplication::GetHWND()
{ 
	return (mpWindow)? mpWindow->GetHWND():NULL; 
}

HINSTANCE cApplication::GetWindowInstance()
{
	return mpInstance;
}

cApplication* cApplication::Create()
{
	return new cApplication;
}

bool cApplication::Init( NiInstanceRef hi, cString ip )
{
	mpInstance = hi;
	mIP = ip;

	///   ý 
	mpFileSystem = new cFilePackSystem;
	if( !mpFileSystem || !mpFileSystem->Init() )
	{
		return false;
	}

	///  ý   ʱȭ
	mpSoundSystem = new cSoundSystem;
	if( !mpSoundSystem || !mpSoundSystem->Init() )
	{
		assert( 0 && "failed to init sound system" );
		NiMessageBox( "Failed to Init SoundSystem", "Error" );
		return false;
	}

	/// 츦 
	if( CreateMainWindow() == false )
	{
		return false;
	}

	mpSoundSystem->SetHWND( mpWindow->GetHWND() );

	/// option file load
	mpOptionManager = new cOptionManager;
	if( !mpOptionManager || !mpOptionManager->Init() )
	{
		return false;
	}

	///  ý   ʱȭ
	mpRenderSystem = new cRenderSystem( mpWindow );
	if( !mpRenderSystem || !mpRenderSystem->Init() )
	{
		assert( 0 && "failed to init render system" );
		NiMessageBox( "Failed to Init RenderSystem", "Error" );
		return false;
	}

	/// ڿ ڸ   ʱȭ
	mpResourceManager = new cResourceManager;
	if( !mpResourceManager || !mpResourceManager->Init() )
	{
		return false;
	}

	/// Ŀ
	mpCursor = new cUICursor;
	if( !mpCursor || !mpCursor->Init() )
	{
		assert( 0 && "failed to Init mouse cursor" );
		return false;
	}

	::ShowWindow( GetHWND(), SW_SHOW );
	NiTexture* tex = mpResourceManager->LoadMapTexture( "./Data/2DData/LoadingMap_Image00.dds", false );
	mpRenderSystem->RenderOnce( tex );

	if( mpRenderSystem->IsFullScreenMode() )
		Sleep(20);

	/// Է ý   ʱȭ
	mpInputSystem = new cInputSystem;
	if( !mpInputSystem || !mpInputSystem->Init( mpInstance, mpWindow->GetHWND() ) )
	{
		assert( 0 && "failed to init input system" );
		NiMessageBox( "Failed to Init InputSystem", "Error" );
		return false;
	}

	/// Ÿ̸Ӹ   ʱȭ
	mpTimer = new cAppTimer;
	if( !mpTimer )
	{
		return false;
	}
	mpTimer->Reset();

	/// ī޶ ڸ   ʱȭ
	mpCameraManager = new cCameraManager;
	if( !mpCameraManager || !mpCameraManager->Init() )
	{
		assert( 0 && "failed to init camera manager" );
		return false;
	}

	///  ڸ 
	mpSceneManager = new cSceneManager;
	if( !mpSceneManager || !mpSceneManager->Init() )
	{
		return false;
	}

	/// stage manager   ʱȭ
	mpStageManager = new cStageManager;
	if( !mpStageManager || !mpStageManager->Init( mpWindow->GetHWND(), mpRenderSystem->GetScreenWidth(), mpRenderSystem->GetScreenHeight() ) )
	{
		return false;
	}

#ifdef _DEVSYS
	mpDevSystem = new cDevSystem();
	if( !mpDevSystem || !mpDevSystem->Init() )
	{
		return false;
	}
#endif

	/// System Timer Start..
	mpTimer->Start();

	return true;
}

void cApplication::Run()
{
	MSG  msg;
	ZeroMemory( &msg, sizeof(msg) );

//	static char buff[256] = {0,};

	while( msg.message != WM_QUIT )
	{
//		XPG_SET( "Performance Test", 100 );

		if( ::PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
		{
			::TranslateMessage( &msg );
			::DispatchMessage( &msg );

//			sprintf(buff, "Message : %d", msg.message );
		}
		else
		{
			MainLoop();
//			strcpy( buff, "MainLoop");
		}
//		XPG_DO(buff);
	}

/*
	XPG_SET( "Performance Test", 100 );

	while( !::PeekMessage( &msg, NULL, 0U, 0U, PM_NOREMOVE ) )
	{
		MainLoop();
	}
	XPG_DO( "MainLoop" );

	do 
	{
		///  κ  ϴºκп  ڵ Ƿ ҽǵǾ
		/// ޼ť  ϰ  ݺǴ 츦 ȸѴ.
		///    鼭  Ѵ.
		ret = ::GetMessage( &msg, NULL, 0U, 0U );
		if( ret == 0 || ret == -1 )
		{
			break;
		}

		::TranslateMessage( &msg );
		::DispatchMessage( &msg );

	} while( ::PeekMessage( &msg, NULL, 0U, 0U, PM_NOREMOVE ) );

	XPG_DO( "Message Process" );
*/
}

/// :  ý  ڵ 
/// :   ϴ Ģ ּ.
void cApplication::Exit()
{
#ifdef _GMTOOL
	if( mGMTool )
		mGMTool->Exit();
#endif

	if(mpStageManager)
	{
		mpStageManager->Exit();
		delete mpStageManager;
		mpStageManager = 0;
	}

	if( mpSceneManager )
		mpSceneManager->Exit();

	if( mpResourceManager )
		mpResourceManager->Exit();

#ifdef _DEVSYS
	if( mpDevSystem )
		mpDevSystem->Exit();
#endif
	if( mpInputSystem )
		mpInputSystem->Exit();

	if( mpRenderSystem )
		mpRenderSystem->Exit();

	/// Ÿ̸Ӹ 
	if( mpTimer )
		mpTimer->Stop();
}

/// :  ȯ ׷ ޸ ʱȭ
/// : Ӻ긮  ƾ ϴ κ,
///  ߻ ƾ ϱ  Լ
void cApplication::Invalidate()
{
//	NiDX9Renderer* r = NiDX9Renderer::GetRenderer();
//	if( r->IsDeviceLost() == false )
//		return;

//	if( mResetFlag )
//		return;

	//OutputDebugString( _T("Invalidate\n") );
//	mResetFlag = true;

	if( mpRenderSystem )
		mpRenderSystem->Invalidate();

#ifdef _DEVSYS
	if(mpDevSystem)
		mpDevSystem->Invalidate();
#endif
}

/// :  ȯ ׷ ޸ 
/// : Ӻ긮  ƾ ϴ κ,
///  ߻ ƾ ϱ  Լ
void cApplication::Restore()
{
//	if( mResetFlag == false )
//		return;

	//OutputDebugString( _T("Restore\n") );
//	mResetFlag = false;

#ifdef _DEVSYS
	if(mpDevSystem)
		mpDevSystem->Restore();
#endif

	if( mpRenderSystem )
		mpRenderSystem->Restore();
}

void cApplication::ChangeMode( )
{
/*
	cRenderSystem::sRenderOption* pOption = mpRenderSystem->GetOption();
	if( !pOption )
		return;

	Invalidate();
	mpRenderSystem->Reset();
	Restore();
*/
}

/*
void cApplication::ToggleScreen()
{	
	Invalidate();

	mpRenderSystem->ToggleFullScreenMode();
	if( mpRenderSystem->Reset( RENDERSYS->GetScreenWidth(), RENDERSYS->GetScreenHeight() ) == false )
	{
		mpRenderSystem->ToggleFullScreenMode();
	}

	Restore();
}
*/

void cApplication::UpdateScreenSize( unsigned int width, unsigned int height, unsigned char bpp, bool windowed )
{
	Invalidate();

	bool check = mpRenderSystem->Reset( width, height, bpp, windowed );

//	Restore();

	if( check == false )
	{
		/// α׷ ...
		::SendMessage( mpWindow->GetHWND(), WM_CLOSE, 0, 0 );
		return;
	}

	CAMERAMAN->Reset( width, height );

	/// ɼ   ϶ GetClientRect    մ.
	UIMAN->UpdateScreenSize( width, height );
}

void cApplication::MainLoop()
{
	/// 찡 Ȱȭ Ǿ ٸ Application CPU Ÿ Ҵ
	if( mIsActive == false )
		NiSleep( 10 );

	///  ð   ð 
	mDeltaTime = mpTimer->GetDeltaTime();
	mAccumTime += mDeltaTime;

	/// μ
	mpInputSystem->Process( mDeltaTime );

	mpResourceManager->Process();

	mpStageManager->Process( mDeltaTime, mAccumTime );

	mpCameraManager->Process( mDeltaTime, mAccumTime );

	mpSceneManager->Process( mDeltaTime, mAccumTime );

	mpSoundSystem->Process( mDeltaTime, mAccumTime );

	mpStageManager->ProcessWorld( mDeltaTime, mAccumTime );

#ifdef _DEVSYS
	mpDevSystem->Process( mAccumTime );
#endif

	/// 
	mpRenderSystem->Render();

	/// ũ
	if( mSaveScreenShot )
	{
		mSaveScreenShot = false;
		SaveScreenShot();
	}
}

void cApplication::Process()
{

}

void cApplication::Render()
{

}

bool cApplication::CreateMainWindow()
{
	/// 츦 
	WNDCLASS wndclass;
	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc   = cApplication::WinProc;
	wndclass.cbClsExtra    = 0;
	wndclass.cbWndExtra    = 0;
	wndclass.hInstance     = mpInstance;
	wndclass.hIcon         = ::LoadIcon(NULL, MAKEINTRESOURCE(IDR_MAINFRAME));
	wndclass.hCursor       = ::LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)::GetStockObject(BLACK_BRUSH);
	wndclass.lpszClassName = cAppWindow::GetWindowClassName();
	wndclass.lpszMenuName  = 0;

	if( ::RegisterClass(&wndclass) == 0 )
	{
		NiMessageBox( "Can't Create Window!", "Error!!" );
		return false;
	}

	mpWindow->Create( mpInstance, 0, 0 );

	return true;
}

bool cApplication::CheckEnoughMemory()
{
	return true;
}

bool cApplication::CheckEnoughHardDisk()
{
	return true;
}

bool cApplication::CheckDirectXVersion()
{
	///  GetDXVersion() Լ ӵ κ , Ʈ  Ͼ.
	/// ̺κ ó  ѹ ˻縦 ϰ,   Ͽ Ű,
	///  ô Ʈ  ˻ϴ  Ѵ.
	HKEY hkey;
	char producttype[BUFSIZE];
	unsigned long buflen = BUFSIZE;
	long ret;

	/// Ʈ ִ  ŷѴ.
	ret = ::RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Microsoft\\DirectX"), 0, KEY_QUERY_VALUE, &hkey );
	if( ret == ERROR_SUCCESS )
	{
		ret = ::RegQueryValueEx( hkey, _T("Version"), NULL, NULL, (LPBYTE) producttype, &buflen);
		if( (ret == ERROR_SUCCESS) && (buflen <= BUFSIZE) )
		{
			if( producttype[2] == '0' && producttype[3] < '9' )
			{
				/// Version Check Fail!
				NiMessageBox( "ֽ DirectX  ġϼ.\n\n ӵ  缳ġ Ͻñ ٶϴ.", "Error Info" );
				::RegCloseKey( hkey );
				return false;
			}
			else
			{
				/// Version Check Succeed!
				::RegCloseKey( hkey );
				return true;
			}
		}

		::RegCloseKey( hkey );
	}

	/// DxDialog File üũѴ.
	HRESULT hr = E_FAIL;
	unsigned long dxver = 0;
	TCHAR dxvertext[10];

	CDXVersion kVer;
	hr = kVer.GetDXVersion( &dxver, dxvertext, 10 );

	if( SUCCEEDED(hr) )
	{
		/// 9.0~ 9.0c .
		if( HIWORD(dxver) < 9 )
		{
			NiMessageBox( "ֽ DirectX  ġϼ.", "Error Info" );
			return false;
		}
	}
	else
	{
		/// Dx   üũ .
		NiMessageBox( "DirectXġ  ֽϴ.\n\n ӵ  缳ġ Ͻñ ٶϴ.", "Error Check" );
		return false;
	}

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	CheckExecutionApplication()
*      :	ؽ ؼ Application ߺ  Ѵ.
* ǻ :	
* ------------------------------------------------------------------ */
bool cApplication::CheckExecutionApplication()
{
	cAppWindow::mMutexHandle = ::CreateMutex( NULL, TRUE, cAppWindow::GetWindowClassName() );
	unsigned long err = ::GetLastError();
	if( err != ERROR_SUCCESS )
	{
		NiMessageBox( "Application already running...", "Error Info" );
		return false;
	}
	return true;
}

void cApplication::SetActive( bool active )
{
	mIsActive = active;
	if( SOUNDSYS )
		SOUNDSYS->ActiveSound( active );
}

/* ------------------------------------------------------------------
* Լ̸ :	WinProc()
*      :	 System Լ ϰ Ѵ.
* ǻ :	  ϴ Ģ ּ.
* ------------------------------------------------------------------ */
LRESULT CALLBACK cApplication::WinProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam )
{
	/// window message parsing !!
	if( INPUTSYS && INPUTSYS->WindowMessageParser( wnd, msg, wparam, lparam ) )
	{
		/// Ŀü ϴ 
		/// DX_INPUT Ű  ..
		INPUTSYS->KeyInfoClear();
		return 0;
	}

	switch( msg ) 
	{
	case WM_CREATE:
		{
			::SetTimer( wnd, 0, 60000, NULL );
		}
		break;
	case WM_TIMER:
		{
			///
			NETWORK->SendHeartbeat();
		}
		break;
	case WM_SOCKEVENTMSG2:
		NETWORK->Process( wparam, lparam );
		break;
	case WM_ACTIVATE:
		{
			if( THEAPP )
			{
				if( wparam == WA_INACTIVE )
				{
					THEAPP->SetActive( false );
				}
				else 
				{
					THEAPP->SetActive( true );
				}
			}
		}
		break;
	case WM_SETCURSOR:
		{ 
			if( CURSOR != NULL )
			{
				CURSOR->Process(0);
			}
		}
		break;
	case WM_IME_SETCONTEXT:
		{
			if( wparam == TRUE )
			{
				lparam &= ~( ISC_SHOWUICOMPOSITIONWINDOW /*| ISC_SHOWUIALLCANDIDATEWINDOW*/ );
				return 0;
			}
		}
		break;
	case WM_SYSCOMMAND:
		switch( wparam )
		{
		case SC_MOVE:
		case SC_SIZE:
		case SC_MAXIMIZE:
		case SC_MONITORPOWER:
			{
				if( RENDERSYS && RENDERSYS->IsFullScreenMode() )
				{
					return 1;
				}
			}
			return 0;
		case SC_KEYMENU:
			{
				return 1;
			}
		}
		break;
		/// ޴ PC  ϴ 쿡  ó
	case WM_POWERBROADCAST:	
		{
			switch( wparam )
			{
#ifndef	PBT_APMQUERYSUSPEND
#define	PBT_APMQUERYSUSPEND 0x0000
#endif
	case PBT_APMQUERYSUSPEND:
		return true;
#ifndef	PBT_APMRESUMESUSPEND
#define PBT_APMRESUMESUSPEND 0x0007
#endif
	case PBT_APMRESUMESUSPEND:
		return true;
			}
		}
		break;
//	case WM_SIZE:
//		{
//		}
//		return 0;
	case WM_MOVE:
		{
#ifdef _GMTOOL
			if( GMTOOL )
				GMTOOL->OnMove();
#endif
		}
		break;

	case WM_CLOSE:
	case WM_DESTROY:
		{
//			SOUNDSYSTEM->SoundAllStop();
			::PostQuitMessage( 0 );
		}
		return 0;
	case WM_DISPLAYCHANGE:
		{
			THEAPP->mIsResolution = true;
		}
		break;
	}

	return ::DefWindowProc( wnd, msg, wparam, lparam );
}

bool cApplication::SaveScreenShot()
{
	NiDX9Renderer* renderer = NiDX9Renderer::GetRenderer();
	if( renderer == 0 )
		return false;

	/// ۸ Ϸ 
	LPDIRECT3DDEVICE9 device = renderer->GetD3DDevice();
	if( device == 0 )
		return false;

	IDirect3DSurface9* buffer = 0;
	if( device->GetBackBuffer( 0, 0, D3DBACKBUFFER_TYPE_MONO, &buffer ) != D3D_OK )
		return false;

	if( buffer == 0 )
		return false;

	///
	if( ::FileExist( "ScreenShot" ) == false )
	{
		::CreateDirectory( L"ScreenShot", 0 );
	}

	///
	SYSTEMTIME tm;
	::GetLocalTime( &tm );

	cStringT pathName;
	pathName.Format( L"ScreenShot/iris_screenshot_%d_%02d_%02d_%02d_%02d_%02d.jpg", tm.wYear, tm.wMonth, tm.wDay, tm.wHour, tm.wMinute, tm.wSecond );

	HRESULT ret = D3DXSaveSurfaceToFile( pathName.Cstr(), D3DXIFF_JPG, buffer, 0, 0 );
	buffer->Release();

	return ret == D3D_OK;
}

void cApplication::TestTest()
{
	UIMAN->UpdateScreenSize( mpRenderSystem->GetScreenWidth(), mpRenderSystem->GetScreenHeight() );
}

#ifdef _GMTOOL
bool cApplication::InitGMTool()
{
	mGMTool = new cGMTool();
	if( mGMTool == 0 || mGMTool->Init( mpInstance, mpWindow->GetHWND() ) == false )
		return false;

	return true;
}
#endif