/* ====================================================================
*      :	Application.h
*      :	    Ŭ 
*    :	̹
*    :	2006.12
* ǻ :	
* =================================================================== */
#pragma once

class cAppWindow;
class cAppTimer;
class cFilePackSystem;
class cOptionManager;
class cRenderSystem;
class cSoundSystem;
class cInputSystem;
class cResourceManager;
class cCameraManager;
class cSceneManager;
class cStageManager;
class cSyncTimer;
class cUICursor;

#ifdef _GMTOOL
class cGMTool;
#endif

#ifdef _DEVSYS
class cDevSystem;
#endif

/// ø̼
class cApplication
{
	static cApplication* mpSingleton;

public:
	cApplication();
	~cApplication();

	/// ø̼ 
	static cApplication* Create();

	/// ޽ ó Լ
	static LRESULT CALLBACK	WinProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );

	///  ޸ üũ
	static bool CheckEnoughMemory();

	///  ޸ üũ
	static bool	CheckEnoughHardDisk();

	/// Dx üũ
	static bool	CheckDirectXVersion();

	/// ߺ ࿡  üũ
	static bool	CheckExecutionApplication();

	///  Ȱȭ üũ
	inline bool IsActive()	{ return mIsActive; }
	void SetActive( bool active );

	/// ʱȭ
	bool Init( NiInstanceRef hi, cString ip );

#ifdef _GMTOOL
	bool InitGMTool();
#endif

	///   
	void Run();

	/// 
	void Exit();

	///  , ũ   ػ󵵸 
	void ChangeMode();

	/// ũ  
//	void ToggleScreen();
	void UpdateScreenSize( unsigned int width, unsigned int height, unsigned char bpp, bool windowed );

	void TestTest();

	/// ũ
	void SetSaveScreenShot( bool save );

	///  ȯ ڿ ޸ ʱȭ
	void Invalidate();

	///  ȭ ڿ ޸ 
	void Restore();

	inline bool IsReset() { return mResetFlag; } 

	/// Application ð
	inline unsigned long GetWorldAccumTime() { return mAccumTime; } 
	inline unsigned long GetWorldDeltaTime() { return mDeltaTime; }

	/// ø̼ 츦 
	inline cAppWindow* GetAppWindow() const { return mpWindow; }

	///  ڵ 
	HWND GetHWND();
	HINSTANCE GetWindowInstance();

	char* GetIP() { return (char*)mIP.Cstr(); }

private:
	/// 츦 
	bool CreateMainWindow();

	///  
	void MainLoop();

	/// ũ
	bool SaveScreenShot();

	void Process();
	void Render();

public:
	/// ü 
	static cApplication* GetSingleton();

private:
	/// νϽ
	NiInstanceRef mpInstance;

	/// 
	cAppWindow* mpWindow;

	/// Ÿ̸
	cAppTimer* mpTimer;

	/// Ȱȭ 
	bool mIsActive;

	///  ػ  üũ
	bool mIsResolution;

	///  ð
	unsigned long mAccumTime;

	///   ð
	unsigned long mDeltaTime;

	///   ý
	cFilePackSystem* mpFileSystem;

	cOptionManager* mpOptionManager;

	///  ý
	cRenderSystem* mpRenderSystem;

	///  ý
	cSoundSystem* mpSoundSystem;

	/// Է ý
	cInputSystem* mpInputSystem;

	/// ڿ 
	cResourceManager* mpResourceManager;

	/// ī޶ 
	cCameraManager* mpCameraManager;

	///  
	cSceneManager* mpSceneManager;

	///   
	cStageManager* mpStageManager;

	/// 콺 Ŀ
	cUICursor* mpCursor;

#ifdef _GMTOOL
private:
	/// 
	cGMTool* mGMTool;
#endif

#ifdef _DEVSYS
private:
	/// ڸ  ý
	cDevSystem* mpDevSystem;
#endif

	/// ũ
	bool mSaveScreenShot;

	bool mResetFlag;

	cString mIP;
};

inline
void cApplication::SetSaveScreenShot( bool save )
{
	mSaveScreenShot = save;
}

inline
cApplication* cApplication::GetSingleton()
{
	return mpSingleton;
}

#define THEAPP cApplication::GetSingleton()
