#include "stdafx.h"
#include "AreaGroup.h"

#include "AreaSceneNode.h"

#include "OptionManager.h"
#include "ObjectManager.h"
#include "hero.h"

#include "RenderSystem.h"

cAreaGroup* cAreaGroup::mCurrentGroup = 0;

cAreaGroup::cAreaGroup( NiAudioSource* snd, NiTexture* tex, unsigned int x, unsigned int y, unsigned int tx, unsigned int ty, unsigned int tw, unsigned int th, unsigned int nameIdx )
: mImage( tex, x, y, tx, ty, tw, th )
, mSound( snd )
{
	assert( tex );

	mHeroIn = false;
	mTempTime = 0;
	mTargetAlpha = 0.0f;
	mAlpha = 0.0f;
	mTargetGain = 0.0f;
	mGain = 0.0f;

	mImage.SetAlpha( 0.0f );
	mImageWidth = tw;

	if( mSound )
	{
		mSound->SetLoopCount( 1 );
//		mSound->SetGain( 0.0f );
		mSound->SetGain( OPTIONMAN->GetEnvVolume() );
		mSound->Stop();
		mSound->Update( 0.0f );
	}

	mNameIndex = nameIdx;
}

cAreaGroup::~cAreaGroup()
{
	if( mSound )
		mSound->Stop();
}

void cAreaGroup::OnProcess( unsigned long deltaTime, const cSphere& heroSphere )
{
	bool oldHeroIn = mHeroIn;
	mHeroIn = false;

	cAreaList::cIterator i = mAreaList.Begin();
	cAreaList::cIterator iend = mAreaList.End();

	for( ; i != iend; ++i )
	{
		cAreaSceneNode* n = *i;
		if( n->GetBoundSphere().ContainSphere( heroSphere ) )
		{
			mHeroIn = true;
			break;
		}
	}

	///
	if( mTargetAlpha > 0.0f )
	{
		mTempTime += deltaTime;

		if( mTempTime > 5000 )
		{
			mTargetAlpha = 0.0f;
		}
	}

	if( oldHeroIn == false )
	{
		if( mHeroIn && mCurrentGroup != this )
		{
			mTargetAlpha = 1.0f;
			mTargetGain = OPTIONMAN->GetEnvVolume();//1.0f;
			mTempTime = 0;

			if( mSound )
			{
				mSound->Play();
			}

			if( mCurrentGroup )
			{
				mCurrentGroup->FadeOut();
			}
			mCurrentGroup = this;

			HERO->SetAreaNameIdx( mNameIndex );
		}
	}
	else
	{
		/// ģ  ó
		if( mHeroIn && mCurrentGroup != this )
		{
			if( mCurrentGroup->IsHeroIn() == false )
			{
				mTargetAlpha = 1.0f;
				mTargetGain = OPTIONMAN->GetEnvVolume();//1.0f;
				mTempTime = 0;

				if( mSound )
				{
					mSound->Play();
				}

				if( mCurrentGroup )
				{
					mCurrentGroup->FadeOut();
				}
				mCurrentGroup = this;

				HERO->SetAreaNameIdx( mNameIndex );
			}
		}
	}

	/// ̹  ó
	if( mAlpha != mTargetAlpha )
	{
		float da = deltaTime * 0.0012f;

		if( mAlpha < mTargetAlpha )
		{
			/// ̵ 
			mAlpha += da;

			if( mAlpha > mTargetAlpha )
				mAlpha = mTargetAlpha;
		}
		else
		{
			/// ̵ ƿ
			mAlpha -= da;

			if( mAlpha < mTargetAlpha )
				mAlpha = mTargetAlpha;
		}
		mImage.SetAlpha( mAlpha );
	}

	///   ó
	if( mSound )
	{
		mSound->Update( 0.0f );
	}
	if( mGain != mTargetGain )
	{
		float dg = deltaTime * 0.0005f;

		if( mGain < mTargetGain )
		{
			/// ̵ 
			mGain += dg;

			if( mGain > mTargetGain )
				mGain = mTargetGain;
		}
		else
		{
			/// ̵ ƿ
			mGain -= dg;

			if( mGain < mTargetGain )
				mGain = mTargetGain;
		}

		if( mSound )
		{
			mSound->SetGain( mGain );

			if( mTargetGain == 0.0f && mGain == 0.0f )
				mSound->Stop();
		}
	}
}

void cAreaGroup::OnRender()
{
	if( mAlpha > 0.0f )
	{
		unsigned int x = (RENDERSYS->GetScreenWidth() - mImageWidth ) / 2;
		unsigned int y = 60;

		mImage.SetPos( x, y );
		mImage.Draw();
	}
}

void cAreaGroup::AddArea( cAreaSceneNode* area )
{
	assert( area );

	mAreaList.PushBack( area );
}

void cAreaGroup::FadeOut()
{
	mTargetAlpha = 0.0f;
	mTargetGain = 0.0f;
}