#include "stdafx.h"
#include "BagWindow.h"

#include "GameUIManager.h"
#include "InventoryWindow.h"
#include "DragWindow.h"
#include "UINpcTelling.h"
#include "Npc_Common.h"
#include "Label.h"
#include "UIImage.h"
#include "ItemIcon.h"
#include "ChatWindow.h"

cBagWindow::cBagWindow( cInventoryWindow* invenWin, unsigned int index )
: mInventoryWindow( invenWin )
, mIndex( index )
, mCaption(0)
, mSelectIcon(0)
, mpSelectImage(0)
, mShowSelect( false )
{
	for( int i = 0;i < BAG_SLOT_COUNT; ++i )
		mIcon[i] = 0;

	/// npc ȭ¿ visible  !!
	/// ֳĸ, κ丮 ư  visible   ϹǷ
	SetBackupVisible( false );
}

cBagWindow::~cBagWindow()
{
	SAFE_DELETE( mpSelectImage );
}

void cBagWindow::OnHide()
{
	cUIWindow::OnHide();

	/// õ  ǥ 
	mSelectIcon = 0;
	mShowSelect = false;
}

void cBagWindow::OnShow()
{
	if( mCaption )
		mCaption->SetEnabled( false );

	cUIWindow::OnHide();
}

void cBagWindow::HideESC( bool onsound )
{
	cUIWindow::HideESC( onsound );

	if( mInventoryWindow )
		mInventoryWindow->Hide();
}

bool cBagWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	if( mIndex == 0 )
	{
		mCaption = (cLabel*)GetChild( eUIID_BAG0_CAPTION );
	}
	else if( mIndex == 1 )
	{
		mCaption = (cLabel*)GetChild( eUIID_BAG1_CAPTION );
	}
	else if( mIndex == 2 )
	{
		mCaption = (cLabel*)GetChild( eUIID_BAG2_CAPTION );
	}
	else
	{
		assert(0);
	}

	if( mCaption )
		mCaption->SetEnabled( false );

	/// 
	unsigned int slotIndex = INVENTORY_BAG1_BEGIN + mIndex * BAG_SLOT_COUNT;
	cString str;

	for( unsigned int i = 0; i < BAG_SLOT_COUNT; ++i, ++slotIndex )
	{
		str.Format( "Bag_Icon%02d", i );
		cItemIcon* icon = new cItemIcon;
		if( icon->CreateBySkinName( str, this, slotIndex + 1 ) == false )
			return false;

		mIcon[i] = icon;
		ITEMMAN->BindIcon( slotIndex, icon );
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}
	
	///  ̹ 
	cUINodeSkin* selectSkin = pSkin->GetNodeSkin( "Inventory_SelectImage" );
	if( selectSkin )
	{
		mpSelectImage = new cUIImage( selectSkin->mpTexture );
		unsigned int tx = selectSkin->mSkinInfo->mTexX;
		unsigned int ty = selectSkin->mSkinInfo->mTexY;
		unsigned int w = selectSkin->mSkinInfo->mWidth;
		unsigned int h = selectSkin->mSkinInfo->mHeight;
		unsigned int x = selectSkin->mSkinInfo->mX;
		unsigned int y = selectSkin->mSkinInfo->mY;
		mpSelectImage->SetTextureRect( tx, ty, tx + w, ty + h );
		mpSelectImage->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
	}
	return true;
}

void cBagWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mSelectIcon && mpSelectImage )
	{
		cUIRect rc = mSelectIcon->GetAbsoluteRect();
		mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
	}
}

void cBagWindow::OnRender(cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mShowSelect && mpSelectImage )
		mpSelectImage->Draw();
}

void cBagWindow::OnCommand( cUINode* /*node*/, unsigned int id )
{
	switch( id )
	{
	case eUIID_BAG0_CLOSE:
		if( mInventoryWindow )
			mInventoryWindow->SetBagButtonPressed( 0, false );
		break;
	case eUIID_BAG1_CLOSE:
		if( mInventoryWindow )
			mInventoryWindow->SetBagButtonPressed( 1, false );
		break;
	case eUIID_BAG2_CLOSE:
		if( mInventoryWindow )
			mInventoryWindow->SetBagButtonPressed( 2, false );
		break;
	}

	Hide();
}

void cBagWindow::OnIconDragged( cUINode* caller, unsigned int /*id*/, const cUIPos& pos, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon )
		UIMAN->ShowDrag( (cUIWindow*)mpParent, DRAG_FROM_INVENTORY, icon, pos, shift );
}

void cBagWindow::OnIconDoubleClicked( cUINode* caller, unsigned int /*id*/ )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( icon && UIMAN->GetNpcFunc() == NPC_FUNC_NULL )
		ITEMMAN->TryToEquipItem( icon->GetSlotIndex() );
}

void cBagWindow::OnIconClicked( cUINode* caller, unsigned int id )
{
	UpdateSelect( (cItemIcon*)caller );
}

void cBagWindow::OnIconRightClicked( cUINode* caller, unsigned int id, bool shift )
{
	cItemIcon* icon = (cItemIcon*)caller;
	if( !icon )
	{
		assert(0);
		return;
	}

	/// ΰ
	if( UIMAN->GetNpcFunc() == NPC_FUNC_STORE )
	{
		unsigned int slotIndex = icon->GetSlotIndex();
		const cItem& item = ITEMMAN->GetItem( slotIndex );
		unsigned short count = item.GetCount();

		if( count )
			GAMEUI->ShowItemSellAskWindow( slotIndex, count );
	}
	else
	{
		cChatWindow* chatWin = GAMEUI->GetChatWindow();
		if( chatWin )
			chatWin->AddLinkItem( icon->GetSlotIndex() );
	}
}

/// ο   
void cBagWindow::ChangeSelect( unsigned int slotIndex )
{
	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemIcon* newIcon = item.GetIcon();
	UpdateSelect( newIcon );
}

void cBagWindow::UpdateSelect( cItemIcon* icon )
{
	if( icon == 0 )
	{
		assert(0);
		return;
	}

	unsigned int itemIdex = icon->GetItemIndex();
	if( mpSelectImage && itemIdex > 0 )
	{
		///    ȿ
		cUIRect rc = icon->GetAbsoluteRect();
		mpSelectImage->SetPos( rc.mLeft-2, rc.mTop-2 );
		mSelectIcon = icon;
		mShowSelect = true;

		ITEMMAN->SetInvenSelect( this );
	}
	else
		mShowSelect = false;
}
