#include "Stdafx.h"
#include "BarButton.h"

#include "UIEvent.h"
#include "PlaneObject.h"
#include "UIContainer.h"

cBarButton::cBarButton( eUINodeType type )
: cButton( type )
, mpBarImage(0)
, mDragStart( 0, 0 )
{
}

cBarButton::~cBarButton()
{
	SAFE_DELETE( mpBarImage );
}

void cBarButton::Hide()
{
	cUINode::Hide();
}


/// ǻ : 
bool cBarButton::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_BARBUTTON ) == false )
	{
		assert( 0 && "not button skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cButtonSkin* p = (cButtonSkin*)pskin;
	mUpPos = p->mUpPos;
	mDownPos = p->mDownPos;

	if( pskin->mpTexture )
	{
		/// ؽó  
		unsigned short w = (unsigned short)pskin->mSkinInfo->mWidth;
		unsigned short h = (unsigned short)pskin->mSkinInfo->mHeight;
		unsigned short tx = (unsigned short)pskin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)pskin->mSkinInfo->mTexY;

		if( mpBarImage == 0 )
		{
			mpBarImage = new cPlaneObject;
			
			if( mpBarImage->Create( pskin->mpTexture, (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop, 
									w, h, tx, ty, tx + w, ty + h ) == false )
			{
				assert( 0 && "failed to create bar button image");
				return false;
			}

			
		}
		else
		{
			mpBarImage->SetTextureRect( tx, ty, tx + w, ty + h );
		}

		mOriginalTexWidth = w;
		mOriginalTexHeight = h;
	}
	return true;
}

/// ǻ : 
void cBarButton::UpdateRect()
{
	cUINode::UpdateRect();

	///
	if( mpBarImage )
	{
		mpBarImage->SetScreenXY( (short)GetAbsoluteRect().mLeft, (short)GetAbsoluteRect().mTop );
		mpBarImage->SetScreenWH( (unsigned short)GetAbsoluteRect().GetWidth(), (unsigned short)GetAbsoluteRect().GetHeight() );
	}
}

/// ǻ : 
void cBarButton::OnRender( cUIFontItemKeeper* )
{
	/// ̹ 
	if( mpBarImage )
        mpBarImage->Draw();
}

/// ǻ : 
void cBarButton::OnMouseMove( const cUIPos& pos )
{
	if( mPressed )
	{
		//  ũѹٿ̶..
		cUIEvent event;
		event.mType = eUIEVENT_SCROLLBAR_MOVE;
		event.mpCaller = this;
		event.mID = mID;
		event.mPos = pos;
		mpParent->HandleEvent( event );
	}
}

/// ǻ : 
void cBarButton::OnLButtonDown( const cUIPos& pos, bool, bool, bool )
{
	/// ĸİ  ĸĸ ´
	if( GetCapture() != this )
	{
		SetCapture();
	}

	mPressed = true;
	mDragStart.mX = pos.mX;
	mDragStart.mY = pos.mY;

	// ҽ ̹ ٲٱ
	mpBarImage->SetTextureRect( (unsigned short)mDownPos.mX, (unsigned short)mDownPos.mY, 
							 (unsigned short)(mDownPos.mX + mOriginalTexWidth), (unsigned short)(mDownPos.mY + mOriginalTexHeight) );

}

/// ǻ :
void cBarButton::OnLButtonDoubleClick( const cUIPos& pos )
{
	OnLButtonDown( pos, 0, 0, 0 );
}

/// ǻ : 
void cBarButton::OnLButtonUp( const cUIPos& )
{
	ReleaseCapture();
	mPressed = false;

	// ҽ ̹ ٲٱ
	mpBarImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
							 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
}

/// ǻ : 콺 ǥ ޾ Y θ ̵
void cBarButton::MoveY( int moveY, const cUIPos& mousePos )
{
	Move( cUIPos( 0, moveY ) );
	mDragStart = mousePos;
}

/// ǻ : 콺 ǥ ޾ X θ ̵
void cBarButton::MoveX( int moveX, const cUIPos& mousePos )
{
	Move( cUIPos( moveX, 0 ) );
	mDragStart = mousePos;
}

