/* ====================================================================
*      :	BaseObject.h
*      :	  ⺻  ü
*    :	
*    :	2006.08.29
*
* ߰ :
*		߰¥	۾	߰
*		2006.08.29		
* 
* ǻ :	
* =================================================================== */
#pragma once

#include "BaseObject_Common.h"

class cEffectSceneNodeParam;
class cEffectSceneNode;
class cSoundSceneNodeParam;
class cSoundSceneNode;
class cDynamicSceneNode;	
class cInfluenceObject;

struct sTargetDamageHP;
struct sTrailInfo;

class cBaseObject
{
public:
	virtual ~cBaseObject();

public:
	/// ź
	virtual void Update( unsigned long deltaTime, unsigned long accumTime ) = 0;

	virtual void UpdateAnimationSpeed(float val);
	virtual float GetAnimationSpeed();

	/// skillObject Ǵ Լ
	virtual void UpdateSkillAnimation( unsigned int aniIdx, bool checkWeapon = false );

	virtual void ApplyDamageDrama( unsigned int damage, unsigned int damageType, cBaseObject* pAttacker = 0 );

	/// ٸ ų Ҽ ִ 
	///  Animation ϱ   ȭ    

	inline bool IsReadyUseSkill() { return mReadyUseSkill; }
	virtual void SetReadyUseSkill( bool used ) 
	{
		if( mReadyUseSkill != used )
			mReadyUseSkill = used; 
	}

	inline virtual unsigned long	GetObjectID() = 0;

	float			GetXPos();
	float			GetYPos();
	float			GetZPos();
	NiPoint3		GetPos();
	void			SetPos( float x, float y, float z );
	void			SetPos( NiPoint3& pos );

	NiMatrix3		GetModelRot();

	virtual void				SetState( unsigned int, bool) {}
	virtual unsigned int		GetState() { return 0; }

	/// ܺο ü κ ġ  ö Ѵ.
	virtual bool	GetDummyPos( unsigned int dummyId, NiPoint3& pos );

	/// 070808 PKH ǥ
	void			FixPos( float x, float y, bool resetCamera = false );

	inline virtual cDynamicSceneNode* GetSceneNode() { return mpObjectSceneNode; }

	/// ü ׷ Ϳ  
	virtual void RemoveObjectSceneNode();

	/// 061127 PKH ϰ ִ Ÿ index object͸ 
	cBaseObject* GetTargetObject();
	inline const sObject* GetTargetInfo() { return &mTarget; }

	/// 061127 PKH ǥ(,) ε object Ѵ.
	virtual void SetTargetObject( unsigned char type, unsigned long idx );

	/// 061211 PKH ϰ ִ Ÿ  ˾Ƴ
	inline unsigned char GetTargetType() { return mTarget.type; }

	inline unsigned char GetObjectType() { return mObjectType; }

	/// ׽Ʈ - ǥâ  
	virtual inline LPTSTR GetName() = 0;

	/// 061205 PKH 
	virtual unsigned long	GetHP() { return 0; }
	virtual unsigned long	GetMaxHP() { return 0; }

	virtual unsigned long	GetMP() { return 0; }
	virtual unsigned long	GetMaxMP() { return 0; }

	virtual void			HPChange( sTargetDamageHP* damage, cBaseObject* attacker = 0 );
	virtual void			HPChange( unsigned long /*objectHP*/, unsigned long /*objectMaxHP*/, bool /*die*/ ){}
	virtual void			MPChange( unsigned long /*objectMP*/, unsigned long /*objectMaxMP*/ ){}

	/// 
	virtual unsigned char	GetLevel() { return 0; }

	/// 061213 wonju
	virtual unsigned int	SetLinkdObject( unsigned int /*num*/, char* /*nif*/ ) { return 0xffffffff; }
	virtual void			UnLinkdObject( unsigned int /*num*/ ) {}

	/// Ʈ ü ũ Ű.
	virtual cEffectSceneNode*	SetLinkdEffect( unsigned int num, const char* nif, NiTransform* trans, bool bLoop=false, bool bFollow=true );
	virtual cSoundSceneNode*	SetLinkdSound( unsigned long soundIdx, bool bLoop=false );
	virtual cEffectSceneNode*	SetLinkdDamage( unsigned int num, const char* nif, NiTransform* trans, bool IsMiss, bool zFalse );

	virtual sTrailInfo* CreateTrailEffect( cString str, unsigned long lifeTime, unsigned int link1, unsigned int link2, float lenPer, float factor );
	void DeleteTrailEffect( sTrailInfo* pInfo );

	///
	virtual void AddBuff( unsigned long uniqueIdx, cInfluenceObject* p );
	virtual void DelBuff( unsigned long uniqueIdx );

	virtual void AddDeBuff( unsigned long uniqueIdx, cInfluenceObject* p );
	virtual void DelDeBuff( unsigned long uniqueIdx );

	virtual void BlinkBuffIcon( unsigned long /*uniqueIdx*/, unsigned long /*influenceIdx*/ ) {}
	virtual void BlinkDeBuffIcon( unsigned long /*uniqueIdx*/, unsigned long /*influenceIdx*/ ) {}

	/// 071023 PKH   
	tPointerHashMap<unsigned long, void*>* GetBufMap()	{ return &mBuffMap; }
	tPointerHashMap<unsigned long, void*>* GetDeBufMap()	{ return &mDeBuffMap; }

	/// Ʈ Ÿ üũ  Ÿ -  
	virtual float			GetFixedObjectSize()	{ return 0.0f; }
	float GetStatureValue();

	///
	void SetOverFlag( bool over );

	virtual bool IsDie() { return false; }
	virtual void FadeOutObject();

protected:
	virtual void ResetState() {}

	virtual void ClearAllBuff();
	virtual void ClearAllDeBuff();

protected:
	cBaseObject( unsigned char type );

	virtual void		Interpret( float /*fTime*/ ) {}

	/// type 
	unsigned char		mObjectType;

	/// ׷  ü 
	cDynamicSceneNode*	mpObjectSceneNode;

	/// 061127 PKH Ÿ ε 
	sObject				mTarget;

	bool				mReadyUseSkill;

	///  ȿ(/)  
	typedef tPointerHashMap<unsigned long, void*>	cInfluenceMap;
	cInfluenceMap		mBuffMap;
	cInfluenceMap		mDeBuffMap;


	/// 
	float				mStatureValue;

	unsigned long	mIdleTime;
	float mRevisionEventTime;
};

