#include "StdAfx.h"
#include "bufftooltipwindow.h"

#include "PlaneObject.h"
#include "FontAgent.h"

#include "Skill_Common.h"
#include "GameResourceManager.h"
#include "SkillManager.h"
#include "SkillIcon.h"
#include "SkillScript.h"
#include "SkillObject.h"


const unsigned int RIGHT_MAXWIDTH = 20;

cBuffToolTipWindow::cBuffToolTipWindow()
{
	mTimeOut = 0;
	mShowTime = true;
}

cBuffToolTipWindow::~cBuffToolTipWindow()
{
}

void cBuffToolTipWindow::Show( bool onsound )
{
	cTipWindow::Show( onsound );

	mTimerEnabled = true;
}

void cBuffToolTipWindow::Hide( bool onsound )
{
	cTipWindow::Hide( onsound );

	mTimerEnabled = false;
}

void cBuffToolTipWindow::OnTimer()
{
	if( mVisible == false )
		return;
	if( mShowTime == false )
		return;

	cInfluenceObject* p = SKILLMAN->GetInfluenceObject( mUniqueIdx );
	if( p == 0 )
		return;

	unsigned int restTime = (unsigned int)(p->GetRestTime() * 0.001f);
	unsigned int h = restTime / 3600;
	unsigned int m = restTime / 60;
	unsigned int s = restTime % 60 + 1;

	cStringT th,tm,ts;
	if( h != 0 )
		th.Format( GAMERESOURCEMAN->GetSkillToolTipText(100017), h );
	if( m != 0 )
		tm.Format( GAMERESOURCEMAN->GetSkillToolTipText(100016), m );
	if( s != 0 )
		ts.Format( GAMERESOURCEMAN->GetSkillToolTipText(100015), s );
	if( h == 0 && m == 0 && s == 0 )
		ts.Format( GAMERESOURCEMAN->GetSkillToolTipText(100015), s );

	th += tm; th += ts;
	mToolTip[mTimeTipIdx].mString.Format( GAMERESOURCEMAN->GetSkillToolTipText(100024), th.Cstr() );
	mToolTip[mTimeTipIdx].mColor = eCOLOR_WHITE;
}

void cBuffToolTipWindow::OnRender( cUIFontItemKeeper* fontKeeper )
{
	if( mVisible == false )
		return;

	/// 
	mMiddleBack->Draw();

	int px = mX + GAP_SIZE;
	int py = mY;

	///   
	for( unsigned int row = 0; row < mIndex; ++row )
	{
		cStringT& str = mToolTip[row].mString;
		if( str.IsEmpty() )
			continue;

		py += mToolTip[row].mGapCount * GAP_SIZE;

		///   
		unsigned int color = mToolTip[row].mColor;
		fontKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), px, py, color );

		py += mLineHeight;
	}

	px = mX + GAP_SIZE + mMaxWidth + RIGHT_MAXWIDTH + 20;
	py = mY;
	if( mRightTip.mString.IsEmpty() == false )
	{
		cStringT& str = mRightTip.mString;

		///   
		unsigned int width = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), str.GetSize() );
		int x = px - width;

		py += mRightTip.mGapCount * GAP_SIZE;
		fontKeeper->AddFontItem( cFontAgent::eFont_System, (LPCTSTR)str.Cstr(), x, py, mRightTip.mColor );
	}
}

void cBuffToolTipWindow::Clear()
{
	cTipWindow::Clear();

	mRightTip.mString.Clear();
}


bool cBuffToolTipWindow::SetBuff( const cUIPos& pos, unsigned long uniqueIdx, unsigned long influenceIdx, bool showTime )
{
	Clear();

	mShowTime = showTime;
	mUniqueIdx =  uniqueIdx;

	if( SetBuffTip( uniqueIdx, influenceIdx ) == false )
		return false;

	/// ּ ʺ  
	if( mMaxWidth < mLimitMinWidth )
		mMaxWidth = mLimitMinWidth;

	/// ִ ʺ  
	if( mMaxWidth > mLimitMaxWidth )
		mMaxWidth = mLimitMaxWidth;

	/// 
	mX = pos.mX + 25;
	mY = pos.mY + 25;

	unsigned int w = mMaxWidth + GAP_SIZE * 2 + ( RIGHT_MAXWIDTH + 20 );
	unsigned int h = mIndex * mLineHeight + (mGapCount+1)*GAP_SIZE;

	/// ȭ ȹ 
	if( mX + w > GetScreenWidth() )
	{	
		mX -= ((mX + w) - GetScreenWidth());
	}

	if( mY + h > GetScreenHeight() )
	{
		mY -= ((mY + h) - GetScreenHeight());
	}

	mMiddleBack->SetScreenRect( (short)mX, (short)mY, (unsigned short)w, (unsigned short)h );
	mMiddleBack->SetColorA( 0.6f, 0.6f, 0.6f, 0.6f );
	SetRelativePos( cUIPos(mX, mY) );

	return true;
}

bool cBuffToolTipWindow::SetBuffTip( unsigned long uniqueIdx, unsigned long influenceIdx )
{
	cInfluenceObject* p = SKILLMAN->GetInfluenceObject( uniqueIdx );
	if( p )
	{
		influenceIdx = p->GetInfluenceIdx();
		mShowTime = !p->IsStatic();
	}

	sInfluenceScript* pInfo = SKILLSCRIPT->GetInfluenceInfo( influenceIdx );
	if( pInfo == 0 )
	{
		return false;
	}

	AddGap( 1 );
	/// name
	mToolTip[mIndex].mString = GAMERESOURCEMAN->GetSkillNameText( pInfo->mNameidx );
	mToolTip[mIndex].mColor = eCOLOR_YELLOW;
	CalcMaxWidth( mToolTip[mIndex].mString );
	mIndex++;
	if( mIndex > MAX_TIP )
	{
		assert( 0 && "error tip index" );
	}

	/// 081014 PKH p NULL üũ
	if( mShowTime && p != NULL )
	{
		AddGap(1);
		/// ӽð

		unsigned int restTime = (unsigned int)(p->GetRestTime() * 0.001f);

		unsigned int h = restTime / 3600;
		unsigned int m = restTime / 60;
		unsigned int s = restTime % 60 + 1;

		cStringT th,tm,ts;
		if( h != 0 )
			th.Format( GAMERESOURCEMAN->GetSkillToolTipText(100017), h );
		if( m != 0 )
			tm.Format( GAMERESOURCEMAN->GetSkillToolTipText(100016), m );
		if( s != 0 )
			ts.Format( GAMERESOURCEMAN->GetSkillToolTipText(100015), s );
		if( h == 0 && m == 0 && s == 0 )
			ts.Format( GAMERESOURCEMAN->GetSkillToolTipText(100015), s );

		th += tm; th += ts;
		mToolTip[mIndex].mString.Format( GAMERESOURCEMAN->GetSkillToolTipText(100024), th.Cstr() );
		mToolTip[mIndex].mColor = eCOLOR_WHITE;
		CalcMaxWidth( mToolTip[mIndex].mString );
		mTimeTipIdx = mIndex;
		mIndex++;
		if( mIndex > MAX_TIP )
		{
			assert( 0 && "error tip index" );
		}
	}

	/// 
	cStringT temp;

	/// ȿ  ȿ
	if( pInfo->mValue1 != 0 || pInfo->mValue2 != 0 || pInfo->mValue3 != 0 )
	{
		if( pInfo->mValue1 && pInfo->mValue2 && pInfo->mValue3 )
		{
			AddGap(1);
			temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1, pInfo->mValue2, pInfo->mValue3 );
			CheckText( (LPCTSTR)temp.Cstr(), eCOLOR_YELLOW );
		}
		else if( pInfo->mValue1 && pInfo->mValue2 )
		{
			AddGap(1);
			temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1, pInfo->mValue2 );
			CheckText( (LPCTSTR)temp.Cstr(), eCOLOR_YELLOW );
		}
		else if( pInfo->mValue1 )
		{
			AddGap(1);
			temp.Format( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), pInfo->mValue1 );
			CheckText( (LPCTSTR)temp.Cstr(), eCOLOR_YELLOW );
		}
	}
	else
	{
		/// Ϲ  
		AddGap( 1 );
		if( CheckText( GAMERESOURCEMAN->GetSkillToolTipText( pInfo->mToolTipIdx ), eCOLOR_YELLOW ) )
		{
			cStringT str;
			str.Format( GAMERESOURCEMAN->GetSkillToolTipText( 100025 ), pInfo->mGroupOrder );
			mToolTip[mIndex-1].mString += str.Cstr();
		}
	}


	///  ǥ
	unsigned int typeIdx = 0;
	switch( pInfo->mTypeDetail )
	{
	case eINFLUENCETYPEDETAIL_AURA:			typeIdx = 100051; break;
	case eINFLUENCETYPEDETAIL_BUILD:		typeIdx = 100050; break;
	case eINFLUENCETYPEDETAIL_MAGIC:		typeIdx = 100052; break;

	case eINFLUENCETYPEDETAIL_TRAUMA:		typeIdx = 100054; break;
	case eINFLUENCETYPEDETAIL_ELEMENT:		typeIdx = 100055; break;
	case eINFLUENCETYPEDETAIL_WEAK:			typeIdx = 100056; break;
	case eINFLUENCETYPEDETAIL_AFTEREFFECT:	typeIdx = 100057; break;
	case eINFLUENCETYPEDETAIL_LEADER:		typeIdx = 100058; break;
	case eINFLUENCETYPEDETAIL_NOPROPERTY:	typeIdx = 100059; break;

	case eINFLUENCETYPEDETAIL_POTION:		typeIdx = 100053; break;
	case eINFLUENCETYPEDETAIL_GOODS:		typeIdx = 100061; break;	
	case eINFLUENCETYPEDETAIL_COOKING:		typeIdx = 100062; break;	
	case eINFLUENCETYPEDETAIL_PERFUME:		typeIdx = 100063; break;	
	case eINFLUENCETYPEDETAIL_CARD:			typeIdx = 100060; break;

	case eINFLUENCETYPEDETAIL_NAME:			typeIdx = 100071; break;
	case EINFLUENCETYPEDETAIL_VEHICLE:		typeIdx = 100072; break;
	}

	mRightTip.mString = GAMERESOURCEMAN->GetSkillToolTipText( typeIdx );
	mRightTip.mColor = eCOLOR_YELLOW;
	mRightTip.mGapCount = 2;

	return true;
}
