/* ==========================================================================
*      : BuffWindow.h
*      :   
*    : 谡
*    : 2007-03-19
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "UITransformImage.h"

struct sBuffBaseIcon
{
	cUITransformImage		mImage;
	unsigned long			mUniqueIdx;
	unsigned long			mInfluenceIdx;
};

struct sBuffIcon : public sBuffBaseIcon
{
	unsigned long			mTotalTime;

	///    ǥ
	cStringT				mUnit;
	int			mTextX;
	int			mTextY;

	bool					mStartBlink;
	bool					mShow;
	unsigned long			mBlinkTime;

	bool					mAuraType;
	bool					mIsBuff;

	sBuffIcon()
	{
		mTotalTime = 0;

		mStartBlink = false;
		mShow = true;
		mBlinkTime = 0;
		mAuraType = false;
	}
};

//////////////////////////////////////////////////////////////////////////
class cBuffWindow : public cUIWindow
{
public:
	cBuffWindow();
	virtual ~cBuffWindow();

	void Clear();

	virtual void AddIcon( unsigned long uniqueIdx, unsigned long influenceIdx );
	virtual void DelIcon( unsigned long uniqueIdx );
	void BlinkIcon( unsigned long uniqueIdx, unsigned long influenceIdx );

	///
	inline void SetRowSpace( unsigned int space ) { mRowSpace = space; }
	inline void SetColumnSpace( unsigned int space ) { mColumnSpace = space; }
	inline void SetHeroBuff( bool value ) { mIsHeroBuffPage = value; }

protected:
	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnMouseMove( const cUIPos& pos );
	virtual void OnMouseLeft( const cUIPos& pos );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnShow();
	virtual void OnHide();
	virtual void HideTip();
	virtual void OnTimer();
	virtual void EventOverIcon( sBuffBaseIcon* p, const cUIPos& pos );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateSkin();
	
	virtual void OnRButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift );

protected:
	unsigned int	mRow;
	unsigned int	mColumn;

	unsigned int	mRowSpace;
	unsigned int	mColumnSpace;

	unsigned int	mIconSize;
	float			mScale;

	unsigned int	mStartX;
	unsigned int	mStartY;

	///  over ̺Ʈ ó
	struct sOverInfo
	{
		unsigned int	mOverIconIdx;
		cUIPos			mPos;
		unsigned int	mRow;		/// 
	};

	sOverInfo		mOverInfo;
	bool			mOverCheck;
	bool			mChangeOverIcon;

	///  콺ư ̺Ʈ ó
	unsigned int	mRButtonClickIconIdx;

	///     
	bool			mUpdateList;

	///   
	typedef	tPointerList<void*>	cBuffIconList;
	cBuffIconList		mIconList;

	bool			mBuffTipShow;
	bool			mIsHeroBuffPage;
};

//////////////////////////////////////////////////////////////////////////
/// cBuffWindowSkin
class cBuffWindowSkin : public cUIWindowSkin
{
public:
	cBuffWindowSkin( eUINodeType type = eUINODE_WINDOW );
	virtual ~cBuffWindowSkin();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// 1. 
	unsigned int	mRowSpace;
	unsigned int	mColumnSpace;

	/// 2. ǥ (, ĭ)
	unsigned int	mRow;
	unsigned int	mColumn;

	/// 3.  ũ
	unsigned int	mIconSize;

	/// 4. 
	float			mScale;
};
//////////////////////////////////////////////////////////////////////////