#pragma once
#include "BaseObject_Common.h"

class cEffectSceneNode;
class cDramaturgyInfo;

struct sBulletAction;
struct sCrashInfo;

class cBulletObj
{
public:
	cBulletObj();
	virtual ~cBulletObj();

	bool Init( cDramaturgyInfo* pInfo, sBulletAction* pAct, cBaseObject* pUser, cBaseObject* pTarget );
	bool Init( cDramaturgyInfo* pInfo, sBulletAction* pAct, cBaseObject* pUser, NiPoint3 fieldPos );
	bool Update( unsigned long time );

	inline void SpeedUp( float val ) { mSpeed += val; }

protected:
	void Crash( cBaseObject* pTarget, NiPoint3 dir = -NiPoint3::UNIT_Y );

	void BulletRotate( NiPoint3 startAt, NiPoint3 endAt );

protected:

	struct sCrashInfo
	{
		unsigned short	crashEffectIdx;
		unsigned int	crashLinkPos;
		NiPoint3		crashVar;
	};

	/// ߻ü
	unsigned long		mBulletEffectIdx;
	cEffectSceneNode*	mBullet;

	float				mSpeed;
	NiPoint3			mDesiredDir;

	unsigned long		mAccumTime;

	/// 浹 ó  
	sObject				mTarget;
	unsigned int		mTargetLinkPos;
	NiPoint3			mLastTargetPos;

	///
	bool				mUseFieldTarget;

	/// 浹 ȿ 
	bool				mExistCrashEffect;

	unsigned int		mCrashCount;
	sCrashInfo			mCrashInfo[5];

	///  
	cDramaturgyInfo*	mpDramaInfo;
};