#include "StdAfx.h"
#include "Button.h"
#include "UIManager.h"
#include "UISkinLexer.h"
#include "Token.h"
#include "Parser.h"

#include "UIEvent.h"
#include "UIImage.h"
#include "UIContainer.h"
#include "FontAgent.h"
#include "SoundSystem.h"

cButton::cButton( eUINodeType type )
: cUINode( type )
, mOriginalTexWidth( 0 )
, mOriginalTexHeight( 0 )
, mTextPosX( 0 )
, mTextPosY( 0 )
, mLastTick( 0 )
, mTimeFlag( true )
, mUseEnable( false ) 
, mUpPos(0, 0)
, mDownPos(0, 0)
, mDownOverPos(0, 0)
, mEnablePos(0, 0)
, mContinuEvent( false )
{
	mUpdateTime = gOneMoveTime;

	mUpColor = mDefaultColor;
	mDownColor = mDefaultColor;
	mOverColor = mDefaultColor;

	mDownSoundIdx = (unsigned long)-1;
	mUpSoundIdx = (unsigned long)-1;

	mProcessEnable = true;
}

cButton::~cButton()
{

}

/// ǻ : 
bool cButton::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_BUTTON ) == false )
	{
		assert( 0 && "not button skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cButtonSkin* p = (cButtonSkin*)pskin;
	if( p->mText.IsEmpty() == false )
		mText = p->mText;

	mOriginalTexWidth = mpImage->GetWidth();
	mOriginalTexHeight = mpImage->GetHeight();
	
	/// ư ̹ ȯǥ  
	mUpPos = p->mUpPos;
	mUpOverPos = p->mUpOverPos;
	mDownPos = p->mDownPos;
	mDownOverPos = p->mDownOverPos;
	mEnablePos = p->mEnablePos;
	mUseEnable = p->mUseEnable;
	
	/// ư  ؽƮ ÷
	mUpColor = p->mUpColor;
	mDownColor = p->mDownColor;

	mDownSoundIdx = p->mDownSoundIdx;
	mUpSoundIdx = p->mUpSoundIdx;

	/// ؽƮ ǥ Ʈ 
	UpdateText();

	return true;
}

/// ǻ : 
void cButton::UpdateRect()
{
	cUINode::UpdateRect();

	/// ؽƮ ǥ Ʈ 
	UpdateText();
}

/// ǻ : 
void cButton::OnProcess( unsigned long , unsigned long accumTime )
{
	if( mVisible == false )
		return;

	/// ư   ˻ 
	if( mPressed )
	{
		if( mTimeFlag )
		{
			mLastTick = accumTime;
			mTimeFlag = false;
		}		

		unsigned long elapsedTime = accumTime - mLastTick;
		if( elapsedTime >= mUpdateTime )
		{
			mUpdateTime = gContinueMoveTime;

			/// ð  ư ȴٴ ޽ Ӻ
			cUIEvent event;
			event.mpCaller = this;
			event.mID = mID;
			event.mType = eUIEVENT_BUTTON_DOWNED;
			mpParent->HandleEvent( event );

			mLastTick = accumTime;
		}

		///  ̺Ʈ ޱϸ
		if( mContinuEvent )
		{
			/// ִµ Ӻ.
			cUIEvent event;
			event.mpCaller = this;
			event.mID = mID;
			event.mType = eUIEVENT_BUTTON_CONTINUEDOWNED;
			mpParent->HandleEvent( event );
		}
	}
}

/// ǻ : 
void cButton::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	mpImage->Draw();

	if( mPressed )
	{
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY+1, mDownColor );
	}
	else
	{
		pKeeper->AddFontItem( cFontAgent::eFont_UI, const_cast<LPTSTR>(mText.Cstr()), mTextPosX, mTextPosY, mUpColor );
	}
}

/// ǻ : 
void cButton::OnMouseMove( const cUIPos& pos )
{
	if( mAbsoluteRect.ContainPoint( pos ) == false )
	{
		ReleaseCapture();
		mPressed = false;
	}
}

/// ǻ : ȣ  ̺Ʈ  
void cButton::OnMouseHovered( const cUIPos& pos )
{
	cUINode::OnMouseHovered( pos );

	// ҽ ̹ ٲٱ
	mpImage->SetTextureRect( (unsigned short)mUpOverPos.mX, (unsigned short)mUpOverPos.mY, 
						     (unsigned short)(mUpOverPos.mX + mOriginalTexWidth), (unsigned short)(mUpOverPos.mY + mOriginalTexHeight) );
}

/// ǻ : ȣ  ̺Ʈ  
void cButton::OnMouseLeft( const cUIPos& pos )
{
	cUINode::OnMouseLeft( pos );

	// ҽ ̹ ٲٱ
	mpImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
							 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
}

/// ǻ : 
void cButton::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );
	
	///
	SOUNDSYS->Play2DSound( mDownSoundIdx );

	/// ĸİ  ĸĸ ´
	if( GetCapture() != this )
	{
		SetCapture();
	}

	// ҽ ̹ ٲٱ
	mpImage->SetTextureRect( (unsigned short)mDownPos.mX, (unsigned short)mDownPos.mY, 
							 (unsigned short)(mDownPos.mX + mOriginalTexWidth), (unsigned short)(mDownPos.mY + mOriginalTexHeight) );
	mPressed = true;
	mTimeFlag = true;
}


/// ǻ : 
void cButton::OnLButtonUp( const cUIPos& )
{
	if( mPressed )
	{
		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
								 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );

		mUpdateTime = gOneMoveTime;
		mPressed = false;

		/// ̺Ʈ ߻
		cUIEvent event;
		event.mType = eUIEVENT_COMMAND;
		event.mpCaller = this;
		event.mID = mID;
		mpParent->HandleEvent( event );
	}
}

/// ǻ : ؽƮ ǥ Ʈ 
void cButton::UpdateText()
{
	if( mText )
	{
		/// ؽƮ ѷ ġ  
		cUIRect rc = GetAbsoluteRect();

		mTextPosX = rc.mLeft + (int)(( rc.GetWidth() - FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, mText.Cstr(), mText.GetLength() )) * 0.5f );
		/// +1  ġ  
		mTextPosY = rc.mTop + (int)(( rc.GetHeight() - FONTAGENT->GetTextHeight(cFontAgent::eFont_UI) + 1) * 0.5f);
	}	
}

/// ǻ : ư Ȱȭ   
void cButton::SetEnabled( bool enabled )
{
	if( mEnabled == enabled )
		return;

	if( mUseEnable && enabled == false )
	{	
		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mEnablePos.mX, (unsigned short)mEnablePos.mY, 
								 (unsigned short)(mEnablePos.mX + mOriginalTexWidth), (unsigned short)(mEnablePos.mY + mOriginalTexHeight) );

	}
	else
	{
		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mUpPos.mX, (unsigned short)mUpPos.mY, 
							 	 (unsigned short)(mUpPos.mX + mOriginalTexWidth), (unsigned short)(mUpPos.mY + mOriginalTexHeight) );
	}

	cUINode::SetEnabled( enabled );
}


void cButton::SetText( LPCTSTR text )
{
	mText = text;

	UpdateText();
}

void cButton::Hide()
{
	cUINode::Hide();

	ReleaseCapture();
	mPressed = false;
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////
cButtonSkin::cButtonSkin( eUINodeType type )
: cUINodeSkin( type )
, mUpPos(0, 0)
, mUpOverPos(0, 0)
, mDownPos(0, 0)
, mDownOverPos(0, 0)
, mUpSize(0, 0)
, mDownSize(0, 0)
, mEnablePos(0, 0)
{
	mUseEnable = false;

	mUpColor = mDefaultColor;
	mDownColor = mDefaultColor;

	mDownSoundIdx = (unsigned long)-1;
	mUpSoundIdx = (unsigned long)-1;
}

cButtonSkin::~cButtonSkin()
{
}

/// ǻ : ư ʿ   Ľ
bool cButtonSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
			break;

		switch( token.mType )
		{
		case eTOKEN_DOWNSOUND:
			{
				/// Ŭ 
				mDownSoundIdx = parser.ParseInt();
			}
			break;
		case eTOKEN_UPSOUND:
			{
				///   
				mUpSoundIdx = parser.ParseInt();
			}
			break;
		case eTOKEN_UPCOLOR:
			{
				///  ū "(" ̹Ƿ Ѿ 
				if( parser.ExpectTokenString( "(" ) == false )
					return false;

				unsigned char r = (unsigned char)parser.ParseInt();
				unsigned char g = (unsigned char)parser.ParseInt();
				unsigned char b = (unsigned char)parser.ParseInt();

				if( parser.ExpectTokenString( ")" ) == false )
					return false;

				/// ȯ ( R,G,B  )
				unsigned long color = (unsigned long)( (DWORD)((BYTE)r << 16) | (WORD)((BYTE)g << 8) | (BYTE)b );

				/// down ÷ ⺻ up ÷ ϰ Ѵ
				mUpColor = mDownColor = color | 0xff000000;
			}
			break;
		case eTOKEN_DOWNCOLOR:
			{
				///  ū "(" ̹Ƿ Ѿ 
				if( parser.ExpectTokenString( "(" ) == false )
					return false;

				unsigned char r = (unsigned char)parser.ParseInt();
				unsigned char g = (unsigned char)parser.ParseInt();
				unsigned char b = (unsigned char)parser.ParseInt();

				if( parser.ExpectTokenString( ")" ) == false )
					return false;

				/// ȯ ( R,G,B  )
				unsigned long color = (unsigned long)( (DWORD)((BYTE)r << 16) | (WORD)((BYTE)g << 8) | (BYTE)b );

				mDownColor = color | 0xff000000;
			}
			break;
		case eTOKEN_TEXT:
			{
				int i = parser.ParseInt();
				if( UIMAN->GetUIText( &mText, i ) == false )
				{
					assert ( 0 && "failed to interface - button text" );
					return false;
				}
			}
			break;
		case eTOKEN_UPPOS:
			{
				mUpPos.mX = parser.ParseInt();
				mUpPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_UPOVERPOS:
			{
				mUpOverPos.mX = parser.ParseInt();
				mUpOverPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_DOWNPOS:
			{
				mDownPos.mX = parser.ParseInt();
				mDownPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_DOWNOVERPOS:
			{
				mDownOverPos.mX = parser.ParseInt();
				mDownOverPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_ENABLEPOS:
			{
				mEnablePos.mX = parser.ParseInt();
				mEnablePos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_UPSIZE:
			{
				mUpSize.mWidth = parser.ParseInt();
				mUpSize.mHeight = parser.ParseInt();
			}
			break;
		case eTOKEN_DOWNSIZE:
			{
				mDownSize.mWidth = parser.ParseInt();
				mDownSize.mHeight = parser.ParseInt();
			}
			break;
		case eTOKEN_USEENABLE:
			{
				/// mUseEnable    о̱ 
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mUseEnable = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mUseEnable = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}

