/* ====================================================================
*      :	CacheAgent.h
*      :	ĳ ϰ, ۸ Ͽ Ѵ.
*    :	̹
*    :	2006.11.10
*
* ߰ :
*		߰¥ 	۾		߰
*		06.11.10    ̹		
* 
* ǻ :	
* =================================================================== */
#pragma once

#include "CacheBuffer.h"

#define MAX_SEARCH_TABLE_NUM	10
#define MIN_FONT_HEIGHT			8
#define MAX_STRING_BYTES_NUM	256

struct sTextureBufferDesc;

struct sFontPropertyDesc
{
	HFONT			hFont;
	unsigned int	width;
	unsigned int	height;

	LPTSTR			pszString;
	unsigned long	strLen;
	unsigned long	color;	
};

/// Ư ؽ ߿ Ҵ 
struct sTextureLineDesc
{
	/// key
	unsigned int			height;

	/// ִ   
	unsigned int			availableWidth;

	/// Ҵ Xǥ
	unsigned int			currentPosX;

	/// Ű  ġ
	unsigned int			posY;

	///  ؽ
	LPDIRECT3DTEXTURE9		pTexture;
	NiScreenTexture*		pNiTexture;
//	NiScreenElements*		pNiElement;

	/// sContainerAE* ڵ
	void*					pSearchHandle;

	sTextureBufferDesc*		pBufferDesc;

	sTextureLineDesc*		pNext;
};

struct sTextureBlockDesc
{
	unsigned int			posX;
	unsigned int			posY;
	unsigned int			width;
	unsigned int			height;

	///  ؽ
	LPDIRECT3DTEXTURE9		pTexture;
	NiScreenTexture*		pNiTexture;
//	NiScreenElements*		pNiElement;
	RECT					rect;

	/// sCacheKey ڵ
	void*					pHashHandle;
	sTextureBufferDesc*		pBufferDesc;

	sTextureBlockDesc*		pNext;
};

/// ؽ  
struct sTextureBufferDesc
{
	int						testnum;
	/// 
	LPDIRECT3DTEXTURE9		pTexture;
	NiScreenTexture*		pNiTexture;

	/// ִ   
	unsigned int			availableHeight;

	/// Ҵ Yǥ
	unsigned int			posY;

	sTextureLineDesc*		pLineDesc;
	sTextureBlockDesc*		pBlockDesc;

	///  Ʈ   
	sTextureBufferDesc*		pNext;
};

class NiDX9Renderer;
class cBinSearchAE;

class cCacheAgent
{
public:
	cCacheAgent();
	~cCacheAgent();

	/// ʱȭ
	bool Initialize( unsigned int maxCacheItemNum, unsigned int texWidth, unsigned int texHeight, unsigned int texNum );

	/// 2D Ʈ ĳ ȹ
	bool GetCache( RECT* pRect, sFontPropertyDesc* pDesc, NiObject** ppRvalue, SIZE* size );

protected:
	/// ̹ Ѵ..
	HBITMAP CreateBitmapFromText( unsigned int& width, unsigned int& height, HFONT hFont, 
								  LPTSTR string, unsigned long strLen, unsigned long color, 
								  RECT* pRect, unsigned long fontHeight, HBITMAP* pOldBitmap );

	void DDBToDIB( HDC hDC,HBITMAP hBitmap, unsigned char* pOut );

	///  ۼ ڿ ˻Ͽ ٸ  ϴ ƾ Ѵ.
	sTextureBlockDesc* AddCache( RECT* pRect, sFontPropertyDesc* pDesc );

	sTextureBlockDesc*	AllocTextureBlock( unsigned int width, unsigned int height );
	sTextureLineDesc*	AllocLineDesc( unsigned int height );
	void				ChangeTextureBuffer();

protected:
	/// ĳ 
	cCacheBuffer*			mpCacheHashBuffer;

	typedef tPool<sTextureBlockDesc> cBlockDescPool;
	typedef tPool<sTextureLineDesc> cLineDescPool;

	cBlockDescPool*			mpBlockDescPool;
	cLineDescPool*			mpLineDescPool;

	cBinSearchAE*			mpLineDescSearch;


	unsigned long			mMaxTextureBlockDescNum;
	unsigned long			mMaxLineDescNum;

	///  Ʈ ̸鼭,  
	sTextureBufferDesc*		mpTextureBufferDesc;

	///  ҴǾ  
	sTextureBufferDesc*		mpPrimaryBufferDesc;

	///  Ʈ  
	unsigned long			mTextureBufferNum;
	unsigned long			mMaxCacheItemNum;


	/// ڸ ϱ  
	unsigned int		mTexWidth;
	unsigned int		mTexHeight;

	unsigned char*		mpImageBuffer;
	unsigned char		mImageDepth; ///  16 or 32 -> 2byte or 4byte

	HDC					mhDC;
	HDC					mhMemDC;
	HBRUSH				mhBrush;
};
