#include "stdafx.h"
#include "cachebuffer.h"

cCacheBuffer::cCacheBuffer() :
mpKeyPool(0), mpKeyTable(0), mpHash(0)
{
	mKeyMemSize = 0;
	mReservedKeyNum = 0;

	mMaxContainerNum = 0;
	mUsedContainerNum = 0;
}

cCacheBuffer::~cCacheBuffer()
{
	Cleanup();
}

/* ------------------------------------------------------------------
* Լ̸ :	Initialize( unsigned long maxContainerNum, unsigned long maxStringSize )
*      :	ĳ  ޸𸮸 Ҵ
* ǻ :	
* ------------------------------------------------------------------ */
bool cCacheBuffer::Initialize( unsigned long maxContainerNum, unsigned long maxStringSize )
{
	mMaxContainerNum = maxContainerNum;
	mKeyMemSize = sizeof(sCacheKey) + (maxStringSize-1)*sizeof(TCHAR);

	/// Key ޸ 
	mpKeyPool = new char[mKeyMemSize*mMaxContainerNum];
	::memset( mpKeyPool, 0, mKeyMemSize*mMaxContainerNum );

	/// Ǿ Key ̺
	mpKeyTable = new sCacheKey*[mMaxContainerNum];
	::memset( mpKeyTable, 0, sizeof(sCacheKey*)*mMaxContainerNum );

	/// Key ޸ ּ Ҵ    
	for( unsigned long i=0; i<mMaxContainerNum; i++ )
	{
		mpKeyTable[i] = (sCacheKey*)(mpKeyPool + mKeyMemSize*i);
	}
	mReservedKeyNum = mMaxContainerNum;

	/// Hash 
	mpHash = NiNew cCaheTxtHash<void*>( maxStringSize );
	mpSearchKey = (sCacheKey*) new char[mKeyMemSize];

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	Cleanup()
*      :	Ҵ ޸ 
* ǻ :	
* ------------------------------------------------------------------ */
void cCacheBuffer::Cleanup()
{
	SAFE_DELETE_ARRAY(mpSearchKey);

	if( mpHash )
	{
		mpHash->RemoveAll();
		NiDelete mpHash;
	}

	SAFE_DELETE_ARRAY(mpKeyTable);

	SAFE_DELETE_ARRAY(mpKeyPool);

	::memset( this, 0, sizeof(cCacheBuffer) );
}

/* ------------------------------------------------------------------
* Լ̸ :	InsertValue( char* string, unsigned long strSize, HFONT hFont, unsigned long color, void* pValue )
*      :	̳ ߰
* ǻ :	
* ------------------------------------------------------------------ */
void* cCacheBuffer::InsertValue( LPTSTR string, unsigned long strSize, HFONT hFont, unsigned long color, void* pValue )
{
	///  ̳ Ű ..
	sCacheKey* pKey = AllocKeyMem();
	if( !pKey )
		return NULL;

	pKey->hFont = hFont;
	pKey->strSize = strSize;
	pKey->color = color;

	::_tcsncpy( pKey->szString, string, strSize );
	pKey->szString[strSize] = 0;


	mpHash->SetAt( pKey, pValue );

	mUsedContainerNum++;

	return pKey;
}

/* ------------------------------------------------------------------
* Լ̸ :	DeleteValue( void* pHashHandle )
*      :	̳ 
* ǻ :	
* ------------------------------------------------------------------ */
void cCacheBuffer::DeleteValue( void* pHashHandle )
{
	sCacheKey* pKey = (sCacheKey*)pHashHandle;

	mpHash->RemoveAt( pKey );
	FreeKeyMem( pKey );
}

/* ------------------------------------------------------------------
* Լ̸ :	SearchValue( char* string, unsigned long strSize, HFONT hFont, unsigned long color )
*      :	 ޸ ˻
* ǻ :	
* ------------------------------------------------------------------ */
void* cCacheBuffer::SearchValue( LPTSTR string, unsigned long strSize, HFONT hFont, unsigned long color )
{
	mpSearchKey->color = color;
	mpSearchKey->hFont = hFont;
	mpSearchKey->strSize = strSize;

	::_tcsncpy( mpSearchKey->szString, string, strSize );
	mpSearchKey->szString[strSize] = 0;

	void* rValue = NULL;
	mpHash->GetAt( mpSearchKey, rValue );

	return rValue;
}

/* ------------------------------------------------------------------
* Լ̸ :	AllocKeyMem()
*      :	޸ Ҵ  Լ
* ǻ :	
* ------------------------------------------------------------------ */

sCacheKey* cCacheBuffer::AllocKeyMem()
{
	///
	sCacheKey* pKey;
	//	pKey = mpKeyTable[0];

	///
	//	mpKeyTable[0] = mpKeyTable[mReservedKeyNum-1];
	//	mReservedKeyNum--;

	pKey = mpKeyTable[mReservedKeyNum-1];
	mReservedKeyNum--;

	return pKey;
}

/* ------------------------------------------------------------------
* Լ̸ :	FreeKeyMem( sCacheKey* pKey )
*      :	޸   Լ
* ǻ :	
* ------------------------------------------------------------------ */
void cCacheBuffer::FreeKeyMem( sCacheKey* pKey )
{
	mpKeyTable[mReservedKeyNum] = pKey;
	mReservedKeyNum++;
}