#include "stdafx.h"
#include "cachefont.h"

#include "RenderSystem.h"

cCacheFont::cCacheFont() :
mpCacheAgent(0)
{
	::memset( &mFontPropertyDesc, 0, sizeof(sFontPropertyDesc) );
}

cCacheFont::~cCacheFont()
{
	SAFE_DELETE(mpCacheAgent);
}

/* ------------------------------------------------------------------
* Լ̸ :	CreateFont(  HWND hwnd, LOGFONT* pLogFont )
*      :	Ʈ 
* ǻ :	
* ------------------------------------------------------------------ */
bool cCacheFont::CreateFont( HWND hwnd, LOGFONT* pLogFont, sCacheInfo& cacheInfo )
{
	LOGFONT		font;

	if( !pLogFont )
	{
		pLogFont = &font;

		font.lfHeight = -12;
		font.lfWidth = 0;//-pLogFont->lfHeight / 2;
		font.lfEscapement = 0;
		font.lfOrientation = 0;
		font.lfWeight = FW_NORMAL;
		font.lfItalic = 0;
		font.lfUnderline = 0;
		font.lfStrikeOut = 0;
/*
		font.lfCharSet = DEFAULT_CHARSET;
		font.lfOutPrecision = 0;
		font.lfClipPrecision = 0;
		font.lfQuality = PROOF_QUALITY;
		font.lfPitchAndFamily = 0;
*/
		font.lfCharSet = DEFAULT_CHARSET;
		font.lfOutPrecision = OUT_OUTLINE_PRECIS;
		font.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		font.lfQuality =  PROOF_QUALITY;
		font.lfPitchAndFamily = FF_SWISS;
		::lstrcpy( font.lfFaceName, _T("ü") );
	}

	mpRenderer = (NiDX9Renderer*)NiRenderer::GetRenderer();
	if( !mpRenderer )
	{
		return false;
	}

	/// Font Ȯ  Ѵ.
	if( !cFontObject::SetFontInfo( hwnd, pLogFont ) )
	{
		return false;
	}

	/// CacheAgent ..
	mpCacheAgent = new cCacheAgent;
	if( !mpCacheAgent->Initialize( cacheInfo.maxCacheItemNum, cacheInfo.texWidth, cacheInfo.texHeight, cacheInfo.texNum ) )
	{
		return false;
	}

	/// Ʈ  ⺻  
	mFontPropertyDesc.hFont = mhFont;

	if( pLogFont->lfHeight < 0 )
		mFontPropertyDesc.height = (pLogFont->lfHeight) * -1;
	else
		mFontPropertyDesc.height = pLogFont->lfHeight;

	mFontPropertyDesc.width = mFontPropertyDesc.height / 2;

	mFontPropertyDesc.pszString = NULL;
	mFontPropertyDesc.strLen = 0;
	mFontPropertyDesc.color = 0xffffffff;

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	DrawText( char* str, int strLen, RECT* pRect, unsigned long color )
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
bool cCacheFont::DrawText( LPTSTR str, int strLen, RECT* pRect, unsigned long color, SIZE* pScreenSize )
{
	mFontPropertyDesc.pszString = str;
	mFontPropertyDesc.strLen = strLen;
	mFontPropertyDesc.color = color;

	/*
	NiScreenElements* pElement = NULL;
	if( mpCacheAgent->GetCache( mpRenderer, pRect, &mFontPropertyDesc, (NiObject**)&pElement ) == false )
	return false;

	pElement->Draw( mpRenderer );
	//*/

	SIZE size;
	if( pScreenSize )
	{
		size.cx = pScreenSize->cx;
		size.cy = pScreenSize->cy;
	}
	else
	{
		size.cx = RENDERSYS->GetScreenWidth();
		size.cy = RENDERSYS->GetScreenHeight();
	}

	//*
	NiScreenTexture* pTexture = NULL;
	if( mpCacheAgent->GetCache( pRect, &mFontPropertyDesc, (NiObject**)&pTexture, &size ) == false )
		return false;

	if( pTexture && pTexture->GetNumScreenRects() )
	{
		pTexture->MarkAsChanged(NiScreenTexture::EVERYTHING_MASK);

		/// ȭ 
		pTexture->Draw( mpRenderer );

		///     
		pTexture->RemoveAllScreenRects();
	}
	//*/
	return true;
}