/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      : ī޶
* ǻ : 
*===========================================================================*/
#pragma once

/// ī޶
//////////////////////////////////////////////////////////////////////////
//       Y                         Z
// NI:   |__ Z         MAX(APP):   |__ X
//      /                         /
//    -X                        -Y
//////////////////////////////////////////////////////////////////////////
class cCamera
{
	friend class cCameraManager;
	static const unsigned int MIN_NEAR_DIST = 10;
	static const unsigned int MAX_FAR_DIST = 50000;

public:
	cCamera();
	virtual ~cCamera();

	/// ʱȭ  
	virtual bool Init( float width = 800.f, float height = 600.f );

	/// ī޶ ġ   
	virtual void Reset(){}// = 0;

	virtual void Shake() {}

	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void Update( unsigned long accumTime );

	/// ٰŸ
	float GetNearDistance() const;

	/// Ÿ
	void SetFarDistance( float farDist );
	float GetFarDistance() const;

	/// þ Դ
	void SetViewFrustum( float width, float height );
	void SetViewFrustum( float width, float height, float fovyDegree, float farDist );
	void SetViewFrustum( float left, float right, float top, float bottom, float farDist );

	/// Ʈ
	void SetViewPort( float left = 0.f, float right = 1.f, float top = 1.f, float bottom = 0.f );

	/// ̵
	void SetTranslate( const NiPoint3& trans );
	void SetTranslate( float x, float y, float z );
	void Translate( const NiPoint3& move );
	const NiPoint3& GetWorldTranslate() const;

	/// ȸ
	void SetRotate( const NiMatrix3& rot );
	void Rotate( const NiPoint3& axis, float angle );
	void Pitch( float angle );
	void Yaw( float angle );

	/// 
	NiPoint3 GetWorldDirection() const;

	NiNode*	GetOrientNode() { return mOrientNode; }

	void ChangeNiCamera( NiCamera* cam );

	/// ӷ
	void SetSpeed( float unitsPerSec );

	/// Ⱦ
	float GetAspectRatio() const;

	/// 콺 ǥ شϴ 
	bool GetRayFromWindowPoint( long mouseX, long mouseY, NiPoint3& origin, NiPoint3& dir ) const;
	
	/// 
	virtual void SetLookAt( const NiPoint3& target );
	void SetLookAt( float x, float y, float z );
	const NiPoint3& GetLookAt() const;
	void ResetLookAt( const NiPoint3& target );

	/// κ Ÿ
	void SetLookAtDistance( float dist );
	float GetLookAtDistance() const;

	///  
	bool GetNeedUpdate() const;

	///  ī޶ ȯ
	operator NiCamera*() const
	{
		return mNiCamera;
	}

protected:
	/// Է ó
	virtual void OnProcessMouse( unsigned long time ) = 0;

protected:
	/// ȭ ũ
	float mWidth;
	float mHeight;

	///  þ߰
	float mFovyDegree;

	/// Ÿ
	float mFarDistance;

	/// Ⱦ
	float mAspectRatio;

	///  ī޶
	NiCameraPtr mNiCamera;

	/// ī޶ ȯ 
	NiNodePtr mOrientNode;

	/// ӷ
	float mSpeed;

	/// 
	NiPoint3 mTargetLookAt;
	NiPoint3 mLookAt;

	///   ī޶   Ÿ
	float mLookAtDistance;

	///  
	bool mNeedUpdate;
};

inline
void cCamera::Update( unsigned long accumTime )
{
	mOrientNode->Update( accumTime * 0.001f );
}

inline
void cCamera::SetSpeed( float unitsPerSec )
{
	mSpeed = unitsPerSec;
}

inline
float cCamera::GetNearDistance() const
{
	return float(MIN_NEAR_DIST);
}

inline
float cCamera::GetFarDistance() const
{
	return mFarDistance;
}

inline
float cCamera::GetAspectRatio() const
{
	return mAspectRatio;
}

inline
const NiPoint3& cCamera::GetWorldTranslate() const
{
	return mNiCamera->GetWorldTranslate();
}

inline
NiPoint3 cCamera::GetWorldDirection() const
{
	return mNiCamera->GetWorldDirection();
}

inline
bool cCamera::GetRayFromWindowPoint( long mouseX, long mouseY, NiPoint3& origin, NiPoint3& dir ) const
{
	return mNiCamera->WindowPointToRay( mouseX, mouseY, origin, dir );
}

inline
void cCamera::SetLookAt( const NiPoint3& target )
{
	mTargetLookAt = target;
}

inline
void cCamera::SetLookAt( float x, float y, float z )
{
	mTargetLookAt.x = x;
	mTargetLookAt.y = y;
	mTargetLookAt.z = z;
}

inline
const NiPoint3& cCamera::GetLookAt() const
{
	return mLookAt;
}

inline
void cCamera::ResetLookAt( const NiPoint3& target )
{
	mLookAt = mTargetLookAt = target;
}

inline
void cCamera::SetLookAtDistance( float dist )
{
	mLookAtDistance = dist;
}

inline
float cCamera::GetLookAtDistance() const
{
	return mLookAtDistance;
}

inline
bool cCamera::GetNeedUpdate() const
{
	return mNeedUpdate;
}
