#include "StdAfx.h"
#include "CardBookWindow.h"
#include "TarotSheetWindow.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "GameUIManager.h"

cCardBookWindow::cCardBookWindow()
: mPage(ePAGE_DATA)
, mTarotSheet(0)
{

}

cCardBookWindow::~cCardBookWindow()
{

}

void cCardBookWindow::Clear()
{
	if( mTarotSheet )
		mTarotSheet->Clear();
}

///   ȣ
bool cCardBookWindow::UIStageIn()
{
	if( mTarotSheet )
		mTarotSheet->UIStageIn();
	return true;
}

bool cCardBookWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cTabWindow::OnCreate( pproperty ) == false )
		return false;

	mTarotSheet = (cTarotSheetWindow*)GetChild( eUIID_GAME_CARDBOOK_TAROTSHEET );

	/// Ÿ  켱
	SetCurrent( ePAGE_TAROT );
	return true;
}

void cCardBookWindow::OnRender( cUIFontItemKeeper* pkeeper )
{
	cTabWindow::OnRender( pkeeper );
}

void cCardBookWindow::OnCommand( cUINode*, unsigned int id )
{
	if( id == eUIID_GAME_CARDBOOK_CLOSE )
	{
		SendCardBookHide();
	}
}

void cCardBookWindow::OnTabButtonPressed( cUINode* caller, unsigned int id )
{
	cTabWindow::OnTabButtonPressed( caller, id );
}

void cCardBookWindow::SetCurrent( unsigned int index )
{
	cTabWindow::SetCurrent( index );
	mPage = (eBookPage)index;
}

void cCardBookWindow::HideESC( bool onsound )
{
	SendCardBookHide();
}

void cCardBookWindow::Toggle()
{
	if( IsVisible() == true )
	{
		SendCardBookHide();
	}
	else
	{
		SendCardBookOpen();
	}
}

void cCardBookWindow::SendCardBookOpen()
{
	if( IsNetLock() == true )
		return;

	if( HERO->GetStopFlag() == eSTOP_COLLECTIONBOOK )
		return;

	MSGROOT Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_COLLECTIONBOOK_OPEN_REQ;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

	NetLock( eBook_Open );
}

void cCardBookWindow::SendCardBookHide()
{
	if( IsNetLock() == true )
		return;

	MSGROOT Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_COLLECTIONBOOK_CLOSE_REQ;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

	NetLock( eBook_Close );
}